/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SslConnection;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SelectChannelServerSslTest
extends HttpServerTestBase {
    static SSLContext __sslContext;
    private static final AtomicInteger _handlecount;

    public SelectChannelServerSslTest() {
        this._scheme = "https";
    }

    @Override
    protected Socket newSocket(String host, int port) throws Exception {
        return __sslContext.getSocketFactory().createSocket(host, port);
    }

    @BeforeClass
    public static void init() throws Exception {
        SslSelectChannelConnector connector = new SslSelectChannelConnector(){

            protected SslConnection newSslConnection(AsyncEndPoint endPoint, SSLEngine engine) {
                return new SslConnection(engine, (EndPoint)endPoint){

                    public Connection handle() throws IOException {
                        _handlecount.incrementAndGet();
                        return super.handle();
                    }
                };
            }
        };
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore";
        SslContextFactory cf = connector.getSslContextFactory();
        cf.setKeyStorePath(keystorePath);
        cf.setKeyStorePassword("storepwd");
        cf.setKeyManagerPassword("keypwd");
        cf.setTrustStore(keystorePath);
        cf.setTrustStorePassword("storepwd");
        connector.setUseDirectBuffers(true);
        SelectChannelServerSslTest.startServer((Connector)connector);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(new FileInputStream(connector.getKeystore()), "storepwd".toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        __sslContext = SSLContext.getInstance("TLS");
        __sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        try {
            HttpsURLConnection.setDefaultHostnameVerifier(__hostnameverifier);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void testRequest2Fragments() throws Exception {
        super.testRequest2Fragments();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequest2FixedFragments() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        int[] points = new int[]{74, 325};
        Arrays.sort(points);
        Socket client = this.newSocket("localhost", _connector.getLocalPort());
        try {
            OutputStream os = client.getOutputStream();
            int last = 0;
            for (int j = 0; j < points.length; ++j) {
                int point = points[j];
                os.write(bytes, last, point - last);
                last = point;
                os.flush();
                Thread.sleep(10L);
            }
            os.write(bytes, last, bytes.length - last);
            os.flush();
            Thread.sleep(10L);
            String response = SelectChannelServerSslTest.readResponse(client);
            Assert.assertEquals((Object)RESPONSE2, (Object)response);
        }
        finally {
            client.close();
        }
    }

    @Override
    @Test
    @Ignore(value="Override and ignore this test as SSLSocket.shutdownOutput() is not supported, but shutdownOutput() is needed by the test.")
    public void testInterruptedRequest() {
    }

    @Override
    @Ignore
    public void testAvailable() throws Exception {
    }

    @Override
    public void testSuspendedPipeline() throws Exception {
        _handlecount.set(0);
        super.testSuspendedPipeline();
        Assert.assertThat((Object)_handlecount.get(), (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(50)));
    }

    static {
        _handlecount = new AtomicInteger();
    }
}

