/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.SSLSession;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.ssl.SslConnector;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.Assert;
import org.junit.Test;

public class SslRenegotiateTest {
    private static final Logger LOG = Log.getLogger(SslRenegotiateTest.class);
    private ByteBuffer _outAppB;
    private ByteBuffer _outPacketB;
    private ByteBuffer _inAppB;
    private ByteBuffer _inPacketB;
    private SocketChannel _socket;
    private SSLEngine _engine;

    @Test
    public void testRenegNIO() throws Exception {
    }

    @Test
    public void testNoRenegNIO() throws Exception {
        this.doRequests((SslConnector)new SslSelectChannelConnector(), false);
    }

    @Test
    public void testRenegBIO() throws Exception {
    }

    @Test
    public void testNoRenegBIO() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequests(SslConnector connector, boolean reneg) throws Exception {
        Server server = new Server();
        try {
            String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath();
            connector.setPort(0);
            SslContextFactory cf = connector.getSslContextFactory();
            cf.setKeyStorePath(keystore);
            cf.setKeyStorePassword("storepwd");
            cf.setKeyManagerPassword("keypwd");
            cf.setAllowRenegotiate(reneg);
            server.setConnectors(new Connector[]{connector});
            server.setHandler((Handler)new HelloWorldHandler());
            server.start();
            InetSocketAddress addr = new InetSocketAddress("localhost", connector.getLocalPort());
            this._socket = SocketChannel.open(addr);
            this._socket.configureBlocking(true);
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, SslContextFactory.TRUST_ALL_CERTS, new SecureRandom());
            this._engine = context.createSSLEngine();
            this._engine.setUseClientMode(true);
            SSLSession session = this._engine.getSession();
            this._outAppB = ByteBuffer.allocate(session.getApplicationBufferSize());
            this._outPacketB = ByteBuffer.allocate(session.getPacketBufferSize());
            this._inAppB = ByteBuffer.allocate(session.getApplicationBufferSize());
            this._inPacketB = ByteBuffer.allocate(session.getPacketBufferSize());
            this._outAppB.put("GET /1 HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes("ISO-8859-1"));
            this._outAppB.flip();
            this._engine.beginHandshake();
            this.runHandshake();
            this.doWrap();
            this.doUnwrap();
            this._inAppB.flip();
            String response = new IndirectNIOBuffer(this._inAppB, true).toString();
            Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
            if (response.indexOf("HELLO WORLD") < 0) {
                this._inAppB.clear();
                this.doUnwrap();
                this._inAppB.flip();
                response = new IndirectNIOBuffer(this._inAppB, true).toString();
            }
            Assert.assertTrue((response.indexOf("HELLO WORLD") >= 0 ? 1 : 0) != 0);
            this._inAppB.clear();
            this._outAppB.clear();
            this._outAppB.put("GET /2 HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes("ISO-8859-1"));
            this._outAppB.flip();
            try {
                session.invalidate();
                this._engine.beginHandshake();
                this.runHandshake();
                this.doWrap();
                this.doUnwrap();
                this._inAppB.flip();
                response = new IndirectNIOBuffer(this._inAppB, true).toString();
                Assert.assertTrue((boolean)response.startsWith("HTTP/1.1 200 OK"));
                Assert.assertTrue((response.indexOf("HELLO WORLD") > 0 ? 1 : 0) != 0);
                Assert.assertTrue((boolean)reneg);
            }
            catch (IOException e) {
                if (!(e instanceof SSLProtocolException)) {
                    if (reneg) {
                        LOG.warn((Throwable)e);
                    }
                    Assert.assertFalse((boolean)reneg);
                }
            }
        }
        finally {
            server.stop();
            server.join();
        }
    }

    void runHandshake() throws Exception {
        block5: while (true) {
            switch (this._engine.getHandshakeStatus()) {
                case NEED_TASK: {
                    this._engine.getDelegatedTask().run();
                    continue block5;
                }
                case NEED_WRAP: {
                    this.doWrap();
                    continue block5;
                }
                case NEED_UNWRAP: {
                    this.doUnwrap();
                    continue block5;
                }
            }
            break;
        }
    }

    private void doWrap() throws Exception {
        this._engine.wrap(this._outAppB, this._outPacketB);
        this._outPacketB.flip();
        while (this._outPacketB.hasRemaining()) {
            int p = this._outPacketB.remaining();
            int n = this._socket.write(this._outPacketB);
        }
        this._outPacketB.clear();
    }

    private void doUnwrap() throws Exception {
        SSLEngineResult result;
        this._inPacketB.clear();
        int l = this._socket.read(this._inPacketB);
        if (l < 0) {
            throw new IOException("EOF");
        }
        this._inPacketB.flip();
        while ((result = this._engine.unwrap(this._inPacketB, this._inAppB)).bytesConsumed() > 0 && this._inPacketB.remaining() > 0 && (this._engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP || this._engine.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING)) {
        }
    }

    private static class HelloWorldHandler
    extends AbstractHandler {
        private HelloWorldHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            byte[] b = ("HELLO WORLD " + baseRequest.getUri()).getBytes("UTF-8");
            response.setContentLength(b.length);
            response.getOutputStream().write(b);
            response.getOutputStream().flush();
        }
    }
}

