/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.FileInputStream;
import java.net.Socket;
import java.net.SocketException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class SslSocketServerTest
extends HttpServerTestBase {
    static SSLContext __sslContext;

    public SslSocketServerTest() {
        this._scheme = "https";
    }

    @Override
    protected Socket newSocket(String host, int port) throws Exception {
        SSLSocket socket = (SSLSocket)__sslContext.getSocketFactory().createSocket(host, port);
        socket.setEnabledProtocols(new String[]{"TLSv1"});
        return socket;
    }

    @BeforeClass
    public static void init() throws Exception {
        SslSocketConnector connector = new SslSocketConnector();
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore";
        SslContextFactory cf = connector.getSslContextFactory();
        cf.setKeyStorePath(keystorePath);
        cf.setKeyStorePassword("storepwd");
        cf.setKeyManagerPassword("keypwd");
        cf.setTrustStore(keystorePath);
        cf.setTrustStorePassword("storepwd");
        SslSocketServerTest.startServer((Connector)connector);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(new FileInputStream(connector.getKeystore()), "storepwd".toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        __sslContext = SSLContext.getInstance("TLSv1");
        __sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
    }

    @Override
    @Test
    @Ignore(value="Override and ignore this test as SSLSocket.shutdownOutput() is not supported, but shutdownOutput() is needed by the test.")
    public void testInterruptedRequest() {
    }

    @Override
    @Test
    public void testFlush() throws Exception {
    }

    @Override
    @Ignore
    public void testAvailable() throws Exception {
    }

    @Override
    public void testFull() throws Exception {
        try {
            super.testFull();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }
}

