/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.FileInputStream;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ConnectorTimeoutTest;
import org.eclipse.jetty.server.ssl.SslSocketConnector;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.BeforeClass;

public class SslSocketTimeoutTest
extends ConnectorTimeoutTest {
    static SSLContext __sslContext;

    @Override
    protected Socket newSocket(String host, int port) throws Exception {
        SSLSocket socket = (SSLSocket)__sslContext.getSocketFactory().createSocket(host, port);
        socket.setEnabledProtocols(new String[]{"TLSv1"});
        return socket;
    }

    @BeforeClass
    public static void init() throws Exception {
        SslSocketConnector connector = new SslSocketConnector();
        connector.setMaxIdleTime(250);
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore";
        SslContextFactory cf = connector.getSslContextFactory();
        cf.setKeyStorePath(keystorePath);
        cf.setKeyStorePassword("storepwd");
        cf.setKeyManagerPassword("keypwd");
        cf.setTrustStore(keystorePath);
        cf.setTrustStorePassword("storepwd");
        SslSocketTimeoutTest.startServer((Connector)connector);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(new FileInputStream(connector.getKeystore()), "storepwd".toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        __sslContext = SSLContext.getInstance("TLSv1");
        __sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
    }
}

