/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.ssl.SslSelectChannelConnector;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SslUploadTest {
    private static Server server;
    private static SslSelectChannelConnector connector;
    private static int total;

    @BeforeClass
    public static void startServer() throws Exception {
        server = new Server();
        connector = new SslSelectChannelConnector();
        server.addConnector((Connector)connector);
        String keystorePath = System.getProperty("basedir", ".") + "/src/test/resources/keystore";
        SslContextFactory cf = connector.getSslContextFactory();
        cf.setKeyStorePath(keystorePath);
        cf.setKeyStorePassword("storepwd");
        cf.setKeyManagerPassword("keypwd");
        cf.setTrustStore(keystorePath);
        cf.setTrustStorePassword("storepwd");
        server.setHandler((Handler)new EmptyHandler());
        server.start();
    }

    @AfterClass
    public static void stopServer() throws Exception {
        server.stop();
        server.join();
    }

    @Test
    public void test() throws Exception {
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        keystore.load(new FileInputStream(connector.getKeystore()), "storepwd".toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        SSLSocket socket = (SSLSocket)sslContext.getSocketFactory().createSocket("localhost", connector.getLocalPort());
        long start = System.nanoTime();
        OutputStream out = socket.getOutputStream();
        out.write("POST / HTTP/1.1\r\n".getBytes());
        out.write("Host: localhost\r\n".getBytes());
        out.write("Content-Length: 16777216\r\n".getBytes());
        out.write("Content-Type: bytes\r\n".getBytes());
        out.write("Connection: close\r\n".getBytes());
        out.write("\r\n".getBytes());
        out.flush();
        byte[] requestContent = new byte[0x1000000];
        Arrays.fill(requestContent, (byte)120);
        out.write(requestContent);
        out.flush();
        InputStream in = socket.getInputStream();
        String response = IO.toString((InputStream)in);
        Assert.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        long end = System.nanoTime();
        System.out.println("upload time: " + TimeUnit.NANOSECONDS.toMillis(end - start));
        Assert.assertEquals((long)requestContent.length, (long)total);
    }

    private static class EmptyHandler
    extends AbstractHandler {
        private EmptyHandler() {
        }

        public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
            int read;
            request.setHandled(true);
            ServletInputStream in = request.getInputStream();
            byte[] b = new byte[16384];
            while ((read = in.read(b)) >= 0) {
                total += read;
            }
            System.err.println("Read " + total);
        }
    }
}

