/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class HttpChannelState
implements AsyncContext,
Continuation {
    private static final Logger LOG = Log.getLogger(HttpChannelState.class);
    private static final long DEFAULT_TIMEOUT = 30000L;
    private static final ContinuationThrowable __exception = new ContinuationThrowable();
    private final HttpChannel _channel;
    private List<AsyncListener> _lastAsyncListeners;
    private List<AsyncListener> _asyncListeners;
    private List<ContinuationListener> _continuationListeners;
    private State _state;
    private boolean _initial;
    private boolean _resumed;
    private boolean _expired;
    private volatile boolean _responseWrapped;
    private long _timeoutMs = 30000L;
    private AsyncEventState _event;
    private volatile boolean _continuation;

    protected HttpChannelState(HttpChannel channel) {
        this._channel = channel;
        this._state = State.IDLE;
        this._initial = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, ServletRequest request, ServletResponse response) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._asyncListeners == null) {
                this._asyncListeners = new ArrayList<AsyncListener>();
            }
            this._asyncListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContinuationListener(ContinuationListener listener) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._continuationListeners == null) {
                this._continuationListeners = new ArrayList<ContinuationListener>();
            }
            this._continuationListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeout(long ms) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._timeoutMs = ms;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeout() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._timeoutMs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncEventState getAsyncEventState() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event;
        }
    }

    public boolean isResponseWrapped() {
        return this._responseWrapped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitial() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._initial;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: 
                case REDISPATCHING: 
                case COMPLETECALLED: 
                case ASYNCWAIT: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.IDLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspending() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: 
                case ASYNCWAIT: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDispatchable() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case REDISPATCHING: 
                case COMPLETECALLED: 
                case REDISPATCH: 
                case REDISPATCHED: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return super.toString() + "@" + this.getStatusString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusString() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return (Object)((Object)this._state) + (this._initial ? ",initial" : "") + (this._resumed ? ",resumed" : "") + (this._expired ? ",expired" : "");
        }
    }

    protected boolean handling() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._continuation = false;
            this._responseWrapped = false;
            switch (this._state) {
                case IDLE: {
                    this._initial = true;
                    this._state = State.DISPATCHED;
                    if (this._lastAsyncListeners != null) {
                        this._lastAsyncListeners.clear();
                    }
                    if (this._asyncListeners != null) {
                        this._asyncListeners.clear();
                    } else {
                        this._asyncListeners = this._lastAsyncListeners;
                        this._lastAsyncListeners = null;
                    }
                    return true;
                }
                case COMPLETECALLED: {
                    this._state = State.COMPLETING;
                    return false;
                }
                case ASYNCWAIT: 
                case COMPLETING: 
                case COMPLETED: {
                    return false;
                }
                case REDISPATCH: {
                    this._state = State.REDISPATCHED;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSuspend(ServletContext context, ServletRequest request, ServletResponse response) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case REDISPATCHED: 
                case DISPATCHED: {
                    this._resumed = false;
                    this._expired = false;
                    if (this._event == null || request != this._event.getSuppliedRequest() || response != this._event.getSuppliedResponse() || context != this._event.getServletContext()) {
                        this._event = new AsyncEventState(context, request, response);
                    } else {
                        this._event._dispatchContext = null;
                        this._event._pathInContext = null;
                    }
                    this._state = State.ASYNCSTARTED;
                    List<AsyncListener> listeners = this._lastAsyncListeners;
                    this._lastAsyncListeners = this._asyncListeners;
                    this._asyncListeners = listeners;
                    if (this._asyncListeners == null) break;
                    this._asyncListeners.clear();
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (this._lastAsyncListeners != null) {
            for (AsyncListener listener : this._lastAsyncListeners) {
                try {
                    listener.onStartAsync((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void error(Throwable th) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            if (this._event != null) {
                this._event._cause = th;
            }
        }
    }

    protected boolean unhandle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case REDISPATCHED: 
                case DISPATCHED: {
                    this._state = State.COMPLETING;
                    return true;
                }
                case IDLE: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case ASYNCSTARTED: {
                    this._initial = false;
                    this._state = State.ASYNCWAIT;
                    this.scheduleTimeout();
                    if (this._state == State.ASYNCWAIT) {
                        return true;
                    }
                    if (this._state == State.COMPLETECALLED) {
                        this._state = State.COMPLETING;
                        return true;
                    }
                    this._initial = false;
                    this._state = State.REDISPATCHED;
                    return false;
                }
                case REDISPATCHING: {
                    this._initial = false;
                    this._state = State.REDISPATCHED;
                    return false;
                }
                case COMPLETECALLED: {
                    this._initial = false;
                    this._state = State.COMPLETING;
                    return true;
                }
            }
            throw new IllegalStateException(this.getStatusString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        boolean dispatch = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: {
                    this._state = State.REDISPATCHING;
                    this._resumed = true;
                    return;
                }
                case ASYNCWAIT: {
                    dispatch = !this._expired;
                    this._state = State.REDISPATCH;
                    this._resumed = true;
                    break;
                }
                case REDISPATCH: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void expired() {
        List<AsyncListener> aListeners22;
        List<ContinuationListener> cListeners22;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: 
                case ASYNCWAIT: {
                    cListeners22 = this._continuationListeners;
                    aListeners22 = this._asyncListeners;
                    break;
                }
                default: {
                    Object cListeners22 = null;
                    Object aListeners22 = null;
                    return;
                }
            }
            this._expired = true;
        }
        if (aListeners22 != null) {
            for (AsyncListener asyncListener : aListeners22) {
                try {
                    asyncListener.onTimeout((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        if (cListeners22 != null) {
            for (ContinuationListener continuationListener : cListeners22) {
                try {
                    continuationListener.onTimeout((Continuation)this);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: 
                case ASYNCWAIT: {
                    if (this._continuation) {
                        this.dispatch();
                        break;
                    }
                    this.complete();
                }
            }
        }
        this.scheduleDispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() {
        boolean dispatch = false;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case REDISPATCHED: 
                case DISPATCHED: {
                    throw new IllegalStateException(this.getStatusString());
                }
                case ASYNCSTARTED: 
                case IDLE: {
                    this._state = State.COMPLETECALLED;
                    return;
                }
                case ASYNCWAIT: {
                    this._state = State.COMPLETECALLED;
                    dispatch = !this._expired;
                    break;
                }
                default: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (dispatch) {
            this.cancelTimeout();
            this.scheduleDispatch();
        }
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)clazz.newInstance());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completed() {
        List<AsyncListener> aListeners22;
        List<ContinuationListener> cListeners22;
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case COMPLETING: {
                    this._state = State.COMPLETED;
                    cListeners22 = this._continuationListeners;
                    aListeners22 = this._asyncListeners;
                    break;
                }
                default: {
                    Object cListeners22 = null;
                    Object aListeners22 = null;
                    throw new IllegalStateException(this.getStatusString());
                }
            }
        }
        if (aListeners22 != null) {
            for (AsyncListener asyncListener : aListeners22) {
                try {
                    if (this._event != null && this._event._cause != null) {
                        this._event.getSuppliedRequest().setAttribute("javax.servlet.error.exception", (Object)this._event._cause);
                        this._event.getSuppliedRequest().setAttribute("javax.servlet.error.message", (Object)this._event._cause.getMessage());
                        asyncListener.onError((AsyncEvent)this._event);
                        continue;
                    }
                    asyncListener.onComplete((AsyncEvent)this._event);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
        if (cListeners22 != null) {
            for (ContinuationListener continuationListener : cListeners22) {
                try {
                    continuationListener.onComplete((Continuation)this);
                }
                catch (Exception e) {
                    LOG.warn((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycle() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case REDISPATCHED: 
                case DISPATCHED: {
                    throw new IllegalStateException(this.getStatusString());
                }
            }
            this._state = State.IDLE;
            this._initial = true;
            this._resumed = false;
            this._expired = false;
            this._responseWrapped = false;
            this.cancelTimeout();
            this._timeoutMs = 30000L;
            this._continuationListeners = null;
            if (this._event != null) {
                this._event._cause = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this.cancelTimeout();
            this._continuationListeners = null;
        }
    }

    protected void scheduleDispatch() {
        this._channel.execute(this._channel);
    }

    protected void scheduleTimeout() {
        Scheduler scheduler = this._channel.getScheduler();
        if (scheduler != null) {
            this._event._timeout = scheduler.schedule((Runnable)new AsyncTimeout(), this._timeoutMs, TimeUnit.MILLISECONDS);
        }
    }

    protected void cancelTimeout() {
        Scheduler.Task task;
        AsyncEventState event = this._event;
        if (event != null && (task = event._timeout) != null) {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleteCalled() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETECALLED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCompleting() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETING;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCompleted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._state == State.COMPLETED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsyncStarted() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case ASYNCSTARTED: 
                case REDISPATCHING: 
                case ASYNCWAIT: 
                case REDISPATCH: {
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAsync() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            switch (this._state) {
                case IDLE: 
                case COMPLETING: 
                case COMPLETED: 
                case DISPATCHED: {
                    return false;
                }
            }
            return true;
        }
    }

    public void dispatch(ServletContext context, String path) {
        this._event._dispatchContext = context;
        this._event._pathInContext = path;
        this.dispatch();
    }

    public void dispatch(String path) {
        this._event._pathInContext = path;
        this.dispatch();
    }

    public Request getBaseRequest() {
        return this._channel.getRequest();
    }

    public ServletRequest getRequest() {
        if (this._event != null) {
            return this._event.getSuppliedRequest();
        }
        return this._channel.getRequest();
    }

    public ServletResponse getResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public void start(final Runnable run) {
        final AsyncEventState event = this._event;
        if (event != null) {
            this._channel.execute(new Runnable(){

                @Override
                public void run() {
                    ((ContextHandler.Context)event.getServletContext()).getContextHandler().handle(run);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOriginalRequestAndResponse() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._event != null && this._event.getSuppliedRequest() == this._channel.getRequest() && this._event.getSuppliedResponse() == this._channel.getResponse();
        }
    }

    public ContextHandler getContextHandler() {
        AsyncEventState event = this._event;
        if (event != null) {
            return ((ContextHandler.Context)event.getServletContext()).getContextHandler();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isResumed() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._resumed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpired() {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            return this._expired;
        }
    }

    public void resume() {
        this.dispatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(ServletContext context, ServletRequest request, ServletResponse response) {
        HttpChannelState httpChannelState = this;
        synchronized (httpChannelState) {
            this._responseWrapped = !(response instanceof Response);
            this.doSuspend(context, request, response);
            if (request instanceof HttpServletRequest) {
                this._event._pathInContext = URIUtil.addPaths((String)((HttpServletRequest)request).getServletPath(), (String)((HttpServletRequest)request).getPathInfo());
            }
        }
    }

    public void suspend(ServletResponse response) {
        this._continuation = true;
        this._responseWrapped = !(response instanceof Response);
        this.doSuspend(this._channel.getRequest().getServletContext(), (ServletRequest)this._channel.getRequest(), response);
    }

    public void suspend() {
        this._responseWrapped = false;
        this._continuation = true;
        this.doSuspend(this._channel.getRequest().getServletContext(), (ServletRequest)this._channel.getRequest(), (ServletResponse)this._channel.getResponse());
    }

    public ServletResponse getServletResponse() {
        if (this._responseWrapped && this._event != null && this._event.getSuppliedResponse() != null) {
            return this._event.getSuppliedResponse();
        }
        return this._channel.getResponse();
    }

    public Object getAttribute(String name) {
        return this._channel.getRequest().getAttribute(name);
    }

    public void removeAttribute(String name) {
        this._channel.getRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object attribute) {
        this._channel.getRequest().setAttribute(name, attribute);
    }

    public void undispatch() {
        if (this.isSuspended()) {
            if (LOG.isDebugEnabled()) {
                throw new ContinuationThrowable();
            }
            throw __exception;
        }
        throw new IllegalStateException("!suspended");
    }

    public class AsyncEventState
    extends AsyncEvent {
        private Scheduler.Task _timeout;
        private final ServletContext _suspendedContext;
        private ServletContext _dispatchContext;
        private String _pathInContext;
        private Throwable _cause;

        public AsyncEventState(ServletContext context, ServletRequest request, ServletResponse response) {
            super((AsyncContext)HttpChannelState.this, request, response);
            this._suspendedContext = context;
            Request r = HttpChannelState.this._channel.getRequest();
            if (r.getAttribute("javax.servlet.async.request_uri") == null) {
                String uri = (String)r.getAttribute("javax.servlet.forward.request_uri");
                if (uri != null) {
                    r.setAttribute("javax.servlet.async.request_uri", uri);
                    r.setAttribute("javax.servlet.async.context_path", r.getAttribute("javax.servlet.forward.context_path"));
                    r.setAttribute("javax.servlet.async.servlet_path", r.getAttribute("javax.servlet.forward.servlet_path"));
                    r.setAttribute("javax.servlet.async.path_info", r.getAttribute("javax.servlet.forward.path_info"));
                    r.setAttribute("javax.servlet.async.query_string", r.getAttribute("javax.servlet.forward.query_string"));
                } else {
                    r.setAttribute("javax.servlet.async.request_uri", r.getRequestURI());
                    r.setAttribute("javax.servlet.async.context_path", r.getContextPath());
                    r.setAttribute("javax.servlet.async.servlet_path", r.getServletPath());
                    r.setAttribute("javax.servlet.async.path_info", r.getPathInfo());
                    r.setAttribute("javax.servlet.async.query_string", r.getQueryString());
                }
            }
        }

        public ServletContext getSuspendedContext() {
            return this._suspendedContext;
        }

        public ServletContext getDispatchContext() {
            return this._dispatchContext;
        }

        public ServletContext getServletContext() {
            return this._dispatchContext == null ? this._suspendedContext : this._dispatchContext;
        }

        public String getPath() {
            return this._pathInContext;
        }
    }

    public class AsyncTimeout
    implements Runnable {
        @Override
        public void run() {
            HttpChannelState.this.expired();
        }
    }

    public static enum State {
        IDLE,
        DISPATCHED,
        ASYNCSTARTED,
        REDISPATCHING,
        ASYNCWAIT,
        REDISPATCH,
        REDISPATCHED,
        COMPLETECALLED,
        COMPLETING,
        COMPLETED;

    }
}

