/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationListener;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Request Statistics Gathering")
public class StatisticsHandler
extends HandlerWrapper {
    private final AtomicLong _statsStartedAt = new AtomicLong();
    private final CounterStatistic _requestStats = new CounterStatistic();
    private final SampleStatistic _requestTimeStats = new SampleStatistic();
    private final CounterStatistic _dispatchedStats = new CounterStatistic();
    private final SampleStatistic _dispatchedTimeStats = new SampleStatistic();
    private final CounterStatistic _suspendStats = new CounterStatistic();
    private final AtomicInteger _resumes = new AtomicInteger();
    private final AtomicInteger _expires = new AtomicInteger();
    private final AtomicInteger _responses1xx = new AtomicInteger();
    private final AtomicInteger _responses2xx = new AtomicInteger();
    private final AtomicInteger _responses3xx = new AtomicInteger();
    private final AtomicInteger _responses4xx = new AtomicInteger();
    private final AtomicInteger _responses5xx = new AtomicInteger();
    private final AtomicLong _responsesTotalBytes = new AtomicLong();
    private final ContinuationListener _onCompletion = new ContinuationListener(){

        public void onComplete(Continuation continuation) {
            Request request = ((HttpChannelState)continuation).getBaseRequest();
            long elapsed = System.currentTimeMillis() - request.getTimeStamp();
            StatisticsHandler.this._requestStats.decrement();
            StatisticsHandler.this._requestTimeStats.set(elapsed);
            StatisticsHandler.this.updateResponse(request);
            if (!continuation.isResumed()) {
                StatisticsHandler.this._suspendStats.decrement();
            }
        }

        public void onTimeout(Continuation continuation) {
            StatisticsHandler.this._expires.incrementAndGet();
        }
    };

    @ManagedOperation(value="resets statistics", impact="ACTION")
    public void statsReset() {
        this._statsStartedAt.set(System.currentTimeMillis());
        this._requestStats.reset();
        this._requestTimeStats.reset();
        this._dispatchedStats.reset();
        this._dispatchedTimeStats.reset();
        this._suspendStats.reset();
        this._resumes.set(0);
        this._expires.set(0);
        this._responses1xx.set(0);
        this._responses2xx.set(0);
        this._responses3xx.set(0);
        this._responses4xx.set(0);
        this._responses5xx.set(0);
        this._responsesTotalBytes.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String path, Request request, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException, ServletException {
        long start;
        this._dispatchedStats.increment();
        HttpChannelState continuation = request.getAsyncContinuation();
        if (continuation.isInitial()) {
            this._requestStats.increment();
            start = request.getTimeStamp();
        } else {
            start = System.currentTimeMillis();
            this._suspendStats.decrement();
            if (continuation.isResumed()) {
                this._resumes.incrementAndGet();
            }
        }
        try {
            super.handle(path, request, httpRequest, httpResponse);
        }
        finally {
            long now = System.currentTimeMillis();
            long dispatched = now - start;
            this._dispatchedStats.decrement();
            this._dispatchedTimeStats.set(dispatched);
            if (continuation.isSuspended()) {
                if (continuation.isInitial()) {
                    continuation.addContinuationListener(this._onCompletion);
                }
                this._suspendStats.increment();
            } else if (continuation.isInitial()) {
                this._requestStats.decrement();
                this._requestTimeStats.set(dispatched);
                this.updateResponse(request);
            }
        }
    }

    private void updateResponse(Request request) {
        Response response = request.getResponse();
        switch (response.getStatus() / 100) {
            case 0: {
                if (request.isHandled()) {
                    this._responses2xx.incrementAndGet();
                    break;
                }
                this._responses4xx.incrementAndGet();
                break;
            }
            case 1: {
                this._responses1xx.incrementAndGet();
                break;
            }
            case 2: {
                this._responses2xx.incrementAndGet();
                break;
            }
            case 3: {
                this._responses3xx.incrementAndGet();
                break;
            }
            case 4: {
                this._responses4xx.incrementAndGet();
                break;
            }
            case 5: {
                this._responses5xx.incrementAndGet();
                break;
            }
        }
        this._responsesTotalBytes.addAndGet(response.getContentCount());
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.statsReset();
    }

    @ManagedAttribute(value="number of requests")
    public int getRequests() {
        return (int)this._requestStats.getTotal();
    }

    @ManagedAttribute(value="number of requests currently active")
    public int getRequestsActive() {
        return (int)this._requestStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of active requests")
    public int getRequestsActiveMax() {
        return (int)this._requestStats.getMax();
    }

    @ManagedAttribute(value="maximum time spend handling requests (in ms)")
    public long getRequestTimeMax() {
        return this._requestTimeStats.getMax();
    }

    @ManagedAttribute(value="total time spend in all request handling (in ms)")
    public long getRequestTimeTotal() {
        return this._requestTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time spent handling requests (in ms)")
    public double getRequestTimeMean() {
        return this._requestTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation for request handling (in ms)")
    public double getRequestTimeStdDev() {
        return this._requestTimeStats.getStdDev();
    }

    @ManagedAttribute(value="number of dispatches")
    public int getDispatched() {
        return (int)this._dispatchedStats.getTotal();
    }

    @ManagedAttribute(value="number of dispatches currently active")
    public int getDispatchedActive() {
        return (int)this._dispatchedStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of active dispatches being handled")
    public int getDispatchedActiveMax() {
        return (int)this._dispatchedStats.getMax();
    }

    @ManagedAttribute(value="maximum time spend in dispatch handling")
    public long getDispatchedTimeMax() {
        return this._dispatchedTimeStats.getMax();
    }

    @ManagedAttribute(value="total time spent in dispatch handling (in ms)")
    public long getDispatchedTimeTotal() {
        return this._dispatchedTimeStats.getTotal();
    }

    @ManagedAttribute(value="mean time spent in dispatch handling (in ms)")
    public double getDispatchedTimeMean() {
        return this._dispatchedTimeStats.getMean();
    }

    @ManagedAttribute(value="standard deviation for dispatch handling (in ms)")
    public double getDispatchedTimeStdDev() {
        return this._dispatchedTimeStats.getStdDev();
    }

    @ManagedAttribute(value="number of requests suspended")
    public int getSuspends() {
        return (int)this._suspendStats.getTotal();
    }

    @ManagedAttribute(value="number of currently suspended requests")
    public int getSuspendsActive() {
        return (int)this._suspendStats.getCurrent();
    }

    @ManagedAttribute(value="maximum number of suspended requests")
    public int getSuspendsActiveMax() {
        return (int)this._suspendStats.getMax();
    }

    @ManagedAttribute(value="number of requested that have been resumed")
    public int getResumes() {
        return this._resumes.get();
    }

    @ManagedAttribute(value="number of requests have have expired")
    public int getExpires() {
        return this._expires.get();
    }

    @ManagedAttribute(value="number of requests with 1xx response status")
    public int getResponses1xx() {
        return this._responses1xx.get();
    }

    @ManagedAttribute(value="number of requests with 2xx response status")
    public int getResponses2xx() {
        return this._responses2xx.get();
    }

    @ManagedAttribute(value="number of requests with 3xx response status")
    public int getResponses3xx() {
        return this._responses3xx.get();
    }

    @ManagedAttribute(value="number of requests with 4xx response status")
    public int getResponses4xx() {
        return this._responses4xx.get();
    }

    @ManagedAttribute(value="number of requests with 5xx response status")
    public int getResponses5xx() {
        return this._responses5xx.get();
    }

    @ManagedAttribute(value="time in milliseconds stats have been collected for")
    public long getStatsOnMs() {
        return System.currentTimeMillis() - this._statsStartedAt.get();
    }

    @ManagedAttribute(value="total number of bytes across all responses")
    public long getResponsesBytesTotal() {
        return this._responsesTotalBytes.get();
    }

    public String toStatsHTML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>Statistics:</h1>\n");
        sb.append("Statistics gathering started ").append(this.getStatsOnMs()).append("ms ago").append("<br />\n");
        sb.append("<h2>Requests:</h2>\n");
        sb.append("Total requests: ").append(this.getRequests()).append("<br />\n");
        sb.append("Active requests: ").append(this.getRequestsActive()).append("<br />\n");
        sb.append("Max active requests: ").append(this.getRequestsActiveMax()).append("<br />\n");
        sb.append("Total requests time: ").append(this.getRequestTimeTotal()).append("<br />\n");
        sb.append("Mean request time: ").append(this.getRequestTimeMean()).append("<br />\n");
        sb.append("Max request time: ").append(this.getRequestTimeMax()).append("<br />\n");
        sb.append("Request time standard deviation: ").append(this.getRequestTimeStdDev()).append("<br />\n");
        sb.append("<h2>Dispatches:</h2>\n");
        sb.append("Total dispatched: ").append(this.getDispatched()).append("<br />\n");
        sb.append("Active dispatched: ").append(this.getDispatchedActive()).append("<br />\n");
        sb.append("Max active dispatched: ").append(this.getDispatchedActiveMax()).append("<br />\n");
        sb.append("Total dispatched time: ").append(this.getDispatchedTimeTotal()).append("<br />\n");
        sb.append("Mean dispatched time: ").append(this.getDispatchedTimeMean()).append("<br />\n");
        sb.append("Max dispatched time: ").append(this.getDispatchedTimeMax()).append("<br />\n");
        sb.append("Dispatched time standard deviation: ").append(this.getDispatchedTimeStdDev()).append("<br />\n");
        sb.append("Total requests suspended: ").append(this.getSuspends()).append("<br />\n");
        sb.append("Total requests expired: ").append(this.getExpires()).append("<br />\n");
        sb.append("Total requests resumed: ").append(this.getResumes()).append("<br />\n");
        sb.append("<h2>Responses:</h2>\n");
        sb.append("1xx responses: ").append(this.getResponses1xx()).append("<br />\n");
        sb.append("2xx responses: ").append(this.getResponses2xx()).append("<br />\n");
        sb.append("3xx responses: ").append(this.getResponses3xx()).append("<br />\n");
        sb.append("4xx responses: ").append(this.getResponses4xx()).append("<br />\n");
        sb.append("5xx responses: ").append(this.getResponses5xx()).append("<br />\n");
        sb.append("Bytes sent total: ").append(this.getResponsesBytesTotal()).append("<br />\n");
        return sb.toString();
    }
}

