/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.servlet.ServletOutputStream;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.Resource;

public class HttpOutput
extends ServletOutputStream {
    private final HttpChannel<?> _channel;
    private boolean _closed;
    private long _written;
    private ByteBuffer _aggregate;
    private int _bufferSize;

    public HttpOutput(HttpChannel<?> channel) {
        this._channel = channel;
        this._bufferSize = this._channel.getHttpChannelConfig().getOutputBufferSize();
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reset() {
        this._written = 0L;
        this._closed = false;
    }

    public void reopen() {
        this._closed = false;
    }

    public void close() throws IOException {
        if (!this._closed) {
            if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
                this._channel.write(this._aggregate, !this._channel.getResponse().isIncluding());
            } else {
                this._channel.write(BufferUtil.EMPTY_BUFFER, !this._channel.getResponse().isIncluding());
            }
        }
        this._closed = true;
        if (this._aggregate != null) {
            this._channel.getConnector().getByteBufferPool().release(this._aggregate);
            this._aggregate = null;
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    public void flush() throws IOException {
        if (this._closed) {
            throw new EofException();
        }
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
        } else {
            this._channel.write(BufferUtil.EMPTY_BUFFER, false);
        }
    }

    public boolean closeIfAllContentWritten() throws IOException {
        return this._channel.getResponse().closeIfAllContentWritten(this._written);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        int space;
        if (this._closed) {
            throw new EOFException();
        }
        if (this._aggregate == null) {
            int size = this.getBufferSize();
            if (len > size / 2) {
                this._channel.write(ByteBuffer.wrap(b, off, len), false);
                this._written += (long)len;
                return;
            }
            this._aggregate = this._channel.getByteBufferPool().acquire(size, false);
        }
        if (len > (space = BufferUtil.space((ByteBuffer)this._aggregate)) && BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
            space = BufferUtil.space((ByteBuffer)this._aggregate);
        }
        if (len > space) {
            this._channel.write(ByteBuffer.wrap(b, off, len), false);
            this._written += (long)len;
            return;
        }
        BufferUtil.append((ByteBuffer)this._aggregate, (byte[])b, (int)off, (int)len);
        this._written += (long)len;
        if (!this.closeIfAllContentWritten() && BufferUtil.isFull((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
        }
    }

    public void write(int b) throws IOException {
        if (this._closed) {
            throw new EOFException();
        }
        if (this._aggregate == null) {
            this._aggregate = this._channel.getByteBufferPool().acquire(this.getBufferSize(), false);
        }
        BufferUtil.append((ByteBuffer)this._aggregate, (byte)((byte)b));
        ++this._written;
        if (!this.closeIfAllContentWritten() && BufferUtil.isFull((ByteBuffer)this._aggregate)) {
            this._channel.write(this._aggregate, false);
        }
    }

    public void print(String s) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        this.write(s.getBytes(this._channel.getResponse().getCharacterEncoding()));
    }

    public void sendContent(Object content) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        if (content instanceof HttpContent) {
            long lml;
            String lm;
            HttpContent httpContent = (HttpContent)content;
            Response response = this._channel.getResponse();
            String contentType = httpContent.getContentType();
            if (contentType != null && !response.getHttpFields().containsKey(HttpHeader.CONTENT_TYPE.asString())) {
                response.getHttpFields().put(HttpHeader.CONTENT_TYPE, contentType);
            }
            if (httpContent.getContentLength() > 0L) {
                response.getHttpFields().putLongField(HttpHeader.CONTENT_LENGTH, httpContent.getContentLength());
            }
            if ((lm = httpContent.getLastModified()) != null) {
                response.getHttpFields().put(HttpHeader.LAST_MODIFIED, lm);
            } else if (httpContent.getResource() != null && (lml = httpContent.getResource().lastModified()) != -1L) {
                response.getHttpFields().putDateField(HttpHeader.LAST_MODIFIED, lml);
            }
            content = httpContent.getDirectBuffer();
            if (content == null) {
                content = httpContent.getIndirectBuffer();
            }
            if (content == null) {
                content = httpContent.getInputStream();
            }
        } else if (content instanceof Resource) {
            Resource resource = (Resource)content;
            this._channel.getResponse().getHttpFields().putDateField(HttpHeader.LAST_MODIFIED, resource.lastModified());
            content = resource.getInputStream();
        }
        if (!(content instanceof ByteBuffer)) {
            if (content instanceof InputStream) {
                throw new IllegalArgumentException("not implemented!");
            }
            throw new IllegalArgumentException("unknown content type?");
        }
        this._channel.write((ByteBuffer)content, true);
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
    }

    public void resetBuffer() {
        if (BufferUtil.hasContent((ByteBuffer)this._aggregate)) {
            BufferUtil.clear((ByteBuffer)this._aggregate);
        }
    }
}

