/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FilterConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.annotation.Name;

public class FilterConnectionFactory
extends AbstractConnectionFactory {
    private final String _nextProtocol;
    private final int _outputBufferSize;
    private final CopyOnWriteArrayList<FilterConnection.Filter> _filters = new CopyOnWriteArrayList();

    public FilterConnectionFactory() {
        this(HttpVersion.HTTP_1_1.asString());
    }

    public FilterConnectionFactory(String nextProtocol) {
        this(nextProtocol, 16384);
    }

    public FilterConnectionFactory(@Name(value="nextProtocol") String nextProtocol, @Name(value="outputBufferSize") int outputBufferSize) {
        super("filter-" + nextProtocol);
        this._nextProtocol = nextProtocol;
        this._outputBufferSize = outputBufferSize;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        FilterConnection filteredConnection = new FilterConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, this._outputBufferSize);
        this.configure((AbstractConnection)filteredConnection, connector, endPoint);
        this.addFilters(connector, filteredConnection);
        ConnectionFactory next = connector.getConnectionFactory(this._nextProtocol);
        FilterConnection.FilteredEndPoint filteredEndPoint = filteredConnection.getFilterEndPoint();
        Connection connection = next.newConnection(connector, (EndPoint)filteredEndPoint);
        filteredEndPoint.setConnection(connection);
        return filteredConnection;
    }

    protected void addFilters(Connector connector, FilterConnection filteredConnection) {
        for (FilterConnection.Filter filter : this._filters) {
            filteredConnection.addFilter(filter);
        }
    }

    public void addFilter(FilterConnection.Filter filter) {
        this.addBean(filter);
        this._filters.add(filter);
    }

    public boolean removeFilter(FilterConnection.Filter filter) {
        this.removeBean(filter);
        return this._filters.remove(filter);
    }
}

