/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RequestLogHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(RequestLogHandler.class);
    private RequestLog _requestLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpChannelState continuation = baseRequest.getHttpChannelState();
        if (!continuation.isInitial()) {
            baseRequest.setDispatchTime(System.currentTimeMillis());
        }
        try {
            super.handle(target, baseRequest, request, response);
        }
        finally {
            if (this._requestLog != null && DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
                this._requestLog.log(baseRequest, (Response)response);
            }
        }
    }

    public void setRequestLog(RequestLog requestLog) {
        this.updateBean(this._requestLog, requestLog);
        this._requestLog = requestLog;
    }

    public RequestLog getRequestLog() {
        return this._requestLog;
    }
}

