/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpInputOverHTTP;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.NegotiatingServerConnectionFactory;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

class HttpChannelOverHttp
extends HttpChannel
implements HttpParser.RequestHandler {
    private static final Logger LOG = Log.getLogger(HttpChannelOverHttp.class);
    private final HttpFields _fields = new HttpFields();
    private final MetaData.Request _metadata = new MetaData.Request(this._fields);
    private final HttpConnection _httpConnection;
    private HttpField _connection;
    private boolean _delayedForContent;
    private boolean _unknownExpectation = false;
    private boolean _expect100Continue = false;
    private boolean _expect102Processing = false;

    public HttpChannelOverHttp(HttpConnection httpConnection, Connector connector, HttpConfiguration config, EndPoint endPoint, HttpTransport transport) {
        super(connector, config, endPoint, transport);
        this._httpConnection = httpConnection;
        this._metadata.setURI(new HttpURI());
    }

    @Override
    protected HttpInput newHttpInput(HttpChannelState state) {
        return new HttpInputOverHTTP(state);
    }

    @Override
    public void recycle() {
        super.recycle();
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        this._metadata.recycle();
        this._connection = null;
        this._fields.clear();
    }

    @Override
    public boolean isExpecting100Continue() {
        return this._expect100Continue;
    }

    @Override
    public boolean isExpecting102Processing() {
        return this._expect102Processing;
    }

    public boolean startRequest(String method, String uri, HttpVersion version) {
        this._metadata.setMethod(method);
        this._metadata.getURI().parse(uri);
        this._metadata.setHttpVersion(version);
        this._unknownExpectation = false;
        this._expect100Continue = false;
        this._expect102Processing = false;
        return false;
    }

    public void parsedHeader(HttpField field) {
        HttpHeader header = field.getHeader();
        String value = field.getValue();
        if (header != null) {
            block0 : switch (header) {
                case CONNECTION: {
                    this._connection = field;
                    break;
                }
                case HOST: {
                    if (this._metadata.getURI().isAbsolute() || !(field instanceof HostPortHttpField)) break;
                    HostPortHttpField hp = (HostPortHttpField)field;
                    this._metadata.getURI().setAuthority(hp.getHost(), hp.getPort());
                    break;
                }
                case EXPECT: {
                    if (this._metadata.getVersion() != HttpVersion.HTTP_1_1) break;
                    HttpHeaderValue expect = (HttpHeaderValue)HttpHeaderValue.CACHE.get(value);
                    switch (expect == null ? HttpHeaderValue.UNKNOWN : expect) {
                        case CONTINUE: {
                            this._expect100Continue = true;
                            break block0;
                        }
                        case PROCESSING: {
                            this._expect102Processing = true;
                            break block0;
                        }
                    }
                    String[] values = field.getValues();
                    block13: for (int i = 0; values != null && i < values.length; ++i) {
                        expect = (HttpHeaderValue)HttpHeaderValue.CACHE.get(values[i].trim());
                        if (expect == null) {
                            this._unknownExpectation = true;
                            continue;
                        }
                        switch (expect) {
                            case CONTINUE: {
                                this._expect100Continue = true;
                                continue block13;
                            }
                            case PROCESSING: {
                                this._expect102Processing = true;
                                continue block13;
                            }
                            default: {
                                this._unknownExpectation = true;
                            }
                        }
                    }
                    break;
                }
            }
        }
        this._fields.add(field);
    }

    @Override
    public void continue100(int available) throws IOException {
        if (this.isExpecting100Continue()) {
            this._expect100Continue = false;
            if (available == 0) {
                if (this.getResponse().isCommitted()) {
                    throw new IOException("Committed before 100 Continues");
                }
                boolean committed = this.sendResponse(HttpGenerator.CONTINUE_100_INFO, null, false);
                if (!committed) {
                    throw new IOException("Concurrent commit while trying to send 100-Continue");
                }
            }
        }
    }

    public void earlyEOF() {
        if (this._metadata.getMethod() == null) {
            this._httpConnection.close();
        } else {
            this.onEarlyEOF();
        }
    }

    public boolean content(ByteBuffer content) {
        HttpInput.Content c = this._httpConnection.newContent(content);
        boolean handle = this.onContent(c) || this._delayedForContent;
        this._delayedForContent = false;
        return handle;
    }

    @Override
    public void asyncReadFillInterested() {
        this._httpConnection.asyncReadFillInterested();
    }

    public void badMessage(int status, String reason) {
        this._httpConnection.getGenerator().setPersistent(false);
        try {
            this.onRequest(this._metadata);
        }
        catch (Exception e) {
            LOG.ignore((Throwable)e);
        }
        this.onBadMessage(status, reason);
    }

    public boolean headerComplete() {
        boolean persistent;
        switch (this._metadata.getVersion()) {
            case HTTP_1_0: {
                persistent = this._connection != null ? (this._connection.contains(HttpHeaderValue.KEEP_ALIVE.asString()) ? true : this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE.asString())) : false;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (!persistent) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.KEEP_ALIVE);
                break;
            }
            case HTTP_1_1: {
                if (this._unknownExpectation) {
                    this.badMessage(417, null);
                    return false;
                }
                persistent = this._connection != null ? (this._connection.contains(HttpHeaderValue.CLOSE.asString()) ? false : !this._fields.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) : true;
                if (!persistent) {
                    persistent = HttpMethod.CONNECT.is(this._metadata.getMethod());
                }
                if (persistent) break;
                this.getResponse().getHttpFields().add(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE);
                break;
            }
            case HTTP_2: {
                ConnectionFactory h2 = null;
                if (!(this.getConnector().getDefaultConnectionFactory() instanceof NegotiatingServerConnectionFactory)) {
                    for (ConnectionFactory factory : this.getConnector().getConnectionFactories()) {
                        if (!factory.getProtocols().contains("h2c")) continue;
                        h2 = factory;
                    }
                }
                if (h2 == null || this._metadata.getMethod() != HttpMethod.PRI.asString() || !"*".equals(this._metadata.getURI().toString()) || this._fields.size() > 0) {
                    this.badMessage(426, null);
                    return false;
                }
                Connection old_connection = this.getEndPoint().getConnection();
                Connection new_connection = h2.newConnection(this.getConnector(), this.getEndPoint());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Direct Upgrade from {} to {}", new Object[]{old_connection, new_connection});
                }
                this.getResponse().setStatus(101);
                this.getRequest().setAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", new_connection);
                this.getHttpTransport().onCompleted();
                return true;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (!persistent) {
            this._httpConnection.getGenerator().setPersistent(false);
        }
        this.onRequest(this._metadata);
        this._delayedForContent = this.getHttpConfiguration().isDelayDispatchUntilContent() && this._httpConnection.getParser().getContentLength() > 0L && !this.isExpecting100Continue() && !this.isCommitted() && this._httpConnection.isRequestBufferEmpty();
        return !this._delayedForContent;
    }

    @Override
    protected void handleException(Throwable x) {
        this._httpConnection.getGenerator().setPersistent(false);
        super.handleException(x);
    }

    @Override
    public void abort(Throwable failure) {
        super.abort(failure);
        this._httpConnection.getGenerator().setPersistent(false);
    }

    public boolean messageComplete() {
        return this.onRequestComplete();
    }

    public int getHeaderCacheSize() {
        return this.getHttpConfiguration().getHeaderCacheSize();
    }
}

