/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class HouseKeeper
extends AbstractLifeCycle {
    private static final Logger LOG = Log.getLogger((String)"org.eclipse.jetty.server.session");
    public static final long DEFAULT_PERIOD_MS = 600000L;
    protected SessionIdManager _sessionIdManager;
    protected Scheduler _scheduler;
    protected Scheduler.Task _task;
    protected Runner _runner;
    protected boolean _ownScheduler = false;
    private long _intervalMs = 600000L;

    public void setSessionIdManager(SessionIdManager sessionIdManager) {
        this._sessionIdManager = sessionIdManager;
    }

    protected void doStart() throws Exception {
        if (this._sessionIdManager == null) {
            throw new IllegalStateException("No SessionIdManager for Housekeeper");
        }
        if (this._sessionIdManager instanceof DefaultSessionIdManager) {
            this._scheduler = (Scheduler)((DefaultSessionIdManager)this._sessionIdManager).getServer().getBean(Scheduler.class);
        }
        if (this._scheduler == null) {
            this._scheduler = new ScheduledExecutorScheduler();
            this._ownScheduler = true;
            this._scheduler.start();
        } else if (!this._scheduler.isStarted()) {
            throw new IllegalStateException("Shared scheduler not started");
        }
        this.setIntervalSec(this.getIntervalSec());
        super.doStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (this._task != null) {
                this._task.cancel();
            }
            this._task = null;
            if (this._ownScheduler && this._scheduler != null) {
                this._scheduler.stop();
            }
            this._scheduler = null;
            this._runner = null;
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntervalSec(long sec) {
        long period;
        if (sec <= 0L) {
            sec = 60L;
        }
        long old_period = this._intervalMs;
        this._intervalMs = period = sec * 1000L;
        long tenPercent = this._intervalMs / 10L;
        if (System.currentTimeMillis() % 2L == 0L) {
            this._intervalMs += tenPercent;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging every " + this._intervalMs + " ms", new Object[0]);
        }
        HouseKeeper houseKeeper = this;
        synchronized (houseKeeper) {
            if (this._scheduler != null && (period != old_period || this._task == null)) {
                if (this._task != null) {
                    this._task.cancel();
                }
                if (this._runner == null) {
                    this._runner = new Runner();
                }
                this._task = this._scheduler.schedule((Runnable)this._runner, this._intervalMs, TimeUnit.MILLISECONDS);
            }
        }
    }

    public long getIntervalSec() {
        return this._intervalMs / 1000L;
    }

    public void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scavenging sessions", new Object[0]);
        }
        for (SessionHandler manager : this._sessionIdManager.getSessionHandlers()) {
            if (manager == null) continue;
            try {
                manager.scavenge();
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    public String toString() {
        return super.toString() + "[interval=" + this._intervalMs + ", ownscheduler=" + this._ownScheduler + "]";
    }

    protected class Runner
    implements Runnable {
        protected Runner() {
        }

        @Override
        public void run() {
            try {
                HouseKeeper.this.scavenge();
            }
            finally {
                if (HouseKeeper.this._scheduler != null && HouseKeeper.this._scheduler.isRunning()) {
                    HouseKeeper.this._task = HouseKeeper.this._scheduler.schedule((Runnable)this, HouseKeeper.this._intervalMs, TimeUnit.MILLISECONDS);
                }
            }
        }
    }
}

