/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.io.ArrayByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.EncodingHttpWriter;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.Iso88591HttpWriter;
import org.eclipse.jetty.server.MockConnector;
import org.eclipse.jetty.server.Utf8HttpWriter;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HttpWriterTest {
    private HttpOutput _httpOut;
    private ByteBuffer _bytes;

    @BeforeEach
    public void init() throws Exception {
        this._bytes = BufferUtil.allocate((int)2048);
        ArrayByteBufferPool pool = new ArrayByteBufferPool();
        HttpChannel channel = new HttpChannel((Connector)new MockConnector(), new HttpConfiguration(), null, null, (ByteBufferPool)pool){
            final /* synthetic */ ByteBufferPool val$pool;
            {
                this.val$pool = byteBufferPool;
                super(arg0, arg1, arg2, arg3);
            }

            public ByteBufferPool getByteBufferPool() {
                return this.val$pool;
            }
        };
        this._httpOut = new HttpOutput(channel){

            public void write(byte[] b, int off, int len) throws IOException {
                BufferUtil.append((ByteBuffer)HttpWriterTest.this._bytes, (byte[])b, (int)off, (int)len);
            }
        };
    }

    @Test
    public void testSimpleUTF8() throws Exception {
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        writer.write("Now is the time");
        this.assertArrayEquals("Now is the time".getBytes(StandardCharsets.UTF_8), BufferUtil.toArray((ByteBuffer)this._bytes));
    }

    @Test
    public void testUTF8() throws Exception {
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        writer.write("How now \uff22rown cow");
        this.assertArrayEquals("How now \uff22rown cow".getBytes(StandardCharsets.UTF_8), BufferUtil.toArray((ByteBuffer)this._bytes));
    }

    @Test
    public void testUTF16() throws Exception {
        EncodingHttpWriter writer = new EncodingHttpWriter(this._httpOut, "utf-16");
        writer.write("How now \uff22rown cow");
        this.assertArrayEquals("How now \uff22rown cow".getBytes(StandardCharsets.UTF_16), BufferUtil.toArray((ByteBuffer)this._bytes));
    }

    @Test
    public void testNotCESU8() throws Exception {
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        String data = "xxx\ud801\udc00xxx";
        writer.write(data);
        Assertions.assertEquals((Object)"787878F0909080787878", (Object)TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)this._bytes)));
        this.assertArrayEquals(data.getBytes(StandardCharsets.UTF_8), BufferUtil.toArray((ByteBuffer)this._bytes));
        Assertions.assertEquals((int)10, (int)this._bytes.remaining());
        Utf8StringBuilder buf = new Utf8StringBuilder();
        buf.append(BufferUtil.toArray((ByteBuffer)this._bytes), 0, this._bytes.remaining());
        Assertions.assertEquals((Object)data, (Object)buf.toString());
    }

    @Test
    public void testMultiByteOverflowUTF8() throws Exception {
        int i;
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        String singleByteStr = "a";
        String multiByteDuplicateStr = "\uff22";
        int remainSize = 1;
        int multiByteStrByteLength = "\uff22".getBytes(StandardCharsets.UTF_8).length;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 512 - multiByteStrByteLength; ++i) {
            sb.append("a");
        }
        sb.append("\uff22");
        for (i = 0; i < remainSize; ++i) {
            sb.append("a");
        }
        char[] buf = new char[1536];
        int length = 512 - multiByteStrByteLength + remainSize + 1;
        sb.toString().getChars(0, length, buf, 0);
        writer.write(buf, 0, length);
        Assertions.assertEquals((Object)sb.toString(), (Object)new String(BufferUtil.toArray((ByteBuffer)this._bytes), StandardCharsets.UTF_8));
    }

    @Test
    public void testISO8859() throws Exception {
        Iso88591HttpWriter writer = new Iso88591HttpWriter(this._httpOut);
        writer.write("How now \uff22rown cow");
        Assertions.assertEquals((Object)new String(BufferUtil.toArray((ByteBuffer)this._bytes), StandardCharsets.ISO_8859_1), (Object)"How now ?rown cow");
    }

    @Test
    public void testUTF16x2() throws Exception {
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        String source = "\ud842\udf9f";
        byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
        writer.write(source.toCharArray(), 0, source.toCharArray().length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        osw.write(source.toCharArray(), 0, source.toCharArray().length);
        osw.flush();
        this.myReportBytes(bytes);
        this.myReportBytes(baos.toByteArray());
        this.myReportBytes(BufferUtil.toArray((ByteBuffer)this._bytes));
        this.assertArrayEquals(bytes, BufferUtil.toArray((ByteBuffer)this._bytes));
        this.assertArrayEquals(baos.toByteArray(), BufferUtil.toArray((ByteBuffer)this._bytes));
    }

    @Test
    public void testMultiByteOverflowUTF16x2() throws Exception {
        int i;
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        String singleByteStr = "a";
        int remainSize = 1;
        String multiByteDuplicateStr = "\ud842\udf9f";
        int adjustSize = -1;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 512 + adjustSize; ++i) {
            sb.append("a");
        }
        sb.append("\ud842\udf9f");
        for (i = 0; i < remainSize; ++i) {
            sb.append("a");
        }
        String source = sb.toString();
        byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
        writer.write(source.toCharArray(), 0, source.toCharArray().length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        osw.write(source.toCharArray(), 0, source.toCharArray().length);
        osw.flush();
        this.myReportBytes(bytes);
        this.myReportBytes(baos.toByteArray());
        this.myReportBytes(BufferUtil.toArray((ByteBuffer)this._bytes));
        this.assertArrayEquals(bytes, BufferUtil.toArray((ByteBuffer)this._bytes));
        this.assertArrayEquals(baos.toByteArray(), BufferUtil.toArray((ByteBuffer)this._bytes));
    }

    @Test
    public void testMultiByteOverflowUTF16X22() throws Exception {
        int i;
        Utf8HttpWriter writer = new Utf8HttpWriter(this._httpOut);
        String singleByteStr = "a";
        int remainSize = 1;
        String multiByteDuplicateStr = "\ud842\udf9f";
        int adjustSize = -2;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < 512 + adjustSize; ++i) {
            sb.append("a");
        }
        sb.append("\ud842\udf9f");
        for (i = 0; i < remainSize; ++i) {
            sb.append("a");
        }
        String source = sb.toString();
        byte[] bytes = source.getBytes(StandardCharsets.UTF_8);
        writer.write(source.toCharArray(), 0, source.toCharArray().length);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
        osw.write(source.toCharArray(), 0, source.toCharArray().length);
        osw.flush();
        this.myReportBytes(bytes);
        this.myReportBytes(baos.toByteArray());
        this.myReportBytes(BufferUtil.toArray((ByteBuffer)this._bytes));
        this.assertArrayEquals(bytes, BufferUtil.toArray((ByteBuffer)this._bytes));
        this.assertArrayEquals(baos.toByteArray(), BufferUtil.toArray((ByteBuffer)this._bytes));
    }

    private void myReportBytes(byte[] bytes) throws Exception {
    }

    private void assertArrayEquals(byte[] b1, byte[] b2) {
        String test = new String(b1) + "==" + new String(b2);
        Assertions.assertEquals((int)b1.length, (int)b2.length, (String)test);
        for (int i = 0; i < b1.length; ++i) {
            Assertions.assertEquals((byte)b1[i], (byte)b2[i], (String)test);
        }
    }
}

