/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class InclusiveByteRangeTest {
    private void assertInvalidRange(String rangeString) {
        Vector<String> strings = new Vector<String>();
        strings.add(rangeString);
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)200L);
        Assertions.assertNull((Object)ranges, (String)("Invalid Range [" + rangeString + "] should result in no satisfiable ranges"));
    }

    private void assertRange(String msg, int expectedFirst, int expectedLast, int size, InclusiveByteRange actualRange) {
        Assertions.assertEquals((long)expectedFirst, (long)actualRange.getFirst(), (String)(msg + " - first"));
        Assertions.assertEquals((long)expectedLast, (long)actualRange.getLast(), (String)(msg + " - last"));
        String expectedHeader = String.format("bytes %d-%d/%d", expectedFirst, expectedLast, size);
        MatcherAssert.assertThat((String)(msg + " - header range string"), (Object)actualRange.toHeaderRangeString((long)size), (Matcher)Matchers.is((Object)expectedHeader));
    }

    private void assertSimpleRange(int expectedFirst, int expectedLast, String rangeId, int size) {
        InclusiveByteRange range = this.parseRange(rangeId, size);
        Assertions.assertEquals((long)expectedFirst, (long)range.getFirst(), (String)("Range [" + rangeId + "] - first"));
        Assertions.assertEquals((long)expectedLast, (long)range.getLast(), (String)("Range [" + rangeId + "] - last"));
        String expectedHeader = String.format("bytes %d-%d/%d", expectedFirst, expectedLast, size);
        Assertions.assertEquals((Object)expectedHeader, (Object)range.toHeaderRangeString((long)size), (String)("Range [" + rangeId + "] - header range string"));
    }

    private InclusiveByteRange parseRange(String rangeString, int size) {
        Vector<String> strings = new Vector<String>();
        strings.add(rangeString);
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)size);
        Assertions.assertNotNull((Object)ranges, (String)"Satisfiable Ranges should not be null");
        Assertions.assertEquals((int)1, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        return (InclusiveByteRange)ranges.iterator().next();
    }

    private List<InclusiveByteRange> parseRanges(int size, String ... rangeString) {
        Vector<String> strings = new Vector<String>();
        for (String range : rangeString) {
            strings.add(range);
        }
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)size);
        Assertions.assertNotNull((Object)ranges, (String)"Satisfiable Ranges should not be null");
        return ranges;
    }

    @Test
    public void testHeader416RangeString() {
        Assertions.assertEquals((Object)"bytes */100", (Object)InclusiveByteRange.to416HeaderRangeString((long)100L), (String)"416 Header on size 100");
        Assertions.assertEquals((Object)"bytes */123456789", (Object)InclusiveByteRange.to416HeaderRangeString((long)123456789L), (String)"416 Header on size 123456789");
    }

    @Test
    public void testInvalidRanges() {
        this.assertInvalidRange("bytes=a-b");
        this.assertInvalidRange("byte=10-3");
        this.assertInvalidRange("onceuponatime=5-10");
        this.assertInvalidRange("bytes=300-310");
    }

    @Test
    public void testMultipleAbsoluteRanges() {
        int size = 50;
        String rangeString = "bytes=5-20,35-65";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 5, 20, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 35, 49, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleAbsoluteRangesSplit() {
        int size = 50;
        List<InclusiveByteRange> ranges = this.parseRanges(size, "bytes=5-20", "bytes=35-65");
        Assertions.assertEquals((int)2, (int)ranges.size());
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("testMultipleAbsoluteRangesSplit[0]", 5, 20, size, inclusiveByteRangeIterator.next());
        this.assertRange("testMultipleAbsoluteRangesSplit[1]", 35, 49, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleRangesClipped() {
        int size = 50;
        String rangeString = "bytes=5-20,35-65,-5";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 5, 20, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 35, 49, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleRangesOverlapping() {
        int size = 200;
        String rangeString = "bytes=5-20,15-25";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)1, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 5, 25, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleRangesSplit() {
        int size = 200;
        String rangeString = "bytes=5-10,15-20";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 5, 10, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 15, 20, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleSameRangesSplit() {
        int size = 200;
        String rangeString = "bytes=5-10,15-20,5-10,15-20,5-10,5-10,5-10,5-10,5-10,5-10";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 5, 10, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 15, 20, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleOverlappingRanges() {
        int size = 200;
        String rangeString = "bytes=5-15,20-30,10-25";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)1, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 5, 30, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleOverlappingRangesOrdered() {
        int size = 200;
        String rangeString = "bytes=20-30,5-15,0-5,25-35";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 20, 35, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 0, 15, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testMultipleOverlappingRangesOrderedSplit() {
        int size = 200;
        String rangeString = "bytes=20-30,5-15,0-5,25-35";
        List<InclusiveByteRange> ranges = this.parseRanges(size, "bytes=20-30", "bytes=5-15", "bytes=0-5,25-35");
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 20, 35, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 0, 15, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testNasty() {
        int size = 200;
        String rangeString = "bytes=90-100, 10-20, 30-40, -161";
        List<InclusiveByteRange> ranges = this.parseRanges(size, rangeString);
        Assertions.assertEquals((int)2, (int)ranges.size(), (String)("Satisfiable Ranges of [" + rangeString + "] count"));
        Iterator<InclusiveByteRange> inclusiveByteRangeIterator = ranges.iterator();
        this.assertRange("Range [" + rangeString + "]", 30, 199, size, inclusiveByteRangeIterator.next());
        this.assertRange("Range [" + rangeString + "]", 10, 20, size, inclusiveByteRangeIterator.next());
    }

    @Test
    public void testRangeOpenEnded() {
        this.assertSimpleRange(50, 499, "bytes=50-", 500);
    }

    @Test
    public void testSimpleRange() {
        this.assertSimpleRange(5, 10, "bytes=5-10", 200);
        this.assertSimpleRange(195, 199, "bytes=-5", 200);
        this.assertSimpleRange(50, 119, "bytes=50-150", 120);
        this.assertSimpleRange(50, 119, "bytes=50-", 120);
        this.assertSimpleRange(1, 50, "bytes= 1 - 50", 120);
    }

    private void assertBadRangeList(int size, String badRange) {
        Vector<String> strings = new Vector<String>();
        strings.add(badRange);
        List ranges = InclusiveByteRange.satisfiableRanges(strings.elements(), (long)size);
        MatcherAssert.assertThat((String)"Should have no ranges", (Object)ranges, (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    @Test
    @Disabled
    public void testBadRangeSetPartiallyBad() {
        this.assertBadRangeList(500, "bytes=1-50,1-b,a-50");
    }

    @Test
    public void testBadRangeNoNumbers() {
        this.assertBadRangeList(500, "bytes=a-b");
    }

    @Test
    public void testBadRangeEmpty() {
        this.assertBadRangeList(500, "bytes=");
    }

    @Test
    @Disabled
    public void testBadRangeZeroPrefixed() {
        this.assertBadRangeList(500, "bytes=01-050");
    }

    @Test
    public void testBadRangeHex() {
        this.assertBadRangeList(500, "bytes=0F-FF");
    }

    @Test
    @Disabled
    public void testBadRangeTabWhitespace() {
        this.assertBadRangeList(500, "bytes=\t1\t-\t50");
    }

    @Test
    public void testBadRangeTabDelim() {
        this.assertBadRangeList(500, "bytes=1-50\t90-101\t200-250");
    }

    @Test
    public void testBadRangeSemiColonDelim() {
        this.assertBadRangeList(500, "bytes=1-50;90-101;200-250");
    }

    @Test
    public void testBadRangeNegativeSize() {
        this.assertBadRangeList(500, "bytes=50-1");
    }

    @Test
    public void testBadRangeDoubleDash() {
        this.assertBadRangeList(500, "bytes=1--20");
    }

    @Test
    public void testBadRangeTrippleDash() {
        this.assertBadRangeList(500, "bytes=1---");
    }

    @Test
    public void testBadRangeZeroedNegativeSize() {
        this.assertBadRangeList(500, "bytes=050-001");
    }
}

