/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;

class SuspendHandler
extends HandlerWrapper
implements AsyncListener {
    private int _read;
    private long _suspendFor = -1L;
    private long _resumeAfter = -1L;
    private long _completeAfter = -1L;

    public int getRead() {
        return this._read;
    }

    public void setRead(int read) {
        this._read = read;
    }

    public long getSuspendFor() {
        return this._suspendFor;
    }

    public void setSuspendFor(long suspendFor) {
        this._suspendFor = suspendFor;
    }

    public long getResumeAfter() {
        return this._resumeAfter;
    }

    public void setResumeAfter(long resumeAfter) {
        this._resumeAfter = resumeAfter;
    }

    public long getCompleteAfter() {
        return this._completeAfter;
    }

    public void setCompleteAfter(long completeAfter) {
        this._completeAfter = completeAfter;
    }

    public void handle(String target, final Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        if (DispatcherType.REQUEST.equals((Object)baseRequest.getDispatcherType())) {
            if (this._read > 0) {
                byte[] buf = new byte[this._read];
                request.getInputStream().read(buf);
            } else if (this._read < 0) {
                ServletInputStream in = request.getInputStream();
                int b = in.read();
                while (b != -1) {
                    b = in.read();
                }
            }
            final AsyncContext asyncContext = baseRequest.startAsync();
            asyncContext.addListener((AsyncListener)this);
            if (this._suspendFor > 0L) {
                asyncContext.setTimeout(this._suspendFor);
            }
            if (this._completeAfter > 0L) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(SuspendHandler.this._completeAfter);
                            response.getOutputStream().println("COMPLETED");
                            response.setStatus(200);
                            baseRequest.setHandled(true);
                            asyncContext.complete();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            } else if (this._completeAfter == 0L) {
                response.getOutputStream().println("COMPLETED");
                response.setStatus(200);
                baseRequest.setHandled(true);
                asyncContext.complete();
            }
            if (this._resumeAfter > 0L) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(SuspendHandler.this._resumeAfter);
                            asyncContext.dispatch();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }.start();
            } else if (this._resumeAfter == 0L) {
                asyncContext.dispatch();
            }
        } else if (request.getAttribute("TIMEOUT") != null) {
            response.setStatus(200);
            response.getOutputStream().print("TIMEOUT");
            baseRequest.setHandled(true);
        } else {
            response.setStatus(200);
            response.getOutputStream().print("RESUMED");
            baseRequest.setHandled(true);
        }
    }

    public void onComplete(AsyncEvent asyncEvent) throws IOException {
    }

    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        asyncEvent.getSuppliedRequest().setAttribute("TIMEOUT", (Object)Boolean.TRUE);
        asyncEvent.getAsyncContext().dispatch();
    }

    public void onError(AsyncEvent asyncEvent) throws IOException {
    }

    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
    }
}

