/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.BufferedResponseHandler;
import org.eclipse.jetty.server.handler.FileBufferedResponseHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDirExtension;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={WorkDirExtension.class})
public class FileBufferedResponseHandlerTest {
    private static final Logger LOG = Log.getLogger(FileBufferedResponseHandlerTest.class);
    public WorkDir _workDir;
    private final CountDownLatch _disposeLatch = new CountDownLatch(1);
    private Server _server;
    private LocalConnector _localConnector;
    private ServerConnector _serverConnector;
    private Path _testDir;
    private FileBufferedResponseHandler _bufferedHandler;

    @BeforeEach
    public void before() throws Exception {
        this._testDir = this._workDir.getEmptyPathDir();
        this._server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        config.setOutputBufferSize(1024);
        config.setOutputAggregationSize(256);
        this._localConnector = new LocalConnector(this._server, (ConnectionFactory)new HttpConnectionFactory(config));
        this._localConnector.setIdleTimeout(Duration.ofMinutes(1L).toMillis());
        this._server.addConnector((Connector)this._localConnector);
        this._serverConnector = new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(config)});
        this._server.addConnector((Connector)this._serverConnector);
        this._bufferedHandler = new FileBufferedResponseHandler(){

            protected BufferedResponseHandler.BufferedInterceptor newBufferedInterceptor(HttpChannel httpChannel, HttpOutput.Interceptor interceptor) {
                return new FileBufferedResponseHandler.FileBufferedInterceptor(httpChannel, interceptor){

                    protected void dispose() {
                        super.dispose();
                        FileBufferedResponseHandlerTest.this._disposeLatch.countDown();
                    }
                };
            }
        };
        this._bufferedHandler.setTempDir(this._testDir);
        this._bufferedHandler.getPathIncludeExclude().include((Object)"/include/*");
        this._bufferedHandler.getPathIncludeExclude().exclude((Object)"*.exclude");
        this._bufferedHandler.getMimeIncludeExclude().exclude((Object)"text/excluded");
        this._server.setHandler((Handler)this._bufferedHandler);
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testPathNotIncluded() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(10);
                PrintWriter writer = response.getWriter();
                writer.println("a string larger than the buffer size");
                writer.println("Committed: " + response.isCommitted());
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Committed: true"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 0"));
        MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testIncludedByPath() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(10);
                PrintWriter writer = response.getWriter();
                writer.println("a string larger than the buffer size");
                writer.println("Committed: " + response.isCommitted());
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Committed: false"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 1"));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testExcludedByPath() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(10);
                PrintWriter writer = response.getWriter();
                writer.println("a string larger than the buffer size");
                writer.println("Committed: " + response.isCommitted());
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path.exclude HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Committed: true"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 0"));
        MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testExcludedByMime() throws Exception {
        final String excludedMimeType = "text/excluded";
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setContentType(excludedMimeType);
                response.setBufferSize(10);
                PrintWriter writer = response.getWriter();
                writer.println("a string larger than the buffer size");
                writer.println("Committed: " + response.isCommitted());
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Committed: true"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 0"));
        MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testFlushed() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(1024);
                PrintWriter writer = response.getWriter();
                writer.println("a string smaller than the buffer size");
                writer.println("NumFilesBeforeFlush: " + FileBufferedResponseHandlerTest.this.getNumFiles());
                writer.flush();
                writer.println("Committed: " + response.isCommitted());
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFilesBeforeFlush: 0"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Committed: false"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 1"));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testClosed() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(10);
                PrintWriter writer = response.getWriter();
                writer.println("a string larger than the buffer size");
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
                writer.close();
                writer.println("writtenAfterClose");
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"writtenAfterClose")));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 1"));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testBufferSizeBig() throws Exception {
        final int bufferSize = 4096;
        final String largeContent = FileBufferedResponseHandlerTest.generateContent(bufferSize - 64);
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(bufferSize);
                PrintWriter writer = response.getWriter();
                writer.println(largeContent);
                writer.println("Committed: " + response.isCommitted());
                writer.println("NumFiles: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"writtenAfterClose")));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"Committed: false"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 0"));
        MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testFlushEmpty() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(1024);
                PrintWriter writer = response.getWriter();
                writer.flush();
                int numFiles = FileBufferedResponseHandlerTest.this.getNumFiles();
                writer.println("NumFiles: " + numFiles);
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFiles: 0"));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testReset() throws Exception {
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setBufferSize(8);
                PrintWriter writer = response.getWriter();
                writer.println("THIS WILL BE RESET");
                writer.flush();
                writer.println("THIS WILL BE RESET");
                int numFilesBeforeReset = FileBufferedResponseHandlerTest.this.getNumFiles();
                response.resetBuffer();
                int numFilesAfterReset = FileBufferedResponseHandlerTest.this.getNumFiles();
                writer.println("NumFilesBeforeReset: " + numFilesBeforeReset);
                writer.println("NumFilesAfterReset: " + numFilesAfterReset);
                writer.println("a string larger than the buffer size");
                writer.println("NumFilesAfterWrite: " + FileBufferedResponseHandlerTest.this.getNumFiles());
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        String responseContent = response.getContent();
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"THIS WILL BE RESET")));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFilesBeforeReset: 1"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFilesAfterReset: 0"));
        MatcherAssert.assertThat((Object)responseContent, (Matcher)Matchers.containsString((String)"NumFilesAfterWrite: 1"));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testFileLargerThanMaxInteger() throws Exception {
        final long fileSize = 2147484881L;
        final byte[] bytes = this.randomBytes(0x100000);
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                int length;
                baseRequest.setHandled(true);
                ServletOutputStream outputStream = response.getOutputStream();
                for (long written = 0L; written < fileSize; written += (long)length) {
                    length = Math.toIntExact(Math.min((long)bytes.length, fileSize - written));
                    outputStream.write(bytes, 0, length);
                }
                outputStream.flush();
                response.setHeader("NumFiles", Integer.toString(FileBufferedResponseHandlerTest.this.getNumFiles()));
                response.setHeader("FileSize", Long.toString(FileBufferedResponseHandlerTest.this.getFileSize()));
            }
        });
        this._server.start();
        final AtomicLong received = new AtomicLong();
        HttpTester.Response response = new HttpTester.Response(){

            public boolean content(ByteBuffer ref) {
                while (ref.hasRemaining()) {
                    long totalReceived;
                    int bytesIndex;
                    byte byteFromArray;
                    byte byteFromBuffer = ref.get();
                    if (byteFromBuffer == (byteFromArray = bytes[bytesIndex = (int)((totalReceived = received.getAndIncrement()) % (long)bytes.length)])) continue;
                    LOG.warn("Mismatch at index {} received bytes {}, {}!={}", new Object[]{bytesIndex, totalReceived, byteFromBuffer, byteFromArray, new IllegalStateException()});
                    return true;
                }
                return false;
            }
        };
        try (Socket socket = new Socket("localhost", this._serverConnector.getLocalPort());){
            OutputStream output = socket.getOutputStream();
            String request = "GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.parseResponse((HttpTester.Input)input, (HttpTester.Response)response);
        }
        Assertions.assertTrue((boolean)response.isComplete());
        MatcherAssert.assertThat((Object)response.get("NumFiles"), (Matcher)Matchers.is((Object)"1"));
        MatcherAssert.assertThat((Object)response.get("FileSize"), (Matcher)Matchers.is((Object)Long.toString(fileSize)));
        MatcherAssert.assertThat((Object)received.get(), (Matcher)Matchers.is((Object)fileSize));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testNextInterceptorFailed() throws Exception {
        AbstractHandler failingInterceptorHandler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                HttpOutput httpOutput = baseRequest.getResponse().getHttpOutput();
                final HttpOutput.Interceptor nextInterceptor = httpOutput.getInterceptor();
                httpOutput.setInterceptor(new HttpOutput.Interceptor(){

                    public void write(ByteBuffer content, boolean last, Callback callback) {
                        callback.failed(new Throwable("intentionally throwing from interceptor"));
                    }

                    public HttpOutput.Interceptor getNextInterceptor() {
                        return nextInterceptor;
                    }

                    public boolean isOptimizedForDirectBuffers() {
                        return false;
                    }
                });
            }
        };
        this._server.setHandler((Handler)new HandlerCollection(new Handler[]{failingInterceptorHandler, this._server.getHandler()}));
        final CompletableFuture errorFuture = new CompletableFuture();
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                byte[] chunk1 = "this content will ".getBytes();
                byte[] chunk2 = "be buffered in a file".getBytes();
                response.setContentLength(chunk1.length + chunk2.length);
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(chunk1);
                outputStream.flush();
                MatcherAssert.assertThat((Object)FileBufferedResponseHandlerTest.this.getNumFiles(), (Matcher)Matchers.is((Object)1));
                try {
                    outputStream.write(chunk2);
                }
                catch (Throwable t) {
                    errorFuture.complete(t);
                    throw t;
                }
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)0));
        Throwable error = (Throwable)errorFuture.get(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.containsString((String)"intentionally throwing from interceptor"));
        if (!OS.WINDOWS.isCurrentOs()) {
            Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
        }
    }

    @Test
    public void testFileWriteFailed() throws Exception {
        File tempDir = MavenTestingUtils.getTargetTestingDir((String)this.getClass().getSimpleName());
        FS.ensureDeleted((File)tempDir);
        this._bufferedHandler.setTempDir(tempDir.toPath());
        final CompletableFuture errorFuture = new CompletableFuture();
        this._bufferedHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                ServletOutputStream outputStream = response.getOutputStream();
                byte[] content = "this content will be buffered in a file".getBytes();
                try {
                    outputStream.write(content);
                    outputStream.flush();
                }
                catch (Throwable t) {
                    errorFuture.complete(t);
                    throw t;
                }
            }
        });
        this._server.start();
        String rawResponse = this._localConnector.getResponse("GET /include/path HTTP/1.1\r\nHost: localhost\r\n\r\n");
        HttpTester.Response response = HttpTester.parseResponse((String)rawResponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)0));
        Throwable error = (Throwable)errorFuture.get(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)error, (Matcher)Matchers.instanceOf(NoSuchFileException.class));
        Assertions.assertTrue((boolean)this._disposeLatch.await(5L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)this.getNumFiles(), (Matcher)Matchers.is((Object)0));
    }

    private int getNumFiles() {
        File[] files = this._testDir.toFile().listFiles();
        if (files == null) {
            return 0;
        }
        return files.length;
    }

    private long getFileSize() {
        File[] files = this._testDir.toFile().listFiles();
        Assertions.assertNotNull((Object)files);
        MatcherAssert.assertThat((Object)files.length, (Matcher)Matchers.is((Object)1));
        return files[0].length();
    }

    private static String generateContent(int size) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            stringBuilder.append((char)Math.abs(random.nextInt(127)));
        }
        return stringBuilder.toString();
    }

    private byte[] randomBytes(int size) {
        byte[] data = new byte[size];
        new Random().nextBytes(data);
        return data;
    }
}

