/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ShutdownHandler;
import org.eclipse.jetty.util.component.LifeCycle;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShutdownHandlerTest {
    private Server server;
    private ServerConnector connector;
    private String shutdownToken = "asdlnsldgnklns";

    public void start(HandlerWrapper wrapper) throws Exception {
        ShutdownHandler shutdown;
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ShutdownHandler handler = shutdown = new ShutdownHandler(this.shutdownToken);
        if (wrapper != null) {
            wrapper.setHandler((Handler)shutdown);
            handler = wrapper;
        }
        this.server.setHandler((Handler)handler);
        this.server.start();
    }

    @Test
    public void testShutdownServerWithCorrectTokenAndIP() throws Exception {
        this.start(null);
        final CountDownLatch stopLatch = new CountDownLatch(1);
        this.server.addLifeCycleListener(new LifeCycle.Listener(){

            public void lifeCycleStopped(LifeCycle event) {
                stopLatch.countDown();
            }
        });
        HttpTester.Response response = this.shutdown(this.shutdownToken);
        Assertions.assertEquals((int)200, (int)response.getStatus());
        Assertions.assertTrue((boolean)stopLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)"STOPPED", (Object)this.server.getState());
    }

    @Test
    public void testWrongToken() throws Exception {
        this.start(null);
        HttpTester.Response response = this.shutdown("wrongToken");
        Assertions.assertEquals((int)401, (int)response.getStatus());
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)"STARTED", (Object)this.server.getState());
    }

    @Test
    public void testShutdownRequestNotFromLocalhost() throws Exception {
        this.start(new HandlerWrapper(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setRemoteAddr(new InetSocketAddress("192.168.0.1", 12345));
                super.handle(target, baseRequest, request, response);
            }
        });
        HttpTester.Response response = this.shutdown(this.shutdownToken);
        Assertions.assertEquals((int)401, (int)response.getStatus());
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)"STARTED", (Object)this.server.getState());
    }

    private HttpTester.Response shutdown(String shutdownToken) throws IOException {
        try (Socket socket = new Socket("localhost", this.connector.getLocalPort());){
            String request = "POST /shutdown?token=" + shutdownToken + " HTTP/1.1\r\nHost: localhost\r\n\r\n";
            OutputStream output = socket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            return response;
        }
    }
}

