/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ThreadLimitHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ThreadLimitHandlerTest {
    private Server _server;
    private NetworkConnector _connector;
    private LocalConnector _local;

    @BeforeEach
    public void before() throws Exception {
        this._server = new Server();
        this._connector = new ServerConnector(this._server);
        this._local = new LocalConnector(this._server);
        this._server.setConnectors(new Connector[]{this._local, this._connector});
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testNoForwardHeaders() throws Exception {
        final AtomicReference last = new AtomicReference();
        ThreadLimitHandler handler = new ThreadLimitHandler(null, false){

            protected int getThreadLimit(String ip) {
                last.set(ip);
                return super.getThreadLimit(ip);
            }
        };
        handler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
            }
        });
        this._server.setHandler((Handler)handler);
        this._server.start();
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nX-Forwarded-For: 1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nForwarded: for=1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
    }

    @Test
    public void testXForwardForHeaders() throws Exception {
        final AtomicReference last = new AtomicReference();
        ThreadLimitHandler handler = new ThreadLimitHandler("X-Forwarded-For"){

            protected int getThreadLimit(String ip) {
                last.set(ip);
                return super.getThreadLimit(ip);
            }
        };
        this._server.setHandler((Handler)handler);
        this._server.start();
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nX-Forwarded-For: 1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"1.2.3.4"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nForwarded: for=1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nX-Forwarded-For: 1.1.1.1\r\nX-Forwarded-For: 6.6.6.6,1.2.3.4\r\nForwarded: for=1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"1.2.3.4"));
    }

    @Test
    public void testForwardHeaders() throws Exception {
        final AtomicReference last = new AtomicReference();
        ThreadLimitHandler handler = new ThreadLimitHandler("Forwarded"){

            protected int getThreadLimit(String ip) {
                last.set(ip);
                return super.getThreadLimit(ip);
            }
        };
        this._server.setHandler((Handler)handler);
        this._server.start();
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nX-Forwarded-For: 1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"0.0.0.0"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nForwarded: for=1.2.3.4\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"1.2.3.4"));
        last.set(null);
        this._local.getResponse("GET / HTTP/1.0\r\nX-Forwarded-For: 1.1.1.1\r\nForwarded: for=6.6.6.6; for=1.2.3.4\r\nX-Forwarded-For: 6.6.6.6\r\nForwarded: proto=https\r\n\r\n");
        MatcherAssert.assertThat((Object)((String)last.get()), (Matcher)Matchers.is((Object)"1.2.3.4"));
    }

    @Test
    public void testLimit() throws Exception {
        ThreadLimitHandler handler = new ThreadLimitHandler("Forwarded");
        handler.setThreadLimit(4);
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger total = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(1);
        handler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                if ("/other".equals(target)) {
                    return;
                }
                try {
                    count.incrementAndGet();
                    total.incrementAndGet();
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new ServletException((Throwable)e);
                }
                finally {
                    count.decrementAndGet();
                }
            }
        });
        this._server.setHandler((Handler)handler);
        this._server.start();
        Socket[] client = new Socket[10];
        for (int i = 0; i < client.length; ++i) {
            client[i] = new Socket("127.0.0.1", this._connector.getLocalPort());
            client[i].getOutputStream().write(("GET /" + i + " HTTP/1.0\r\nForwarded: for=1.2.3.4\r\n\r\n").getBytes());
            client[i].getOutputStream().flush();
        }
        long wait = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
        while (count.get() < 4 && System.nanoTime() < wait) {
            Thread.sleep(1L);
        }
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((Object)this._local.getResponse("GET /other HTTP/1.0\r\nForwarded: for=6.6.6.6\r\n\r\n"), (Matcher)Matchers.containsString((String)" 200 OK"));
        latch.countDown();
        while (total.get() < 10 && System.nanoTime() < wait) {
            Thread.sleep(10L);
        }
        MatcherAssert.assertThat((Object)total.get(), (Matcher)Matchers.is((Object)10));
        while (count.get() > 0 && System.nanoTime() < wait) {
            Thread.sleep(10L);
        }
        MatcherAssert.assertThat((Object)count.get(), (Matcher)Matchers.is((Object)0));
    }
}

