/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.LeakTrackingByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerConnectorSslServerTest
extends HttpServerTestBase {
    private SSLContext _sslContext;

    public ServerConnectorSslServerTest() {
        this._scheme = "https";
    }

    @BeforeEach
    public void init() throws Exception {
        String keystorePath = MavenTestingUtils.getTestResourcePath((String)"keystore").toString();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystorePath);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        sslContextFactory.setTrustStorePath(keystorePath);
        sslContextFactory.setTrustStorePassword("storepwd");
        LeakTrackingByteBufferPool pool = new LeakTrackingByteBufferPool((ByteBufferPool)new MappedByteBufferPool.Tagged());
        HttpConnectionFactory httpConnectionFactory = new HttpConnectionFactory();
        ServerConnector connector = new ServerConnector(this._server, null, null, (ByteBufferPool)pool, 1, 1, AbstractConnectionFactory.getFactories((SslContextFactory)sslContextFactory, (ConnectionFactory[])new ConnectionFactory[]{httpConnectionFactory}));
        SecureRequestCustomizer secureRequestCustomer = new SecureRequestCustomizer();
        secureRequestCustomer.setSslSessionAttribute("SSL_SESSION");
        httpConnectionFactory.getHttpConfiguration().addCustomizer((HttpConfiguration.Customizer)secureRequestCustomer);
        this.startServer(connector);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream stream = sslContextFactory.getKeyStoreResource().getInputStream();){
            keystore.load(stream, "storepwd".toCharArray());
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        this._sslContext = SSLContext.getInstance("TLS");
        this._sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        try {
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, SslContextFactory.TRUST_ALL_CERTS, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Socket newSocket(String host, int port) throws Exception {
        Socket socket = this._sslContext.getSocketFactory().createSocket(host, port);
        socket.setSoTimeout(10000);
        socket.setTcpNoDelay(true);
        return socket;
    }

    @Override
    public void testFullHeader() throws Exception {
        super.testFullHeader();
    }

    @Override
    public void testBlockingWhileReadingRequestContent() throws Exception {
        super.testBlockingWhileReadingRequestContent();
    }

    @Override
    public void testBlockingWhileWritingResponseContent() throws Exception {
        super.testBlockingWhileWritingResponseContent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequest2FixedFragments() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        int[] points = new int[]{74, 325};
        Arrays.sort(points);
        URI uri = this._server.getURI();
        try (Socket client = this.newSocket(uri.getHost(), uri.getPort());){
            OutputStream os = client.getOutputStream();
            int last = 0;
            for (int j = 0; j < points.length; ++j) {
                int point = points[j];
                os.write(bytes, last, point - last);
                last = point;
                os.flush();
                Thread.sleep(10L);
            }
            os.write(bytes, last, bytes.length - last);
            os.flush();
            Thread.sleep(10L);
            String response = ServerConnectorSslServerTest.readResponse(client);
            Assertions.assertEquals((Object)RESPONSE2, (Object)response);
        }
    }

    @Override
    @Test
    public void testInterruptedRequest() {
        Assumptions.assumeFalse((boolean)this._serverURI.getScheme().equals("https"), (String)"SSLSocket.shutdownOutput() is not supported, but shutdownOutput() is needed by the test");
    }

    @Override
    public void testAvailable() {
        Assumptions.assumeFalse((boolean)this._serverURI.getScheme().equals("https"), (String)"SSLSocket available() is not supported");
    }

    @Test
    public void testSecureRequestCustomizer() throws Exception {
        this.configureServer((Handler)new SecureRequestHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = ServerConnectorSslServerTest.readResponse(client);
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.containsString((String)"Hello world"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.containsString((String)"scheme='https'"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.containsString((String)"isSecure='true'"));
            MatcherAssert.assertThat((Object)response, (org.hamcrest.Matcher)Matchers.containsString((String)"X509Certificate='null'"));
            Matcher matcher = Pattern.compile("cipher_suite='([^']*)'").matcher(response);
            matcher.find();
            MatcherAssert.assertThat((String)matcher.group(1), (Object)Matchers.allOf((org.hamcrest.Matcher[])new org.hamcrest.Matcher[]{Matchers.not((org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.emptyOrNullString()))}), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((Object)"null")));
            matcher = Pattern.compile("key_size='([^']*)'").matcher(response);
            matcher.find();
            MatcherAssert.assertThat((Object)matcher.group(1), (org.hamcrest.Matcher)Matchers.allOf((org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.emptyOrNullString())), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((Object)"null"))));
            matcher = Pattern.compile("ssl_session_id='([^']*)'").matcher(response);
            matcher.find();
            MatcherAssert.assertThat((Object)matcher.group(1), (org.hamcrest.Matcher)Matchers.allOf((org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.emptyOrNullString())), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((Object)"null"))));
            matcher = Pattern.compile("ssl_session='([^']*)'").matcher(response);
            matcher.find();
            MatcherAssert.assertThat((Object)matcher.group(1), (org.hamcrest.Matcher)Matchers.allOf((org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((org.hamcrest.Matcher)Matchers.emptyOrNullString())), (org.hamcrest.Matcher)Matchers.not((org.hamcrest.Matcher)Matchers.is((Object)"null"))));
        }
    }

    public static class SecureRequestHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.getOutputStream().println("Hello world");
            response.getOutputStream().println("scheme='" + request.getScheme() + "'");
            response.getOutputStream().println("isSecure='" + request.isSecure() + "'");
            response.getOutputStream().println("X509Certificate='" + request.getAttribute("javax.servlet.request.X509Certificate") + "'");
            response.getOutputStream().println("cipher_suite='" + request.getAttribute("javax.servlet.request.cipher_suite") + "'");
            response.getOutputStream().println("key_size='" + request.getAttribute("javax.servlet.request.key_size") + "'");
            response.getOutputStream().println("ssl_session_id='" + request.getAttribute("javax.servlet.request.ssl_session_id") + "'");
            SSLSession sslSession = (SSLSession)request.getAttribute("SSL_SESSION");
            response.getOutputStream().println("ssl_session='" + sslSession + "'");
        }
    }
}

