/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BlockingTest {
    private Server server;
    private ServerConnector connector;
    private ContextHandler context;

    @BeforeEach
    public void setUp() {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.connector.setPort(0);
        this.server.addConnector((Connector)this.connector);
        this.context = new ContextHandler("/ctx");
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{this.context, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.server.stop();
    }

    @Test
    public void testBlockingReadThenNormalComplete() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        final CountDownLatch stopped = new CountDownLatch(1);
        final AtomicReference readException = new AtomicReference();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                new Thread(() -> {
                    try {
                        int b = baseRequest.getHttpInput().read();
                        if (b == 49) {
                            started.countDown();
                            if (baseRequest.getHttpInput().read() > Integer.MIN_VALUE) {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    catch (Throwable t) {
                        readException.set(t);
                        stopped.countDown();
                    }
                }).start();
                try {
                    started.await(10L, TimeUnit.SECONDS);
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
                response.setStatus(200);
                response.setContentType("text/plain");
                response.getOutputStream().print("OK\r\n");
            }
        };
        this.context.setHandler((Handler)handler);
        this.server.start();
        StringBuilder request = new StringBuilder();
        request.append("POST /ctx/path/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: test/data\r\n").append("Content-Length: 2\r\n").append("\r\n").append("1");
        int port = this.connector.getLocalPort();
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            HttpTester.Response response = HttpTester.parseResponse((InputStream)socket.getInputStream());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"OK"));
            Assertions.assertTrue((boolean)stopped.await(10L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)((Throwable)readException.get()), (Matcher)Matchers.instanceOf(IOException.class));
        }
    }

    @Test
    public void testNormalCompleteThenBlockingRead() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        final CountDownLatch completed = new CountDownLatch(1);
        final CountDownLatch stopped = new CountDownLatch(1);
        final AtomicReference readException = new AtomicReference();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                new Thread(() -> {
                    try {
                        int b = baseRequest.getHttpInput().read();
                        if (b == 49) {
                            started.countDown();
                            completed.await(10L, TimeUnit.SECONDS);
                            Thread.sleep(500L);
                            if (baseRequest.getHttpInput().read() > Integer.MIN_VALUE) {
                                throw new IllegalStateException();
                            }
                        }
                    }
                    catch (Throwable t) {
                        readException.set(t);
                        stopped.countDown();
                    }
                }).start();
                try {
                    started.await(10L, TimeUnit.SECONDS);
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
                response.setStatus(200);
                response.setContentType("text/plain");
                response.getOutputStream().print("OK\r\n");
            }
        };
        this.context.setHandler((Handler)handler);
        this.server.start();
        StringBuilder request = new StringBuilder();
        request.append("POST /ctx/path/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: test/data\r\n").append("Content-Length: 2\r\n").append("\r\n").append("1");
        int port = this.connector.getLocalPort();
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            HttpTester.Response response = HttpTester.parseResponse((InputStream)socket.getInputStream());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"OK"));
            completed.countDown();
            Thread.sleep(1000L);
            Assertions.assertTrue((boolean)stopped.await(10L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)((Throwable)readException.get()), (Matcher)Matchers.instanceOf(IOException.class));
        }
    }

    @Test
    public void testStartAsyncThenBlockingReadThenTimeout() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        final CountDownLatch completed = new CountDownLatch(1);
        final CountDownLatch stopped = new CountDownLatch(1);
        final AtomicReference readException = new AtomicReference();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException {
                baseRequest.setHandled(true);
                if (baseRequest.getDispatcherType() != DispatcherType.ERROR) {
                    AsyncContext async = request.startAsync();
                    async.setTimeout(100L);
                    new Thread(() -> {
                        try {
                            int b = baseRequest.getHttpInput().read();
                            if (b == 49) {
                                started.countDown();
                                completed.await(10L, TimeUnit.SECONDS);
                                Thread.sleep(500L);
                                if (baseRequest.getHttpInput().read() > Integer.MIN_VALUE) {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        catch (Throwable t) {
                            readException.set(t);
                            stopped.countDown();
                        }
                    }).start();
                    try {
                        started.await(10L, TimeUnit.SECONDS);
                        Thread.sleep(1000L);
                    }
                    catch (Throwable e) {
                        throw new ServletException(e);
                    }
                }
            }
        };
        this.context.setHandler((Handler)handler);
        this.server.start();
        StringBuilder request = new StringBuilder();
        request.append("POST /ctx/path/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: test/data\r\n").append("Content-Length: 2\r\n").append("\r\n").append("1");
        int port = this.connector.getLocalPort();
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            HttpTester.Response response = HttpTester.parseResponse((InputStream)socket.getInputStream());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)500));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"AsyncContext timeout"));
            completed.countDown();
            Thread.sleep(1000L);
            Assertions.assertTrue((boolean)stopped.await(10L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)((Throwable)readException.get()), (Matcher)Matchers.instanceOf(IOException.class));
        }
    }

    @Test
    public void testBlockingReadThenSendError() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        final CountDownLatch stopped = new CountDownLatch(1);
        final AtomicReference readException = new AtomicReference();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                if (baseRequest.getDispatcherType() != DispatcherType.ERROR) {
                    new Thread(() -> {
                        try {
                            int b = baseRequest.getHttpInput().read();
                            if (b == 49) {
                                started.countDown();
                                if (baseRequest.getHttpInput().read() > Integer.MIN_VALUE) {
                                    throw new IllegalStateException();
                                }
                            }
                        }
                        catch (Throwable t) {
                            readException.set(t);
                            stopped.countDown();
                        }
                    }).start();
                    try {
                        started.await(10L, TimeUnit.SECONDS);
                        Thread.sleep(1000L);
                    }
                    catch (Throwable e) {
                        throw new ServletException(e);
                    }
                    response.sendError(499);
                }
            }
        };
        this.context.setHandler((Handler)handler);
        this.server.start();
        StringBuilder request = new StringBuilder();
        request.append("POST /ctx/path/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("Content-Type: test/data\r\n").append("Content-Length: 2\r\n").append("\r\n").append("1");
        int port = this.connector.getLocalPort();
        try (Socket socket = new Socket("localhost", port);){
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            HttpTester.Response response = HttpTester.parseResponse((InputStream)socket.getInputStream());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Is.is((Object)499));
            Assertions.assertTrue((boolean)stopped.await(10L, TimeUnit.SECONDS));
            MatcherAssert.assertThat((Object)((Throwable)readException.get()), (Matcher)Matchers.instanceOf(IOException.class));
        }
    }

    @Test
    public void testBlockingWriteThenNormalComplete() throws Exception {
        final CountDownLatch started = new CountDownLatch(1);
        final CountDownLatch stopped = new CountDownLatch(1);
        final AtomicReference readException = new AtomicReference();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setContentType("text/plain");
                new Thread(() -> {
                    try {
                        byte[] data = new byte[16384];
                        Arrays.fill(data, (byte)88);
                        data[data.length - 2] = 13;
                        data[data.length - 1] = 10;
                        ServletOutputStream out = response.getOutputStream();
                        started.countDown();
                        while (true) {
                            out.write(data);
                        }
                    }
                    catch (Throwable t) {
                        readException.set(t);
                        stopped.countDown();
                        return;
                    }
                }).start();
                try {
                    started.await(10L, TimeUnit.SECONDS);
                    Thread.sleep(1000L);
                }
                catch (Throwable e) {
                    throw new ServletException(e);
                }
            }
        };
        this.context.setHandler((Handler)handler);
        this.server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /ctx/path/info HTTP/1.1\r\n").append("Host: localhost\r\n").append("\r\n");
        int port = this.connector.getLocalPort();
        try (Socket socket = new Socket("localhost", port);){
            String line;
            String line2;
            socket.setSoTimeout(10000);
            OutputStream out = socket.getOutputStream();
            out.write(request.toString().getBytes(StandardCharsets.ISO_8859_1));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.ISO_8859_1));
            ArrayList<String> header = new ArrayList<String>();
            while ((line2 = in.readLine()).length() != 0) {
                header.add(line2);
            }
            MatcherAssert.assertThat((Object)((String)header.get(0)), (Matcher)Matchers.containsString((String)"200 OK"));
            String content = in.readLine();
            MatcherAssert.assertThat((Object)content, (Matcher)Is.is((Object)"4000"));
            content = in.readLine();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.startsWith((String)"XXXXXXXX"));
            Assertions.assertTrue((boolean)stopped.await(10L, TimeUnit.SECONDS));
            String last = null;
            while ((line = in.readLine()) != null) {
                last = line;
            }
            MatcherAssert.assertThat((Object)last, (Matcher)Matchers.startsWith((String)"XXXXX"));
        }
    }
}

