/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannelOverHttp;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpServerTestBase;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ExtendedServerTest
extends HttpServerTestBase {
    @BeforeEach
    public void init() throws Exception {
        this.startServer(new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(){

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                return this.configure((AbstractConnection)new ExtendedHttpConnection(this.getHttpConfiguration(), connector, endPoint), connector, endPoint);
            }
        }}){

            protected ChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) throws IOException {
                return new ExtendedEndPoint(channel, selectSet, key, this.getScheduler());
            }
        });
    }

    @Test
    public void testExtended() throws Exception {
        this.configureServer((Handler)new DispatchedAtHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            long start = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            os.write("GET / HTTP/1.0\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            Thread.sleep(200L);
            long end = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            os.write("\r\n".getBytes(StandardCharsets.ISO_8859_1));
            String response = ExtendedServerTest.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"DispatchedAt="));
            String s = response.substring(response.indexOf("DispatchedAt=") + 13);
            s = s.substring(0, s.indexOf(10));
            long dispatched = Long.parseLong(s);
            MatcherAssert.assertThat((Object)dispatched, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(start)));
            MatcherAssert.assertThat((Object)dispatched, (Matcher)Matchers.lessThan((Comparable)Long.valueOf(end)));
        }
    }

    protected static class DispatchedAtHandler
    extends AbstractHandler {
        protected DispatchedAtHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.getOutputStream().print("DispatchedAt=" + request.getAttribute("DispatchedAt") + "\r\n");
        }
    }

    private static class ExtendedHttpConnection
    extends HttpConnection {
        public ExtendedHttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
            super(config, connector, endPoint, HttpCompliance.RFC7230_LEGACY, false);
        }

        protected HttpChannelOverHttp newHttpChannel() {
            return new HttpChannelOverHttp(this, this.getConnector(), this.getHttpConfiguration(), this.getEndPoint(), (HttpTransport)this){

                public boolean startRequest(String method, String uri, HttpVersion version) {
                    this.getRequest().setAttribute("DispatchedAt", (Object)((ExtendedEndPoint)this.getEndPoint()).getLastSelected());
                    return super.startRequest(method, uri, version);
                }
            };
        }
    }

    private static class ExtendedEndPoint
    extends SocketChannelEndPoint {
        private volatile long _lastSelected;

        public ExtendedEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey key, Scheduler scheduler) {
            super(channel, selector, key, scheduler);
        }

        public Runnable onSelected() {
            this._lastSelected = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            return super.onSelected();
        }

        long getLastSelected() {
            return this._lastSelected;
        }
    }
}

