/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class GracefulStopTest {
    @Test
    public void testGracefulNoWaiter() throws Exception {
        Server server = new Server();
        server.setStopTimeout(1000L);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        TestHandler handler = new TestHandler();
        server.setHandler((Handler)handler);
        server.start();
        int port = connector.getLocalPort();
        Socket client = new Socket("127.0.0.1", port);
        client.getOutputStream().write(("POST / HTTP/1.0\r\nHost: localhost:" + port + "\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345").getBytes());
        client.getOutputStream().flush();
        handler.latch.await();
        long start = System.nanoTime();
        server.stop();
        long stop = System.nanoTime();
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(stop - start), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(900L)));
        MatcherAssert.assertThat((Object)client.getInputStream().read(), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)handler.handling.get(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)handler.thrown.get(), (Matcher)Matchers.notNullValue());
        client.close();
    }

    @Test
    public void testGracefulTimeout() throws Exception {
        Server server = new Server();
        server.setStopTimeout(1000L);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        TestHandler handler = new TestHandler();
        StatisticsHandler stats = new StatisticsHandler();
        server.setHandler((Handler)stats);
        stats.setHandler((Handler)handler);
        server.start();
        int port = connector.getLocalPort();
        Socket client = new Socket("127.0.0.1", port);
        client.getOutputStream().write(("POST / HTTP/1.0\r\nHost: localhost:" + port + "\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345").getBytes());
        client.getOutputStream().flush();
        handler.latch.await();
        long start = System.nanoTime();
        Assertions.assertThrows(TimeoutException.class, () -> server.stop());
        long stop = System.nanoTime();
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(stop - start), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(900L)));
        MatcherAssert.assertThat((Object)client.getInputStream().read(), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((Object)handler.handling.get(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)handler.thrown.get(), (Matcher)Matchers.instanceOf(ClosedChannelException.class));
        client.close();
    }

    @Test
    public void testWriteDuringShutdown() throws Exception {
        Server server = new Server();
        server.setStopTimeout(1000L);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        ABHandler handler = new ABHandler();
        StatisticsHandler stats = new StatisticsHandler();
        server.setHandler((Handler)stats);
        stats.setHandler((Handler)handler);
        server.start();
        Thread stopper = new Thread(() -> {
            try {
                handler.latchA.await();
                server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        stopper.start();
        int port = connector.getLocalPort();
        try (Socket client = new Socket("127.0.0.1", port);){
            client.getOutputStream().write(("GET / HTTP/1.1\r\nHost: localhost:" + port + "\r\n\r\n").getBytes());
            client.getOutputStream().flush();
            while (!connector.isShutdown()) {
                Thread.sleep(10L);
            }
            handler.latchB.countDown();
            String response = IO.toString((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 2"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)"ab"));
        }
        stopper.join();
    }

    @Test
    public void testGracefulComplete() throws Exception {
        Server server = new Server();
        server.setStopTimeout(10000L);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        TestHandler handler = new TestHandler();
        StatisticsHandler stats = new StatisticsHandler();
        server.setHandler((Handler)stats);
        stats.setHandler((Handler)handler);
        server.start();
        final int port = connector.getLocalPort();
        try (final Socket client1 = new Socket("127.0.0.1", port);
             final Socket client2 = new Socket("127.0.0.1", port);){
            client1.getOutputStream().write(("POST / HTTP/1.0\r\nHost: localhost:" + port + "\r\nContent-Type: plain/text\r\nContent-Length: 10\r\n\r\n12345").getBytes());
            client1.getOutputStream().flush();
            handler.latch.await();
            new Thread(){

                @Override
                public void run() {
                    long now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                    long end = now + 500L;
                    try {
                        Thread.sleep(100L);
                        try {
                            Socket s = new Socket("127.0.0.1", port);
                            s.close();
                            throw new IllegalStateException();
                        }
                        catch (ConnectException s) {
                            client2.getOutputStream().write(("GET / HTTP/1.0\r\nHost: localhost:" + port + "\r\n\r\n").getBytes());
                            client2.getOutputStream().flush();
                            String response2 = IO.toString((InputStream)client2.getInputStream());
                            MatcherAssert.assertThat((Object)response2, (Matcher)Matchers.containsString((String)" 503 "));
                            now = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
                            Thread.sleep(Math.max(1L, end - now));
                            client1.getOutputStream().write("567890".getBytes());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }.start();
            long start = System.nanoTime();
            server.stop();
            long stop = System.nanoTime();
            MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(stop - start), (Matcher)Matchers.greaterThan((Comparable)Long.valueOf(490L)));
            MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(stop - start), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(10000L)));
            String response = IO.toString((InputStream)client1.getInputStream());
            MatcherAssert.assertThat((Object)handler.handling.get(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"read 10/10"));
            MatcherAssert.assertThat((Object)stats.getRequests(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((Object)stats.getResponses4xx(), (Matcher)Matchers.is((Object)0));
        }
    }

    public void testSlowClose(long stopTimeout, final long closeWait, Matcher<Long> stopTimeMatcher) throws Exception {
        int r;
        String line;
        Server server = new Server();
        server.setStopTimeout(stopTimeout);
        final CountDownLatch closed = new CountDownLatch(1);
        ServerConnector connector = new ServerConnector(server, 2, 2, new ConnectionFactory[]{new HttpConnectionFactory(){

            public Connection newConnection(Connector con, EndPoint endPoint) {
                HttpConnection conn = new HttpConnection(this.getHttpConfiguration(), con, endPoint, this.getHttpCompliance(), this.isRecordHttpComplianceViolations()){

                    public void close() {
                        try {
                            new Thread(() -> {
                                try {
                                    Thread.sleep(closeWait);
                                }
                                catch (InterruptedException interruptedException) {
                                }
                                finally {
                                    super.close();
                                }
                            }).start();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            closed.countDown();
                        }
                    }
                };
                return this.configure((AbstractConnection)conn, con, endPoint);
            }
        }});
        connector.setPort(0);
        server.addConnector((Connector)connector);
        NoopHandler handler = new NoopHandler();
        server.setHandler((Handler)handler);
        server.start();
        int port = connector.getLocalPort();
        Socket client = new Socket("127.0.0.1", port);
        client.setSoTimeout(10000);
        client.getOutputStream().write(("GET / HTTP/1.1\r\nHost: localhost:" + port + "\r\nContent-Type: plain/text\r\n\r\n").getBytes());
        client.getOutputStream().flush();
        handler.latch.await();
        BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream(), StandardCharsets.ISO_8859_1));
        do {
            line = in.readLine();
            MatcherAssert.assertThat((String)"Line should not be null", (Object)line, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        } while (line.length() != 0);
        long start = System.nanoTime();
        try {
            server.stop();
            Assertions.assertTrue((stopTimeout == 0L || stopTimeout > closeWait ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assertions.assertTrue((stopTimeout > 0L && stopTimeout < closeWait ? 1 : 0) != 0);
        }
        long stop = System.nanoTime();
        MatcherAssert.assertThat((Object)TimeUnit.NANOSECONDS.toMillis(stop - start), stopTimeMatcher);
        while ((r = client.getInputStream().read()) != -1) {
        }
        if (stopTimeout > 0L) {
            Assertions.assertTrue((boolean)closed.await(1000L, TimeUnit.MILLISECONDS));
        }
        if (!client.isClosed()) {
            client.close();
        }
    }

    @Test
    public void testSlowCloseNotGraceful() throws Exception {
        Log.getLogger(QueuedThreadPool.class).info("Expect some threads can't be stopped", new Object[0]);
        this.testSlowClose(0L, 5000L, (Matcher<Long>)Matchers.lessThan((Comparable)Long.valueOf(750L)));
    }

    @Test
    @Disabled
    public void testSlowCloseTinyGraceful() throws Exception {
        Log.getLogger(QueuedThreadPool.class).info("Expect some threads can't be stopped", new Object[0]);
        this.testSlowClose(1L, 5000L, (Matcher<Long>)Matchers.lessThan((Comparable)Long.valueOf(1500L)));
    }

    @Test
    @Disabled
    public void testSlowCloseGraceful() throws Exception {
        this.testSlowClose(5000L, 1000L, (Matcher<Long>)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Long.valueOf(750L)), (Matcher)Matchers.lessThan((Comparable)Long.valueOf(4999L))));
    }

    @Test
    public void testResponsesAreClosed() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        StatisticsHandler stats = new StatisticsHandler();
        server.setHandler((Handler)stats);
        ContextHandler context = new ContextHandler((HandlerContainer)stats, "/");
        final Exchanger<Object> exchanger0 = new Exchanger<Object>();
        final Exchanger<Object> exchanger1 = new Exchanger<Object>();
        context.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setContentLength(13);
                response.flushBuffer();
                try {
                    exchanger0.exchange(null);
                    exchanger1.exchange(null);
                }
                catch (Throwable x) {
                    throw new ServletException(x);
                }
                response.getOutputStream().print("The Response\n");
            }
        });
        server.setStopTimeout(1000L);
        server.start();
        LocalConnector.LocalEndPoint endp = connector.executeRequest("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n");
        exchanger0.exchange(null);
        exchanger1.exchange(null);
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        endp.addInputAndExecute(BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost: localhost\r\n\r\n"));
        exchanger0.exchange(null);
        server.getConnectors()[0].shutdown().get();
        exchanger1.exchange(null);
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(1L);
        while (endp.isOpen() && System.nanoTime() < end) {
            Thread.sleep(10L);
        }
        Assertions.assertFalse((boolean)endp.isOpen());
    }

    @Test
    public void testCommittedResponsesAreClosed() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        StatisticsHandler stats = new StatisticsHandler();
        server.setHandler((Handler)stats);
        ContextHandler context = new ContextHandler((HandlerContainer)stats, "/");
        final Exchanger<Object> exchanger0 = new Exchanger<Object>();
        final Exchanger<Object> exchanger1 = new Exchanger<Object>();
        context.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    exchanger0.exchange(null);
                    exchanger1.exchange(null);
                }
                catch (Throwable x) {
                    throw new ServletException(x);
                }
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.getWriter().println("The Response");
                response.getWriter().close();
            }
        });
        server.setStopTimeout(1000L);
        server.start();
        LocalConnector.LocalEndPoint endp = connector.executeRequest("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n");
        exchanger0.exchange(null);
        exchanger1.exchange(null);
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        endp.addInputAndExecute(BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost:localhost\r\n\r\n"));
        exchanger0.exchange(null);
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            try {
                server.stop();
                latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        while (server.isStarted()) {
            Thread.sleep(10L);
        }
        String unavailable = connector.getResponse("GET / HTTP/1.1\r\nHost:localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)unavailable, (Matcher)Matchers.containsString((String)" 503 Service Unavailable"));
        MatcherAssert.assertThat((Object)unavailable, (Matcher)Matchers.containsString((String)"Connection: close"));
        exchanger1.exchange(null);
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testContextStop() throws Exception {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        ContextHandler context = new ContextHandler((HandlerContainer)server, "/");
        StatisticsHandler stats = new StatisticsHandler();
        context.setHandler((Handler)stats);
        final Exchanger<Object> exchanger0 = new Exchanger<Object>();
        final Exchanger<Object> exchanger1 = new Exchanger<Object>();
        stats.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    exchanger0.exchange(null);
                    exchanger1.exchange(null);
                }
                catch (Throwable x) {
                    throw new ServletException(x);
                }
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.getWriter().println("The Response");
                response.getWriter().close();
            }
        });
        context.setStopTimeout(1000L);
        server.start();
        LocalConnector.LocalEndPoint endp = connector.executeRequest("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n");
        exchanger0.exchange(null);
        exchanger1.exchange(null);
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        endp.addInputAndExecute(BufferUtil.toBuffer((String)"GET / HTTP/1.1\r\nHost:localhost\r\n\r\n"));
        exchanger0.exchange(null);
        CountDownLatch latch = new CountDownLatch(1);
        new Thread(() -> {
            try {
                context.stop();
                latch.countDown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }).start();
        while (context.isStarted()) {
            Thread.sleep(10L);
        }
        String unavailable = connector.getResponse("GET / HTTP/1.1\r\nHost:localhost\r\n\r\n");
        MatcherAssert.assertThat((Object)unavailable, (Matcher)Matchers.containsString((String)" 404 Not Found"));
        exchanger1.exchange(null);
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Connection: close")));
        Assertions.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
    }

    @Test
    public void testFailedStart() {
        Server server = new Server();
        LocalConnector connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        final AtomicBoolean context0Started = new AtomicBoolean(false);
        ContextHandler context0 = new ContextHandler("/zero"){

            protected void doStart() throws Exception {
                context0Started.set(true);
            }
        };
        ContextHandler context1 = new ContextHandler("/one"){

            protected void doStart() throws Exception {
                throw new Exception("Test start failure");
            }
        };
        final AtomicBoolean context2Started = new AtomicBoolean(false);
        ContextHandler context2 = new ContextHandler("/two"){

            protected void doStart() throws Exception {
                context2Started.set(true);
            }
        };
        contexts.setHandlers(new Handler[]{context0, context1, context2});
        try {
            server.start();
            Assertions.fail();
        }
        catch (Exception e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.is((Object)"Test start failure"));
        }
        Assertions.assertTrue((boolean)server.getContainedBeans(LifeCycle.class).stream().noneMatch(LifeCycle::isRunning));
        Assertions.assertTrue((boolean)server.getContainedBeans(LifeCycle.class).stream().anyMatch(LifeCycle::isFailed));
        Assertions.assertTrue((boolean)context0Started.get());
        Assertions.assertFalse((boolean)context2Started.get());
    }

    static class TestHandler
    extends AbstractHandler {
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference<Throwable> thrown = new AtomicReference();
        final AtomicBoolean handling = new AtomicBoolean(false);

        TestHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this.handling.set(true);
            this.latch.countDown();
            int c = 0;
            try {
                int contentLength = request.getContentLength();
                ServletInputStream in = request.getInputStream();
                while (in.read() >= 0) {
                    ++c;
                }
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.getWriter().printf("read %d/%d%n", c, contentLength);
            }
            catch (Throwable th) {
                this.thrown.set(th);
            }
            finally {
                this.handling.set(false);
            }
        }
    }

    static class ABHandler
    extends AbstractHandler {
        final CountDownLatch latchA = new CountDownLatch(1);
        final CountDownLatch latchB = new CountDownLatch(1);

        ABHandler() {
        }

        public void handle(String s, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.setContentLength(2);
            response.getOutputStream().write("a".getBytes());
            try {
                this.latchA.countDown();
                this.latchB.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            response.flushBuffer();
            response.getOutputStream().write("b".getBytes());
        }
    }

    static class NoopHandler
    extends AbstractHandler {
        final CountDownLatch latch = new CountDownLatch(1);

        NoopHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            this.latch.countDown();
        }
    }
}

