/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.Exchanger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.QuietServletException;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SuspendHandler;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.AbstractLogger;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.junit.jupiter.api.condition.DisabledOnJre;
import org.junit.jupiter.api.condition.JRE;

public abstract class HttpServerTestBase
extends HttpServerTestFixture {
    private static final String REQUEST1_HEADER = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=utf-8\nConnection: close\nContent-Length: ";
    private static final String REQUEST1_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n</nimbus>";
    private static final String REQUEST1 = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=utf-8\nConnection: close\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n</nimbus>".getBytes().length + "\n\n" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n</nimbus>";
    private static final String RESPONSE1 = "HTTP/1.1 200 OK\nContent-Length: 13\nServer: Jetty(" + Server.getVersion() + ")\n\nHello world\n";
    private static final String FRAGMENT1 = REQUEST1.substring(0, 16);
    private static final String FRAGMENT2 = REQUEST1.substring(16, 34);
    private static final String FRAGMENT3 = REQUEST1.substring(34);
    protected static final String REQUEST2_HEADER = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=ISO-8859-1\nContent-Length: ";
    protected static final String REQUEST2_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>";
    protected static final String REQUEST2 = "POST / HTTP/1.0\nHost: localhost\nContent-Type: text/xml; charset=ISO-8859-1\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>".getBytes().length + "\n\n" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>";
    protected static final String RESPONSE2_CONTENT = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>\n";
    protected static final String RESPONSE2 = "HTTP/1.1 200 OK\nContent-Type: text/xml;charset=iso-8859-1\nContent-Length: " + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>\n".getBytes().length + "\nServer: Jetty(" + Server.getVersion() + ")\n\n" + "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<nimbus xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n        xsi:noNamespaceSchemaLocation=\"nimbus.xsd\" version=\"1.0\">\n    <request requestId=\"1\">\n        <getJobDetails>\n            <jobId>73</jobId>\n        </getJobDetails>\n    </request>\n</nimbus>\n";

    @Test
    public void testSimple() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello world"));
        }
    }

    @Test
    public void testOPTIONS() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.OptionsHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(("OPTIONS * HTTP/1.1\r\nHost: " + this._serverURI.getHost() + "\r\nConnection: close\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Allow: GET"));
        }
    }

    @Test
    public void testGETStar() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.OptionsHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(("GET * HTTP/1.1\r\nHost: " + this._serverURI.getHost() + "\r\nConnection: close\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 "));
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Allow: ")));
        }
    }

    @Test
    public void testFullMethod() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
             StacklessLogging stackless = new StacklessLogging(new Class[]{HttpConnection.class});){
            client.setSoTimeout(10000);
            Log.getLogger(HttpConnection.class).info("expect request is too large, then ISE extra data ...", new Object[0]);
            OutputStream os = client.getOutputStream();
            byte[] buffer = new byte[65536];
            Arrays.fill(buffer, (byte)65);
            os.write(buffer);
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 431 "));
        }
    }

    @Test
    public void testFullURI() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        int maxHeaderSize = 1000;
        this._httpConfiguration.setRequestHeaderSize(maxHeaderSize);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
             StacklessLogging stackless = new StacklessLogging(new Class[]{HttpConnection.class});){
            Log.getLogger(HttpConnection.class).info("expect URI is too large", new Object[0]);
            OutputStream os = client.getOutputStream();
            byte[] buffer = new byte[5 + maxHeaderSize];
            buffer[0] = 71;
            buffer[1] = 69;
            buffer[2] = 84;
            buffer[3] = 32;
            buffer[4] = 47;
            Arrays.fill(buffer, 5, buffer.length, (byte)65);
            os.write(buffer);
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 414 "));
        }
    }

    @Test
    public void testBadURI() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET /%xx HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 "));
        }
    }

    @Test
    public void testExceptionThrownInHandlerLoop() throws Exception {
        this.configureServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                throw new QuietServletException("TEST handler exception");
            }
        });
        StringBuffer request = new StringBuffer("GET / HTTP/1.0\r\n");
        request.append("Host: localhost\r\n\r\n");
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        OutputStream os = client.getOutputStream();
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            Log.getLogger(HttpChannel.class).info("Expecting ServletException: TEST handler exception...", new Object[0]);
            os.write(request.toString().getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 500 "));
        }
    }

    @Test
    public void testExceptionThrownInHandler() throws Exception {
        this.configureServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                throw new QuietServletException("TEST handler exception");
            }
        });
        StringBuffer request = new StringBuffer("GET / HTTP/1.0\r\n");
        request.append("Host: localhost\r\n\r\n");
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        OutputStream os = client.getOutputStream();
        try (StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            Log.getLogger(HttpChannel.class).info("Expecting ServletException: TEST handler exception...", new Object[0]);
            os.write(request.toString().getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)" 500 "));
        }
    }

    @Test
    public void testInterruptedRequest() throws Exception {
        final AtomicBoolean fourBytesRead = new AtomicBoolean(false);
        final AtomicBoolean earlyEOFException = new AtomicBoolean(false);
        this.configureServer((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                int contentLength = request.getContentLength();
                ServletInputStream inputStream = request.getInputStream();
                for (int i = 0; i < contentLength; ++i) {
                    try {
                        inputStream.read();
                    }
                    catch (EofException e) {
                        earlyEOFException.set(true);
                        throw new QuietServletException((Throwable)e);
                    }
                    if (i != 3) continue;
                    fourBytesRead.set(true);
                }
            }
        });
        StringBuffer request = new StringBuffer("GET / HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Content-length: 6\n\n");
        request.append("foo");
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        OutputStream os = client.getOutputStream();
        os.write(request.toString().getBytes());
        os.flush();
        client.shutdownOutput();
        String response = HttpServerTestBase.readResponse(client);
        client.close();
        MatcherAssert.assertThat((String)"response contains 500", (Object)response, (Matcher)Matchers.containsString((String)" 500 "));
        MatcherAssert.assertThat((String)"The 4th byte (-1) has not been passed to the handler", (Object)fourBytesRead.get(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"EofException has been caught", (Object)earlyEOFException.get(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testFullHeader() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
             StacklessLogging stackless = new StacklessLogging(new Class[]{HttpConnection.class});){
            Log.getLogger(HttpConnection.class).info("expect header is too large ...", new Object[0]);
            OutputStream os = client.getOutputStream();
            byte[] buffer = new byte[65536];
            buffer[0] = 71;
            buffer[1] = 69;
            buffer[2] = 84;
            buffer[3] = 32;
            buffer[4] = 47;
            buffer[5] = 32;
            buffer[6] = 72;
            buffer[7] = 84;
            buffer[8] = 84;
            buffer[9] = 80;
            buffer[10] = 47;
            buffer[11] = 49;
            buffer[12] = 46;
            buffer[13] = 48;
            buffer[14] = 10;
            buffer[15] = 72;
            buffer[16] = 58;
            Arrays.fill(buffer, 17, buffer.length - 1, (byte)65);
            try {
                os.write(buffer);
                os.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                String response = HttpServerTestBase.readResponse(client);
                MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 431 "));
            }
            catch (Exception e) {
                Log.getLogger(HttpServerTestBase.class).warn("TODO Early close???", new Object[0]);
            }
        }
    }

    @Test
    public void testRequest1() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(REQUEST1.getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assertions.assertEquals((Object)RESPONSE1, (Object)response, (String)"response");
        }
    }

    @Test
    public void testFragmentedChunk() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET /R2 HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\n".getBytes());
            os.flush();
            Thread.sleep(1000L);
            os.write("5".getBytes());
            Thread.sleep(1000L);
            os.write("\r\n".getBytes());
            os.flush();
            Thread.sleep(1000L);
            os.write("ABCDE\r\n0;\r\n\r\n".getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200"));
        }
    }

    @Test
    public void testTrailingContent() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET /R2 HTTP/1.1\r\nHost: localhost\r\nContent-Length: 5\r\nContent-Type: text/plain\r\nConnection: close\r\n\r\nABCDE\r\n\r\n".getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assertions.assertTrue((response.indexOf("200") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testRequest1Fragments() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(FRAGMENT1.getBytes());
            os.flush();
            Thread.sleep(10L);
            os.write(FRAGMENT2.getBytes());
            os.flush();
            Thread.sleep(10L);
            os.write(FRAGMENT3.getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            Assertions.assertEquals((Object)RESPONSE1, (Object)response, (String)"response");
        }
    }

    @Test
    public void testRequest2() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        for (int i = 0; i < 50; ++i) {
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                OutputStream os = client.getOutputStream();
                os.write(bytes);
                os.flush();
                String response = HttpServerTestBase.readResponse(client);
                Assertions.assertEquals((Object)RESPONSE2, (Object)response, (String)("response " + i));
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                this._server.dumpStdErr();
                throw e;
            }
        }
    }

    @Test
    @DisabledIfSystemProperty(named="env", matches="ci")
    public void testRequest2Sliced2() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        int splits = bytes.length - REQUEST2_CONTENT.length() + 5;
        for (int i = 0; i < splits; ++i) {
            int[] points = new int[]{i};
            StringBuilder message = new StringBuilder();
            message.append("iteration #").append(i + 1);
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                OutputStream os = client.getOutputStream();
                this.writeFragments(bytes, points, message, os);
                String response = HttpServerTestBase.readResponse(client);
                Assertions.assertEquals((Object)RESPONSE2, (Object)response, (String)("response for " + i + " " + message.toString()));
                Thread.sleep(10L);
                continue;
            }
        }
    }

    @Test
    @DisabledIfSystemProperty(named="env", matches="ci")
    public void testRequest2Sliced3() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        byte[] bytes = REQUEST2.getBytes();
        int splits = bytes.length - REQUEST2_CONTENT.length() + 5;
        for (int i = 0; i < splits; ++i) {
            int[] points = new int[]{i, i + 1};
            StringBuilder message = new StringBuilder();
            message.append("iteration #").append(i + 1);
            try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
                OutputStream os = client.getOutputStream();
                this.writeFragments(bytes, points, message, os);
                String response = HttpServerTestBase.readResponse(client);
                Assertions.assertEquals((Object)RESPONSE2, (Object)response, (String)("response for " + i + " " + message.toString()));
                Thread.sleep(10L);
                continue;
            }
        }
    }

    @Test
    public void testFlush() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        String[] encoding = new String[]{"NONE", "UTF-8", "ISO-8859-1", "ISO-8859-2"};
        for (int e = 0; e < encoding.length; ++e) {
            int b = 1;
            while (b <= 128) {
                for (int w = 41; w < 42; w += 4096) {
                    for (int c = 0; c < 1; ++c) {
                        String test = encoding[e] + "x" + b + "x" + w + "x" + c;
                        try {
                            URL url = new URL(this._scheme + "://" + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "/?writes=" + w + "&block=" + b + (e == 0 ? "" : "&encoding=" + encoding[e]) + (c == 0 ? "&chars=true" : ""));
                            InputStream in = (InputStream)url.getContent();
                            String response = IO.toString((InputStream)in, e == 0 ? null : encoding[e]);
                            Assertions.assertEquals((int)(b * w), (int)response.length(), (String)test);
                            continue;
                        }
                        catch (Exception x) {
                            System.err.println(test);
                            x.printStackTrace();
                            throw x;
                        }
                    }
                }
                b = b == 1 ? 2 : (b == 2 ? 32 : (b == 32 ? 128 : 129));
            }
        }
    }

    @Test
    public void testBlockingWhileReadingRequestContent() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        long start = System.currentTimeMillis();
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data?writes=1024&block=256 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\ncontent-type: unknown\r\ncontent-length: 30\r\n\r\n").getBytes());
            os.flush();
            Thread.sleep(200L);
            os.write("\r\n23456890".getBytes());
            os.flush();
            Thread.sleep(1000L);
            os.write("abcdefghij".getBytes());
            os.flush();
            Thread.sleep(1000L);
            os.write("0987654321\r\n".getBytes());
            os.flush();
            int total = 0;
            int len = 0;
            byte[] buf = new byte[65536];
            int sleeps = 0;
            while (len >= 0) {
                len = is.read(buf);
                if (len <= 0 || (total += len) / 10240 <= sleeps) continue;
                ++sleeps;
                Thread.sleep(100L);
            }
            Assertions.assertTrue((total > 262144 ? 1 : 0) != 0);
            Assertions.assertTrue((30000L > System.currentTimeMillis() - start ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBlockingReadBadChunk() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.ReadHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            client.setSoTimeout(600000);
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: unknown\r\ntransfer-encoding: chunked\r\n\r\n").getBytes());
            os.flush();
            Thread.sleep(50L);
            os.write("a\r\n123456890\r\n".getBytes());
            os.flush();
            Thread.sleep(50L);
            os.write("4\r\nabcd\r\n".getBytes());
            os.flush();
            Thread.sleep(50L);
            os.write("X\r\nabcd\r\n".getBytes());
            os.flush();
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)HttpTester.from((InputStream)is));
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"EofException"));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Early EOF"));
        }
    }

    @Test
    public void testBlockingWhileWritingResponseContent() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        long start = System.currentTimeMillis();
        int total = 0;
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data?writes=256&block=1024 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\ncontent-type: unknown\r\n\r\n").getBytes());
            os.flush();
            int len = 0;
            byte[] buf = new byte[32768];
            int sleeps = 0;
            while (len >= 0) {
                len = is.read(buf);
                if (len <= 0 || (total += len) / 10240 <= sleeps) continue;
                Thread.sleep(200L);
                ++sleeps;
            }
            Assertions.assertTrue((total > 262144 ? 1 : 0) != 0);
            Assertions.assertTrue((30000L > System.currentTimeMillis() - start ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCloseWhileWriteBlocked() throws Exception {
        InputStream is;
        OutputStream os;
        this.configureServer((Handler)new HttpServerTestFixture.DataHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            os = client.getOutputStream();
            is = client.getInputStream();
            os.write(("GET /data?encoding=iso-8859-1&writes=100&block=100000 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\ncontent-type: unknown\r\n\r\n").getBytes());
            os.flush();
            byte[] buf = new byte[8192];
            is.read(buf);
            Thread.sleep(500L);
            client.close();
        }
        Thread.sleep(200L);
        client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        try {
            client.setSoTimeout(500);
            os = client.getOutputStream();
            is = client.getInputStream();
            os.write(("GET /data?writes=1&block=1024 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\ncontent-type: unknown\r\n\r\n").getBytes());
            os.flush();
            String response = IO.toString((InputStream)is);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 OK"));
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    @Test
    public void testBigBlocks() throws Exception {
        this.configureServer((Handler)new BigBlockHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            String line;
            String[] times;
            String line2;
            client.setSoTimeout(20000);
            OutputStream os = client.getOutputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
            os.write(("GET /r1 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n\r\nGET /r2 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\n\r\n").getBytes());
            os.flush();
            boolean chunked = false;
            boolean closed = false;
            while ((line2 = in.readLine()) != null && line2.length() != 0) {
                chunked |= "Transfer-Encoding: chunked".equals(line2);
                closed |= "Connection: close".equals(line2);
            }
            Assertions.assertTrue((boolean)chunked);
            Assertions.assertFalse((boolean)closed);
            int max = Integer.MIN_VALUE;
            while (true) {
                String chunk = in.readLine();
                String[] line3 = in.readLine();
                if (line3.length() == 0) break;
                int len = line3.length();
                Assertions.assertEquals((int)Integer.valueOf(chunk, 16), (int)len);
                if (max >= len) continue;
                max = len;
            }
            Assertions.assertEquals((int)((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).getHttpConfiguration().getOutputBufferSize(), (int)max);
            for (String t : times = in.readLine().split(",")) {
                Assertions.assertTrue((Integer.parseInt(t) < 999 ? 1 : 0) != 0);
            }
            String end = in.readLine();
            Assertions.assertEquals((Object)"0", (Object)end);
            end = in.readLine();
            Assertions.assertEquals((int)0, (int)end.length());
            chunked = false;
            closed = false;
            while ((line = in.readLine()) != null && line.length() != 0) {
                chunked |= "Transfer-Encoding: chunked".equals(line);
                closed |= "Connection: close".equals(line);
            }
            Assertions.assertFalse((boolean)chunked);
            Assertions.assertTrue((boolean)closed);
            String bigline = in.readLine();
            Assertions.assertEquals((int)0x140000, (int)bigline.length());
            for (String t : times = in.readLine().split(",")) {
                Assertions.assertTrue((Integer.parseInt(t) < 999 ? 1 : 0) != 0, (String)t);
            }
            Assertions.assertNull((Object)in.readLine());
        }
    }

    @Test
    public void testPipeline() throws Exception {
        final AtomicInteger served = new AtomicInteger();
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler(){

            @Override
            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                served.incrementAndGet();
                super.handle(target, baseRequest, request, response);
            }
        });
        int pipeline = 64;
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            served.set(0);
            client.setSoTimeout(5000);
            OutputStream os = client.getOutputStream();
            String request = "";
            for (int i = 1; i < pipeline; ++i) {
                request = request + "GET /data?writes=1&block=16&id=" + i + " HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nuser-agent: testharness/1.0 (blah foo/bar)\r\naccept-encoding: nothing\r\ncookie: aaa=1234567890\r\n\r\n";
            }
            request = request + "GET /data?writes=1&block=16 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nuser-agent: testharness/1.0 (blah foo/bar)\r\naccept-encoding: nothing\r\ncookie: aaa=bbbbbb\r\nConnection: close\r\n\r\n";
            os.write(request.getBytes());
            os.flush();
            LineNumberReader in = new LineNumberReader(new InputStreamReader(client.getInputStream()));
            String line = in.readLine();
            int count = 0;
            while (line != null) {
                if ("HTTP/1.1 200 OK".equals(line)) {
                    ++count;
                }
                line = in.readLine();
            }
            Assertions.assertEquals((int)pipeline, (int)served.get());
            Assertions.assertEquals((int)pipeline, (int)count);
        }
    }

    @Test
    public void testRecycledWriters() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write("123456789\n".getBytes("utf-8"));
            os.write(("POST /echo?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write("abcdefghZ\n".getBytes("utf-8"));
            String content = "Wibble";
            byte[] contentB = content.getBytes("utf-8");
            os.write(("POST /echo?charset=utf-16 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: " + contentB.length + "\r\nconnection: close\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write(contentB);
            os.flush();
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            IO.copy((InputStream)is, (OutputStream)bout);
            byte[] b = bout.toByteArray();
            int i = 0;
            while (b[i] != 90) {
                ++i;
            }
            int state = 0;
            block10: while (state != 4) {
                switch (b[i++]) {
                    case 13: {
                        if (state != 0 && state != 2) continue block10;
                        ++state;
                        continue block10;
                    }
                    case 10: {
                        if (state != 1 && state != 3) continue block10;
                        ++state;
                        continue block10;
                    }
                }
                state = 0;
            }
            String in = new String(b, 0, i, StandardCharsets.UTF_8);
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"123456789"));
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"abcdefghZ"));
            Assertions.assertFalse((boolean)in.contains("Wibble"));
            in = new String(b, i, b.length - i, StandardCharsets.UTF_16);
            Assertions.assertEquals((Object)"Wibble\n", (Object)in);
        }
    }

    @Test
    public void testHead() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler(false));
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("POST /R1 HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\n\r\n123456789\nHEAD /R2 HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\n\r\nABCDEFGHI\nPOST /R3 HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\nConnection: close\r\n\r\nabcdefghi\n").getBytes(StandardCharsets.ISO_8859_1));
            String in = IO.toString((InputStream)is);
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"123456789"));
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"ABCDEFGHI")));
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"abcdefghi"));
        }
    }

    @Test
    public void testRecycledReaders() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.EchoHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("POST /echo/0?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write("123456789\n".getBytes("utf-8"));
            os.write(("POST /echo/1?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-8\r\ncontent-length: 10\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write("abcdefghi\n".getBytes(StandardCharsets.UTF_8));
            String content = "Wibble";
            byte[] contentB = content.getBytes(StandardCharsets.UTF_16);
            os.write(("POST /echo/2?charset=utf-8 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\ncontent-type: text/plain; charset=utf-16\r\ncontent-length: " + contentB.length + "\r\nconnection: close\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write(contentB);
            os.flush();
            String in = IO.toString((InputStream)is);
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"123456789"));
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"abcdefghi"));
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"Wibble"));
        }
    }

    @Test
    public void testBlockedClient() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET / HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nTransfer-Encoding: chunked\r\nExpect: 100-continue\r\nConnection: Keep-Alive\r\n\r\n").getBytes());
            os.flush();
            client.setSoTimeout(2000);
            long start = System.currentTimeMillis();
            String in = IO.toString((InputStream)is);
            Assertions.assertTrue((System.currentTimeMillis() - start < 1000L ? 1 : 0) != 0);
            Assertions.assertTrue((in.indexOf("Connection: close") > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((in.indexOf("Hello world") > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCommittedError() throws Exception {
        CommittedErrorHandler handler = new CommittedErrorHandler();
        this.configureServer((Handler)handler);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
             StacklessLogging stackless = new StacklessLogging(new Class[]{HttpChannel.class});){
            ((AbstractLogger)Log.getLogger(HttpChannel.class)).info("Expecting exception after commit then could not send 500....", new Object[0]);
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET / HTTP/1.1\r\nHost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n\r\n").getBytes());
            os.flush();
            client.setSoTimeout(2000);
            String in = IO.toString((InputStream)is);
            Assertions.assertEquals((int)-1, (int)is.read());
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
            Assertions.assertTrue((in.indexOf("Transfer-Encoding: chunked") > 0 ? 1 : 0) != 0);
            Assertions.assertTrue((in.indexOf("Now is the time for all good men to come to the aid of the party") > 0 ? 1 : 0) != 0);
            MatcherAssert.assertThat((Object)in, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"\r\n0\r\n")));
            client.close();
            Thread.sleep(200L);
            Assertions.assertFalse((boolean)handler._endp.isOpen());
        }
    }

    @Test
    public void testAvailable() throws Exception {
        AvailableHandler ah = new AvailableHandler();
        this.configureServer((Handler)ah);
        ((HttpConnectionFactory)this._connector.getConnectionFactory(HttpConnectionFactory.class)).getHttpConfiguration().setDelayDispatchUntilContent(false);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream is = client.getInputStream();
            os.write(("GET /data?writes=1024&block=256 HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\ncontent-type: unknown\r\ncontent-length: 30\r\n\r\n").getBytes());
            os.flush();
            Thread.sleep(500L);
            os.write("1234567890".getBytes());
            os.flush();
            ah._ex.exchange(null);
            os.write("abcdefghijklmnopqrst".getBytes());
            os.flush();
            Thread.sleep(500L);
            ah._ex.exchange(null);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while (reader.readLine().length() > 0) {
            }
            MatcherAssert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)9));
            MatcherAssert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)0));
            MatcherAssert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
            MatcherAssert.assertThat((Object)Integer.parseInt(reader.readLine()), (Matcher)Matchers.equalTo((Object)0));
            Assertions.assertEquals((Object)"1234567890abcdefghijklmnopqrst", (Object)reader.readLine());
        }
    }

    @Test
    public void testDualRequest1() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.HelloWorldHandler());
        try (Socket client1 = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
             Socket client2 = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os1 = client1.getOutputStream();
            OutputStream os2 = client2.getOutputStream();
            os1.write(REQUEST1.getBytes());
            os2.write(REQUEST1.getBytes());
            os1.flush();
            os2.flush();
            String response1 = HttpServerTestBase.readResponse(client1);
            String response2 = HttpServerTestBase.readResponse(client2);
            Assertions.assertEquals((Object)RESPONSE1, (Object)response1, (String)"client1");
            Assertions.assertEquals((Object)RESPONSE1, (Object)response2, (String)"client2");
        }
    }

    protected static String readResponse(Socket client) throws IOException {
        String string;
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(client.getInputStream()));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                System.err.println(e + " while reading '" + sb + "'");
                throw e;
            }
        }
        br.close();
        return string;
    }

    protected void writeFragments(byte[] bytes, int[] points, StringBuilder message, OutputStream os) throws IOException, InterruptedException {
        int last = 0;
        for (int j = 0; j < points.length; ++j) {
            int point = points[j];
            os.write(bytes, last, point - last);
            last = point;
            os.flush();
            Thread.sleep(10L);
            message.append(" point #").append(j + 1).append(": ").append(point);
        }
        os.write(bytes, last, bytes.length - last);
        os.flush();
        Thread.sleep(10L);
    }

    @Test
    public void testUnreadInput() throws Exception {
        this.configureServer((Handler)new NoopHandler());
        int REQS = 2;
        String content = "This is a coooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooonnnnnnnnnnnnnnnntent";
        final int cl = "This is a coooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooonnnnnnnnnnnnnnnntent".getBytes().length;
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        final OutputStream out = client.getOutputStream();
        new Thread(){

            @Override
            public void run() {
                try {
                    byte[] bytes = ("GET / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + cl + "\r\n\r\n" + "This is a coooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooooonnnnnnnnnnnnnnnntent").getBytes(StandardCharsets.ISO_8859_1);
                    for (int i = 0; i < 2; ++i) {
                        out.write(bytes, 0, bytes.length);
                    }
                    out.write("GET / HTTP/1.1\r\nHost: last\r\nConnection: close\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
                    out.flush();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
        String resps = HttpServerTestBase.readResponse(client);
        int offset = 0;
        for (int i = 0; i < 3; ++i) {
            int ok = resps.indexOf("HTTP/1.1 200 OK", offset);
            MatcherAssert.assertThat((String)("resp" + i), (Object)ok, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(offset)));
            offset = ok + 15;
        }
    }

    @Test
    public void testWriteBodyAfterNoBodyResponse() throws Exception {
        this.configureServer((Handler)new WriteBodyAfterNoBodyResponseHandler());
        Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());
        OutputStream out = client.getOutputStream();
        out.write("GET / HTTP/1.1\r\nHost: test\r\n\r\n".getBytes());
        out.write("GET / HTTP/1.1\r\nHost: test\r\nConnection: close\r\n\r\n".getBytes());
        out.flush();
        BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
        String line = in.readLine();
        MatcherAssert.assertThat((Object)line, (Matcher)Matchers.containsString((String)" 304 "));
        while (true) {
            if ((line = in.readLine()) == null) {
                throw new EOFException();
            }
            if (line.length() == 0) break;
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Type")));
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Transfer-Encoding")));
        }
        line = in.readLine();
        MatcherAssert.assertThat((Object)line, (Matcher)Matchers.containsString((String)" 304 "));
        while (true) {
            if ((line = in.readLine()) == null) {
                throw new EOFException();
            }
            if (line.length() == 0) break;
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Type")));
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Transfer-Encoding")));
        }
        while ((line = in.readLine()) != null) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSuspendedPipeline() throws Exception {
        SuspendHandler suspend = new SuspendHandler();
        suspend.setSuspendFor(30000L);
        suspend.setResumeAfter(1000L);
        this.configureServer((Handler)suspend);
        long start = System.currentTimeMillis();
        client.setSoTimeout(5000);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(("GET / HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\n\r\n").getBytes());
            os.flush();
            Thread.sleep(200L);
            os.write(("GET / HTTP/1.1\r\nhost: " + this._serverURI.getHost() + ":" + this._serverURI.getPort() + "\r\nconnection: close\r\n\r\n").getBytes());
            os.flush();
            String response = HttpServerTestBase.readResponse(client);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"RESUMEDHTTP/1.1 200 OK"));
            MatcherAssert.assertThat((Object)(System.currentTimeMillis() - start), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(1999L)));
        }
    }

    @Test
    @DisabledOnJre(value={JRE.JAVA_8, JRE.JAVA_9, JRE.JAVA_10})
    public void testShutdown() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.ReadExactHandler());
        byte[] content = new byte[4096];
        Arrays.fill(content, (byte)88);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write(("GET / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write(content);
            os.write(("GET / HTTP/1.1\r\nHost: localhost\r\nContent-Length: " + content.length + "\r\n\r\n").getBytes(StandardCharsets.ISO_8859_1));
            os.write(content);
            os.flush();
            client.shutdownOutput();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)("Read " + content.length)));
            response = HttpTester.parseResponse((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)("Read " + content.length)));
            MatcherAssert.assertThat((Object)client.getInputStream().read(), (Matcher)Matchers.is((Object)-1));
        }
    }

    @Test
    @DisabledOnJre(value={JRE.JAVA_8, JRE.JAVA_9, JRE.JAVA_10})
    public void testChunkedShutdown() throws Exception {
        this.configureServer((Handler)new HttpServerTestFixture.ReadExactHandler(4096));
        byte[] content = new byte[4096];
        Arrays.fill(content, (byte)88);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET / HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n1000\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.write(content);
            os.write("\r\n0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.write("GET / HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n1000\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.write(content);
            os.write("\r\n0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            client.shutdownOutput();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)("Read " + content.length)));
            response = HttpTester.parseResponse((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)("Read " + content.length)));
            MatcherAssert.assertThat((Object)client.getInputStream().read(), (Matcher)Matchers.is((Object)-1));
        }
    }

    @Test
    public void testSendAsyncContent() throws Exception {
        int size = 65536;
        this.configureServer((Handler)new SendAsyncContentHandler(size));
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            os.write("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContentBytes().length, (Matcher)Matchers.is((Object)size));
            os.write("GET / HTTP/1.1\r\nHost: localhost\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            response = HttpTester.parseResponse((InputStream)client.getInputStream());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            MatcherAssert.assertThat((Object)response.getContentBytes().length, (Matcher)Matchers.is((Object)size));
        }
    }

    private class SendAsyncContentHandler
    extends AbstractHandler {
        final ByteBuffer content;

        public SendAsyncContentHandler(int size) {
            this.content = BufferUtil.allocate((int)size);
            Arrays.fill(this.content.array(), 0, size, (byte)88);
            this.content.position(0);
            this.content.limit(size);
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("application/unknown");
            response.setContentLength(this.content.remaining());
            AsyncContext async = request.startAsync();
            ((HttpOutput)response.getOutputStream()).sendContent(this.content.slice(), Callback.from(() -> ((AsyncContext)async).complete()));
        }
    }

    public class NoopHandler
    extends AbstractHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            ((Request)request).setHandled(true);
            response.setStatus(200);
        }
    }

    private class WriteBodyAfterNoBodyResponseHandler
    extends AbstractHandler {
        private WriteBodyAfterNoBodyResponseHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(304);
            response.getOutputStream().print("yuck");
            response.flushBuffer();
        }
    }

    protected static class AvailableHandler
    extends AbstractHandler {
        public Exchanger<Object> _ex = new Exchanger();

        protected AvailableHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("text/plain");
            ServletInputStream in = request.getInputStream();
            ServletOutputStream out = response.getOutputStream();
            int avail = in.available();
            out.println(avail);
            String buf = "";
            buf = buf + (char)in.read();
            avail = in.available();
            out.println(avail);
            for (int i = 0; i < avail; ++i) {
                buf = buf + (char)in.read();
            }
            avail = in.available();
            out.println(avail);
            try {
                this._ex.exchange(null);
                this._ex.exchange(null);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            avail = in.available();
            if (avail == 0) {
                buf = buf + (char)in.read();
                avail = in.available();
                out.println(avail + 1);
            } else if (avail == 1) {
                buf = buf + (char)in.read();
                avail = in.available();
                out.println(avail + 1);
            } else {
                out.println(avail);
            }
            while (avail > 0) {
                buf = buf + (char)in.read();
                avail = in.available();
            }
            out.println(avail);
            int b = in.read();
            while (b >= 0) {
                buf = buf + (char)b;
                b = in.read();
            }
            out.println(buf);
            out.close();
        }
    }

    public static class CommittedErrorHandler
    extends AbstractHandler {
        public EndPoint _endp;

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            this._endp = baseRequest.getHttpChannel().getEndPoint();
            response.setHeader("test", "value");
            response.setStatus(200);
            response.setContentType("text/plain");
            response.getWriter().println("Now is the time for all good men to come to the aid of the party");
            response.getWriter().flush();
            response.flushBuffer();
            throw new ServletException((Throwable)new Exception("exception after commit"));
        }
    }

    protected static class BigBlockHandler
    extends AbstractHandler {
        protected BigBlockHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            byte[] buf = new byte[131072];
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_".charAt(i % 63);
            }
            baseRequest.setHandled(true);
            response.setStatus(200);
            response.setContentType("text/plain");
            ServletOutputStream out = response.getOutputStream();
            long[] times = new long[10];
            for (int i = 0; i < times.length; ++i) {
                long start = System.currentTimeMillis();
                out.write(buf);
                long end = System.currentTimeMillis();
                times[i] = end - start;
            }
            out.println();
            for (long t : times) {
                out.print(t);
                out.print(",");
            }
            out.close();
        }
    }
}

