/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import javax.net.ssl.SSLSocket;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.OptionalSslConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionalSslConnectionTest {
    private Server server;
    private ServerConnector connector;

    private void startServer(Function<SslConnectionFactory, OptionalSslConnectionFactory> configFn, Handler handler) throws Exception {
        QueuedThreadPool serverThreads = new QueuedThreadPool();
        serverThreads.setName("server");
        this.server = new Server((ThreadPool)serverThreads);
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        HttpConfiguration httpConfig = new HttpConfiguration();
        HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
        SslConnectionFactory ssl = new SslConnectionFactory((SslContextFactory)sslContextFactory, http.getProtocol());
        OptionalSslConnectionFactory sslOrOther = configFn.apply(ssl);
        this.connector = new ServerConnector(this.server, 1, 1, new ConnectionFactory[]{sslOrOther, http});
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler(handler);
        this.server.start();
    }

    @AfterEach
    public void stopServer() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
    }

    private OptionalSslConnectionFactory optionalSsl(SslConnectionFactory ssl) {
        return new OptionalSslConnectionFactory(ssl, ssl.getNextProtocol());
    }

    private OptionalSslConnectionFactory optionalSslNoOtherProtocol(SslConnectionFactory ssl) {
        return new OptionalSslConnectionFactory(ssl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOptionalSslConnection() throws Exception {
        this.startServer(this::optionalSsl, (Handler)new EmptyServerHandler());
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        byte[] requestBytes = request.getBytes(StandardCharsets.US_ASCII);
        try (Socket plain = new Socket();){
            plain.connect(new InetSocketAddress("localhost", this.connector.getLocalPort()), 1000);
            OutputStream plainOutput = plain.getOutputStream();
            plainOutput.write(requestBytes);
            plainOutput.flush();
            plain.setSoTimeout(5000);
            InputStream plainInput = plain.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)plainInput);
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((int)200, (int)response.getStatus());
        }
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(true);
        sslContextFactory.start();
        try (SSLSocket ssl = sslContextFactory.newSslSocket();){
            ssl.connect(new InetSocketAddress("localhost", this.connector.getLocalPort()), 1000);
            OutputStream sslOutput = ssl.getOutputStream();
            sslOutput.write(requestBytes);
            sslOutput.flush();
            ssl.setSoTimeout(5000);
            InputStream sslInput = ssl.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)sslInput);
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((int)200, (int)response.getStatus());
        }
        finally {
            sslContextFactory.stop();
        }
    }

    @Test
    public void testOptionalSslConnectionWithOnlyOneByteShouldIdleTimeout() throws Exception {
        this.startServer(this::optionalSsl, (Handler)new EmptyServerHandler());
        long idleTimeout = 1000L;
        this.connector.setIdleTimeout(idleTimeout);
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("localhost", this.connector.getLocalPort()), 1000);
            OutputStream output = socket.getOutputStream();
            output.write(22);
            output.flush();
            socket.setSoTimeout((int)(2L * idleTimeout));
            InputStream input = socket.getInputStream();
            int read = input.read();
            Assertions.assertEquals((int)-1, (int)read);
        }
    }

    @Test
    public void testOptionalSslConnectionWithUnknownBytes() throws Exception {
        this.startServer(this::optionalSslNoOtherProtocol, (Handler)new EmptyServerHandler());
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("localhost", this.connector.getLocalPort()), 1000);
            OutputStream output = socket.getOutputStream();
            output.write(0);
            output.flush();
            Thread.sleep(500L);
            output.write(0);
            output.flush();
            socket.setSoTimeout(5000);
            InputStream input = socket.getInputStream();
            int read = input.read();
            Assertions.assertEquals((int)-1, (int)read);
        }
    }

    @Test
    public void testOptionalSslConnectionWithHTTPBytes() throws Exception {
        this.startServer(this::optionalSslNoOtherProtocol, (Handler)new EmptyServerHandler());
        String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
        byte[] requestBytes = request.getBytes(StandardCharsets.US_ASCII);
        try (Socket socket = new Socket();){
            socket.connect(new InetSocketAddress("localhost", this.connector.getLocalPort()), 1000);
            OutputStream output = socket.getOutputStream();
            output.write(requestBytes);
            output.flush();
            socket.setSoTimeout(5000);
            InputStream input = socket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            Assertions.assertEquals((int)400, (int)response.getStatus());
        }
    }

    @Test
    public void testNextProtocolIsNotNullButNotConfiguredEither() throws Exception {
        QueuedThreadPool serverThreads = new QueuedThreadPool();
        serverThreads.setName("server");
        this.server = new Server((ThreadPool)serverThreads);
        String keystore = MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath();
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keystore);
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        HttpConfiguration httpConfig = new HttpConfiguration();
        HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
        SslConnectionFactory ssl = new SslConnectionFactory((SslContextFactory)sslContextFactory, http.getProtocol());
        OptionalSslConnectionFactory optSsl = new OptionalSslConnectionFactory(ssl, "no-such-protocol");
        this.connector = new ServerConnector(this.server, 1, 1, new ConnectionFactory[]{optSsl, http});
        this.server.addConnector((Connector)this.connector);
        this.server.setHandler((Handler)new EmptyServerHandler());
        this.server.start();
        try (Socket socket = new Socket(this.server.getURI().getHost(), this.server.getURI().getPort());){
            OutputStream sslOutput = socket.getOutputStream();
            String request = "GET / HTTP/1.1\r\nHost: localhost\r\n\r\n";
            byte[] requestBytes = request.getBytes(StandardCharsets.US_ASCII);
            sslOutput.write(requestBytes);
            sslOutput.flush();
            socket.setSoTimeout(5000);
            InputStream sslInput = socket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)sslInput);
            Assertions.assertNull((Object)response);
        }
    }

    private static class EmptyServerHandler
    extends AbstractHandler {
        private EmptyServerHandler() {
        }

        public void handle(String target, Request jettyRequest, HttpServletRequest request, HttpServletResponse response) {
            jettyRequest.setHandled(true);
        }
    }
}

