/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.IPAccessHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class IPAccessHandlerTest {
    private Server _server;
    private NetworkConnector _connector;
    private IPAccessHandler _handler;

    @BeforeEach
    public void setUp() throws Exception {
        this._server = new Server();
        this._connector = new ServerConnector(this._server);
        this._server.setConnectors(new Connector[]{this._connector});
        this._handler = new IPAccessHandler();
        this._handler.setHandler((Handler)new ScopedHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                try {
                    baseRequest.setServletPath(baseRequest.getPathInfo());
                    baseRequest.setPathInfo(null);
                    super.doScope(target, baseRequest, request, response);
                }
                finally {
                    baseRequest.setPathInfo(baseRequest.getServletPath());
                    baseRequest.setServletPath(null);
                }
            }

            public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
            }
        });
    }

    @AfterEach
    public void tearDown() throws Exception {
        this._server.stop();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testHandler(String white, String black, String host, String uri, String code, boolean byPath) throws Exception {
        this._server.setHandler((Handler)this._handler);
        this._server.start();
        this._handler.setWhite(white.split(";", -1));
        this._handler.setBlack(black.split(";", -1));
        this._handler.setWhiteListByPath(byPath);
        String request = "GET " + uri + " HTTP/1.1\nHost: " + host + "\n\n";
        Socket socket = new Socket("127.0.0.1", this._connector.getLocalPort());
        socket.setSoTimeout(5000);
        try (OutputStream output = socket.getOutputStream();){
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            Response response = this.readResponse(input);
            Object[] params = new Object[]{"Request WBHUC", white, black, host, uri, code, "Response", response.getCode()};
            Assertions.assertEquals((Object)code, (Object)response.getCode(), (String)Arrays.deepToString(params));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testContext(String white, String black, String host, String uri, String code, boolean byPath) throws Exception {
        ContextHandler context = new ContextHandler((HandlerContainer)this._server, "/ctx");
        context.setHandler((Handler)this._handler);
        this._server.setHandler((Handler)context);
        this._server.start();
        white = white.replaceAll("\\|/", "|/ctx/");
        black = black.replaceAll("\\|/", "|/ctx/");
        Assumptions.assumeFalse((boolean)white.endsWith("|"));
        Assumptions.assumeFalse((boolean)black.endsWith("|"));
        this._handler.setWhite(white.split(";", -1));
        this._handler.setBlack(black.split(";", -1));
        this._handler.setWhiteListByPath(byPath);
        String request = "GET /ctx" + uri + " HTTP/1.1\nHost: " + host + "\n\n";
        Socket socket = new Socket("127.0.0.1", this._connector.getLocalPort());
        socket.setSoTimeout(5000);
        try (OutputStream output = socket.getOutputStream();){
            BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            Response response = this.readResponse(input);
            Object[] params = new Object[]{"Request WBHUC", white, black, host, uri, code, "Response", response.getCode()};
            Assertions.assertEquals((Object)code, (Object)response.getCode(), (String)Arrays.deepToString(params));
        }
    }

    protected Response readResponse(BufferedReader reader) throws IOException {
        StringBuilder body;
        LinkedHashMap<String, String> headers;
        String code;
        block6: {
            String line;
            block7: {
                line = reader.readLine();
                if (line == null) {
                    throw new EOFException();
                }
                Matcher responseLine = Pattern.compile("HTTP/1\\.1\\s+(\\d+)").matcher(line);
                Assertions.assertTrue((boolean)responseLine.lookingAt());
                code = responseLine.group(1);
                headers = new LinkedHashMap<String, String>();
                while ((line = reader.readLine()) != null && line.trim().length() != 0) {
                    Matcher header = Pattern.compile("([^:]+):\\s*(.*)").matcher(line);
                    Assertions.assertTrue((boolean)header.lookingAt());
                    String headerName = header.group(1);
                    String headerValue = header.group(2);
                    headers.put(headerName.toLowerCase(Locale.ENGLISH), headerValue.toLowerCase(Locale.ENGLISH));
                }
                body = new StringBuilder();
                if (!headers.containsKey("content-length")) break block7;
                int length = Integer.parseInt((String)headers.get("content-length"));
                for (int i = 0; i < length; ++i) {
                    char c = (char)reader.read();
                    body.append(c);
                }
                break block6;
            }
            if (!"chunked".equals(headers.get("transfer-encoding"))) break block6;
            while ((line = reader.readLine()) != null) {
                if ("0".equals(line)) {
                    line = reader.readLine();
                    Assertions.assertEquals((Object)"", (Object)line);
                    break;
                }
                int length = Integer.parseInt(line, 16);
                for (int i = 0; i < length; ++i) {
                    char c = (char)reader.read();
                    body.append(c);
                }
                line = reader.readLine();
                Assertions.assertEquals((Object)"", (Object)line);
            }
        }
        return new Response(code, headers, body.toString().trim());
    }

    public static Stream<Arguments> data() {
        Object[][] data = new Object[][]{{"", "", "127.0.0.1", "/", "200", false}, {"", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1", "", "127.0.0.1", "/", "200", false}, {"127.0.0.1", "", "127.0.0.1", "/dispatch", "200", false}, {"127.0.0.1", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/", "", "127.0.0.1", "/", "200", false}, {"127.0.0.1|/", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.1|/", "", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.1|/*", "", "127.0.0.1", "/", "200", false}, {"127.0.0.1|/*", "", "127.0.0.1", "/dispatch", "200", false}, {"127.0.0.1|/*", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/", "403", false}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dump/test", "200", false}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/", "403", false}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dump/test", "403", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/", "403", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/test", "200", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/fail", "403", false}, {"127.0.0.0-2|", "", "127.0.0.1", "/", "200", false}, {"127.0.0.0-2|", "", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.0-2|/", "", "127.0.0.1", "/", "200", false}, {"127.0.0.0-2|/", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.0-2|/", "", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/", "403", false}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/", "403", false}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dump/test", "403", false}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/", "403", false}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/test", "200", false}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/fail", "403", false}, {"", "127.0.0.1", "127.0.0.1", "/", "403", false}, {"", "127.0.0.1", "127.0.0.1", "/dispatch", "403", false}, {"", "127.0.0.1", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.1|/", "127.0.0.1", "/", "403", false}, {"", "127.0.0.1|/", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.1|/", "127.0.0.1", "/dump/info", "200", false}, {"", "127.0.0.1|/*", "127.0.0.1", "/", "403", false}, {"", "127.0.0.1|/*", "127.0.0.1", "/dispatch", "403", false}, {"", "127.0.0.1|/*", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/", "200", false}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dump/test", "403", false}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/", "200", false}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dump/test", "200", false}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/", "200", false}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/test", "403", false}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/fail", "200", false}, {"", "127.0.0.0-2|", "127.0.0.1", "/", "403", false}, {"", "127.0.0.0-2|", "127.0.0.1", "/dump/info", "200", false}, {"", "127.0.0.0-2|/", "127.0.0.1", "/", "403", false}, {"", "127.0.0.0-2|/", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.0-2|/", "127.0.0.1", "/dump/info", "200", false}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/", "200", false}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/", "200", false}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dump/test", "200", false}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/", "200", false}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dispatch", "200", false}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/info", "403", false}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/test", "403", false}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/fail", "200", false}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200", false}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/test", "403", false}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump", "403", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/test", "403", false}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/fail", "403", false}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/", "200", false}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/dump/fail", "403", false}, {"127.0.0.2", "", "127.0.0.1", "/", "403", false}, {"127.0.0.2", "", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.2|/dump/*", "", "127.0.0.1", "/", "403", false}, {"127.0.0.2|/dump/*", "", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/", "403", false}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/dump/info", "403", false}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/dump/test", "403", false}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/", "403", false}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dispatch", "403", false}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/info", "200", false}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/test", "403", false}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/fail", "403", false}, {"172.0.0.0-255", "", "127.0.0.1", "/", "403", false}, {"172.0.0.0-255", "", "127.0.0.1", "/dump/info", "403", false}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/", "403", false}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/dispatch", "403", false}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/dump/info", "200", false}, {"", "", "127.0.0.1", "/", "200", true}, {"", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1|/", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/*", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/*", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1|/*", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/*", "", "127.0.0.1", "/dump/test", "200", true}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/info", "", "127.0.0.1", "/dump/test", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/test", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "", "127.0.0.1", "/dump/fail", "200", true}, {"127.0.0.0-2|", "", "127.0.0.1", "/", "200", true}, {"127.0.0.0-2|", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.0-2|/", "", "127.0.0.1", "/", "200", true}, {"127.0.0.0-2|/", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.0-2|/", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/", "200", true}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.0-2|/dump/*", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/", "200", true}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.0-2|/dump/info", "", "127.0.0.1", "/dump/test", "200", true}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/", "200", true}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/test", "200", true}, {"127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "", "127.0.0.1", "/dump/fail", "200", true}, {"", "127.0.0.1", "127.0.0.1", "/", "403", true}, {"", "127.0.0.1", "127.0.0.1", "/dispatch", "403", true}, {"", "127.0.0.1", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.1|/", "127.0.0.1", "/", "403", true}, {"", "127.0.0.1|/", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.1|/", "127.0.0.1", "/dump/info", "200", true}, {"", "127.0.0.1|/*", "127.0.0.1", "/", "403", true}, {"", "127.0.0.1|/*", "127.0.0.1", "/dispatch", "403", true}, {"", "127.0.0.1|/*", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/", "200", true}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.1|/dump/*", "127.0.0.1", "/dump/test", "403", true}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/", "200", true}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.1|/dump/info", "127.0.0.1", "/dump/test", "200", true}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/", "200", true}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/test", "403", true}, {"", "127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1", "/dump/fail", "200", true}, {"", "127.0.0.0-2|", "127.0.0.1", "/", "403", true}, {"", "127.0.0.0-2|", "127.0.0.1", "/dump/info", "200", true}, {"", "127.0.0.0-2|/", "127.0.0.1", "/", "403", true}, {"", "127.0.0.0-2|/", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.0-2|/", "127.0.0.1", "/dump/info", "200", true}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/", "200", true}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.0-2|/dump/*", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/", "200", true}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.0-2|/dump/info", "127.0.0.1", "/dump/test", "200", true}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/", "200", true}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dispatch", "200", true}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/info", "403", true}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/test", "403", true}, {"", "127.0.0.0-2|/dump/info;127.0.0.0-2|/dump/test", "127.0.0.1", "/dump/fail", "200", true}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200", true}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump", "200", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/test", "403", true}, {"127.0.0.1|/dump/*", "127.0.0.1|/dump/test;127.0.0.1|/dump/fail", "127.0.0.1", "/dump/fail", "403", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/test", "403", true}, {"127.0.0.1|/dump/info;127.0.0.1|/dump/test", "127.0.0.1|/dump/test", "127.0.0.1", "/dump/fail", "200", true}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/;127.0.0.0-2|/dump/*", "127.0.0.0,1|/dump/fail", "127.0.0.1", "/dump/fail", "403", true}, {"127.0.0.2", "", "127.0.0.1", "/", "403", true}, {"127.0.0.2", "", "127.0.0.1", "/dump/info", "403", true}, {"127.0.0.2|/dump/*", "", "127.0.0.1", "/", "200", true}, {"127.0.0.2|/dump/*", "", "127.0.0.1", "/dump/info", "403", true}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/", "200", true}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/dump/info", "403", true}, {"127.0.0.2|/dump/info", "", "127.0.0.1", "/dump/test", "200", true}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/", "200", true}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dispatch", "200", true}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/info", "200", true}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/test", "403", true}, {"127.0.0.1|/dump/info;127.0.0.2|/dump/test", "", "127.0.0.1", "/dump/fail", "200", true}, {"172.0.0.0-255", "", "127.0.0.1", "/", "403", true}, {"172.0.0.0-255", "", "127.0.0.1", "/dump/info", "403", true}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/", "200", true}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/dispatch", "200", true}, {"172.0.0.0-255|/dump/*;127.0.0.0-255|/dump/*", "", "127.0.0.1", "/dump/info", "200", true}};
        return Arrays.asList(data).stream().map(Arguments::of);
    }

    protected class Response {
        private final String code;
        private final Map<String, String> headers;
        private final String body;

        private Response(String code, Map<String, String> headers, String body) {
            this.code = code;
            this.headers = headers;
            this.body = body;
        }

        public String getCode() {
            return this.code;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.code).append("\r\n");
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                builder.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
            }
            builder.append("\r\n");
            builder.append(this.body);
            return builder.toString();
        }
    }
}

