/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.InetAccessHandler;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class InetAccessHandlerTest {
    private static Server _server;
    private static ServerConnector _connector1;
    private static ServerConnector _connector2;
    private static InetAccessHandler _handler;

    @BeforeAll
    public static void setUp() throws Exception {
        _server = new Server();
        _connector1 = new ServerConnector(_server);
        _connector1.setName("http_connector1");
        _connector2 = new ServerConnector(_server);
        _connector2.setName("http_connector2");
        _server.setConnectors(new Connector[]{_connector1, _connector2});
        _handler = new InetAccessHandler();
        _handler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
            }
        });
        _server.setHandler((Handler)_handler);
        _server.start();
    }

    @AfterAll
    public static void tearDown() throws Exception {
        _server.stop();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testHandler(String include, String exclude, String includeConnectors, String excludeConnectors, String code) throws Exception {
        _handler.clear();
        for (String inc : include.split(";", -1)) {
            if (inc.length() <= 0) continue;
            _handler.include(inc);
        }
        for (String exc : exclude.split(";", -1)) {
            if (exc.length() <= 0) continue;
            _handler.exclude(exc);
        }
        for (String inc : includeConnectors.split(";", -1)) {
            if (inc.length() <= 0) continue;
            _handler.includeConnector(inc);
        }
        for (String exc : excludeConnectors.split(";", -1)) {
            if (exc.length() <= 0) continue;
            _handler.excludeConnector(exc);
        }
        ArrayList<String> codePerConnector = new ArrayList<String>();
        for (String nextCode : code.split(";", -1)) {
            if (nextCode.length() <= 0) continue;
            codePerConnector.add(nextCode);
        }
        this.testConnector(_connector1.getLocalPort(), include, exclude, includeConnectors, excludeConnectors, (String)codePerConnector.get(0));
        this.testConnector(_connector2.getLocalPort(), include, exclude, includeConnectors, excludeConnectors, (String)codePerConnector.get(1));
    }

    private void testConnector(int port, String include, String exclude, String includeConnectors, String excludeConnectors, String code) throws IOException {
        try (Socket socket = new Socket("127.0.0.1", port);){
            socket.setSoTimeout(5000);
            HttpTester.Request request = HttpTester.newRequest();
            request.setMethod("GET");
            request.setURI("/path");
            request.setHeader("Host", "127.0.0.1");
            request.setVersion(HttpVersion.HTTP_1_0);
            ByteBuffer output = request.generate();
            socket.getOutputStream().write(output.array(), output.arrayOffset() + output.position(), output.remaining());
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            Object[] params = new Object[]{"Request WBHUC", include, exclude, includeConnectors, excludeConnectors, code, "Response", response.getStatus()};
            Assertions.assertEquals((int)Integer.parseInt(code), (int)response.getStatus(), (String)Arrays.deepToString(params));
        }
    }

    public static Stream<Arguments> data() {
        Object[][] data = new Object[][]{{"", "", "", "", "200;200"}, {"127.0.0.1", "", "", "", "200;200"}, {"127.0.0.1-127.0.0.254", "", "", "", "200;200"}, {"192.0.0.1", "", "", "", "403;403"}, {"192.0.0.1-192.0.0.254", "", "", "", "403;403"}, {"127.0.0.1", "", "http_connector1", "", "200;200"}, {"127.0.0.1-127.0.0.254", "", "http_connector1", "", "200;200"}, {"192.0.0.1", "", "http_connector1", "", "403;200"}, {"192.0.0.1-192.0.0.254", "", "http_connector1", "", "403;200"}, {"192.0.0.1", "", "http_connector2", "", "200;403"}, {"192.0.0.1-192.0.0.254", "", "http_connector2", "", "200;403"}, {"127.0.0.1", "", "nothttp", "", "200;200"}, {"127.0.0.1-127.0.0.254", "", "nothttp", "", "200;200"}, {"192.0.0.1", "", "nothttp", "", "200;200"}, {"192.0.0.1-192.0.0.254", "", "nothttp", "", "200;200"}, {"127.0.0.1", "", "", "http_connector1", "200;200"}, {"127.0.0.1-127.0.0.254", "", "", "http_connector1", "200;200"}, {"192.0.0.1", "", "", "http_connector1", "200;403"}, {"192.0.0.1-192.0.0.254", "", "", "http_connector1", "200;403"}, {"192.0.0.1", "", "", "http_connector2", "403;200"}, {"192.0.0.1-192.0.0.254", "", "", "http_connector2", "403;200"}, {"127.0.0.1", "", "", "nothttp", "200;200"}, {"127.0.0.1-127.0.0.254", "", "", "nothttp", "200;200"}, {"192.0.0.1", "", "", "nothttp", "403;403"}, {"192.0.0.1-192.0.0.254", "", "", "nothttp", "403;403"}, {"127.0.0.1", "", "", "http_connector1;http_connector2", "200;200"}, {"127.0.0.1-127.0.0.254", "", "", "http_connector1;http_connector2", "200;200"}, {"192.0.0.1", "", "", "http_connector1;http_connector2", "200;200"}, {"192.0.0.1-192.0.0.254", "", "", "http_connector1;http_connector2", "200;200"}, {"127.0.0.1", "", "http_connector1;http_connector2", "", "200;200"}, {"127.0.0.1-127.0.0.254", "", "http_connector1;http_connector2", "", "200;200"}, {"192.0.0.1", "", "http_connector1;http_connector2", "", "403;403"}, {"192.0.0.1-192.0.0.254", "", "http_connector1;http_connector2", "", "403;403"}, {"127.0.0.1", "", "http_connector1;http_connector2", "http_connector1;http_connector2", "200;200"}, {"127.0.0.1-127.0.0.254", "", "http_connector1;http_connector2", "http_connector1;http_connector2", "200;200"}, {"192.0.0.1", "", "http_connector1;http_connector2", "http_connector1;http_connector2", "200;200"}, {"192.0.0.1-192.0.0.254", "", "http_connector1;http_connector2", "http_connector1;http_connector2", "200;200"}};
        return Arrays.asList(data).stream().map(Arguments::of);
    }
}

