/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ChannelEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.HttpServerTestFixture;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class AsyncCompletionTest
extends HttpServerTestFixture {
    private static final int POLL = 10;
    private static final int WAIT = 10;
    private static final String SMALL = "Now is the time for all good men to come to the aid of the party. ";
    private static final String LARGE = "Now is the time for all good men to come to the aid of the party. Now is the time for all good men to come to the aid of the party. Now is the time for all good men to come to the aid of the party. Now is the time for all good men to come to the aid of the party. Now is the time for all good men to come to the aid of the party. ";
    private static final int BUFFER_SIZE = "Now is the time for all good men to come to the aid of the party. ".length() * 3 / 2;
    private static final BlockingQueue<PendingCallback> __queue = new BlockingArrayQueue();
    private static final AtomicBoolean __transportComplete = new AtomicBoolean();

    @BeforeEach
    public void init() throws Exception {
        __transportComplete.set(false);
        this.startServer(new ServerConnector(this._server, new ConnectionFactory[]{new HttpConnectionFactory(){

            public Connection newConnection(Connector connector, EndPoint endPoint) {
                this.getHttpConfiguration().setOutputBufferSize(BUFFER_SIZE);
                this.getHttpConfiguration().setOutputAggregationSize(BUFFER_SIZE);
                return this.configure((AbstractConnection)new ExtendedHttpConnection(this.getHttpConfiguration(), connector, endPoint), connector, endPoint);
            }
        }}){

            protected ChannelEndPoint newEndPoint(SocketChannel channel, ManagedSelector selectSet, SelectionKey key) throws IOException {
                return new ExtendedEndPoint(channel, selectSet, key, this.getScheduler());
            }
        });
    }

    public static Stream<Arguments> asyncIOWriteTests() {
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (WriteStyle w : WriteStyle.values()) {
            Boolean[] booleanArray = new Boolean[]{true, false};
            int n = booleanArray.length;
            for (int i = 0; i < n; ++i) {
                boolean contentLength = booleanArray[i];
                Boolean[] booleanArray2 = new Boolean[]{true, false};
                int n2 = booleanArray2.length;
                for (int j = 0; j < n2; ++j) {
                    boolean isReady = booleanArray2[j];
                    Boolean[] booleanArray3 = new Boolean[]{true, false};
                    int n3 = booleanArray3.length;
                    for (int k = 0; k < n3; ++k) {
                        boolean flush = booleanArray3[k];
                        Boolean[] booleanArray4 = new Boolean[]{true, false};
                        int n4 = booleanArray4.length;
                        for (int i2 = 0; i2 < n4; ++i2) {
                            boolean close = booleanArray4[i2];
                            for (String data : new String[]{SMALL, LARGE}) {
                                tests.add(new Object[]{new AsyncIOWriteHandler(w, contentLength, isReady, flush, close, data)});
                            }
                        }
                    }
                }
            }
        }
        return tests.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"asyncIOWriteTests"})
    public void testAsyncIOWrite(AsyncIOWriteHandler handler) throws Exception {
        this.configureServer((Handler)handler);
        int base = this._threadPool.getBusyThreads();
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            PendingCallback delay;
            long end;
            OutputStream os = client.getOutputStream();
            InputStream in = client.getInputStream();
            os.write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            boolean completeCalled = handler.waitForOWPExit();
            while (true) {
                Boolean c;
                end = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
                while (this._threadPool.getBusyThreads() != base) {
                    if (System.nanoTime() > end) {
                        throw new TimeoutException();
                    }
                    Thread.sleep(10L);
                }
                if (completeCalled) break;
                MatcherAssert.assertThat((Object)__transportComplete.get(), (Matcher)Matchers.is((Object)false));
                while (true) {
                    if ((delay = __queue.poll(10L, TimeUnit.MILLISECONDS)) != null) {
                        delay.proceed();
                        continue;
                    }
                    c = handler.pollForOWPExit();
                    if (c != null) break;
                }
                completeCalled = c;
            }
            end = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            while (!__transportComplete.get()) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException();
                }
                delay = __queue.poll(10L, TimeUnit.MILLISECONDS);
                if (delay == null) continue;
                delay.proceed();
            }
            HttpTester.Response response = HttpTester.parseResponse((InputStream)in);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String content = response.getContent();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)handler.getExpectedMessage()));
        }
    }

    public static Stream<Arguments> blockingWriteTests() {
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (WriteStyle w : WriteStyle.values()) {
            Boolean[] booleanArray = new Boolean[]{true, false};
            int n = booleanArray.length;
            for (int i = 0; i < n; ++i) {
                boolean contentLength = booleanArray[i];
                Boolean[] booleanArray2 = new Boolean[]{true, false};
                int n2 = booleanArray2.length;
                for (int j = 0; j < n2; ++j) {
                    boolean flush = booleanArray2[j];
                    Boolean[] booleanArray3 = new Boolean[]{true, false};
                    int n3 = booleanArray3.length;
                    for (int k = 0; k < n3; ++k) {
                        boolean close = booleanArray3[k];
                        for (String data : new String[]{SMALL, LARGE}) {
                            tests.add(new Object[]{new BlockingWriteHandler(w, contentLength, flush, close, data)});
                        }
                    }
                }
            }
        }
        return tests.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"blockingWriteTests"})
    public void testBlockingWrite(BlockingWriteHandler handler) throws Exception {
        this.configureServer((Handler)handler);
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream in = client.getInputStream();
            os.write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            handler.wait4handle();
            long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            while (!__transportComplete.get()) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException();
                }
                try {
                    PendingCallback delay = __queue.poll(10L, TimeUnit.MILLISECONDS);
                    if (delay == null) continue;
                    delay.proceed();
                }
                catch (Exception delay) {}
            }
            HttpTester.Response response = HttpTester.parseResponse((InputStream)in);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String content = response.getContent();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)handler.getExpectedMessage()));
        }
    }

    public static Stream<Arguments> sendContentTests() {
        ArrayList<Object[]> tests = new ArrayList<Object[]>();
        for (ContentStyle style : ContentStyle.values()) {
            for (String data : new String[]{SMALL, LARGE}) {
                tests.add(new Object[]{new SendContentHandler(style, data)});
            }
        }
        return tests.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"sendContentTests"})
    public void testSendContent(SendContentHandler handler) throws Exception {
        this.configureServer((Handler)handler);
        int base = this._threadPool.getBusyThreads();
        try (Socket client = this.newSocket(this._serverURI.getHost(), this._serverURI.getPort());){
            OutputStream os = client.getOutputStream();
            InputStream in = client.getInputStream();
            os.write("GET / HTTP/1.0\r\n\r\n".getBytes(StandardCharsets.ISO_8859_1));
            os.flush();
            handler.wait4handle();
            long end = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            while (this._threadPool.getBusyThreads() != base) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException();
                }
                Thread.sleep(10L);
            }
            end = System.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            while (!__transportComplete.get()) {
                if (System.nanoTime() > end) {
                    throw new TimeoutException();
                }
                try {
                    PendingCallback delay = __queue.poll(10L, TimeUnit.MILLISECONDS);
                    if (delay == null) continue;
                    delay.proceed();
                }
                catch (Exception delay) {}
            }
            HttpTester.Response response = HttpTester.parseResponse((InputStream)in);
            MatcherAssert.assertThat((Object)response, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String content = response.getContent();
            MatcherAssert.assertThat((Object)content, (Matcher)Matchers.containsString((String)handler.getExpectedMessage()));
        }
    }

    static enum WriteStyle {
        ARRAY,
        BUFFER,
        BYTE,
        BYTE_THEN_ARRAY,
        PRINT;

    }

    private static class AsyncIOWriteHandler
    extends AbstractHandler {
        final WriteStyle _write;
        final boolean _contentLength;
        final boolean _isReady;
        final boolean _flush;
        final boolean _close;
        final String _data;
        final Exchanger<Boolean> _ready = new Exchanger();
        int _toWrite;
        boolean _flushed;
        boolean _closed;

        AsyncIOWriteHandler(WriteStyle write, boolean contentLength, boolean isReady, boolean flush, boolean close, String data) {
            this._write = write;
            this._contentLength = contentLength;
            this._isReady = isReady;
            this._flush = flush;
            this._close = close;
            this._data = data;
            this._toWrite = data.length();
        }

        public String getExpectedMessage() {
            return AsyncCompletionTest.SMALL;
        }

        boolean waitForOWPExit() {
            try {
                return this._ready.exchange(null);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        Boolean pollForOWPExit() {
            try {
                return this._ready.exchange(null, 10L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                return null;
            }
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            final AsyncContext context = request.startAsync();
            final ServletOutputStream out = response.getOutputStream();
            response.setContentType("text/plain");
            final byte[] bytes = this._data.getBytes(StandardCharsets.ISO_8859_1);
            if (this._contentLength) {
                response.setContentLength(bytes.length);
            }
            out.setWriteListener(new WriteListener(){

                public void onWritePossible() throws IOException {
                    try {
                        if (out.isReady()) {
                            boolean ready;
                            if (_toWrite > 0) {
                                switch (_write) {
                                    case ARRAY: {
                                        _toWrite = 0;
                                        out.write(bytes, 0, bytes.length);
                                        break;
                                    }
                                    case BUFFER: {
                                        _toWrite = 0;
                                        ((HttpOutput)out).write(BufferUtil.toBuffer((byte[])bytes));
                                        break;
                                    }
                                    case BYTE: {
                                        for (int i = bytes.length - _toWrite; i < bytes.length; ++i) {
                                            --_toWrite;
                                            out.write((int)bytes[i]);
                                            boolean ready2 = out.isReady();
                                            if (ready2) continue;
                                            _ready.exchange(Boolean.FALSE);
                                            return;
                                        }
                                        break;
                                    }
                                    case BYTE_THEN_ARRAY: {
                                        _toWrite = 0;
                                        out.write((int)bytes[0]);
                                        MatcherAssert.assertThat((Object)out.isReady(), (Matcher)Matchers.is((Object)true));
                                        out.write(bytes, 1, bytes.length - 1);
                                        break;
                                    }
                                    case PRINT: {
                                        _toWrite = 0;
                                        out.print(_data);
                                    }
                                }
                            }
                            if (_flush && !_flushed) {
                                ready = out.isReady();
                                if (!ready) {
                                    _ready.exchange(Boolean.FALSE);
                                    return;
                                }
                                _flushed = true;
                                out.flush();
                            }
                            if (_close && !_closed) {
                                if (_isReady && !(ready = out.isReady())) {
                                    _ready.exchange(Boolean.FALSE);
                                    return;
                                }
                                _closed = true;
                                out.close();
                            }
                            if (_isReady && !(ready = out.isReady())) {
                                _ready.exchange(Boolean.FALSE);
                                return;
                            }
                            context.complete();
                            _ready.exchange(Boolean.TRUE);
                        }
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                }
            });
        }

        public String toString() {
            return String.format("AWCH{w=%s,cl=%b,ir=%b,f=%b,c=%b,d=%d}", new Object[]{this._write, this._contentLength, this._isReady, this._flush, this._close, this._data.length()});
        }
    }

    private static class PendingCallback
    extends Callback.Nested {
        private CompletableFuture<Void> _pending = new CompletableFuture();

        public PendingCallback(Callback callback) {
            super(callback);
        }

        public void succeeded() {
            this._pending.complete(null);
        }

        public void failed(Throwable x) {
            this._pending.completeExceptionally(x);
        }

        public void proceed() {
            try {
                this._pending.get(10L, TimeUnit.SECONDS);
                this.getCallback().succeeded();
            }
            catch (Throwable th) {
                th.printStackTrace();
                this.getCallback().failed(th);
            }
        }
    }

    private static class BlockingWriteHandler
    extends AbstractHandler {
        final WriteStyle _write;
        final boolean _contentLength;
        final boolean _flush;
        final boolean _close;
        final String _data;
        final CountDownLatch _wait = new CountDownLatch(1);

        BlockingWriteHandler(WriteStyle write, boolean contentLength, boolean flush, boolean close, String data) {
            this._write = write;
            this._contentLength = contentLength;
            this._flush = flush;
            this._close = close;
            this._data = data;
        }

        public String getExpectedMessage() {
            return AsyncCompletionTest.SMALL;
        }

        public void wait4handle() {
            try {
                Assertions.assertTrue((boolean)this._wait.await(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            AsyncContext context = request.startAsync();
            ServletOutputStream out = response.getOutputStream();
            context.start(() -> {
                try {
                    this._wait.countDown();
                    response.setContentType("text/plain");
                    byte[] bytes = this._data.getBytes(StandardCharsets.ISO_8859_1);
                    if (this._contentLength) {
                        response.setContentLength(bytes.length);
                    }
                    switch (this._write) {
                        case ARRAY: {
                            out.write(bytes, 0, bytes.length);
                            break;
                        }
                        case BUFFER: {
                            ((HttpOutput)out).write(BufferUtil.toBuffer((byte[])bytes));
                            break;
                        }
                        case BYTE: {
                            for (byte b : bytes) {
                                out.write((int)b);
                            }
                            break;
                        }
                        case BYTE_THEN_ARRAY: {
                            out.write((int)bytes[0]);
                            out.write(bytes, 1, bytes.length - 1);
                            break;
                        }
                        case PRINT: {
                            out.print(this._data);
                        }
                    }
                    if (this._flush) {
                        out.flush();
                    }
                    if (this._close) {
                        out.close();
                    }
                    context.complete();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }

        public String toString() {
            return String.format("BWCH{w=%s,cl=%b,f=%b,c=%b,d=%d}", new Object[]{this._write, this._contentLength, this._flush, this._close, this._data.length()});
        }
    }

    static enum ContentStyle {
        BUFFER,
        STREAM;

    }

    private static class SendContentHandler
    extends AbstractHandler {
        final ContentStyle _style;
        final String _data;
        final CountDownLatch _wait = new CountDownLatch(1);

        SendContentHandler(ContentStyle style, String data) {
            this._style = style;
            this._data = data;
        }

        public String getExpectedMessage() {
            return AsyncCompletionTest.SMALL;
        }

        public void wait4handle() {
            try {
                Assertions.assertTrue((boolean)this._wait.await(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            AsyncContext context = request.startAsync();
            HttpOutput out = (HttpOutput)response.getOutputStream();
            response.setContentType("text/plain");
            byte[] bytes = this._data.getBytes(StandardCharsets.ISO_8859_1);
            switch (this._style) {
                case BUFFER: {
                    out.sendContent(BufferUtil.toBuffer((byte[])bytes), Callback.from(() -> ((AsyncContext)context).complete()));
                    break;
                }
                case STREAM: {
                    out.sendContent((InputStream)new ByteArrayInputStream(bytes), Callback.from(() -> ((AsyncContext)context).complete()));
                }
            }
            this._wait.countDown();
        }

        public String toString() {
            return String.format("SCCH{w=%s,d=%d}", new Object[]{this._style, this._data.length()});
        }
    }

    private static class ExtendedHttpConnection
    extends HttpConnection {
        public ExtendedHttpConnection(HttpConfiguration config, Connector connector, EndPoint endPoint) {
            super(config, connector, endPoint, HttpCompliance.RFC7230_LEGACY, false);
        }

        public void onCompleted() {
            __transportComplete.compareAndSet(false, true);
            super.onCompleted();
        }
    }

    private static class ExtendedEndPoint
    extends SocketChannelEndPoint {
        public ExtendedEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey key, Scheduler scheduler) {
            super(channel, selector, key, scheduler);
        }

        public void write(Callback callback, ByteBuffer ... buffers) throws IllegalStateException {
            PendingCallback delay = new PendingCallback(callback);
            super.write((Callback)delay, buffers);
            __queue.offer(delay);
        }
    }
}

