/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;

public class ConnectionOpenCloseTest
extends AbstractHttpTest {
    @Test
    @Tag(value="Slow")
    @DisabledIfSystemProperty(named="env", matches="ci")
    public void testOpenClose() throws Exception {
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                throw new IllegalStateException();
            }
        });
        server.start();
        final AtomicInteger callbacks = new AtomicInteger();
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        connector.addBean((Object)new Connection.Listener.Adapter(){

            public void onOpened(Connection connection) {
                callbacks.incrementAndGet();
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                callbacks.incrementAndGet();
                closeLatch.countDown();
            }
        });
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout((int)connector.getIdleTimeout());
            Assertions.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
            socket.shutdownOutput();
            Assertions.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
            String response = IO.toString((InputStream)socket.getInputStream());
            Assertions.assertEquals((int)0, (int)response.length());
            TimeUnit.MILLISECONDS.sleep(200L);
            Assertions.assertEquals((int)2, (int)callbacks.get());
        }
    }

    @Test
    @Tag(value="Slow")
    @DisabledIfSystemProperty(named="env", matches="ci")
    public void testOpenRequestClose() throws Exception {
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
            }
        });
        server.start();
        final AtomicInteger callbacks = new AtomicInteger();
        final CountDownLatch openLatch = new CountDownLatch(1);
        final CountDownLatch closeLatch = new CountDownLatch(1);
        connector.addBean((Object)new Connection.Listener.Adapter(){

            public void onOpened(Connection connection) {
                callbacks.incrementAndGet();
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                callbacks.incrementAndGet();
                closeLatch.countDown();
            }
        });
        try (Socket socket = new Socket("localhost", connector.getLocalPort());){
            socket.setSoTimeout((int)connector.getIdleTimeout());
            OutputStream output = socket.getOutputStream();
            output.write(("GET / HTTP/1.1\r\nHost: localhost:" + connector.getLocalPort() + "\r\nConnection: close\r\n\r\n").getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream inputStream = socket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)inputStream);
            MatcherAssert.assertThat((String)"Status Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            Assertions.assertEquals((int)-1, (int)inputStream.read());
            socket.close();
            Assertions.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
            Assertions.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
            TimeUnit.SECONDS.sleep(1L);
            Assertions.assertEquals((int)2, (int)callbacks.get());
        }
    }

    @Test
    @Tag(value="Slow")
    @DisabledIfSystemProperty(named="env", matches="ci")
    public void testSSLOpenRequestClose() throws Exception {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        File keystore = MavenTestingUtils.getTestResourceFile((String)"keystore");
        sslContextFactory.setKeyStoreResource(Resource.newResource((File)keystore));
        sslContextFactory.setKeyStorePassword("storepwd");
        sslContextFactory.setKeyManagerPassword("keypwd");
        server.addBean((Object)sslContextFactory);
        server.removeConnector((Connector)connector);
        connector = new ServerConnector(server, (SslContextFactory)sslContextFactory);
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
            }
        });
        server.start();
        final AtomicInteger callbacks = new AtomicInteger();
        final CountDownLatch openLatch = new CountDownLatch(2);
        final CountDownLatch closeLatch = new CountDownLatch(2);
        connector.addBean((Object)new Connection.Listener.Adapter(){

            public void onOpened(Connection connection) {
                callbacks.incrementAndGet();
                openLatch.countDown();
            }

            public void onClosed(Connection connection) {
                callbacks.incrementAndGet();
                closeLatch.countDown();
            }
        });
        Socket socket = sslContextFactory.getSslContext().getSocketFactory().createSocket("localhost", connector.getLocalPort());
        socket.setSoTimeout((int)connector.getIdleTimeout());
        OutputStream output = socket.getOutputStream();
        output.write(("GET / HTTP/1.1\r\nHost: localhost:" + connector.getLocalPort() + "\r\nConnection: close\r\n\r\n").getBytes(StandardCharsets.UTF_8));
        output.flush();
        String response = BufferUtil.toString((ByteBuffer)ByteBuffer.wrap(IO.readBytes((InputStream)socket.getInputStream())));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        socket.close();
        Assertions.assertTrue((boolean)openLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)closeLatch.await(5L, TimeUnit.SECONDS));
        TimeUnit.SECONDS.sleep(1L);
        Assertions.assertEquals((int)4, (int)callbacks.get());
    }
}

