/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HostHeaderCustomizer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class HostHeaderCustomizerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHostHeaderCustomizer() throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        String serverName = "test_server_name";
        int serverPort = 13;
        String redirectPath = "/redirect";
        httpConfig.addCustomizer((HttpConfiguration.Customizer)new HostHeaderCustomizer("test_server_name", 13));
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfig)});
        server.addConnector((Connector)connector);
        server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                Assertions.assertEquals((Object)"test_server_name", (Object)request.getServerName());
                Assertions.assertEquals((int)13, (int)request.getServerPort());
                response.sendRedirect("/redirect");
            }
        });
        server.start();
        try (Socket socket = new Socket("localhost", connector.getLocalPort());
             OutputStream output = socket.getOutputStream();){
            String request = "GET / HTTP/1.0\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            HttpTester.Input input = HttpTester.from((InputStream)socket.getInputStream());
            HttpTester.Response response = HttpTester.parseResponse((HttpTester.Input)input);
            String location = response.get("location");
            Assertions.assertNotNull((Object)location);
            String schemePrefix = "http://";
            Assertions.assertTrue((boolean)location.startsWith(schemePrefix));
            Assertions.assertTrue((boolean)location.endsWith("/redirect"));
            String hostPort = location.substring(schemePrefix.length(), location.length() - "/redirect".length());
            Assertions.assertEquals((Object)"test_server_name:13", (Object)hostPort);
        }
        finally {
            server.stop();
        }
    }
}

