/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Objects;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class HttpConfigurationAuthorityOverrideTest {
    @Test
    public void testLocalAuthorityHttp10NoHostDump() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("foo.local.name", 80);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /dump HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[foo.local.name]"), (Matcher)Matchers.containsString((String)"ServerPort=[80]"), (Matcher)Matchers.containsString((String)"LocalAddr=[foo.local.name]"), (Matcher)Matchers.containsString((String)"LocalName=[foo.local.name]"), (Matcher)Matchers.containsString((String)"LocalPort=[80]"), (Matcher)Matchers.containsString((String)"RequestURL=[http://foo.local.name/dump]")));
        }
    }

    @Test
    public void testLocalAuthorityHttp10NoHostRedirect() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("foo.local.name", 80);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /redirect HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.local.name/dump"));
        }
    }

    @Test
    public void testLocalAuthorityHttp10NotFound() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("foo.local.name", 777);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /bogus HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.local.name:777/error"));
        }
    }

    @Test
    public void testLocalAuthorityHttp11EmptyHostDump() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("foo.local.name", 80);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[foo.local.name]"), (Matcher)Matchers.containsString((String)"ServerPort=[80]"), (Matcher)Matchers.containsString((String)"LocalAddr=[foo.local.name]"), (Matcher)Matchers.containsString((String)"LocalName=[foo.local.name]"), (Matcher)Matchers.containsString((String)"LocalPort=[80]"), (Matcher)Matchers.containsString((String)"RequestURL=[http://foo.local.name/dump]")));
        }
    }

    @Test
    public void testLocalAuthorityHttp11EmptyHostRedirect() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("foo.local.name", 80);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: \r\nConnect: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.local.name/dump"));
        }
    }

    @Test
    public void testLocalAuthorityHttp11EmptyHostAbsUriDump() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("bar.local.name", 9999);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET mobile:///dump HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[bar.local.name]"), (Matcher)Matchers.containsString((String)"ServerPort=[9999]"), (Matcher)Matchers.containsString((String)"LocalAddr=[bar.local.name]"), (Matcher)Matchers.containsString((String)"LocalName=[bar.local.name]"), (Matcher)Matchers.containsString((String)"LocalPort=[9999]"), (Matcher)Matchers.containsString((String)"RequestURL=[mobile://bar.local.name:9999/dump]")));
        }
    }

    @Test
    public void testLocalAuthorityHttp11ValidHostDump() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("zed.local.name", 9999);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: jetty.eclipse.org:8888\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[jetty.eclipse.org]"), (Matcher)Matchers.containsString((String)"ServerPort=[8888]"), (Matcher)Matchers.containsString((String)"LocalAddr=[zed.local.name]"), (Matcher)Matchers.containsString((String)"LocalName=[zed.local.name]"), (Matcher)Matchers.containsString((String)"LocalPort=[9999]"), (Matcher)Matchers.containsString((String)"RequestURL=[http://jetty.eclipse.org:8888/dump]")));
        }
    }

    @Test
    public void testLocalAuthorityHttp11ValidHostRedirect() throws Exception {
        InetSocketAddress localAddress = InetSocketAddress.createUnresolved("zed.local.name", 9999);
        try (CloseableServer server = this.startServer(null, localAddress);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: jetty.eclipse.org:8888\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://jetty.eclipse.org:8888/dump"));
        }
    }

    @Test
    public void testServerAuthorityNoPortHttp11EmptyHostDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("foo.server.authority");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[foo.server.authority]"), (Matcher)Matchers.containsString((String)"ServerPort=[80]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[http://foo.server.authority/dump]")));
        }
    }

    @Test
    public void testServerAuthorityNoPortHttp11EmptyHostRedirect() throws Exception {
        HostPort serverUriAuthority = new HostPort("foo.server.authority");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: \r\nConnect: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.server.authority/dump"));
        }
    }

    @Test
    public void testServerAuthorityWithPortHttp11EmptyHostDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("foo.server.authority:7777");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[foo.server.authority]"), (Matcher)Matchers.containsString((String)"ServerPort=[7777]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[http://foo.server.authority:7777/dump]")));
        }
    }

    @Test
    public void testServerAuthorityWithPortHttp11EmptyHostRedirect() throws Exception {
        HostPort serverUriAuthority = new HostPort("foo.server.authority:7777");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: \r\nConnect: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.server.authority:7777/dump"));
        }
    }

    @Test
    public void testServerUriAuthorityNoPortHttp10NoHostDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("foo.server.authority");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /dump HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[foo.server.authority]"), (Matcher)Matchers.containsString((String)"ServerPort=[80]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[http://foo.server.authority/dump]")));
        }
    }

    @Test
    public void testServerUriAuthorityNoPortHttp10NoHostRedirect() throws Exception {
        HostPort serverUriAuthority = new HostPort("foo.server.authority");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /redirect HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.server.authority/dump"));
        }
    }

    @Test
    public void testServerUriAuthorityNoPortHttp10NotFound() throws Exception {
        HostPort severUriAuthority = new HostPort("foo.server.authority");
        try (CloseableServer server = this.startServer(severUriAuthority, null);){
            String rawRequest = "GET /bogus HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.server.authority/error"));
        }
    }

    @Test
    public void testServerUriAuthorityNoPortHttp10PathError() throws Exception {
        HostPort severUriAuthority = new HostPort("foo.server.authority");
        try (CloseableServer server = this.startServer(severUriAuthority, null);){
            String rawRequest = "GET /%00 HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
        }
    }

    @Test
    public void testServerUriAuthorityNoPortHttp11ValidHostDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("zed.server.authority");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: jetty.eclipse.org:8888\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[jetty.eclipse.org]"), (Matcher)Matchers.containsString((String)"ServerPort=[8888]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[http://jetty.eclipse.org:8888/dump]")));
        }
    }

    @Test
    public void testServerUriAuthorityNoPortHttp11ValidHostRedirect() throws Exception {
        HostPort serverUriAuthority = new HostPort("zed.local.name");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: jetty.eclipse.org:8888\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://jetty.eclipse.org:8888/dump"));
        }
    }

    @Test
    public void testServerUriAuthorityWithPortHttp10NoHostDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("bar.server.authority:9999");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /dump HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[bar.server.authority]"), (Matcher)Matchers.containsString((String)"ServerPort=[9999]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[http://bar.server.authority:9999/dump]")));
        }
    }

    @Test
    public void testServerUriAuthorityWithPortHttp10NoHostRedirect() throws Exception {
        HostPort severUriAuthority = new HostPort("foo.server.authority:9999");
        try (CloseableServer server = this.startServer(severUriAuthority, null);){
            String rawRequest = "GET /redirect HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.server.authority:9999/dump"));
        }
    }

    @Test
    public void testServerUriAuthorityWithPortHttp10NotFound() throws Exception {
        HostPort severUriAuthority = new HostPort("foo.server.authority:7777");
        try (CloseableServer server = this.startServer(severUriAuthority, null);){
            String rawRequest = "GET /bogus HTTP/1.0\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://foo.server.authority:7777/error"));
        }
    }

    @Test
    public void testServerUriAuthorityWithPortHttp11ValidHostDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("zed.server.authority:7777");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: jetty.eclipse.org:8888\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[jetty.eclipse.org]"), (Matcher)Matchers.containsString((String)"ServerPort=[8888]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[http://jetty.eclipse.org:8888/dump]")));
        }
    }

    @Test
    public void testServerUriAuthorityWithPortHttp11EmptyHostAbsUriDump() throws Exception {
        HostPort serverUriAuthority = new HostPort("zed.server.authority:7777");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET mobile:///dump HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"ServerName=[zed.server.authority]"), (Matcher)Matchers.containsString((String)"ServerPort=[7777]"), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)"RequestURL=[mobile://zed.server.authority:7777/dump]")));
        }
    }

    @Test
    public void testServerUriAuthorityWithPortHttp11ValidHostRedirect() throws Exception {
        HostPort serverUriAuthority = new HostPort("zed.local.name:7777");
        try (CloseableServer server = this.startServer(serverUriAuthority, null);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: jetty.eclipse.org:8888\r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)"http://jetty.eclipse.org:8888/dump"));
        }
    }

    @Test
    public void testUnsetAuthoritiesHttp11EmptyHostDump() throws Exception {
        try (CloseableServer server = this.startServer(null, null);){
            String rawRequest = "GET /dump HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((String)"response.status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            String responseContent = response.getContent();
            MatcherAssert.assertThat((String)"response content", (Object)responseContent, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)("ServerName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("ServerPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)("LocalAddr=[" + server.getConnectorLocalAddr() + "]")), (Matcher)Matchers.containsString((String)("LocalName=[" + server.getConnectorLocalName() + "]")), (Matcher)Matchers.containsString((String)("LocalPort=[" + server.getConnectorLocalPort() + "]")), (Matcher)Matchers.containsString((String)("RequestURL=[http://" + server.getConnectorLocalName() + ":" + server.getConnectorLocalPort() + "/dump]"))));
        }
    }

    @Test
    public void testUnsetAuthoritiesHttp11EmptyHostRedirect() throws Exception {
        try (CloseableServer server = this.startServer(null, null);){
            String rawRequest = "GET /redirect HTTP/1.1\r\nHost: \r\nConnection: close\r\n\r\n";
            HttpTester.Response response = this.issueRequest(server, rawRequest);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)302));
            String location = response.get(HttpHeader.LOCATION);
            MatcherAssert.assertThat((Object)location, (Matcher)Matchers.is((Object)("http://" + server.getConnectorLocalName() + ":" + server.getConnectorLocalPort() + "/dump")));
        }
    }

    /*
     * Exception decompiling
     */
    private HttpTester.Response issueRequest(CloseableServer server, String rawRequest) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private CloseableServer startServer(HostPort serverUriAuthority, InetSocketAddress localAddress) throws Exception {
        Server server = new Server();
        HttpConfiguration httpConfiguration = new HttpConfiguration();
        if (serverUriAuthority != null) {
            httpConfiguration.setServerAuthority(serverUriAuthority);
        }
        if (localAddress != null) {
            httpConfiguration.setLocalAddress((SocketAddress)localAddress);
        }
        ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(httpConfiguration)});
        connector.setPort(0);
        server.addConnector((Connector)connector);
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new RedirectHandler());
        handlers.addHandler((Handler)new DumpHandler());
        handlers.addHandler((Handler)new ErrorMsgHandler());
        server.setHandler((Handler)handlers);
        server.setErrorHandler((ErrorHandler)new RedirectErrorHandler());
        server.start();
        return new CloseableServer(server, connector);
    }

    private static class CloseableServer
    implements AutoCloseable {
        private final Server server;
        private final ServerConnector connector;

        public CloseableServer(Server server, ServerConnector connector) {
            this.server = Objects.requireNonNull(server, "Server");
            this.connector = Objects.requireNonNull(connector, "Connector");
        }

        @Override
        public void close() throws Exception {
            LifeCycle.stop((Object)this.server);
        }

        public String getConnectorLocalAddr() {
            return "127.0.0.1";
        }

        public String getConnectorLocalName() {
            return HostPort.normalizeHost((String)this.getConnectorLocalAddr());
        }

        public int getConnectorLocalPort() {
            return this.connector.getLocalPort();
        }
    }

    private static class RedirectHandler
    extends AbstractHandler {
        private RedirectHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (target.startsWith("/redirect")) {
                baseRequest.setHandled(true);
                response.sendRedirect("/dump");
            }
        }
    }

    private static class DumpHandler
    extends AbstractHandler {
        private DumpHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (target.startsWith("/dump")) {
                baseRequest.setHandled(true);
                response.setCharacterEncoding("utf-8");
                response.setContentType("text/plain");
                PrintWriter out = response.getWriter();
                out.printf("ServerName=[%s]%n", request.getServerName());
                out.printf("ServerPort=[%d]%n", request.getServerPort());
                out.printf("LocalName=[%s]%n", request.getLocalName());
                out.printf("LocalAddr=[%s]%n", request.getLocalAddr());
                out.printf("LocalPort=[%s]%n", request.getLocalPort());
                out.printf("RequestURL=[%s]%n", request.getRequestURL());
            }
        }
    }

    private static class ErrorMsgHandler
    extends AbstractHandler {
        private ErrorMsgHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            if (target.startsWith("/error")) {
                baseRequest.setHandled(true);
                response.setCharacterEncoding("utf-8");
                response.setContentType("text/plain");
                response.getWriter().println("Generic Error Page.");
            }
        }
    }

    public static class RedirectErrorHandler
    extends ErrorHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.sendRedirect("/error");
        }
    }
}

