/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.util.stream.Stream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpFieldsMatchers;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.AbstractHttpTest;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HttpManyWaysToCommitTest
extends AbstractHttpTest {
    public static Stream<Arguments> httpVersions() {
        return Stream.of(HttpVersion.HTTP_1_0, HttpVersion.HTTP_1_1).map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerDoesNotSetHandled(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new DoesNotSetHandledHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerDoesNotSetHandledAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new DoesNotSetHandledHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerSetsHandledTrueOnly(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new OnlySetHandledHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        if (HttpVersion.HTTP_1_1.asString().equals(httpVersion)) {
            MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"0"));
        }
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerSetsHandledTrueOnlyAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new OnlySetHandledHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerSetsHandledAndWritesSomeContent(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetHandledWriteSomeDataHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"6"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerSetsHandledAndWritesSomeContentAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetHandledWriteSomeDataHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"foobar")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerExplicitFlush(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new ExplicitFlushHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandlerExplicitFlushAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new ExplicitFlushHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledAndFlushWithoutContent(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetHandledAndFlushWithoutContentHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledAndFlushWithoutContentAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetHandledAndFlushWithoutContentHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledWriteFlushWriteMore(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new WriteFlushWriteMoreHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledWriteFlushWriteMoreAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new WriteFlushWriteMoreHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledOverflow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new OverflowHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledOverflow2(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new Overflow2Handler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobarfoobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledOverflow3(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new Overflow3Handler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobarfoobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testHandledBufferOverflowAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new OverflowHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"foobar"));
        Assumptions.assumingThat((httpVersion == HttpVersion.HTTP_1_1 ? 1 : 0) != 0, () -> MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"transfer-encoding", (String)"chunked")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAnd304Status(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLength304Handler());
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"32768"));
        byte[] content = response.getContentBytes();
        MatcherAssert.assertThat((Object)content.length, (Matcher)Matchers.is((Object)0));
        Assertions.assertFalse((boolean)response.isEarlyEOF());
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthFlushAndWriteInsufficientBytes(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteInsufficientBytesHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"6"));
        byte[] content = response.getContentBytes();
        MatcherAssert.assertThat((String)"content bytes", (Object)content.length, (Matcher)Matchers.is((Object)0));
        Assertions.assertTrue((boolean)response.isEarlyEOF(), (String)"response eof");
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAndWriteInsufficientBytes(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteInsufficientBytesHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response is error", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        Assertions.assertFalse((boolean)response.isEarlyEOF(), (String)"response not eof");
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAndFlushWriteInsufficientBytes(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteInsufficientBytesHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response has no status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        Assertions.assertTrue((boolean)response.isEarlyEOF(), (String)"response eof");
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytes(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteThatAmountOfBytesHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"3"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAndWriteExactlyThatAmountOfBytesAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteThatAmountOfBytesHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAndWriteMoreBytes(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteMoreBytesHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"3"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testSetContentLengthAndWriteMoreAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new SetContentLengthAndWriteMoreBytesHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testWriteAndSetContentLength(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
        MatcherAssert.assertThat((Object)response, (Matcher)HttpFieldsMatchers.containsHeaderValue((String)"content-length", (String)"3"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testWriteAndSetContentLengthAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.is((Object)"foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testWriteAndSetContentLengthTooSmall(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthTooSmallHandler(false));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"foo")));
    }

    @ParameterizedTest
    @MethodSource(value={"httpVersions"})
    public void testWriteAndSetContentLengthTooSmallAndThrow(HttpVersion httpVersion) throws Exception {
        server.setHandler((Handler)new WriteAndSetContentLengthTooSmallHandler(true));
        server.start();
        HttpTester.Response response = this.executeRequest(httpVersion);
        MatcherAssert.assertThat((String)"response code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)500));
        MatcherAssert.assertThat((String)"response body", (Object)response.getContent(), (Matcher)Matchers.not((Matcher)Matchers.is((Object)"foo")));
    }

    private class DoesNotSetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private DoesNotSetHandledHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(false);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OnlySetHandledHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private OnlySetHandledHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledWriteSomeDataHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledWriteSomeDataHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class ExplicitFlushHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private ExplicitFlushHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foobar");
            response.flushBuffer();
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetHandledAndFlushWithoutContentHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetHandledAndFlushWithoutContentHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.flushBuffer();
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteFlushWriteMoreHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteFlushWriteMoreHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foo");
            response.flushBuffer();
            response.getWriter().write("bar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class OverflowHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private OverflowHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setBufferSize(4);
            response.getWriter().write("foobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class Overflow2Handler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private Overflow2Handler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setBufferSize(8);
            response.getWriter().write("fo");
            response.getWriter().write("obarfoobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class Overflow3Handler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private Overflow3Handler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setBufferSize(8);
            response.getWriter().write("fo");
            response.getWriter().write("ob");
            response.getWriter().write("ar");
            response.getWriter().write("fo");
            response.getWriter().write("ob");
            response.getWriter().write("ar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLength304Handler
    extends AbstractHandler {
        private SetContentLength304Handler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentLength(32768);
            response.setStatus(304);
        }
    }

    private class SetContentLengthAndWriteInsufficientBytesHandler
    extends AbstractHandler {
        boolean flush;

        private SetContentLengthAndWriteInsufficientBytesHandler(boolean flush) {
            this.flush = flush;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentLength(6);
            if (this.flush) {
                response.flushBuffer();
            }
            response.getWriter().write("foo");
        }
    }

    private class SetContentLengthAndWriteThatAmountOfBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetContentLengthAndWriteThatAmountOfBytesHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentLength(3);
            response.getWriter().write("foo");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class SetContentLengthAndWriteMoreBytesHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private SetContentLengthAndWriteMoreBytesHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentLength(3);
            response.getWriter().write("foobar");
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteAndSetContentLengthHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteAndSetContentLengthHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foo");
            response.setContentLength(3);
            super.handle(target, baseRequest, request, response);
        }
    }

    private class WriteAndSetContentLengthTooSmallHandler
    extends AbstractHttpTest.ThrowExceptionOnDemandHandler {
        private WriteAndSetContentLengthTooSmallHandler(boolean throwException) {
            super(throwException);
        }

        @Override
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.getWriter().write("foobar");
            response.setContentLength(3);
            super.handle(target, baseRequest, request, response);
        }
    }
}

