/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.HotSwapHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.FuturePromise;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class HttpOutputTest {
    public static final int OUTPUT_AGGREGATION_SIZE = 1024;
    public static final int OUTPUT_BUFFER_SIZE = 4096;
    private Server _server;
    private LocalConnector _connector;
    private ContentHandler _handler;
    private HotSwapHandler _swap;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        this._server.addBean((Object)new ByteBufferPool(){

            public ByteBuffer acquire(int size, boolean direct) {
                return direct ? BufferUtil.allocateDirect((int)size) : BufferUtil.allocate((int)size);
            }

            public void release(ByteBuffer buffer) {
            }
        });
        HttpConnectionFactory http = new HttpConnectionFactory();
        http.getHttpConfiguration().setRequestHeaderSize(1024);
        http.getHttpConfiguration().setResponseHeaderSize(1024);
        http.getHttpConfiguration().setOutputBufferSize(4096);
        http.getHttpConfiguration().setOutputAggregationSize(1024);
        this._connector = new LocalConnector(this._server, (ConnectionFactory)http, null);
        this._server.addConnector((Connector)this._connector);
        this._swap = new HotSwapHandler();
        this._handler = new ContentHandler();
        this._swap.setHandler((Handler)this._handler);
        this._server.setHandler((Handler)this._swap);
        this._server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testSimple() throws Exception {
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    @Test
    public void testByteUnknown() throws Exception {
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    @Test
    public void testSendArray() throws Exception {
        int i;
        byte[] buffer = new byte[16384];
        Arrays.fill(buffer, 0, 4096, (byte)-103);
        Arrays.fill(buffer, 4096, 12288, (byte)88);
        Arrays.fill(buffer, 12288, 16384, (byte)102);
        this._handler._content = ByteBuffer.wrap(buffer);
        this._handler._content.limit(12288);
        this._handler._content.position(4096);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\nXXXXXXXXXXXXXXXXXXXXXXXXXXX"));
        for (i = 0; i < 4096; ++i) {
            Assertions.assertEquals((byte)-103, (byte)buffer[i], (String)("i=" + i));
        }
        for (i = 12288; i < 16384; ++i) {
            Assertions.assertEquals((byte)102, (byte)buffer[i], (String)("i=" + i));
        }
    }

    @Test
    public void testSendInputStreamSimple() throws Exception {
        Resource simple = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._contentInputStream = simple.getInputStream();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
    }

    @Test
    public void testSendInputStreamBig() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentInputStream = big.getInputStream();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testSendInputStreamBigChunked() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentInputStream = new FilterInputStream(big.getInputStream()){

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int filled = super.read(b, off, len > 2000 ? 2000 : len);
                return filled;
            }
        };
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET / HTTP/1.1\nHost: localhost:80\n\nGET / HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"1\tThis is a big file"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
    }

    @Test
    public void testSendChannelSimple() throws Exception {
        Resource simple = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._contentChannel = simple.getReadableByteChannel();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
    }

    @Test
    public void testSendChannelBig() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._contentChannel = big.getReadableByteChannel();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testSendBigDirect() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)true);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testSendBigInDirect() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testSendChannelBigChunked() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        final ReadableByteChannel channel = big.getReadableByteChannel();
        this._handler._contentChannel = new ReadableByteChannel(){

            @Override
            public boolean isOpen() {
                return channel.isOpen();
            }

            @Override
            public void close() throws IOException {
                channel.close();
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int filled = 0;
                if (dst.position() == 0 && dst.limit() > 2000) {
                    int limit = dst.limit();
                    dst.limit(2000);
                    filled = channel.read(dst);
                    dst.limit(limit);
                } else {
                    filled = channel.read(dst);
                }
                return filled;
            }
        };
        LocalConnector.LocalEndPoint endp = this._connector.executeRequest("GET / HTTP/1.1\nHost: localhost:80\n\nGET / HTTP/1.1\nHost: localhost:80\nConnection: close\n\n");
        String response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Transfer-Encoding: chunked"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"1\tThis is a big file"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tThis is a big file"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"\r\n0\r\n"));
        response = endp.getResponse();
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Connection: close"));
    }

    @Test
    public void testWriteByte() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testWriteSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testWriteMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testWriteLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8192];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
    }

    @Test
    public void testWriteByteKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteSmallKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteMedKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteLargeKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8192];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteHugeKnown() throws Exception {
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.allocate((int)0x400000);
        this._handler._content.limit(this._handler._content.capacity());
        int i = this._handler._content.capacity();
        while (i-- > 0) {
            this._handler._content.put(i, (byte)120);
        }
        this._handler._arrayBuffer = new byte[8192];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteBufferSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testWriteBufferMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)4000);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testWriteBufferLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testWriteBufferSmallKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteBufferMedKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)4000);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testWriteBufferLargeKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAsyncWriteByte() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1];
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8];
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[8192];
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteHuge() throws Exception {
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.allocate((int)0x400000);
        this._handler._content.limit(this._handler._content.capacity());
        int i = this._handler._content.capacity();
        while (i-- > 0) {
            this._handler._content.put(i, (byte)120);
        }
        this._handler._arrayBuffer = new byte[8192];
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteBufferSmall() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8);
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteBufferMed() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)4000);
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteBufferLarge() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteBufferLargeDirect() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)true);
        this._handler._byteBuffer = BufferUtil.allocateDirect((int)8192);
        this._handler._async = true;
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.endsWith((String)HttpOutputTest.toUTF8String(big)));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testAsyncWriteBufferLargeHEAD() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._byteBuffer = BufferUtil.allocate((int)8192);
        this._handler._async = true;
        int start = this._handler._owp.get();
        String response = this._connector.getResponse("HEAD / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)(this._handler._owp.get() - start), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0)));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"1\tThis is a big file")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"400\tThis is a big file")));
    }

    @Test
    public void testAsyncWriteSimpleKnown() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._async = true;
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"simple text"));
        MatcherAssert.assertThat((Object)((Boolean)this._handler._closedAfterWrite.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAsyncWriteSimpleKnownHEAD() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/simple.txt");
        this._handler._async = true;
        this._handler._writeLengthIfKnown = true;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[4000];
        int start = this._handler._owp.get();
        String response = this._connector.getResponse("HEAD / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)(this._handler._owp.get() - start), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 11"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"simple text")));
    }

    @Test
    public void testWriteInterception() throws Exception {
        Resource big = Resource.newClassPathResource((String)"simple/big.txt");
        this._handler._writeLengthIfKnown = false;
        this._handler._content = BufferUtil.toBuffer((Resource)big, (boolean)false);
        this._handler._arrayBuffer = new byte[1024];
        this._handler._interceptor = new ChainedInterceptor(){
            HttpOutput.Interceptor _next;

            public void write(ByteBuffer content, boolean complete, Callback callback) {
                String s = BufferUtil.toString((ByteBuffer)content).toUpperCase().replaceAll("BIG", "BIGGER");
                this._next.write(BufferUtil.toBuffer((String)s), complete, callback);
            }

            public boolean isOptimizedForDirectBuffers() {
                return this._next.isOptimizedForDirectBuffers();
            }

            public HttpOutput.Interceptor getNextInterceptor() {
                return this._next;
            }

            @Override
            public void setNext(HttpOutput.Interceptor interceptor) {
                this._next = interceptor;
            }
        };
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"Content-Length")));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"400\tTHIS IS A BIGGER FILE"));
    }

    @Test
    public void testEmptyArray() throws Exception {
        final FuturePromise committed = new FuturePromise();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                try {
                    response.getOutputStream().write(new byte[0]);
                    committed.succeeded((Object)response.isCommitted());
                }
                catch (Throwable t) {
                    committed.failed(t);
                }
            }
        };
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)((Boolean)committed.get()), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEmptyArrayKnown() throws Exception {
        final FuturePromise committed = new FuturePromise();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setContentLength(0);
                try {
                    response.getOutputStream().write(new byte[0]);
                    committed.succeeded((Object)response.isCommitted());
                }
                catch (Throwable t) {
                    committed.failed(t);
                }
            }
        };
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 0"));
        MatcherAssert.assertThat((Object)((Boolean)committed.get()), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testEmptyBuffer() throws Exception {
        final FuturePromise committed = new FuturePromise();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                ((HttpOutput)response.getOutputStream()).write(ByteBuffer.wrap(new byte[0]));
                committed.succeeded((Object)response.isCommitted());
            }
        };
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)((Boolean)committed.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEmptyBufferWithZeroContentLength() throws Exception {
        final FuturePromise committed = new FuturePromise();
        AbstractHandler handler = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setContentLength(0);
                ((HttpOutput)response.getOutputStream()).write(ByteBuffer.wrap(new byte[0]));
                committed.succeeded((Object)response.isCommitted());
            }
        };
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Content-Length: 0"));
        MatcherAssert.assertThat((Object)((Boolean)committed.get(10L, TimeUnit.SECONDS)), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testAggregation() throws Exception {
        AggregateHandler handler = new AggregateHandler();
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)handler.expected.toString()));
    }

    @Test
    public void testAsyncAggregation() throws Exception {
        AsyncAggregateHandler handler = new AsyncAggregateHandler();
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)handler.expected.toString()));
    }

    @Test
    public void testAggregateResidue() throws Exception {
        AggregateResidueHandler handler = new AggregateResidueHandler();
        this._swap.setHandler((Handler)handler);
        handler.start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)handler.expected.toString()));
    }

    @Test
    public void testPrint() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        final PrintWriter exp = new PrintWriter(bout);
        this._swap.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setCharacterEncoding("UTF8");
                HttpOutput out = (HttpOutput)response.getOutputStream();
                exp.print("\u20ac\u0939\ud55c");
                out.print("\u20ac\u0939\ud55c");
                exp.print("zero");
                out.print("zero");
                exp.print(1);
                out.print(1);
                exp.print(2L);
                out.print(2L);
                exp.print(3.0f);
                out.print(3.0f);
                exp.print('4');
                out.print('4');
                exp.print(5.0);
                out.print(5.0);
                exp.print(true);
                out.print(true);
                exp.println("zero");
                out.println("zero");
                exp.println(-1);
                out.println(-1);
                exp.println(-2L);
                out.println(-2L);
                exp.println(-3.0f);
                out.println(-3.0f);
                exp.println('4');
                out.println('4');
                exp.println(-5.0);
                out.println(-5.0);
                exp.println(false);
                out.println(false);
            }
        });
        this._swap.getHandler().start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)bout.toString()));
    }

    @Test
    public void testReset() throws Exception {
        final ByteArrayOutputStream exp = new ByteArrayOutputStream();
        this._swap.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                HttpOutput out = (HttpOutput)response.getOutputStream();
                final HttpOutput.Interceptor interceptor = out.getInterceptor();
                out.setInterceptor(new HttpOutput.Interceptor(){

                    public void write(ByteBuffer content, boolean last, Callback callback) {
                        interceptor.write(content, last, callback);
                    }

                    public HttpOutput.Interceptor getNextInterceptor() {
                        return interceptor;
                    }

                    public boolean isOptimizedForDirectBuffers() {
                        return interceptor.isOptimizedForDirectBuffers();
                    }
                });
                out.setBufferSize(128);
                out.println("NOT TO BE SEEN!");
                out.resetBuffer();
                byte[] data = "TO BE SEEN\n".getBytes(StandardCharsets.ISO_8859_1);
                exp.write(data);
                out.write(data);
                out.flush();
                data = "Not reset after flush\n".getBytes(StandardCharsets.ISO_8859_1);
                exp.write(data);
                try {
                    out.resetBuffer();
                }
                catch (IllegalStateException e) {
                    out.write(data);
                }
            }
        });
        this._swap.getHandler().start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)exp.toString()));
    }

    @Test
    public void testZeroLengthWrite() throws Exception {
        this._swap.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
                baseRequest.setHandled(true);
                response.setContentLength(0);
                final AsyncContext async = request.startAsync();
                response.getOutputStream().setWriteListener(new WriteListener(){

                    public void onWritePossible() throws IOException {
                        response.getOutputStream().write(new byte[0]);
                        async.complete();
                    }

                    public void onError(Throwable t) {
                    }
                });
            }
        });
        this._swap.getHandler().start();
        String response = this._connector.getResponse("GET / HTTP/1.0\nHost: localhost:80\n\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 200 OK"));
    }

    private static String toUTF8String(Resource resource) throws IOException {
        return BufferUtil.toUTF8String((ByteBuffer)BufferUtil.toBuffer((Resource)resource, (boolean)false));
    }

    static class ContentHandler
    extends AbstractHandler {
        AtomicInteger _owp = new AtomicInteger();
        boolean _writeLengthIfKnown = true;
        boolean _async;
        ByteBuffer _byteBuffer;
        byte[] _arrayBuffer;
        InputStream _contentInputStream;
        ReadableByteChannel _contentChannel;
        ByteBuffer _content;
        ChainedInterceptor _interceptor;
        final FuturePromise<Boolean> _closedAfterWrite = new FuturePromise();

        ContentHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            if (this._interceptor != null) {
                this._interceptor.init(baseRequest);
                this._interceptor.setNext(baseRequest.getResponse().getHttpOutput().getInterceptor());
                baseRequest.getResponse().getHttpOutput().setInterceptor((HttpOutput.Interceptor)this._interceptor);
            }
            response.setContentType("text/plain");
            final HttpOutput out = (HttpOutput)response.getOutputStream();
            if (this._contentInputStream != null) {
                out.sendContent(this._contentInputStream);
                this._contentInputStream = null;
                this._closedAfterWrite.succeeded((Object)out.isClosed());
                return;
            }
            if (this._contentChannel != null) {
                out.sendContent(this._contentChannel);
                this._contentChannel = null;
                this._closedAfterWrite.succeeded((Object)out.isClosed());
                return;
            }
            if (this._content != null && this._writeLengthIfKnown) {
                response.setContentLength(this._content.remaining());
            }
            if (this._arrayBuffer != null) {
                if (this._async) {
                    final AsyncContext async = request.startAsync();
                    out.setWriteListener(new WriteListener(){

                        public void onWritePossible() throws IOException {
                            _owp.incrementAndGet();
                            while (out.isReady()) {
                                Assertions.assertTrue((boolean)out.isReady());
                                int len = _content.remaining();
                                if (len > _arrayBuffer.length) {
                                    len = _arrayBuffer.length;
                                }
                                if (len == 0) {
                                    _closedAfterWrite.succeeded((Object)out.isClosed());
                                    async.complete();
                                    break;
                                }
                                _content.get(_arrayBuffer, 0, len);
                                if (len == 1) {
                                    out.write((int)_arrayBuffer[0]);
                                    continue;
                                }
                                out.write(_arrayBuffer, 0, len);
                            }
                        }

                        public void onError(Throwable t) {
                            t.printStackTrace();
                            async.complete();
                        }
                    });
                    return;
                }
                while (BufferUtil.hasContent((ByteBuffer)this._content)) {
                    int len = this._content.remaining();
                    if (len > this._arrayBuffer.length) {
                        len = this._arrayBuffer.length;
                    }
                    this._content.get(this._arrayBuffer, 0, len);
                    if (len == 1) {
                        out.write((int)this._arrayBuffer[0]);
                        continue;
                    }
                    out.write(this._arrayBuffer, 0, len);
                }
                this._closedAfterWrite.succeeded((Object)out.isClosed());
                return;
            }
            if (this._byteBuffer != null) {
                if (this._async) {
                    final AsyncContext async = request.startAsync();
                    out.setWriteListener(new WriteListener(){
                        private boolean isFirstWrite = true;

                        public void onWritePossible() throws IOException {
                            _owp.incrementAndGet();
                            while (out.isReady()) {
                                Assertions.assertTrue((this.isFirstWrite || !_byteBuffer.hasRemaining() ? 1 : 0) != 0);
                                Assertions.assertTrue((boolean)out.isReady());
                                if (BufferUtil.isEmpty((ByteBuffer)_content)) {
                                    _closedAfterWrite.succeeded((Object)out.isClosed());
                                    async.complete();
                                    break;
                                }
                                BufferUtil.clearToFill((ByteBuffer)_byteBuffer);
                                BufferUtil.put((ByteBuffer)_content, (ByteBuffer)_byteBuffer);
                                BufferUtil.flipToFlush((ByteBuffer)_byteBuffer, (int)0);
                                out.write(_byteBuffer);
                                this.isFirstWrite = false;
                            }
                        }

                        public void onError(Throwable t) {
                            t.printStackTrace();
                            async.complete();
                        }
                    });
                    return;
                }
                while (BufferUtil.hasContent((ByteBuffer)this._content)) {
                    BufferUtil.clearToFill((ByteBuffer)this._byteBuffer);
                    BufferUtil.put((ByteBuffer)this._content, (ByteBuffer)this._byteBuffer);
                    BufferUtil.flipToFlush((ByteBuffer)this._byteBuffer, (int)0);
                    out.write(this._byteBuffer);
                }
                this._closedAfterWrite.succeeded((Object)out.isClosed());
                return;
            }
            if (this._content != null) {
                if (this._content.hasArray()) {
                    out.write(this._content.array(), this._content.arrayOffset() + this._content.position(), this._content.remaining());
                } else {
                    out.sendContent(this._content);
                }
                this._content = null;
                this._closedAfterWrite.succeeded((Object)out.isClosed());
                return;
            }
        }
    }

    static interface ChainedInterceptor
    extends HttpOutput.Interceptor {
        default public void init(Request baseRequest) {
        }

        public void setNext(HttpOutput.Interceptor var1);
    }

    static class AggregateHandler
    extends AbstractHandler {
        ByteArrayOutputStream expected = new ByteArrayOutputStream();

        AggregateHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            HttpOutput out = (HttpOutput)response.getOutputStream();
            HttpOutput.Interceptor interceptor = out.getInterceptor();
            out.setInterceptor((HttpOutput.Interceptor)new AggregationChecker(interceptor));
            int bufferSize = baseRequest.getHttpChannel().getHttpConfiguration().getOutputBufferSize();
            int len = bufferSize * 3 / 2;
            byte[] data = new byte[511];
            int fill = 0;
            while (this.expected.size() < len) {
                Arrays.fill(data, (byte)(65 + fill++ % 26));
                this.expected.write(data);
                out.write(data);
            }
        }
    }

    static class AsyncAggregateHandler
    extends AbstractHandler {
        ByteArrayOutputStream expected = new ByteArrayOutputStream();

        AsyncAggregateHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            final HttpOutput out = (HttpOutput)response.getOutputStream();
            HttpOutput.Interceptor interceptor = out.getInterceptor();
            out.setInterceptor((HttpOutput.Interceptor)new AggregationChecker(interceptor));
            int bufferSize = baseRequest.getHttpChannel().getHttpConfiguration().getOutputBufferSize();
            final int len = bufferSize * 3 / 2;
            final AsyncContext async = request.startAsync();
            out.setWriteListener(new WriteListener(){
                int fill = 0;

                public void onWritePossible() throws IOException {
                    byte[] data = new byte[511];
                    while (out.isReady()) {
                        if (expected.size() >= len) {
                            async.complete();
                            return;
                        }
                        Arrays.fill(data, (byte)(65 + this.fill++ % 26));
                        expected.write(data);
                        out.write(data);
                    }
                }

                public void onError(Throwable t) {
                }
            });
        }
    }

    static class AggregateResidueHandler
    extends AbstractHandler {
        ByteArrayOutputStream expected = new ByteArrayOutputStream();

        AggregateResidueHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            HttpOutput out = (HttpOutput)response.getOutputStream();
            int bufferSize = baseRequest.getHttpChannel().getHttpConfiguration().getOutputBufferSize();
            int commitSize = baseRequest.getHttpChannel().getHttpConfiguration().getOutputAggregationSize();
            int fill = 65;
            byte[] data = new byte[commitSize - 1];
            int n = fill;
            fill = (char)(fill + 1);
            Arrays.fill(data, (byte)n);
            this.expected.write(data);
            out.write(data);
            for (int aggregated = data.length; aggregated < bufferSize - 1; aggregated += data.length) {
                data = new byte[Math.min(commitSize - 1, bufferSize - aggregated - 1)];
                int n2 = fill;
                fill = (char)(fill + 1);
                Arrays.fill(data, (byte)n2);
                this.expected.write(data);
                out.write(data);
            }
            data = new byte[bufferSize + 1];
            int n3 = fill;
            fill = (char)(fill + 1);
            Arrays.fill(data, (byte)n3);
            this.expected.write(data);
            out.write(data);
        }
    }

    private static class AggregationChecker
    implements HttpOutput.Interceptor {
        static final int MAX_SIZE = 511;
        private final HttpOutput.Interceptor interceptor;

        public AggregationChecker(HttpOutput.Interceptor interceptor) {
            this.interceptor = interceptor;
        }

        public void write(ByteBuffer content, boolean last, Callback callback) {
            if (content.remaining() <= 511) {
                throw new IllegalStateException("Not Aggregated!");
            }
            this.interceptor.write(content, last, callback);
        }

        public HttpOutput.Interceptor getNextInterceptor() {
            return this.interceptor;
        }

        public boolean isOptimizedForDirectBuffers() {
            return this.interceptor.isOptimizedForDirectBuffers();
        }
    }
}

