/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ShutdownMonitor;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ShutdownMonitorTest {
    @BeforeEach
    public void reset() {
        this.clearShutdownMonitorSystemProperties();
    }

    @AfterEach
    public void shutdown() {
        this.clearShutdownMonitorSystemProperties();
        ShutdownMonitor.reset();
    }

    private void clearShutdownMonitorSystemProperties() {
        Properties systemProperties = System.getProperties();
        systemProperties.remove("STOP.EXIT");
        systemProperties.remove("DEBUG");
        systemProperties.remove("STOP.HOST");
        systemProperties.remove("STOP.PORT");
        systemProperties.remove("STOP.KEY");
    }

    @Test
    public void testStatus() throws Exception {
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        monitor.setExitVm(false);
        monitor.start();
        String key = monitor.getKey();
        int port = monitor.getPort();
        for (int i = 0; i < 2; ++i) {
            try (Socket socket = new Socket("localhost", port);){
                OutputStream output = socket.getOutputStream();
                String command = "status";
                output.write((key + "\r\n" + command + "\r\n").getBytes());
                output.flush();
                BufferedReader input = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                String reply = input.readLine();
                Assertions.assertEquals((Object)"OK", (Object)reply);
                Assertions.assertNull((Object)input.readLine());
                continue;
            }
        }
    }

    @Disabled(value="Issue #2626")
    @Test
    public void testStartStopDifferentPortDifferentKey() throws Exception {
        this.testStartStop(false);
    }

    @Disabled(value="Issue #2626")
    @Test
    public void testStartStopSamePortDifferentKey() throws Exception {
        this.testStartStop(true);
    }

    private void testStartStop(boolean reusePort) throws Exception {
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        monitor.setExitVm(false);
        monitor.start();
        String key = monitor.getKey();
        int port = monitor.getPort();
        monitor.start();
        this.stop("stop", port, key, true);
        monitor.await();
        Assertions.assertTrue((!monitor.isAlive() ? 1 : 0) != 0);
        monitor.setPort(reusePort ? port : 0);
        String newKey = "foo";
        monitor.setKey(newKey);
        monitor.start();
        key = monitor.getKey();
        Assertions.assertEquals((Object)newKey, (Object)key);
        port = monitor.getPort();
        Assertions.assertTrue((boolean)monitor.isAlive());
        this.stop("stop", port, key, true);
        monitor.await();
        Assertions.assertTrue((!monitor.isAlive() ? 1 : 0) != 0);
    }

    @Test
    public void testNoExitSystemProperty() throws Exception {
        System.setProperty("STOP.EXIT", "false");
        ShutdownMonitor.reset();
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        Assertions.assertFalse((boolean)monitor.isExitVm());
        monitor.start();
        try (CloseableServer server = new CloseableServer();){
            server.setStopAtShutdown(true);
            server.start();
            Assertions.assertTrue((boolean)ShutdownThread.isRegistered((LifeCycle)server));
            Assertions.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
            String key = monitor.getKey();
            int port = monitor.getPort();
            this.stop("stop", port, key, true);
            monitor.await();
            Assertions.assertTrue((!monitor.isAlive() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)server.stopped);
            Assertions.assertTrue((!server.destroyed ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownMonitor.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        }
    }

    @Disabled
    @Test
    public void testExitVmDefault() throws Exception {
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        Assertions.assertTrue((boolean)monitor.isExitVm());
    }

    @Disabled
    @Test
    public void testExitVmTrue() throws Exception {
        System.setProperty("STOP.EXIT", "true");
        ShutdownMonitor.reset();
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        Assertions.assertTrue((boolean)monitor.isExitVm());
    }

    @Disabled
    @Test
    public void testExitVmFalse() throws Exception {
        System.setProperty("STOP.EXIT", "false");
        ShutdownMonitor.reset();
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        Assertions.assertFalse((boolean)monitor.isExitVm());
    }

    @Disabled
    @Test
    public void testForceStopCommand() throws Exception {
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        monitor.setExitVm(false);
        monitor.start();
        try (CloseableServer server = new CloseableServer();){
            server.start();
            Assertions.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
            String key = monitor.getKey();
            int port = monitor.getPort();
            this.stop("forcestop", port, key, true);
            monitor.await();
            Assertions.assertTrue((!monitor.isAlive() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)server.stopped);
            Assertions.assertTrue((!server.destroyed ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownMonitor.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOldStopCommandWithStopOnShutdownTrue() throws Exception {
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        monitor.setExitVm(false);
        monitor.start();
        try (CloseableServer server = new CloseableServer();){
            server.setStopAtShutdown(true);
            server.start();
            Assertions.assertTrue((boolean)ShutdownThread.isRegistered((LifeCycle)server));
            Assertions.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
            String key = monitor.getKey();
            int port = monitor.getPort();
            this.stop("stop", port, key, true);
            monitor.await();
            Assertions.assertTrue((!monitor.isAlive() ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)server.stopped);
            Assertions.assertTrue((!server.destroyed ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownMonitor.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOldStopCommandWithStopOnShutdownFalse() throws Exception {
        ShutdownMonitor monitor = ShutdownMonitor.getInstance();
        monitor.setPort(0);
        monitor.setExitVm(false);
        monitor.start();
        try (CloseableServer server = new CloseableServer();){
            server.setStopAtShutdown(false);
            server.start();
            Assertions.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
            String key = monitor.getKey();
            int port = monitor.getPort();
            this.stop("stop", port, key, true);
            monitor.await();
            Assertions.assertTrue((!monitor.isAlive() ? 1 : 0) != 0);
            Assertions.assertTrue((!server.stopped ? 1 : 0) != 0);
            Assertions.assertTrue((!server.destroyed ? 1 : 0) != 0);
            Assertions.assertTrue((!ShutdownThread.isRegistered((LifeCycle)server) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)ShutdownMonitor.isRegistered((LifeCycle)server));
        }
    }

    public void stop(String command, int port, String key, boolean check) throws Exception {
        block12: {
            try (Socket s = new Socket(InetAddress.getByName("127.0.0.1"), port);
                 OutputStream out = s.getOutputStream();){
                out.write((key + "\r\n" + command + "\r\n").getBytes());
                out.flush();
                if (!check) break block12;
                LineNumberReader lin = new LineNumberReader(new InputStreamReader(s.getInputStream()));
                String response = lin.readLine();
                if (response != null) {
                    Assertions.assertEquals((Object)"Stopped", (Object)response);
                    break block12;
                }
                throw new IllegalStateException("No stop confirmation");
            }
        }
    }

    public class CloseableServer
    extends Server
    implements Closeable {
        boolean destroyed = false;
        boolean stopped = false;

        protected void doStop() throws Exception {
            this.stopped = true;
            super.doStop();
        }

        public void destroy() {
            this.destroyed = true;
            super.destroy();
        }

        protected void doStart() throws Exception {
            this.stopped = false;
            this.destroyed = false;
            super.doStart();
        }

        @Override
        public void close() {
            try {
                this.stop();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

