/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.server.AbstractNCSARequestLog;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpChannelState;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.handler.RequestLogHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;

public class NcsaRequestLogTest {
    RequestLog _log;
    Server _server;
    LocalConnector _connector;
    BlockingQueue<String> _entries = new BlockingArrayQueue();
    StacklessLogging stacklessLogging;

    private void setup(String logType) throws Exception {
        TestRequestLogWriter writer = new TestRequestLogWriter();
        switch (logType) {
            case "customNCSA": {
                this._log = new CustomRequestLog((RequestLog.Writer)writer, "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\"");
                break;
            }
            case "NCSA": {
                AbstractNCSARequestLog logNCSA = new AbstractNCSARequestLog((RequestLog.Writer)writer);
                logNCSA.setExtended(true);
                this._log = logNCSA;
                break;
            }
            default: {
                throw new IllegalStateException("invalid logType");
            }
        }
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
    }

    void testHandlerServerStart() throws Exception {
        this._server.setRequestLog(this._log);
        this._server.setHandler((Handler)new TestHandler());
        this._server.start();
    }

    private void startServer() throws Exception {
        this._server.start();
    }

    private void makeRequest(String requestPath) throws Exception {
        this._connector.getResponse("GET " + requestPath + " HTTP/1.0\r\n\r\n");
    }

    @BeforeEach
    public void before() throws Exception {
        this.stacklessLogging = new StacklessLogging(new Class[]{HttpChannel.class});
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
        this.stacklessLogging.close();
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testNotHandled(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo HTTP/1.0\" 404 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testRequestLine(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?data=1 HTTP/1.0\nhost: host:80\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?data=1 HTTP/1.0\" 200 "));
        this._connector.getResponse("GET //bad/foo?data=1 HTTP/1.0\n\n");
        log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET //bad/foo?data=1 HTTP/1.0\" 200 "));
        this._connector.getResponse("GET http://host:80/foo?data=1 HTTP/1.0\n\n");
        log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET http://host:80/foo?data=1 HTTP/1.0\" 200 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testHTTP10Host(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?name=value HTTP/1.0\nHost: servername\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?name=value"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 200 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testHTTP11(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?name=value HTTP/1.1\nHost: servername\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?name=value"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 200 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testAbsolute(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET http://hostname:8888/foo?name=value HTTP/1.1\nHost: servername\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET http://hostname:8888/foo?name=value"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 200 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testQuery(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?name=value HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?name=value"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 200 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testSmallData(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?data=42 HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 200 42 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testBigData(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?data=102400 HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 200 102400 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testStatus(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?status=206 HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 206 0 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testStatusData(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo?status=206&data=42 HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo?"));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 206 42 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testBadRequest(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("XXXXXXXXXXXX\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"\"- - -\""));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 400 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testBadCharacter(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("METHOD /f\u0000o HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"\"- - -\""));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 400 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testBadVersion(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("METHOD /foo HTTP/9\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"\"- - -\""));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 505 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testLongURI(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        char[] chars = new char[10000];
        Arrays.fill(chars, 'o');
        String ooo = new String(chars);
        this._connector.getResponse("METHOD /f" + ooo + " HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"\"- - -\""));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 414 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testLongHeader(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        char[] chars = new char[10000];
        Arrays.fill(chars, 'o');
        String ooo = new String(chars);
        this._connector.getResponse("METHOD /foo HTTP/1.0\name: f+" + ooo + "\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"\"METHOD /foo HTTP/1.0\""));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 431 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testBadRequestNoHost(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET /foo HTTP/1.1\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET /foo "));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 400 "));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testUseragentWithout(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET http://[:1]/foo HTTP/1.1\nReferer: http://other.site\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET http://[:1]/foo "));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 400 50 \"http://other.site\" \"-\""));
    }

    @ParameterizedTest
    @ValueSource(strings={"customNCSA", "NCSA"})
    public void testUseragentWith(String logType) throws Exception {
        this.setup(logType);
        this.testHandlerServerStart();
        this._connector.getResponse("GET http://[:1]/foo HTTP/1.1\nReferer: http://other.site\nUser-Agent: Mozilla/5.0 (test)\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"GET http://[:1]/foo "));
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)" 400 50 \"http://other.site\" \"Mozilla/5.0 (test)\""));
    }

    public static Stream<Arguments> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String logType : Arrays.asList("customNCSA", "NCSA")) {
            data.add(new Object[]{logType, new NoopHandler(), "/noop", "\"GET /noop HTTP/1.0\" 404"});
            data.add(new Object[]{logType, new HelloHandler(), "/hello", "\"GET /hello HTTP/1.0\" 200"});
            data.add(new Object[]{logType, new ResponseSendErrorHandler(), "/sendError", "\"GET /sendError HTTP/1.0\" 599"});
            data.add(new Object[]{logType, new ServletExceptionHandler(), "/sex", "\"GET /sex HTTP/1.0\" 500"});
            data.add(new Object[]{logType, new IOExceptionHandler(), "/ioex", "\"GET /ioex HTTP/1.0\" 500"});
            data.add(new Object[]{logType, new IOExceptionPartialHandler(), "/ioex", "\"GET /ioex HTTP/1.0\" 200"});
            data.add(new Object[]{logType, new RuntimeExceptionHandler(), "/rtex", "\"GET /rtex HTTP/1.0\" 500"});
            data.add(new Object[]{logType, new BadMessageHandler(), "/bad", "\"GET /bad HTTP/1.0\" 499"});
            data.add(new Object[]{logType, new AbortHandler(), "/bad", "\"GET /bad HTTP/1.0\" 500"});
            data.add(new Object[]{logType, new AbortPartialHandler(), "/bad", "\"GET /bad HTTP/1.0\" 200"});
        }
        return data.stream().map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testServerRequestLog(String logType, Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        this._server.setRequestLog(this._log);
        this._server.setHandler(testHandler);
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerWrapper(String logType, Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        RequestLogHandler handler = new RequestLogHandler();
        handler.setRequestLog(this._log);
        handler.setHandler(testHandler);
        this._server.setHandler((Handler)handler);
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollectionFirst(String logType, Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        RequestLogHandler handler = new RequestLogHandler();
        handler.setRequestLog(this._log);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{handler, testHandler});
        this._server.setHandler((Handler)handlers);
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollectionLast(String logType, Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        RequestLogHandler handler = new RequestLogHandler();
        handler.setRequestLog(this._log);
        Assumptions.assumeTrue((testHandler instanceof NoopHandler || testHandler instanceof HelloHandler || testHandler instanceof ResponseSendErrorHandler ? 1 : 0) != 0);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{testHandler, handler});
        this._server.setHandler((Handler)handlers);
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testErrorHandler(String logType, final Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        this._server.setRequestLog(this._log);
        AbstractHandler wrapper = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                testHandler.handle(target, baseRequest, request, response);
            }
        };
        this._server.setHandler((Handler)wrapper);
        final ArrayList errors = new ArrayList();
        ErrorHandler errorHandler = new ErrorHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                errors.add(baseRequest.getRequestURI());
                super.handle(target, baseRequest, request, response);
            }
        };
        this._server.addBean((Object)errorHandler);
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testOKErrorHandler(String logType, final Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        this._server.setRequestLog(this._log);
        AbstractHandler wrapper = new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                testHandler.handle(target, baseRequest, request, response);
            }
        };
        this._server.setHandler((Handler)wrapper);
        OKErrorHandler errorHandler = new OKErrorHandler();
        this._server.addBean((Object)errorHandler);
        this.startServer();
        this.makeRequest(requestPath);
        if (!(testHandler instanceof AbortHandler)) {
            expectedLogEntry = expectedLogEntry.replaceFirst(" [1-9][0-9][0-9]", " 200");
        }
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testAsyncDispatch(String logType, final Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        this._server.setRequestLog(this._log);
        this._server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (Boolean.TRUE.equals(request.getAttribute("ASYNC"))) {
                    testHandler.handle(target, baseRequest, request, response);
                } else {
                    request.setAttribute("ASYNC", (Object)Boolean.TRUE);
                    AsyncContext ac = request.startAsync();
                    ac.setTimeout(1000L);
                    ac.dispatch();
                    baseRequest.setHandled(true);
                }
            }
        });
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testAsyncComplete(String logType, final Handler testHandler, String requestPath, String expectedLogEntry) throws Exception {
        this.setup(logType);
        this._server.setRequestLog(this._log);
        this._server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                if (Boolean.TRUE.equals(request.getAttribute("ASYNC"))) {
                    testHandler.handle(target, baseRequest, request, response);
                } else {
                    request.setAttribute("ASYNC", (Object)Boolean.TRUE);
                    AsyncContext ac = request.startAsync();
                    ac.setTimeout(1000L);
                    baseRequest.setHandled(true);
                    NcsaRequestLogTest.this._server.getThreadPool().execute(() -> {
                        try {
                            try {
                                while (baseRequest.getHttpChannel().getState().getState() != HttpChannelState.State.WAITING) {
                                    Thread.sleep(10L);
                                }
                                baseRequest.setHandled(false);
                                testHandler.handle(target, baseRequest, request, response);
                                if (!baseRequest.isHandled()) {
                                    response.sendError(404);
                                }
                            }
                            catch (BadMessageException bad) {
                                response.sendError(bad.getCode(), bad.getReason());
                            }
                            catch (Exception e) {
                                response.sendError(500, e.toString());
                            }
                        }
                        catch (IOException | IllegalStateException th) {
                            Log.getLog().ignore((Throwable)th);
                        }
                        finally {
                            ac.complete();
                        }
                    });
                }
            }
        });
        this.startServer();
        this.makeRequest(requestPath);
        this.assertRequestLog(expectedLogEntry, this._log);
    }

    private void assertRequestLog(String expectedLogEntry, RequestLog log) throws Exception {
        String line = this._entries.poll(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)line);
        MatcherAssert.assertThat((Object)line, (Matcher)Matchers.containsString((String)expectedLogEntry));
        Assertions.assertTrue((boolean)this._entries.isEmpty());
    }

    class TestRequestLogWriter
    implements RequestLog.Writer {
        TestRequestLogWriter() {
        }

        public void write(String requestEntry) {
            try {
                NcsaRequestLogTest.this._entries.add(requestEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private class TestHandler
    extends AbstractHandler {
        private TestHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String q = request.getQueryString();
            if (q == null) {
                return;
            }
            baseRequest.setHandled(true);
            block17: for (String action : q.split("\\&")) {
                String[] param = action.split("=");
                String name = param[0];
                String value = param.length > 1 ? param[1] : null;
                switch (name) {
                    case "status": {
                        response.setStatus(Integer.parseInt(value));
                        continue block17;
                    }
                    case "data": {
                        int data = Integer.parseInt(value);
                        PrintWriter out = response.getWriter();
                        int w = 0;
                        while (w < data) {
                            if (data - w > 17) {
                                w += 17;
                                out.print("0123456789ABCDEF\n");
                                continue;
                            }
                            ++w;
                            out.print("\n");
                        }
                        continue block17;
                    }
                    case "throw": {
                        try {
                            throw (Throwable)Class.forName(value).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        }
                        catch (IOException | Error | RuntimeException | ServletException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            throw new ServletException(e);
                        }
                    }
                    case "flush": {
                        response.flushBuffer();
                        continue block17;
                    }
                    case "read": {
                        ServletInputStream in = request.getInputStream();
                        while (in.read() >= 0) {
                        }
                        continue block17;
                    }
                }
            }
        }
    }

    private static class NoopHandler
    extends AbstractTestHandler {
        private NoopHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        }
    }

    private static class HelloHandler
    extends AbstractTestHandler {
        private HelloHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.setContentType("text/plain");
            response.getWriter().print("Hello World");
            if (baseRequest != null) {
                baseRequest.setHandled(true);
            }
        }
    }

    private static class ResponseSendErrorHandler
    extends AbstractTestHandler {
        private ResponseSendErrorHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            response.sendError(599, "expected");
            if (baseRequest != null) {
                baseRequest.setHandled(true);
            }
        }
    }

    private static class ServletExceptionHandler
    extends AbstractTestHandler {
        private ServletExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new ServletException("expected");
        }
    }

    private static class IOExceptionHandler
    extends AbstractTestHandler {
        private IOExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new IOException("expected");
        }
    }

    private static class IOExceptionPartialHandler
    extends AbstractTestHandler {
        private IOExceptionPartialHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentType("text/plain");
            response.setContentLength(100);
            response.getOutputStream().println("You were expecting maybe a ");
            response.flushBuffer();
            throw new IOException("expected");
        }
    }

    private static class RuntimeExceptionHandler
    extends AbstractTestHandler {
        private RuntimeExceptionHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new RuntimeException("expected");
        }
    }

    private static class BadMessageHandler
    extends AbstractTestHandler {
        private BadMessageHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            throw new BadMessageException(499);
        }
    }

    private static class AbortHandler
    extends AbstractTestHandler {
        private AbortHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            BadMessageException bad = new BadMessageException(488);
            baseRequest.getHttpChannel().abort((Throwable)bad);
            throw bad;
        }
    }

    private static class AbortPartialHandler
    extends AbstractTestHandler {
        private AbortPartialHandler() {
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            baseRequest.setHandled(true);
            response.setContentType("text/plain");
            response.setContentLength(100);
            response.getOutputStream().println("You were expecting maybe a ");
            response.flushBuffer();
            baseRequest.getHttpChannel().abort(new Throwable("bomb"));
        }
    }

    public static class OKErrorHandler
    extends ErrorHandler {
        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
            if (baseRequest.isHandled() || response.isCommitted()) {
                return;
            }
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            int status = response.getStatus();
            response.setStatus(200);
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.printf("Error %d: %s%n", status, reason);
            baseRequest.setHandled(true);
        }
    }

    private static abstract class AbstractTestHandler
    extends AbstractHandler {
        private AbstractTestHandler() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }

    public static class CaptureLog
    extends AbstractLifeCycle
    implements RequestLog {
        public BlockingQueue<String> log = new BlockingArrayQueue();

        public void log(Request request, Response response) {
            int status = response.getCommittedMetaData().getStatus();
            this.log.add(String.format("%s %s %s %03d", request.getMethod(), request.getRequestURI(), request.getProtocol(), status));
        }
    }
}

