/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.SizeLimitHandler;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SizeLimitHandlerTest {
    private Server _server;
    private LocalConnector _local;
    private ContextHandler _contextHandler;

    @BeforeEach
    public void setUp() throws Exception {
        this._server = new Server();
        HttpConfiguration config = new HttpConfiguration();
        config.setOutputBufferSize(1024);
        this._local = new LocalConnector(this._server, (ConnectionFactory)new HttpConnectionFactory(config));
        this._server.setConnectors(new Connector[]{this._local});
        SizeLimitHandler sizeLimitHandler = new SizeLimitHandler(8192L, 8192L);
        this._contextHandler = new ContextHandler("/ctx");
        this._server.setHandler((Handler)sizeLimitHandler);
        sizeLimitHandler.setHandler((Handler)this._contextHandler);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this._server.stop();
    }

    @Test
    public void testSmallGET() throws Exception {
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.getOutputStream().println("Hello World");
            }
        });
        this._server.start();
        HttpTester.Response response = HttpTester.parseResponse((String)this._local.getResponse("GET /ctx/hello HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testLargeGETContentLengthKnown() throws Exception {
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                response.setContentLength(8193);
                Assertions.fail();
            }
        });
        this._server.start();
        HttpTester.Response response = HttpTester.parseResponse((String)this._local.getResponse("GET /ctx/hello HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)500));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"8193&gt;8192"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Response body is too large"));
    }

    @Test
    public void testLargeGETSingleByteBuffer() throws Exception {
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                baseRequest.getResponse().getHttpOutput().sendContent(ByteBuffer.wrap(new byte[8193]));
            }
        });
        this._server.start();
        HttpTester.Response response = HttpTester.parseResponse((String)this._local.getResponse("GET /ctx/hello HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)500));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"8193&gt;8192"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Response body is too large"));
    }

    @Test
    public void testLargeGETManyWrites() throws Exception {
        final AtomicBoolean error = new AtomicBoolean();
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                byte[] data = new byte[1024];
                Arrays.fill(data, (byte)88);
                data[1023] = 10;
                String text = new String(data, 0, 1024, Charset.defaultCharset());
                PrintWriter out = response.getWriter();
                try {
                    for (int i = 0; i <= 10; ++i) {
                        out.println(i);
                        out.write(text);
                        out.flush();
                    }
                }
                catch (BadMessageException e) {
                    error.set(true);
                    throw e;
                }
            }
        });
        this._server.start();
        HttpTester.Response response = HttpTester.parseResponse((String)this._local.getResponse("GET /ctx/hello HTTP/1.0\r\n\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        Assertions.assertTrue((boolean)error.get());
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"8")));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"9")));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"10")));
        Assertions.assertFalse((boolean)response.isComplete());
    }

    @Test
    public void testSmallPOST() throws Exception {
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                String content = IO.toString((InputStream)request.getInputStream());
                response.getOutputStream().println("OK " + content.length());
            }
        });
        this._server.start();
        HttpTester.Response response = HttpTester.parseResponse((String)this._local.getResponse("POST /ctx/hello HTTP/1.0\r\nContent-Length: 8\r\n\r\n123456\r\n"));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"OK 8"));
    }

    @Test
    public void testLargePOSTKnownSize() throws Exception {
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                String content = IO.toString((InputStream)request.getInputStream());
                response.getOutputStream().println("OK " + content.length());
            }
        });
        this._server.start();
        HttpTester.Response response = HttpTester.parseResponse((String)this._local.getResponse("POST /ctx/hello HTTP/1.0\r\nContent-Length: 32768\r\n\r\n123456..."));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)413));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Request body is too large"));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"32768&gt;8192"));
    }

    @Test
    public void testLargePOSTUnknownSize() throws Exception {
        this._contextHandler.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                baseRequest.setHandled(true);
                String content = IO.toString((InputStream)request.getInputStream());
                response.getOutputStream().println("OK " + content.length());
            }
        });
        this._server.start();
        try (LocalConnector.LocalEndPoint endp = this._local.executeRequest("POST /ctx/hello HTTP/1.1\r\nHost: localhost\r\nTransfer-Encoding: chunked\r\n\r\n");){
            byte[] data = new byte[1024];
            Arrays.fill(data, (byte)88);
            data[1023] = 10;
            String text = new String(data, 0, 1024, Charset.defaultCharset());
            for (int i = 0; i < 9; ++i) {
                endp.addInput(Integer.toHexString(text.length()) + ";\r\n" + text + "\r\n");
            }
            HttpTester.Response response = HttpTester.parseResponse((String)endp.getResponse());
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.equalTo((Object)413));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Request body is too large"));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"&gt;8192"));
        }
    }
}

