/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.resource;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.HashMap;
import java.util.stream.Stream;
import org.eclipse.jetty.server.resource.ByteBufferRangeWriter;
import org.eclipse.jetty.server.resource.InputStreamRangeWriter;
import org.eclipse.jetty.server.resource.RangeWriter;
import org.eclipse.jetty.server.resource.SeekableByteChannelRangeWriter;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.resource.PathResource;
import org.eclipse.jetty.util.resource.Resource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class RangeWriterTest {
    public static final String DATA = "01234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWZYZ!@#$%^&*()_+/.,[]";
    private static FileSystem zipfs;

    @AfterAll
    public static void closeZipFs() throws IOException {
        if (zipfs != null) {
            zipfs.close();
        }
    }

    public static Path initDataFile() throws IOException {
        Path testDir = MavenTestingUtils.getTargetTestingPath((String)RangeWriterTest.class.getSimpleName());
        FS.ensureEmpty((Path)testDir);
        Path dataFile = testDir.resolve("data.dat");
        try (BufferedWriter writer = Files.newBufferedWriter(dataFile, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(DATA);
            writer.flush();
        }
        return dataFile;
    }

    private static Path initZipFsDataFile() throws URISyntaxException, IOException {
        Path exampleJar = MavenTestingUtils.getTestResourcePathFile((String)"example.jar");
        URI uri = new URI("jar", exampleJar.toUri().toASCIIString(), null);
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("multi-release", "runtime");
        if (zipfs != null) {
            zipfs.close();
        }
        zipfs = FileSystems.newFileSystem(uri, env);
        Path rootPath = zipfs.getRootDirectories().iterator().next();
        return rootPath.resolve("data.dat");
    }

    public static Stream<Arguments> impls() throws IOException, URISyntaxException {
        PathResource realFileSystemResource = new PathResource(RangeWriterTest.initDataFile());
        PathResource nonDefaultFileSystemResource = new PathResource(RangeWriterTest.initZipFsDataFile());
        return Stream.of(Arguments.of((Object[])new Object[]{"Traditional / Direct Buffer", new ByteBufferRangeWriter(BufferUtil.toBuffer((Resource)realFileSystemResource, (boolean)true))}), Arguments.of((Object[])new Object[]{"Traditional / Indirect Buffer", new ByteBufferRangeWriter(BufferUtil.toBuffer((Resource)realFileSystemResource, (boolean)false))}), Arguments.of((Object[])new Object[]{"Traditional / SeekableByteChannel", new SeekableByteChannelRangeWriter(() -> RangeWriterTest.lambda$impls$0((Resource)realFileSystemResource))}), Arguments.of((Object[])new Object[]{"Traditional / InputStream", new InputStreamRangeWriter(() -> RangeWriterTest.lambda$impls$1((Resource)realFileSystemResource))}), Arguments.of((Object[])new Object[]{"Non-Default FS / Direct Buffer", new ByteBufferRangeWriter(BufferUtil.toBuffer((Resource)nonDefaultFileSystemResource, (boolean)true))}), Arguments.of((Object[])new Object[]{"Non-Default FS / Indirect Buffer", new ByteBufferRangeWriter(BufferUtil.toBuffer((Resource)nonDefaultFileSystemResource, (boolean)false))}), Arguments.of((Object[])new Object[]{"Non-Default FS / SeekableByteChannel", new SeekableByteChannelRangeWriter(() -> RangeWriterTest.lambda$impls$2((Resource)nonDefaultFileSystemResource))}), Arguments.of((Object[])new Object[]{"Non-Default FS / InputStream", new InputStreamRangeWriter(() -> RangeWriterTest.lambda$impls$3((Resource)nonDefaultFileSystemResource))}));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"impls"})
    public void testSimpleRange(String description, RangeWriter rangeWriter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 10L, 50L);
        MatcherAssert.assertThat((String)"Range: 10 (len=50)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(10, 60)));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"impls"})
    public void testSameRangeMultipleTimes(String description, RangeWriter rangeWriter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 10L, 50L);
        MatcherAssert.assertThat((String)"Range(a): 10 (len=50)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(10, 60)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 10L, 50L);
        MatcherAssert.assertThat((String)"Range(b): 10 (len=50)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(10, 60)));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"impls"})
    public void testMultipleRangesOrdered(String description, RangeWriter rangeWriter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 10L, 20L);
        MatcherAssert.assertThat((String)"Range(a): 10 (len=20)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(10, 30)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 35L, 10L);
        MatcherAssert.assertThat((String)"Range(b): 35 (len=10)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(35, 45)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 55L, 10L);
        MatcherAssert.assertThat((String)"Range(b): 55 (len=10)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(55, 65)));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"impls"})
    public void testMultipleRangesOverlapping(String description, RangeWriter rangeWriter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 10L, 20L);
        MatcherAssert.assertThat((String)"Range(a): 10 (len=20)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(10, 30)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 15L, 20L);
        MatcherAssert.assertThat((String)"Range(b): 15 (len=20)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(15, 35)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 20L, 20L);
        MatcherAssert.assertThat((String)"Range(b): 20 (len=20)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(20, 40)));
    }

    @ParameterizedTest(name="[{index}] {0}")
    @MethodSource(value={"impls"})
    public void testMultipleRangesReverseOrder(String description, RangeWriter rangeWriter) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 55L, 10L);
        MatcherAssert.assertThat((String)"Range(b): 55 (len=10)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(55, 65)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 35L, 10L);
        MatcherAssert.assertThat((String)"Range(b): 35 (len=10)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(35, 45)));
        outputStream = new ByteArrayOutputStream();
        rangeWriter.writeTo((OutputStream)outputStream, 10L, 20L);
        MatcherAssert.assertThat((String)"Range(a): 10 (len=20)", (Object)new String(outputStream.toByteArray(), StandardCharsets.UTF_8), (Matcher)Matchers.is((Object)DATA.substring(10, 30)));
    }

    private static /* synthetic */ InputStream lambda$impls$3(Resource nonDefaultFileSystemResource) throws IOException {
        return nonDefaultFileSystemResource.getInputStream();
    }

    private static /* synthetic */ SeekableByteChannel lambda$impls$2(Resource nonDefaultFileSystemResource) throws IOException {
        return (SeekableByteChannel)nonDefaultFileSystemResource.getReadableByteChannel();
    }

    private static /* synthetic */ InputStream lambda$impls$1(Resource realFileSystemResource) throws IOException {
        return realFileSystemResource.getInputStream();
    }

    private static /* synthetic */ SeekableByteChannel lambda$impls$0(Resource realFileSystemResource) throws IOException {
        return (SeekableByteChannel)realFileSystemResource.getReadableByteChannel();
    }
}

