/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.ssl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SocketCustomizationListener;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;

public class SniSslConnectionFactoryTest {
    private Server _server;
    private ServerConnector _connector;
    private HttpConfiguration _httpsConfiguration;
    private int _port;

    @BeforeEach
    public void before() {
        this._server = new Server();
        HttpConfiguration httpConfig = new HttpConfiguration();
        httpConfig.setSecureScheme("https");
        httpConfig.setSecurePort(8443);
        httpConfig.setOutputBufferSize(32768);
        this._httpsConfiguration = new HttpConfiguration(httpConfig);
        SecureRequestCustomizer src = new SecureRequestCustomizer();
        src.setSniHostCheck(true);
        this._httpsConfiguration.addCustomizer((HttpConfiguration.Customizer)src);
        this._httpsConfiguration.addCustomizer((connector, hc, request) -> {
            EndPoint endp = request.getHttpChannel().getEndPoint();
            if (endp instanceof SslConnection.DecryptedEndPoint) {
                try {
                    SslConnection.DecryptedEndPoint sslEndp = (SslConnection.DecryptedEndPoint)endp;
                    SslConnection sslConnection = sslEndp.getSslConnection();
                    SSLEngine sslEngine = sslConnection.getSSLEngine();
                    SSLSession session = sslEngine.getSession();
                    for (Certificate c : session.getLocalCertificates()) {
                        request.getResponse().getHttpFields().add("X-Cert", ((X509Certificate)c).getSubjectDN().toString());
                    }
                }
                catch (Throwable th) {
                    th.printStackTrace();
                }
            }
        });
    }

    protected void start(String keystorePath) throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath(keystorePath);
            ssl.setKeyManagerPassword("keypwd");
        });
    }

    protected void start(Consumer<SslContextFactory.Server> sslConfig) throws Exception {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (OS.WINDOWS.isCurrentOs()) {
            // empty if block
        }
        sslContextFactory.setKeyStorePassword("storepwd");
        sslConfig.accept(sslContextFactory);
        File keystoreFile = sslContextFactory.getKeyStoreResource().getFile();
        if (!keystoreFile.exists()) {
            throw new FileNotFoundException(keystoreFile.getAbsolutePath());
        }
        ServerConnector https = this._connector = new ServerConnector(this._server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(this._httpsConfiguration)});
        this._server.addConnector((Connector)https);
        this._server.setHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) {
                baseRequest.setHandled(true);
                response.setStatus(200);
                response.setHeader("X-URL", request.getRequestURI());
                response.setHeader("X-HOST", request.getServerName());
            }
        });
        this._server.start();
        this._port = https.getLocalPort();
    }

    @AfterEach
    public void after() throws Exception {
        if (this._server != null) {
            this._server.stop();
        }
    }

    @Test
    public void testConnect() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        String response = this.getResponse("127.0.0.1", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: 127.0.0.1"));
    }

    @Test
    public void testSNIConnectNoWild() throws Exception {
        this.start("src/test/resources/keystore_sni_nowild.p12");
        String response = this.getResponse("www.acme.org", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.acme.org"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-Cert: OU=default"));
        response = this.getResponse("www.example.com", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.example.com"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-Cert: OU=example"));
    }

    @Test
    public void testSNIConnect() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
            ssl.setSNISelector((keyType, issuers, session, sniHost, certificates) -> {
                List sortedCertificates = certificates.stream().sorted((x509a, x509b) -> {
                    if (x509a.matches("domain.com")) {
                        return -1;
                    }
                    if (x509b.matches("domain.com")) {
                        return 1;
                    }
                    return 0;
                }).collect(Collectors.toList());
                return ssl.sniSelect(keyType, issuers, session, sniHost, sortedCertificates);
            });
        });
        String response = this.getResponse("jetty.eclipse.org", "jetty.eclipse.org");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: jetty.eclipse.org"));
        response = this.getResponse("www.example.com", "www.example.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.example.com"));
        response = this.getResponse("foo.domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: foo.domain.com"));
        response = this.getResponse("sub.domain.com", "sub.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: sub.domain.com"));
        response = this.getResponse("m.san.com", "san example");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: m.san.com"));
        response = this.getResponse("www.san.com", "san example");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.san.com"));
    }

    @Test
    public void testWildSNIConnect() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        String response = this.getResponse("domain.com", "www.domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.domain.com"));
        response = this.getResponse("domain.com", "domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: domain.com"));
        response = this.getResponse("www.domain.com", "www.domain.com", "*.domain.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: www.domain.com"));
    }

    @Test
    public void testBadSNIConnect() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        String response = this.getResponse("www.example.com", "some.other.com", "www.example.com");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"HTTP/1.1 400 "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Host does not match SNI"));
    }

    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="TLSv1.3 behavior differences between Linux and Windows")
    @Test
    public void testWrongSNIRejectedConnection() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
            ssl.setSniRequired(true);
        });
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse("wrong.com", "wrong.com", null));
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse(null, "wrong.com", null));
    }

    @Test
    public void testWrongSNIRejectedBadRequest() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
            ssl.setSniRequired(false);
            this._httpsConfiguration.getCustomizers().stream().filter(SecureRequestCustomizer.class::isInstance).map(SecureRequestCustomizer.class::cast).forEach(src -> src.setSniRequired(true));
        });
        HttpTester.Response response = HttpTester.parseResponse((String)this.getResponse("wrong.com", "wrong.com", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
        response = HttpTester.parseResponse((String)this.getResponse(null, "wrong.com", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="TLSv1.3 behavior differences between Linux and Windows")
    @Test
    public void testWrongSNIRejectedFunction() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore_sni.p12");
            ssl.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
            ssl.setSniRequired(true);
            ssl.setSNISelector((keyType, issuers, session, sniHost, certificates) -> {
                if (sniHost == null) {
                    return "delegate_no_sni_match";
                }
                return ssl.sniSelect(keyType, issuers, session, sniHost, certificates);
            });
            this._httpsConfiguration.getCustomizers().stream().filter(SecureRequestCustomizer.class::isInstance).map(SecureRequestCustomizer.class::cast).forEach(src -> src.setSniRequired(true));
        });
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse("wrong.com", "wrong.com", null));
        HttpTester.Response response = HttpTester.parseResponse((String)this.getResponse(null, "wrong.com", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
    }

    @DisabledOnOs(value={OS.WINDOWS}, disabledReason="TLSv1.3 behavior differences between Linux and Windows")
    @Test
    public void testWrongSNIRejectedConnectionWithNonSNIKeystore() throws Exception {
        this.start((SslContextFactory.Server ssl) -> {
            ssl.setKeyStorePath("src/test/resources/keystore");
            ssl.setKeyManagerPassword("OBF:1u2u1wml1z7s1z7a1wnl1u2g");
            ssl.setSniRequired(true);
        });
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse("wrong.com", "wrong.com", null));
        Assertions.assertThrows(SSLHandshakeException.class, () -> this.getResponse(null, "wrong.com", null));
        HttpTester.Response response = HttpTester.parseResponse((String)this.getResponse("jetty.eclipse.org", "jetty.eclipse.org", null));
        Assertions.assertNotNull((Object)response);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameConnectionRequestsForManyDomains() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        this._server.setErrorHandler(new ErrorHandler());
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        try (SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._port);){
            SNIHostName serverName = new SNIHostName("m.san.com");
            SSLParameters params = sslSocket.getSSLParameters();
            params.setServerNames(Collections.singletonList(serverName));
            sslSocket.setSSLParameters(params);
            sslSocket.startHandshake();
            String request = "GET /ctx/path HTTP/1.1\r\nHost: m.san.com\r\n\r\n";
            OutputStream output = sslSocket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = sslSocket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: www.san.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: www.example.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Host does not match SNI"));
        }
        finally {
            clientContextFactory.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSameConnectionRequestsForManyWildDomains() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        try (SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._port);){
            SNIHostName serverName = new SNIHostName("www.domain.com");
            SSLParameters params = sslSocket.getSSLParameters();
            params.setServerNames(Collections.singletonList(serverName));
            sslSocket.setSSLParameters(params);
            sslSocket.startHandshake();
            String request = "GET /ctx/path HTTP/1.1\r\nHost: www.domain.com\r\n\r\n";
            OutputStream output = sslSocket.getOutputStream();
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            InputStream input = sslSocket.getInputStream();
            HttpTester.Response response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: assets.domain.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
            request = "GET /ctx/path HTTP/1.1\r\nHost: www.example.com\r\n\r\n";
            output.write(request.getBytes(StandardCharsets.UTF_8));
            output.flush();
            response = HttpTester.parseResponse((InputStream)input);
            Assertions.assertNotNull((Object)response);
            MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)400));
            MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.containsString((String)"Host does not match SNI"));
        }
        finally {
            clientContextFactory.stop();
        }
    }

    @Test
    public void testSocketCustomization() throws Exception {
        this.start("src/test/resources/keystore_sni.p12");
        final LinkedBlockingQueue history = new LinkedBlockingQueue();
        this._connector.addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize connector " + connection + "," + ssl);
            }
        });
        ((SslConnectionFactory)this._connector.getBean(SslConnectionFactory.class)).addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize ssl " + connection + "," + ssl);
            }
        });
        ((HttpConnectionFactory)this._connector.getBean(HttpConnectionFactory.class)).addBean((Object)new SocketCustomizationListener(){

            protected void customize(Socket socket, Class<? extends Connection> connection, boolean ssl) {
                history.add("customize http " + connection + "," + ssl);
            }
        });
        String response = this.getResponse("127.0.0.1", null);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-HOST: 127.0.0.1"));
        Assertions.assertEquals((Object)"customize connector class org.eclipse.jetty.io.ssl.SslConnection,false", history.poll());
        Assertions.assertEquals((Object)"customize ssl class org.eclipse.jetty.io.ssl.SslConnection,false", history.poll());
        Assertions.assertEquals((Object)"customize connector class org.eclipse.jetty.server.HttpConnection,true", history.poll());
        Assertions.assertEquals((Object)"customize http class org.eclipse.jetty.server.HttpConnection,true", history.poll());
        Assertions.assertEquals((int)0, (int)history.size());
    }

    @Test
    public void testSNIWithDifferentKeyTypes() throws Exception {
        this.start((SslContextFactory.Server ssl) -> ssl.setKeyStorePath("src/test/resources/keystore_sni_key_types.p12"));
        HttpTester.Response response1 = HttpTester.parseResponse((String)this.getResponse("rsa.domain.com", "rsa.domain.com"));
        Assertions.assertEquals((int)200, (int)response1.getStatus());
        HttpTester.Response response2 = HttpTester.parseResponse((String)this.getResponse("ec.domain.com", "ec.domain.com"));
        Assertions.assertEquals((int)200, (int)response2.getStatus());
    }

    private String getResponse(String host, String cn) throws Exception {
        String response = this.getResponse(host, host, cn);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.startsWith((String)"HTTP/1.1 200 "));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"X-URL: /ctx/path"));
        return response;
    }

    private String getResponse(String sniHost, String reqHost, String cn) throws Exception {
        SslContextFactory.Client clientContextFactory = new SslContextFactory.Client(true);
        clientContextFactory.start();
        SSLSocketFactory factory = clientContextFactory.getSslContext().getSocketFactory();
        try {
            String string;
            block11: {
                SSLSocket sslSocket = (SSLSocket)factory.createSocket("127.0.0.1", this._port);
                try {
                    if (sniHost != null) {
                        SNIHostName serverName = new SNIHostName(sniHost);
                        ArrayList<SNIServerName> serverNames = new ArrayList<SNIServerName>();
                        serverNames.add(serverName);
                        SSLParameters params = sslSocket.getSSLParameters();
                        params.setServerNames(serverNames);
                        sslSocket.setSSLParameters(params);
                    }
                    sslSocket.startHandshake();
                    if (cn != null) {
                        X509Certificate cert = (X509Certificate)sslSocket.getSession().getPeerCertificates()[0];
                        MatcherAssert.assertThat((Object)cert.getSubjectX500Principal().getName("CANONICAL"), (Matcher)Matchers.startsWith((String)("cn=" + cn)));
                    }
                    String response = "GET /ctx/path HTTP/1.0\r\nHost: " + reqHost + ":" + this._port + "\r\n\r\n";
                    sslSocket.getOutputStream().write(response.getBytes(StandardCharsets.ISO_8859_1));
                    string = IO.toString((InputStream)sslSocket.getInputStream());
                    if (sslSocket == null) break block11;
                }
                catch (Throwable throwable) {
                    if (sslSocket != null) {
                        try {
                            sslSocket.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                sslSocket.close();
            }
            return string;
        }
        finally {
            clientContextFactory.stop();
        }
    }
}

