/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.CustomRequestLog;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CustomRequestLogTest {
    RequestLog _log;
    Server _server;
    LocalConnector _connector;
    BlockingQueue<String> _entries = new BlockingArrayQueue();
    String _tmpDir;

    @BeforeEach
    public void before() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        this._tmpDir = new File(System.getProperty("java.io.tmpdir")).getCanonicalPath();
    }

    void testHandlerServerStart(String formatString) throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/context");
        context.setResourceBase(this._tmpDir);
        context.addServlet(TestServlet.class, "/servlet/*");
        TestRequestLogWriter writer = new TestRequestLogWriter();
        this._log = new CustomRequestLog((RequestLog.Writer)writer, formatString);
        this._server.setRequestLog(this._log);
        this._server.setHandler((Handler)context);
        this._server.start();
    }

    @AfterEach
    public void after() throws Exception {
        this._server.stop();
    }

    @Test
    public void testLogFilename() throws Exception {
        this.testHandlerServerStart("Filename: %f");
        this._connector.getResponse("GET /context/servlet/info HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        String expected = new File(this._tmpDir + File.separator + "servlet" + File.separator + "info").getCanonicalPath();
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.is((Object)("Filename: " + expected)));
    }

    @Test
    public void testLogRequestHandler() throws Exception {
        this.testHandlerServerStart("RequestHandler: %R");
        this._connector.getResponse("GET /context/servlet/ HTTP/1.0\n\n");
        String log = this._entries.poll(5L, TimeUnit.SECONDS);
        MatcherAssert.assertThat((Object)log, (Matcher)Matchers.containsString((String)"TestServlet"));
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getRequestURI().contains("error404")) {
                response.setStatus(404);
            } else if (request.getRequestURI().contains("error301")) {
                response.setStatus(301);
            } else if (request.getHeader("echo") != null) {
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.print(request.getHeader("echo"));
            } else if (request.getRequestURI().contains("responseHeaders")) {
                response.addHeader("Header1", "value1");
                response.addHeader("Header2", "value2");
            }
        }
    }

    class TestRequestLogWriter
    implements RequestLog.Writer {
        TestRequestLogWriter() {
        }

        public void write(String requestEntry) {
            try {
                CustomRequestLogTest.this._entries.add(requestEntry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

