/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FilterHolderTest {
    @Test
    public void testInitialize() throws Exception {
        ServletHandler handler = new ServletHandler();
        final AtomicInteger counter = new AtomicInteger(0);
        Filter filter = new Filter(){

            public void init(FilterConfig filterConfig) {
                counter.incrementAndGet();
            }

            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
            }

            public void destroy() {
            }
        };
        FilterHolder fh = new FilterHolder();
        fh.setServletHandler(handler);
        fh.setName("xx");
        fh.setFilter(filter);
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{FilterHolder.class});){
            Assertions.assertThrows(IllegalStateException.class, () -> ((FilterHolder)fh).initialize());
        }
        fh.start();
        fh.initialize();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.initialize();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.stop();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.start();
        Assertions.assertEquals((int)1, (int)counter.get());
        fh.initialize();
        Assertions.assertEquals((int)2, (int)counter.get());
    }

    @Test
    public void testCreateInstance() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{ServletHandler.class, ServletContextHandler.class});){
            FilterHolder holder = new FilterHolder();
            holder.setName("foo");
            holder.setHeldClass(DummyFilter.class);
            Filter filter = holder.createInstance();
            Assertions.assertNotNull((Object)filter);
            Server server = new Server();
            ServletContextHandler context = new ServletContextHandler();
            server.setHandler((Handler)context);
            ServletHandler handler = context.getServletHandler();
            handler.addFilter(holder);
            holder.setServletHandler(handler);
            context.start();
            Assertions.assertNotNull((Object)holder.getFilter());
        }
    }

    public static class DummyFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        }
    }
}

