/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.AsyncRequestContent;
import org.eclipse.jetty.client.util.FormRequestContent;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.Fields;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class FormTest {
    private static final int MAX_FORM_CONTENT_SIZE = 128;
    private static final int MAX_FORM_KEYS = 4;
    private Server server;
    private ServerConnector connector;
    private HttpClient client;
    private String contextPath = "/ctx";
    private String servletPath = "/test_form";

    private void start(Function<ServletContextHandler, HttpServlet> config) throws Exception {
        this.startServer(config);
        this.startClient();
    }

    private void startServer(Function<ServletContextHandler, HttpServlet> config) throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server, 1, 1);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler handler = new ServletContextHandler((HandlerContainer)this.server, this.contextPath);
        HttpServlet servlet = config.apply(handler);
        handler.addServlet(new ServletHolder((Servlet)servlet), this.servletPath + "/*");
        this.server.start();
    }

    private void startClient() throws Exception {
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterEach
    public void dispose() throws Exception {
        if (this.client != null) {
            this.client.stop();
        }
        if (this.server != null) {
            this.server.stop();
        }
    }

    public static Stream<Arguments> formContentSizeScenarios() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, true}), Arguments.of((Object[])new Object[]{null, false}), Arguments.of((Object[])new Object[]{-1, true}), Arguments.of((Object[])new Object[]{-1, false}), Arguments.of((Object[])new Object[]{0, true}), Arguments.of((Object[])new Object[]{0, false}), Arguments.of((Object[])new Object[]{128, true}), Arguments.of((Object[])new Object[]{128, false}));
    }

    @ParameterizedTest
    @MethodSource(value={"formContentSizeScenarios"})
    public void testMaxFormContentSizeExceeded(Integer maxFormContentSize, boolean withContentLength) throws Exception {
        this.start(handler -> {
            if (maxFormContentSize != null) {
                handler.setMaxFormContentSize(maxFormContentSize.intValue());
            }
            return new HttpServlet(){

                protected void service(HttpServletRequest request, HttpServletResponse response) {
                    request.getParameterMap();
                }
            };
        });
        byte[] key = "foo=".getBytes(StandardCharsets.US_ASCII);
        int length = maxFormContentSize == null || maxFormContentSize < 0 ? 200000 : maxFormContentSize;
        byte[] value = new byte[++length];
        Arrays.fill(value, (byte)120);
        AsyncRequestContent content = new AsyncRequestContent(new ByteBuffer[]{ByteBuffer.wrap(key), ByteBuffer.wrap(value)});
        ContentResponse response = this.client.newRequest("localhost", this.connector.getLocalPort()).method(HttpMethod.POST).path(this.contextPath + this.servletPath).headers(headers -> headers.put(HttpHeader.CONTENT_TYPE, MimeTypes.Type.FORM_ENCODED.asString())).body((Request.Content)content).onRequestBegin(request -> {
            if (withContentLength) {
                content.close();
            }
        }).onRequestCommit(request -> {
            if (!withContentLength) {
                content.close();
            }
        }).send();
        int expected = maxFormContentSize != null && maxFormContentSize < 0 ? 200 : 400;
        Assertions.assertEquals((int)expected, (int)response.getStatus());
    }

    public static Stream<Integer> formKeysScenarios() {
        return Stream.of(null, -1, 0, 4);
    }

    @ParameterizedTest
    @MethodSource(value={"formKeysScenarios"})
    public void testMaxFormKeysExceeded(Integer maxFormKeys) throws Exception {
        this.start(handler -> {
            if (maxFormKeys != null) {
                handler.setMaxFormKeys(maxFormKeys.intValue());
            }
            return new HttpServlet(){

                protected void service(HttpServletRequest request, HttpServletResponse response) {
                    request.getParameterMap();
                }
            };
        });
        int keys = maxFormKeys == null || maxFormKeys < 0 ? 1000 : maxFormKeys;
        ++keys;
        Fields formParams = new Fields();
        for (int i = 0; i < keys; ++i) {
            formParams.add("key_" + i, "value_" + i);
        }
        ContentResponse response = this.client.newRequest("localhost", this.connector.getLocalPort()).method(HttpMethod.POST).path(this.contextPath + this.servletPath).body((Request.Content)new FormRequestContent(formParams)).send();
        int expected = maxFormKeys != null && maxFormKeys < 0 ? 200 : 400;
        Assertions.assertEquals((int)expected, (int)response.getStatus());
    }
}

