/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.component.LifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GzipHandlerCommitTest {
    private Server server;
    private HttpClient client;

    public void start(Servlet servlet) throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath("/");
        ServletHolder servletHolder = new ServletHolder(servlet);
        contextHandler.addServlet(servletHolder, "/test/*");
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setHandler((Handler)contextHandler);
        this.server.setHandler((Handler)gzipHandler);
        this.server.start();
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterEach
    public void tearDown() {
        LifeCycle.stop((Object)this.client);
        LifeCycle.stop((Object)this.server);
    }

    @Test
    public void testImmediateFlushNoContent() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.start((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.flushBuffer();
                Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS)));
            }
        });
        URI uri = this.server.getURI().resolve("/test/");
        Request request = this.client.newRequest(uri);
        request.header(HttpHeader.CONNECTION, "Close");
        request.onResponseHeaders(r -> latch.countDown());
        ContentResponse response = request.send();
        MatcherAssert.assertThat((String)"Response status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
    }

    @Test
    public void testImmediateFlushWithContent() throws Exception {
        final int size = 8000;
        final CountDownLatch latch = new CountDownLatch(1);
        this.start((Servlet)new HttpServlet(){

            protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.flushBuffer();
                Assertions.assertDoesNotThrow(() -> Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS)));
                response.getOutputStream();
                byte[] buf = new byte[size];
                Arrays.fill(buf, (byte)97);
                response.getOutputStream().write(buf);
            }
        });
        URI uri = this.server.getURI().resolve("/test/");
        Request request = this.client.newRequest(uri);
        request.header(HttpHeader.CONNECTION, "Close");
        request.onResponseHeaders(r -> latch.countDown());
        ContentResponse response = request.send();
        MatcherAssert.assertThat((String)"Response status", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response content size", (Object)response.getContent().length, (Matcher)Matchers.is((Object)size));
    }
}

