/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class GzipHandlerTest {
    private static final String __content = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.";
    private static final byte[] __bytes = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".getBytes(StandardCharsets.UTF_8);
    private static final String __micro = "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".substring(0, 10);
    private static final String __contentETag = String.format("W/\"%x\"", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".hashCode());
    private static final String __contentETagGzip = String.format("W/\"%x--gzip\"", "Lorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.".hashCode());
    private static final String __icontent = "BEFORELorem ipsum dolor sit amet, consectetur adipiscing elit. In quis felis nunc. Quisque suscipit mauris et ante auctor ornare rhoncus lacus aliquet. Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum sit amet felis augue, vel convallis dolor. Cras accumsan vehicula diam at faucibus. Etiam in urna turpis, sed congue mi. Morbi et lorem eros. Donec vulputate velit in risus suscipit lobortis. Aliquam id urna orci, nec sollicitudin ipsum. Cras a orci turpis. Donec suscipit vulputate cursus. Mauris nunc tellus, fermentum eu auctor ut, mollis at diam. Quisque porttitor ultrices metus, vitae tincidunt massa sollicitudin a. Vivamus porttitor libero eget purus hendrerit cursus. Integer aliquam consequat mauris quis luctus. Cras enim nibh, dignissim eu faucibus ac, mollis nec neque. Aliquam purus mauris, consectetur nec convallis lacinia, porta sed ante. Suspendisse et cursus magna. Donec orci enim, molestie a lobortis eu, imperdiet vitae neque.AFTER";
    private Server _server;
    private LocalConnector _connector;

    @BeforeEach
    public void init() throws Exception {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        GzipHandler gzipHandler = new GzipHandler();
        gzipHandler.setMinGzipSize(16);
        gzipHandler.setInflateBufferSize(4096);
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)gzipHandler, "/ctx");
        ServletHandler servlets = context.getServletHandler();
        this._server.setHandler((Handler)gzipHandler);
        gzipHandler.setHandler((Handler)context);
        servlets.addServletWithMapping(MicroServlet.class, "/micro");
        servlets.addServletWithMapping(MicroChunkedServlet.class, "/microchunked");
        servlets.addServletWithMapping(TestServlet.class, "/content");
        servlets.addServletWithMapping(ForwardServlet.class, "/forward");
        servlets.addServletWithMapping(IncludeServlet.class, "/include");
        servlets.addServletWithMapping(EchoServlet.class, "/echo/*");
        servlets.addServletWithMapping(DumpServlet.class, "/dump/*");
        servlets.addServletWithMapping(AsyncServlet.class, "/async/*");
        servlets.addServletWithMapping(BufferServlet.class, "/buffer/*");
        servlets.addFilterWithMapping(CheckFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        this._server.start();
    }

    @AfterEach
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testNotGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content?vary=Other");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETag));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Other", "Accept-Encoding"}));
        ByteArrayInputStream testIn = new ByteArrayInputStream(response.getContentBytes());
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testBlockingResponse() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content?vary=Accept-Encoding,Other");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Accept-Encoding", "Other"}));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testAsyncResponse() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/async/info?writes=1");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Accept-Encoding"}));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testBufferResponse() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/buffer/info");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Accept-Encoding"}));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testAsyncLargeResponse() throws Exception {
        int writes = 100;
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/async/info?writes=" + writes);
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Accept-Encoding"}));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        byte[] bytes = testOut.toByteArray();
        for (int i = 0; i < writes; ++i) {
            Assertions.assertEquals((Object)__content, (Object)new String(Arrays.copyOfRange(bytes, i * __bytes.length, (i + 1) * __bytes.length), StandardCharsets.UTF_8), (String)("chunk " + i));
        }
    }

    @Test
    public void testAsyncEmptyResponse() throws Exception {
        int writes = 0;
        ((GzipHandler)this._server.getChildHandlerByClass(GzipHandler.class)).setMinGzipSize(0);
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/async/info?writes=" + writes);
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Accept-Encoding"}));
    }

    @Test
    public void testGzipHandlerWithMultipleAcceptEncodingHeaders() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content?vary=Accept-Encoding,Other");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "deflate");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
        MatcherAssert.assertThat((Object)response.getCSV("Vary", false), (Matcher)Matchers.contains((Object[])new String[]{"Accept-Encoding", "Other"}));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testGzipNotMicro() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/micro");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("Accept-Encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)"gzip")));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETag));
        MatcherAssert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        ByteArrayInputStream testIn = new ByteArrayInputStream(response.getContentBytes());
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__micro, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testGzipNotMicroChunked() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/microchunked");
        request.setVersion("HTTP/1.1");
        request.setHeader("Host", "tester");
        request.setHeader("Accept-Encoding", "gzip");
        ByteBuffer rawresponse = this._connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)rawresponse);
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Transfer-Encoding"), (Matcher)Matchers.containsString((String)"chunked"));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.containsString((String)"gzip"));
        MatcherAssert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__micro, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testETagNotGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("If-None-Match", __contentETag);
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETag));
    }

    @Test
    public void testETagGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("If-None-Match", __contentETagGzip);
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
    }

    @Test
    public void testDeleteETagGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("DELETE");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("If-Match", "WrongEtag--gzip");
        request.setHeader("accept-encoding", "gzip");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)304));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
        request = HttpTester.newRequest();
        request.setMethod("DELETE");
        request.setURI("/ctx/content");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("If-Match", __contentETagGzip);
        request.setHeader("accept-encoding", "gzip");
        response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)204));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.not((Matcher)Matchers.equalToIgnoringCase((String)"gzip")));
    }

    @Test
    public void testForwardGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        request.setURI("/ctx/forward");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.is((Object)__contentETagGzip));
        MatcherAssert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__content, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testIncludeGzipHandler() throws Exception {
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("GET");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("accept-encoding", "gzip");
        request.setURI("/ctx/include");
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.get("Content-Encoding"), (Matcher)Matchers.equalToIgnoringCase((String)"gzip"));
        MatcherAssert.assertThat((Object)response.get("ETag"), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((Object)response.get("Vary"), (Matcher)Matchers.is((Object)"Accept-Encoding"));
        GZIPInputStream testIn = new GZIPInputStream(new ByteArrayInputStream(response.getContentBytes()));
        ByteArrayOutputStream testOut = new ByteArrayOutputStream();
        IO.copy((InputStream)testIn, (OutputStream)testOut);
        Assertions.assertEquals((Object)__icontent, (Object)testOut.toString("UTF8"));
    }

    @Test
    public void testAddGetPaths() {
        GzipHandler gzip = new GzipHandler();
        gzip.addIncludedPaths(new String[]{"/foo"});
        gzip.addIncludedPaths(new String[]{"^/bar.*$"});
        String[] includedPaths = gzip.getIncludedPaths();
        MatcherAssert.assertThat((String)"Included Paths.size", (Object)includedPaths.length, (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)"Included Paths", Arrays.asList(includedPaths), (Matcher)Matchers.contains((Object[])new String[]{"/foo", "^/bar.*$"}));
    }

    @Test
    public void testGzipRequest() throws Exception {
        Object data = "Hello Nice World! ";
        for (int i = 0; i < 10; ++i) {
            data = (String)data + (String)data;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        output.write(((String)data).getBytes(StandardCharsets.UTF_8));
        output.close();
        byte[] bytes = baos.toByteArray();
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("POST");
        request.setURI("/ctx/echo");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("Content-Type", "text/plain");
        request.setHeader("Content-Encoding", "gzip");
        request.setContent(bytes);
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)data));
    }

    @Test
    public void testGzipRequestChunked() throws Exception {
        Object data = "Hello Nice World! ";
        for (int i = 0; i < 10; ++i) {
            data = (String)data + (String)data;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        output.write(((String)data).getBytes(StandardCharsets.UTF_8));
        output.close();
        byte[] bytes = baos.toByteArray();
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("POST");
        request.setURI("/ctx/echo");
        request.setVersion("HTTP/1.1");
        request.setHeader("Host", "tester");
        request.setHeader("Content-Type", "text/plain");
        request.setHeader("Content-Encoding", "gzip");
        request.add("Transfer-Encoding", "chunked");
        request.setContent(bytes);
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)data));
    }

    @Test
    public void testGzipFormRequest() throws Exception {
        String data = "name=value";
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        output.write(data.getBytes(StandardCharsets.UTF_8));
        output.close();
        byte[] bytes = baos.toByteArray();
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("POST");
        request.setURI("/ctx/dump");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        request.setHeader("Content-Encoding", "gzip");
        request.setContent(bytes);
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContent(), (Matcher)Matchers.is((Object)"name: value\n"));
    }

    @Test
    public void testGzipBomb() throws Exception {
        byte[] data = new byte[524288];
        Arrays.fill(data, (byte)88);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream output = new GZIPOutputStream(baos);
        output.write(data);
        output.close();
        byte[] bytes = baos.toByteArray();
        HttpTester.Request request = HttpTester.newRequest();
        request.setMethod("POST");
        request.setURI("/ctx/echo");
        request.setVersion("HTTP/1.0");
        request.setHeader("Host", "tester");
        request.setHeader("Content-Type", "text/plain");
        request.setHeader("Content-Encoding", "gzip");
        request.setContent(bytes);
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)this._connector.getResponse(request.generate()));
        MatcherAssert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((Object)response.getContentBytes().length, (Matcher)Matchers.is((Object)524288));
    }

    public static class CheckFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (request.getParameter("X-Content-Encoding") != null) {
                Assertions.assertEquals((int)-1, (int)request.getContentLength());
            } else if (request.getContentLength() >= 0) {
                MatcherAssert.assertThat((Object)request.getParameter("X-Content-Encoding"), (Matcher)Matchers.nullValue());
            }
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class IncludeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.getWriter().write("BEFORE");
            this.getServletContext().getRequestDispatcher("/content").include((ServletRequest)request, (ServletResponse)response);
            response.getWriter().write("AFTER");
        }
    }

    public static class ForwardServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            this.getServletContext().getRequestDispatcher("/content").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static class DumpServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String n = (String)e.nextElement();
                response.getWriter().printf("%s: %s\n", n, req.getParameter(n));
            }
        }
    }

    public static class EchoServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType(req.getContentType());
            IO.copy((InputStream)req.getInputStream(), (OutputStream)response.getOutputStream());
        }

        protected void doPost(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            this.doGet(req, response);
        }
    }

    public static class BufferServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            HttpOutput out = (HttpOutput)response.getOutputStream();
            ByteBuffer buffer = BufferUtil.toBuffer((byte[])__bytes).asReadOnlyBuffer();
            response.setContentLength(buffer.remaining());
            response.setContentType("text/plain");
            out.write(buffer);
        }
    }

    public static class AsyncServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, final HttpServletResponse response) throws ServletException, IOException {
            final String writes = req.getParameter("writes");
            AsyncContext context = req.startAsync();
            final ServletOutputStream out = response.getOutputStream();
            out.setWriteListener(new WriteListener(){
                int count;
                {
                    this.count = writes == null ? 1 : Integer.valueOf(writes);
                    response.setContentLength(this.count * __bytes.length);
                }

                public void onWritePossible() throws IOException {
                    while (out.isReady()) {
                        if (this.count-- == 0) {
                            out.close();
                            break;
                        }
                        out.write(__bytes);
                    }
                }

                public void onError(Throwable t) {
                    t.printStackTrace();
                }
            });
        }
    }

    public static class TestServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            if (req.getParameter("vary") != null) {
                response.addHeader("Vary", req.getParameter("vary"));
            }
            response.setHeader("ETag", __contentETag);
            String ifnm = req.getHeader("If-None-Match");
            if (ifnm != null && ifnm.equals(__contentETag)) {
                response.setStatus(304);
                response.flushBuffer();
            } else {
                PrintWriter writer = response.getWriter();
                writer.write(GzipHandlerTest.__content);
            }
        }

        protected void doDelete(HttpServletRequest req, HttpServletResponse response) throws IOException {
            String ifm = req.getHeader("If-Match");
            if (ifm != null && ifm.equals(__contentETag)) {
                response.sendError(204);
            } else {
                response.sendError(304);
            }
        }
    }

    public static class MicroChunkedServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            PrintWriter writer = response.getWriter();
            writer.write(__micro);
            response.flushBuffer();
        }
    }

    public static class MicroServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("ETag", __contentETag);
            String ifnm = req.getHeader("If-None-Match");
            if (ifnm != null && ifnm.equals(__contentETag)) {
                response.sendError(304);
            } else {
                PrintWriter writer = response.getWriter();
                writer.write(__micro);
            }
        }
    }
}

