/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.EventListener;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListenerHolderTest {
    @Test
    public void testCreateInstance() throws Exception {
        try (StacklessLogging ignore = new StacklessLogging(new Class[]{ServletHandler.class, ServletContextHandler.class});){
            ListenerHolder holder = new ListenerHolder();
            holder.setHeldClass(DummyListener.class);
            EventListener listener = holder.createInstance();
            Assertions.assertNotNull((Object)listener);
            Server server = new Server();
            ServletContextHandler context = new ServletContextHandler();
            server.setHandler((Handler)context);
            ServletHandler handler = context.getServletHandler();
            handler.addListener(holder);
            holder.setServletHandler(handler);
            context.start();
            Assertions.assertNotNull((Object)holder.getListener());
        }
    }

    public static class DummyListener
    implements EventListener {
    }
}

