/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.Part;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.util.BytesRequestContent;
import org.eclipse.jetty.client.util.MultiPartRequestContent;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.MultiPartFormInputStream;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.IO;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiPartServletTest {
    private Server server;
    private ServerConnector connector;
    private HttpClient client;
    private Path tmpDir;
    private static final int MAX_FILE_SIZE = 524288;
    private static final int LARGE_MESSAGE_SIZE = 0x100000;

    @BeforeEach
    public void start() throws Exception {
        this.tmpDir = Files.createTempDirectory(MultiPartServletTest.class.getSimpleName(), new FileAttribute[0]);
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler contextHandler = new ServletContextHandler(1);
        contextHandler.setContextPath("/");
        ServletHolder servletHolder = contextHandler.addServlet(MultiPartServlet.class, "/");
        MultipartConfigElement config = new MultipartConfigElement(this.tmpDir.toAbsolutePath().toString(), 524288L, -1L, 1);
        servletHolder.getRegistration().setMultipartConfig(config);
        this.server.setHandler((Handler)contextHandler);
        this.server.start();
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterEach
    public void stop() throws Exception {
        this.client.stop();
        this.server.stop();
        IO.delete((File)this.tmpDir.toFile());
    }

    @Test
    public void testTempFilesDeletedOnError() throws Exception {
        byte[] byteArray = new byte[0x100000];
        Arrays.fill(byteArray, (byte)1);
        BytesRequestContent content = new BytesRequestContent((byte[][])new byte[][]{byteArray});
        MultiPartRequestContent multiPart = new MultiPartRequestContent();
        multiPart.addFieldPart("largePart", (Request.Content)content, null);
        multiPart.close();
        try (StacklessLogging ignored = new StacklessLogging(new Class[]{HttpChannel.class, MultiPartFormInputStream.class});){
            ContentResponse response = this.client.newRequest("localhost", this.connector.getLocalPort()).scheme(HttpScheme.HTTP.asString()).method(HttpMethod.POST).body((Request.Content)multiPart).send();
            Assertions.assertEquals((int)500, (int)response.getStatus());
            MatcherAssert.assertThat((Object)response.getContentAsString(), (Matcher)Matchers.containsString((String)"Multipart Mime part largePart exceeds max filesize"));
        }
        MatcherAssert.assertThat((Object)this.tmpDir.toFile().list().length, (Matcher)Matchers.is((Object)0));
    }

    public static class MultiPartServlet
    extends HttpServlet {
        protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            if (!req.getContentType().contains(MimeTypes.Type.MULTIPART_FORM_DATA.asString())) {
                resp.setContentType("text/plain");
                resp.getWriter().println("not content type " + MimeTypes.Type.MULTIPART_FORM_DATA);
                resp.getWriter().println("contentType: " + req.getContentType());
                return;
            }
            resp.setContentType("text/plain");
            for (Part part : req.getParts()) {
                resp.getWriter().println("Part: name=" + part.getName() + ", size=" + part.getSize());
            }
        }
    }
}

