/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpTester;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.StringUtil;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ResponseHeadersTest {
    private static Server server;
    private static LocalConnector connector;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new Server();
        connector = new LocalConnector(server);
        server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new SimulateUpgradeServlet()), "/ws/*");
        context.addServlet(new ServletHolder((Servlet)new MultilineResponseValueServlet()), "/multiline/*");
        context.addServlet(CharsetResetToJsonMimeTypeServlet.class, "/charset/json-reset/*");
        context.addServlet(CharsetChangeToJsonMimeTypeServlet.class, "/charset/json-change/*");
        context.addServlet(CharsetChangeToJsonMimeTypeSetCharsetToNullServlet.class, "/charset/json-change-null/*");
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        try {
            server.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    @Test
    public void testResponseWebSocketHeaderFormat() throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/ws/");
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)101));
        MatcherAssert.assertThat((String)"Response Header Upgrade", (Object)response.get("Upgrade"), (Matcher)Matchers.is((Object)"WebSocket"));
        MatcherAssert.assertThat((String)"Response Header Connection", (Object)response.get("Connection"), (Matcher)Matchers.is((Object)"Upgrade"));
    }

    @Test
    public void testMultilineResponseHeaderValue() throws Exception {
        String actualPathInfo = "%0A%20Content-Type%3A%20image/png%0A%20Content-Length%3A%208%0A%20%0A%20yuck<!--";
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/multiline/" + actualPathInfo);
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Connection", "close");
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response Header Content-Type", (Object)response.get("Content-Type"), (Matcher)Matchers.is((Object)"text/plain;charset=UTF-8"));
        String expected = StringUtil.replace((String)actualPathInfo, (String)"%0A", (String)" ");
        expected = URLDecoder.decode(expected, "utf-8");
        expected = expected.trim();
        MatcherAssert.assertThat((String)"Response Header X-example", (Object)response.get("X-Example"), (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testCharsetResetToJsonMimeType() throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/charset/json-reset/");
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Connection", "close");
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response Header Content-Type", (Object)response.get("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
    }

    @Test
    public void testCharsetChangeToJsonMimeType() throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/charset/json-change/");
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Connection", "close");
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response Header Content-Type", (Object)response.get("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
    }

    @Test
    public void testCharsetChangeToJsonMimeTypeSetCharsetToNull() throws Exception {
        HttpTester.Request request = new HttpTester.Request();
        request.setMethod("GET");
        request.setURI("/charset/json-change-null/");
        request.setVersion(HttpVersion.HTTP_1_1);
        request.setHeader("Connection", "close");
        request.setHeader("Host", "test");
        ByteBuffer responseBuffer = connector.getResponse(request.generate());
        HttpTester.Response response = HttpTester.parseResponse((ByteBuffer)responseBuffer);
        MatcherAssert.assertThat((String)"Response Code", (Object)response.getStatus(), (Matcher)Matchers.is((Object)200));
        MatcherAssert.assertThat((String)"Response Header Content-Type", (Object)response.get("Content-Type"), (Matcher)Matchers.is((Object)"application/json"));
    }

    public static class CharsetChangeToJsonMimeTypeSetCharsetToNullServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html; charset=us-ascii");
            PrintWriter writer = response.getWriter();
            response.setContentType("application/json");
            response.setCharacterEncoding(null);
            writer.println("{ \"what\": \"should this be?\" }");
        }
    }

    public static class CharsetChangeToJsonMimeTypeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html; charset=US-ASCII");
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.println("{ \"what\": \"should this be?\" }");
        }
    }

    public static class CharsetResetToJsonMimeTypeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/html; charset=US-ASCII");
            PrintWriter writer = response.getWriter();
            response.reset();
            response.setContentType("application/json");
            writer.println("{ \"what\": \"should this be?\" }");
        }
    }

    public static class MultilineResponseValueServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            String pathInfo = req.getPathInfo();
            if (pathInfo != null && pathInfo.length() > 1 && pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            response.setHeader("X-example", pathInfo);
            response.setContentType("text/plain");
            response.setCharacterEncoding("utf-8");
            response.getWriter().println("Got request uri - " + req.getRequestURI());
        }
    }

    public static class SimulateUpgradeServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
            response.setHeader("Upgrade", "WebSocket");
            response.addHeader("Connection", "Upgrade");
            response.addHeader("Sec-WebSocket-Accept", "123456789==");
            response.setStatus(101);
        }
    }
}

