/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.FilterRegistration;
import jakarta.servlet.GenericServlet;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextAttributeEvent;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletRequestAttributeEvent;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestEvent;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.logging.StacklessLogging;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.RoleInfo;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.AbstractHandlerContainer;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletContextHandlerTest {
    private Server _server;
    private LocalConnector _connector;
    private static final AtomicInteger __testServlets = new AtomicInteger();
    private static int __initIndex = 0;
    private static int __destroyIndex = 0;

    @BeforeEach
    public void createServer() {
        this._server = new Server();
        this._connector = new LocalConnector(this._server);
        this._server.addConnector((Connector)this._connector);
        __testServlets.set(0);
    }

    @AfterEach
    public void destroyServer() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testInitParams() throws Exception {
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)this._server, "/", 1);
        this._server.setHandler((Handler)root);
        ListenerHolder initialListener = new ListenerHolder();
        initialListener.setListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                sce.getServletContext().setInitParameter("foo", "bar");
                Assertions.assertEquals((Object)"bar", (Object)sce.getServletContext().getInitParameter("foo"));
                Assertions.assertThrows(NullPointerException.class, () -> sce.getServletContext().setInitParameter(null, "bad"));
                Assertions.assertThrows(NullPointerException.class, () -> sce.getServletContext().getInitParameter(null));
            }
        });
        root.getServletHandler().addListener(initialListener);
        this._server.start();
    }

    @Test
    public void testGetSetSessionTimeout() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        int startMin = 7;
        Integer timeout = 100;
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        root.getSessionHandler().setMaxInactiveInterval((int)TimeUnit.MINUTES.toSeconds(startMin));
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new MySCI(true, timeout)), true);
        this._server.start();
        Assertions.assertEquals((int)startMin, (Integer)((Integer)root.getServletContext().getAttribute("MYSCI.startSessionTimeout")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MYSCI.setSessionTimeout")));
        Assertions.assertEquals((Integer)timeout, (Integer)((Integer)root.getServletContext().getAttribute("MYSCI.getSessionTimeout")));
        Assertions.assertNull((Object)root.getAttribute("MYSCI.sessionTimeoutFailure"));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.getSessionTimeout")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.setSessionTimeout")));
    }

    @Test
    public void testDestroyOrder() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        ListenerHolder listenerHolder = new ListenerHolder();
        StopTestListener stopTestListener = new StopTestListener();
        listenerHolder.setListener((EventListener)((Object)stopTestListener));
        root.getServletHandler().addListener(listenerHolder);
        ServletHolder servletHolder = new ServletHolder();
        StopTestServlet stopTestServlet = new StopTestServlet();
        servletHolder.setServlet((Servlet)stopTestServlet);
        root.addServlet(servletHolder, "/test");
        FilterHolder filterHolder = new FilterHolder();
        StopTestFilter stopTestFilter = new StopTestFilter();
        filterHolder.setFilter((Filter)stopTestFilter);
        root.addFilter(filterHolder, "/*", EnumSet.of(DispatcherType.REQUEST));
        this._server.start();
        this._server.stop();
        Assertions.assertEquals((int)0, (int)stopTestListener._initIndex);
        Assertions.assertEquals((int)1, (int)stopTestFilter._initIndex);
        Assertions.assertEquals((int)2, (int)stopTestServlet._initIndex);
        Assertions.assertEquals((int)0, (int)stopTestFilter._destroyIndex);
        Assertions.assertEquals((int)1, (int)stopTestServlet._destroyIndex);
        Assertions.assertEquals((int)2, (int)stopTestListener._destroyIndex);
    }

    @Test
    public void testAddSessionListener() {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        MySessionHandler sessions = new MySessionHandler();
        root.setSessionHandler((SessionHandler)sessions);
        Assertions.assertNotNull((Object)((Object)sessions));
        root.addEventListener((EventListener)((Object)new MyTestSessionListener()));
        sessions.checkSessionAttributeListeners(1);
        sessions.checkSessionIdListeners(0);
        sessions.checkSessionListeners(1);
    }

    @Test
    public void testListenerFromSCI() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new MySCI()), true);
        this._server.start();
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MySCI.startup")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MySCI.defaultSessionTrackingModes")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MySCI.effectiveSessionTrackingModes")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MySCI.setSessionTrackingModes")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.contextInitialized")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.defaultSessionTrackingModes")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.effectiveSessionTrackingModes")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("MyContextListener.setSessionTrackingModes")));
    }

    @Test
    public void testContextInitializationDestruction() throws Exception {
        Server server = new Server();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        class TestServletContextListener
        implements ServletContextListener {
            public int initialized = 0;
            public int destroyed = 0;

            TestServletContextListener() {
            }

            public void contextInitialized(ServletContextEvent sce) {
                ++this.initialized;
            }

            public void contextDestroyed(ServletContextEvent sce) {
                ++this.destroyed;
            }
        }
        TestServletContextListener listener = new TestServletContextListener();
        root.addEventListener((EventListener)((Object)listener));
        server.start();
        server.stop();
        Assertions.assertEquals((int)1, (int)listener.initialized);
        server.stop();
        Assertions.assertEquals((int)1, (int)listener.destroyed);
    }

    @Test
    public void testListenersFromContextListener() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        ListenerHolder initialListener = new ListenerHolder();
        initialListener.setListener((EventListener)((Object)new InitialListener()));
        root.getServletHandler().addListener(initialListener);
        root.addServlet(TestServlet.class, "/test");
        this._server.start();
        ListenerHolder[] listenerHolders = root.getServletHandler().getListeners();
        Assertions.assertNotNull((Object)listenerHolders);
        for (ListenerHolder l : listenerHolders) {
            Assertions.assertTrue((boolean)l.isStarted());
            Assertions.assertNotNull((Object)l.getListener());
            if ("org.eclipse.jetty.servlet.ServletContextHandlerTest$InitialListener".equals(l.getClassName())) continue;
            Assertions.assertFalse((boolean)root.isDurableListener(l.getListener()));
            Assertions.assertTrue((boolean)root.isProgrammaticListener(l.getListener()));
        }
        ArrayList<String> listenerClassNames = new ArrayList<String>();
        for (EventListener l : root.getEventListeners()) {
            listenerClassNames.add(l.getClass().getName());
        }
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySCAListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MyRequestListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MyRAListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySAListener"));
        Assertions.assertTrue((boolean)listenerClassNames.contains("org.eclipse.jetty.servlet.ServletContextHandlerTest$MySIListener"));
        String response = this._connector.getResponse("GET /test?req=all HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MyRAListener.adds);
        Assertions.assertEquals((int)1, (int)MyRAListener.replaces);
        Assertions.assertEquals((int)1, (int)MyRAListener.removes);
        response = this._connector.getResponse("GET /test?session=create HTTP/1.0\r\n\r\n");
        String sessionid = response.substring(response.indexOf("JSESSIONID"), response.indexOf(";"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.creates);
        Assertions.assertEquals((int)1, (int)MySAListener.adds);
        Assertions.assertEquals((int)0, (int)MySAListener.replaces);
        Assertions.assertEquals((int)0, (int)MySAListener.removes);
        StringBuffer request = new StringBuffer();
        request.append("GET /test?session=replace HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.creates);
        Assertions.assertEquals((int)1, (int)MySAListener.adds);
        Assertions.assertEquals((int)1, (int)MySAListener.replaces);
        Assertions.assertEquals((int)0, (int)MySAListener.removes);
        request = new StringBuffer();
        request.append("GET /test?session=remove HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.creates);
        Assertions.assertEquals((int)1, (int)MySAListener.adds);
        Assertions.assertEquals((int)1, (int)MySAListener.replaces);
        Assertions.assertEquals((int)1, (int)MySAListener.removes);
        request = new StringBuffer();
        request.append("GET /test?session=change HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySIListener.changes);
        sessionid = response.substring(response.indexOf("JSESSIONID"), response.indexOf(";"));
        request = new StringBuffer();
        request.append("GET /test?session=delete HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("Cookie: ").append(sessionid).append("\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySListener.destroys);
        Assertions.assertEquals((int)1, (int)MySCAListener.adds);
        response = this._connector.getResponse("GET /test?ctx=all HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)1, (int)MySCAListener.replaces);
        Assertions.assertEquals((int)1, (int)MySCAListener.removes);
    }

    @Test
    public void testFindContainer() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/", 1);
        SessionHandler session = root.getSessionHandler();
        ServletHandler servlet = root.getServletHandler();
        ConstraintSecurityHandler security = new ConstraintSecurityHandler();
        root.setSecurityHandler((SecurityHandler)security);
        this._server.start();
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)session));
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)security));
        Assertions.assertEquals((Object)root, (Object)AbstractHandlerContainer.findContainerOf((HandlerContainer)this._server, ContextHandler.class, (Handler)servlet));
    }

    @Test
    public void testInitOrder() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        ServletHolder holder0 = context.addServlet(TestServlet.class, "/test0");
        ServletHolder holder1 = context.addServlet(TestServlet.class, "/test1");
        ServletHolder holder2 = context.addServlet(TestServlet.class, "/test2");
        holder1.setInitOrder(1);
        holder2.setInitOrder(2);
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        String response = this._connector.getResponse("GET /test1 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        response = this._connector.getResponse("GET /test2 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)2, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.nullValue());
        response = this._connector.getResponse("GET /test0 HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        Assertions.assertEquals((int)3, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assertions.assertEquals((int)0, (int)__testServlets.get());
        holder0.setInitOrder(0);
        this._server.start();
        Assertions.assertEquals((int)3, (int)__testServlets.get());
        MatcherAssert.assertThat((Object)holder0.getServletInstance(), (Matcher)Matchers.notNullValue(Servlet.class));
        this._server.stop();
        Assertions.assertEquals((int)0, (int)__testServlets.get());
    }

    @Test
    public void testAddServletFromServlet() {
        Logger logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            ServletHolder holder = context.addServlet(ServletAddingServlet.class, "/start");
            context.getServletHandler().setStartWithUnavailable(false);
            holder.setInitOrder(0);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            ServletException se = (ServletException)Assertions.assertThrows(ServletException.class, () -> ((Server)this._server).start());
            MatcherAssert.assertThat((String)"Servlet can only be added from SCI or SCL", (Object)se.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void testCreateMethodsFromSCI() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        class FilterCreatingSCI
        implements ServletContainerInitializer {
            FilterCreatingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
                try {
                    ctx.createFilter(MyFilter.class);
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
                try {
                    ctx.createServlet(HelloServlet.class);
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
                try {
                    ctx.createListener(MyContextListener.class);
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new FilterCreatingSCI()), true);
        this._server.start();
    }

    @Test
    public void testCreateMethodsFromSCL() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        class ListenerCreatingSCI
        implements ServletContainerInitializer {
            ListenerCreatingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
                ctx.addListener((EventListener)((Object)new CreatingSCL()));
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new ListenerCreatingSCI()), true);
        this._server.start();
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("CreatingSCL.filter")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("CreatingSCL.servlet")));
        Assertions.assertTrue((boolean)((Boolean)root.getServletContext().getAttribute("CreatingSCL.listener")));
    }

    @Test
    public void testAddFilterFromServlet() {
        Logger logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            ServletHolder holder = context.addServlet(FilterAddingServlet.class, "/filter");
            context.getServletHandler().setStartWithUnavailable(false);
            holder.setInitOrder(0);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            ServletException se = (ServletException)Assertions.assertThrows(ServletException.class, () -> ((Server)this._server).start());
            MatcherAssert.assertThat((String)"Filter can only be added from SCI or SCL", (Object)se.getCause(), (Matcher)Matchers.instanceOf(IllegalStateException.class));
        }
    }

    @Test
    public void testAddServletByClassFromFilter() {
        Logger logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            FilterHolder holder = new FilterHolder(new Filter(){

                public void init(FilterConfig filterConfig) {
                    ServletRegistration.Dynamic rego = filterConfig.getServletContext().addServlet("hello", HelloServlet.class);
                    rego.addMapping(new String[]{"/hello/*"});
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                }

                public void destroy() {
                }
            });
            context.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.getServletHandler().setStartWithUnavailable(false);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Server)this._server).start(), (String)"Servlet can only be added from SCI or SCL");
        }
    }

    @Test
    public void testAddServletByInstanceFromFilter() {
        Logger logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            FilterHolder holder = new FilterHolder(new Filter(){

                public void init(FilterConfig filterConfig) {
                    ServletRegistration.Dynamic rego = filterConfig.getServletContext().addServlet("hello", (Servlet)new HelloServlet());
                    rego.addMapping(new String[]{"/hello/*"});
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                }

                public void destroy() {
                }
            });
            context.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.getServletHandler().setStartWithUnavailable(false);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Server)this._server).start(), (String)"Servlet can only be added from SCI or SCL");
        }
    }

    @Test
    public void testAddServletByClassNameFromFilter() {
        Logger logger = LoggerFactory.getLogger((String)(ContextHandler.class.getName() + "ROOT"));
        try (StacklessLogging ignored = new StacklessLogging(new Logger[]{logger});){
            ServletContextHandler context = new ServletContextHandler();
            context.setLogger(logger);
            FilterHolder holder = new FilterHolder(new Filter(){

                public void init(FilterConfig filterConfig) {
                    ServletRegistration.Dynamic rego = filterConfig.getServletContext().addServlet("hello", HelloServlet.class.getName());
                    rego.addMapping(new String[]{"/hello/*"});
                }

                public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
                }

                public void destroy() {
                }
            });
            context.addFilter(holder, "/*", EnumSet.of(DispatcherType.REQUEST));
            context.getServletHandler().setStartWithUnavailable(false);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            Assertions.assertThrows(IllegalStateException.class, () -> ((Server)this._server).start(), (String)"Servlet can only be added from SCI or SCL");
        }
    }

    @Test
    public void testAddFilterServletFromSCL() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.getServletHandler().setStartWithUnavailable(false);
        context.setContextPath("/");
        context.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                sce.getServletContext().addFilter("filter", (Filter)new MyFilter()).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
                ServletRegistration.Dynamic rego = sce.getServletContext().addServlet("hello", HelloServlet.class);
                rego.addMapping(new String[]{"/hello/*"});
            }

            public void contextDestroyed(ServletContextEvent sce) {
            }
        });
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"filter: filter"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testAddFilterServletFromSCI() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        class ServletAddingSCI
        implements ServletContainerInitializer {
            ServletAddingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) {
                ctx.addFilter("filter", (Filter)new MyFilter()).addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), true, new String[]{"/*"});
                ServletRegistration.Dynamic rego = ctx.addServlet("hello", HelloServlet.class);
                rego.addMapping(new String[]{"/hello/*"});
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new ServletAddingSCI()), true);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"filter: filter"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testAddJspFile() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        ServletHolder jspServlet = new ServletHolder();
        jspServlet.setName("jsp");
        jspServlet.setHeldClass(FakeJspServlet.class);
        root.addServlet(jspServlet, "*.jsp");
        Assertions.assertThrows(IllegalArgumentException.class, () -> root.getServletContext().addJspFile(null, "/path/to/some.jsp"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> root.getServletContext().addJspFile("", "/path/to/some.jsp"));
        class JSPAddingSCI
        implements ServletContainerInitializer {
            JSPAddingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
                try {
                    ServletRegistration.Dynamic rego = ctx.addJspFile("some.jsp", "/path/to/some.jsp");
                    rego.addMapping(new String[]{"/somejsp/*"});
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new JSPAddingSCI()), true);
        this._server.start();
        ServletHandler.MappedServlet mappedServlet = root.getServletHandler().getMappedServlet("/somejsp/xxx");
        Assertions.assertNotNull((Object)mappedServlet.getServletHolder());
        Assertions.assertEquals((Object)"some.jsp", (Object)mappedServlet.getServletHolder().getName());
    }

    @Test
    public void testAddJspFileWithExistingRegistration() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        ServletHolder jspServlet = new ServletHolder();
        jspServlet.setName("jsp");
        jspServlet.setHeldClass(FakeJspServlet.class);
        root.addServlet(jspServlet, "*.jsp");
        ServletHolder barServlet = new ServletHolder();
        barServlet.setName("some.jsp");
        barServlet.setHeldClass(HelloServlet.class);
        root.addServlet(barServlet, "/bar/*");
        class JSPAddingSCI
        implements ServletContainerInitializer {
            JSPAddingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
                try {
                    ServletRegistration.Dynamic rego = ctx.addJspFile("some.jsp", "/path/to/some.jsp");
                    Assertions.assertNull((Object)rego);
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new JSPAddingSCI()), true);
        this._server.start();
    }

    @Test
    public void testAddJspFileWithPartialRegistration() throws Exception {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this._server.setHandler((Handler)contexts);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)contexts, "/");
        ServletHolder jspServlet = new ServletHolder();
        jspServlet.setName("jsp");
        jspServlet.setHeldClass(FakeJspServlet.class);
        root.addServlet(jspServlet, "*.jsp");
        ServletHolder barServlet = new ServletHolder();
        barServlet.setName("some.jsp");
        root.addServlet(barServlet, "/bar/*");
        class JSPAddingSCI
        implements ServletContainerInitializer {
            JSPAddingSCI() {
            }

            public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
                try {
                    ServletRegistration.Dynamic rego = ctx.addJspFile("some.jsp", "/path/to/some.jsp");
                    Assertions.assertNotNull((Object)rego);
                }
                catch (Exception e) {
                    Assertions.fail((Throwable)e);
                }
            }
        }
        root.addBean((Object)new MySCIStarter(root.getServletContext(), new JSPAddingSCI()), true);
        this._server.start();
        ServletHandler.MappedServlet mappedServlet = root.getServletHandler().getMappedServlet("/bar/xxx");
        Assertions.assertNotNull((Object)mappedServlet.getServletHolder());
        Assertions.assertEquals((Object)"some.jsp", (Object)mappedServlet.getServletHolder().getName());
    }

    @Test
    public void testAddServletAfterStart() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testServletRegistrationByClass() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class);
        reg.addMapping(new String[]{"/test"});
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testServletRegistrationByClassName() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class.getName());
        reg.addMapping(new String[]{"/test"});
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testPartialServletRegistrationByName() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder partial = new ServletHolder();
        partial.setName("test");
        context.addServlet(partial, "/test");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class.getName());
        Assertions.assertNotNull((Object)reg);
        Assertions.assertEquals((Object)TestServlet.class.getName(), (Object)partial.getClassName());
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testPartialServletRegistrationByClass() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder partial = new ServletHolder();
        partial.setName("test");
        context.addServlet(partial, "/test");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class);
        Assertions.assertNotNull((Object)reg);
        Assertions.assertEquals((Object)TestServlet.class.getName(), (Object)partial.getClassName());
        Assertions.assertSame(TestServlet.class, (Object)partial.getHeldClass());
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testNullServletRegistration() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder full = new ServletHolder();
        full.setName("test");
        full.setHeldClass(TestServlet.class);
        context.addServlet(full, "/test");
        ServletRegistration.Dynamic reg = context.getServletContext().addServlet("test", TestServlet.class);
        Assertions.assertNull((Object)reg);
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
    }

    @Test
    public void testHandlerBeforeServletHandler() throws Exception {
        ServletContextHandler context = new ServletContextHandler(1);
        HandlerWrapper extra = new HandlerWrapper();
        context.getSessionHandler().insertHandler(extra);
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuilder request = new StringBuilder();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        Assertions.assertEquals((Object)extra, (Object)context.getSessionHandler().getHandler());
    }

    @Test
    public void testReplaceServletHandlerWithServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        srvHnd.addServletWithMapping(HelloServlet.class, "/hello");
        context.setServletHandler(srvHnd);
        context.start();
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testSetSecurityHandler() {
        ServletContextHandler context = new ServletContextHandler(3);
        Assertions.assertNotNull((Object)context.getSessionHandler());
        SessionHandler sessionHandler = context.getSessionHandler();
        Assertions.assertNotNull((Object)context.getSecurityHandler());
        SecurityHandler securityHandler = context.getSecurityHandler();
        HandlerWrapper h = (HandlerWrapper)context.getHandler();
        Assertions.assertSame((Object)h, (Object)sessionHandler);
        h = (HandlerWrapper)h.getHandler();
        Assertions.assertSame((Object)h, (Object)securityHandler);
        SecurityHandler myHandler = new SecurityHandler(){

            protected RoleInfo prepareConstraintInfo(String pathInContext, Request request) {
                return null;
            }

            protected boolean checkUserDataPermissions(String pathInContext, Request request, Response response, RoleInfo constraintInfo) {
                return false;
            }

            protected boolean isAuthMandatory(Request baseRequest, Response baseResponse, Object constraintInfo) {
                return false;
            }

            protected boolean checkWebResourcePermissions(String pathInContext, Request request, Response response, Object constraintInfo, UserIdentity userIdentity) {
                return false;
            }
        };
        context.setSecurityHandler(myHandler);
        Assertions.assertSame((Object)myHandler, (Object)context.getSecurityHandler());
        h = (HandlerWrapper)context.getHandler();
        Assertions.assertSame((Object)h, (Object)sessionHandler);
        h = (HandlerWrapper)h.getHandler();
        Assertions.assertSame((Object)h, (Object)myHandler);
    }

    @Test
    public void testReplaceServletHandlerWithoutServlet() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.addServlet(TestServlet.class, "/test");
        context.setContextPath("/");
        this._server.setHandler((Handler)context);
        this._server.start();
        StringBuffer request = new StringBuffer();
        request.append("GET /test HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        String response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Test"));
        context.stop();
        ServletHandler srvHnd = new ServletHandler();
        context.setServletHandler(srvHnd);
        context.start();
        context.addServlet(HelloServlet.class, "/hello");
        request = new StringBuffer();
        request.append("GET /hello HTTP/1.0\n");
        request.append("Host: localhost\n");
        request.append("\n");
        response = this._connector.getResponse(request.toString());
        MatcherAssert.assertThat((String)"Response", (Object)response, (Matcher)Matchers.containsString((String)"Hello World"));
    }

    @Test
    public void testReplaceHandler() throws Exception {
        ServletContextHandler servletContextHandler = new ServletContextHandler();
        ServletHolder sh = new ServletHolder((Servlet)new TestServlet());
        servletContextHandler.addServlet(sh, "/foo");
        final AtomicBoolean contextInit = new AtomicBoolean(false);
        final AtomicBoolean contextDestroy = new AtomicBoolean(false);
        servletContextHandler.addEventListener((EventListener)new ServletContextListener(){

            public void contextInitialized(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextInit.set(true);
                }
            }

            public void contextDestroyed(ServletContextEvent sce) {
                if (sce.getServletContext() != null) {
                    contextDestroy.set(true);
                }
            }
        });
        ServletHandler shandler = servletContextHandler.getServletHandler();
        ResourceHandler rh = new ResourceHandler();
        servletContextHandler.insertHandler((HandlerWrapper)rh);
        Assertions.assertEquals((Object)shandler, (Object)servletContextHandler.getServletHandler());
        Assertions.assertEquals((Object)rh, (Object)servletContextHandler.getHandler());
        Assertions.assertEquals((Object)rh.getHandler(), (Object)shandler);
        this._server.setHandler((Handler)servletContextHandler);
        this._server.start();
        Assertions.assertTrue((boolean)contextInit.get());
        this._server.stop();
        Assertions.assertTrue((boolean)contextDestroy.get());
    }

    @Test
    public void testFallThrough() throws Exception {
        HandlerList list = new HandlerList();
        this._server.setHandler((Handler)list);
        ServletContextHandler root = new ServletContextHandler((HandlerContainer)list, "/", 1);
        ServletHandler servlet = root.getServletHandler();
        servlet.setEnsureDefaultServlet(false);
        servlet.addServletWithMapping(HelloServlet.class, "/hello/*");
        list.addHandler((Handler)new AbstractHandler(){

            public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.sendError(404, "Fell Through");
            }
        });
        this._server.start();
        String response = this._connector.getResponse("GET /hello HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        response = this._connector.getResponse("GET /other HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"404 Fell Through"));
    }

    @Test
    public void testUtilDecorator() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        context.getObjectFactory().addDecorator((Decorator)new DummyUtilDecorator());
        this._server.setHandler((Handler)context);
        context.addServlet(DecoratedObjectFactoryServlet.class, "/objfactory/*");
        this._server.start();
        String response = this._connector.getResponse("GET /objfactory/ HTTP/1.0\r\n\r\n");
        MatcherAssert.assertThat((String)"Response status code", (Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        String expected = String.format("Attribute[%s] = %s", DecoratedObjectFactory.ATTR, DecoratedObjectFactory.class.getName());
        MatcherAssert.assertThat((String)"Has context attribute", (Object)response, (Matcher)Matchers.containsString((String)expected));
        MatcherAssert.assertThat((String)"Decorators size", (Object)response, (Matcher)Matchers.containsString((String)"Decorators.size = [2]"));
        expected = String.format("decorator[] = %s", DummyUtilDecorator.class.getName());
        MatcherAssert.assertThat((String)"Specific Legacy Decorator", (Object)response, (Matcher)Matchers.containsString((String)expected));
    }

    @Test
    public void testProgrammaticListener() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        final ServletHandler handler = new ServletHandler();
        this._server.setHandler((Handler)context);
        context.setHandler((Handler)handler);
        handler.addServletWithMapping(new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.getOutputStream().print("Listeners=" + req.getAttribute("testRequestListener"));
            }
        }), "/");
        handler.addListener(new ListenerHolder(TestPListener.class));
        handler.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            public void init() throws ServletException {
                handler.addListener(new ListenerHolder(TestPListener.class));
            }
        }){
            {
                this.setInitOrder(1);
            }
        });
        this._server.start();
        handler.addListener(new ListenerHolder(TestPListener.class));
        String request = "GET /test HTTP/1.0\nHost: localhost\n\n";
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Listeners=3"));
    }

    @Test
    public void testProgrammaticFilters() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        final ServletHandler handler = new ServletHandler();
        this._server.setHandler((Handler)context);
        context.setHandler((Handler)handler);
        handler.addServletWithMapping(new ServletHolder((Servlet)new HttpServlet(){

            protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
                resp.getOutputStream().print("Filters=" + req.getAttribute("testFilter"));
            }
        }), "/");
        handler.addFilterWithMapping(new FilterHolder(TestPFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        handler.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            public void init() throws ServletException {
                handler.addFilterWithMapping(new FilterHolder(TestPFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
            }
        }){
            {
                this.setInitOrder(1);
            }
        });
        this._server.start();
        handler.addFilterWithMapping(new FilterHolder(TestPFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
        String request = "GET /test HTTP/1.0\nHost: localhost\n\n";
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"Filters=3"));
    }

    @Test
    public void testProgrammaticServlets() throws Exception {
        ServletContextHandler context = new ServletContextHandler();
        final ServletHandler handler = new ServletHandler();
        this._server.setHandler((Handler)context);
        context.setHandler((Handler)handler);
        handler.addServletWithMapping(new ServletHolder(TestPServlet.class), "/one");
        handler.addServlet(new ServletHolder((Servlet)new HttpServlet(){

            public void init() throws ServletException {
                handler.addServletWithMapping(new ServletHolder(TestPServlet.class), "/two");
            }
        }){
            {
                this.setInitOrder(1);
            }
        });
        this._server.start();
        handler.addServletWithMapping(new ServletHolder(TestPServlet.class), "/three");
        String request = "GET /one HTTP/1.0\nHost: localhost\n\n";
        String response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/one"));
        request = "GET /two HTTP/1.0\nHost: localhost\n\n";
        response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/two"));
        request = "GET /three HTTP/1.0\nHost: localhost\n\n";
        response = this._connector.getResponse(request);
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"200 OK"));
        MatcherAssert.assertThat((Object)response, (Matcher)Matchers.containsString((String)"/three"));
    }

    public static class TestPServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getOutputStream().println(req.getRequestURI());
        }
    }

    public static class TestPFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            Integer count = (Integer)request.getAttribute("testFilter");
            request.setAttribute("testFilter", (Object)(count == null ? 1 : count + 1));
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class TestPListener
    implements ServletRequestListener {
        public void requestInitialized(ServletRequestEvent sre) {
            ServletRequest request;
            Integer count = (Integer)(request = sre.getServletRequest()).getAttribute("testRequestListener");
            request.setAttribute("testRequestListener", (Object)(count == null ? 1 : count + 1));
        }

        public void requestDestroyed(ServletRequestEvent sre) {
        }
    }

    public static class TestServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        public void destroy() {
            super.destroy();
            __testServlets.decrementAndGet();
        }

        public void init() throws ServletException {
            __testServlets.incrementAndGet();
            super.init();
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Test");
            String action = req.getParameter("session");
            if (!Objects.isNull(action)) {
                if ("create".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(true);
                    session.setAttribute("some", (Object)"thing");
                } else if ("change".equalsIgnoreCase(action)) {
                    req.getSession(true);
                    req.changeSessionId();
                } else if ("replace".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(false);
                    session.setAttribute("some", (Object)"other");
                } else if ("remove".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(false);
                    session.removeAttribute("some");
                } else if ("delete".equalsIgnoreCase(action)) {
                    HttpSession session = req.getSession(false);
                    session.invalidate();
                } else {
                    resp.setStatus(400);
                }
                return;
            }
            action = req.getParameter("req");
            if (!Objects.isNull(action)) {
                req.setAttribute("some", (Object)"value");
                req.setAttribute("some", (Object)"other");
                req.removeAttribute("some");
                return;
            }
            action = req.getParameter("ctx");
            if (!Objects.isNull(action)) {
                req.getServletContext().setAttribute("foo", (Object)"foo");
                req.getServletContext().removeAttribute("foo");
            }
        }
    }

    public static class AddedServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Added");
            resp.getWriter().close();
        }
    }

    public static class FilterAddingServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Filter");
            resp.getWriter().close();
        }

        public void init() throws ServletException {
            FilterRegistration.Dynamic dynamic = this.getServletContext().addFilter("filter", (Filter)new MyFilter());
            dynamic.addMappingForUrlPatterns(EnumSet.of(DispatcherType.REQUEST), false, new String[]{"/*"});
        }
    }

    public static class ServletAddingServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.getWriter().write("Start");
            resp.getWriter().close();
        }

        public void init() throws ServletException {
            ServletRegistration.Dynamic dynamic = this.getServletContext().addServlet("added", AddedServlet.class);
            dynamic.addMapping(new String[]{"/added/*"});
        }
    }

    public static class FakeJspServlet
    extends HttpServlet {
    }

    public static class DecoratedObjectFactoryServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setContentType("text/plain");
            resp.setStatus(200);
            PrintWriter out = resp.getWriter();
            Object obj = req.getServletContext().getAttribute(DecoratedObjectFactory.ATTR);
            out.printf("Attribute[%s] = %s%n", DecoratedObjectFactory.ATTR, obj.getClass().getName());
            if (obj instanceof DecoratedObjectFactory) {
                out.printf("Object is a DecoratedObjectFactory%n", new Object[0]);
                DecoratedObjectFactory objFactory = (DecoratedObjectFactory)obj;
                List decorators = objFactory.getDecorators();
                out.printf("Decorators.size = [%d]%n", decorators.size());
                for (Decorator decorator : decorators) {
                    out.printf(" decorator[] = %s%n", decorator.getClass().getName());
                }
            } else {
                out.printf("Object is NOT a DecoratedObjectFactory%n", new Object[0]);
            }
        }
    }

    public static class DummyUtilDecorator
    implements Decorator {
        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class MyFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ((HttpServletResponse)response).addHeader("filter", "filter");
            request.getServletContext().setAttribute("filter", (Object)"filter");
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }

    public static class HelloServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            resp.setStatus(200);
            PrintWriter writer = resp.getWriter();
            writer.write("Hello World");
        }
    }

    public static class InitialListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            try {
                MySCAListener mySCAListener = (MySCAListener)((Object)sce.getServletContext().createListener(MySCAListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySCAListener));
                MyRequestListener myRequestListener = (MyRequestListener)((Object)sce.getServletContext().createListener(MyRequestListener.class));
                sce.getServletContext().addListener((EventListener)((Object)myRequestListener));
                MyRAListener myRAListener = (MyRAListener)((Object)sce.getServletContext().createListener(MyRAListener.class));
                sce.getServletContext().addListener((EventListener)((Object)myRAListener));
                MySListener mySListener = (MySListener)((Object)sce.getServletContext().createListener(MySListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySListener));
                MySAListener mySAListener = (MySAListener)((Object)sce.getServletContext().createListener(MySAListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySAListener));
                MySIListener mySIListener = (MySIListener)((Object)sce.getServletContext().createListener(MySIListener.class));
                sce.getServletContext().addListener((EventListener)((Object)mySIListener));
            }
            catch (Exception e) {
                Assertions.fail((Throwable)e);
            }
            try {
                MyContextListener contextListener = (MyContextListener)((Object)sce.getServletContext().createListener(MyContextListener.class));
                Assertions.assertThrows(IllegalArgumentException.class, () -> sce.getServletContext().addListener((EventListener)((Object)contextListener)), (String)"Adding SCI from an SCI!");
            }
            catch (IllegalArgumentException contextListener) {
            }
            catch (ServletException x) {
                Assertions.fail((Throwable)x);
            }
            sce.getServletContext().setAttribute("foo", (Object)"bar");
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    public class CreatingSCL
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
            try {
                sce.getServletContext().createFilter(MyFilter.class);
                sce.getServletContext().setAttribute("CreatingSCL.filter", (Object)Boolean.FALSE);
            }
            catch (UnsupportedOperationException e) {
                sce.getServletContext().setAttribute("CreatingSCL.filter", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                Assertions.fail((Throwable)e);
            }
            try {
                sce.getServletContext().createServlet(HelloServlet.class);
                sce.getServletContext().setAttribute("CreatingSCL.servlet", (Object)Boolean.FALSE);
            }
            catch (UnsupportedOperationException e) {
                sce.getServletContext().setAttribute("CreatingSCL.servlet", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                Assertions.fail((Throwable)e);
            }
            try {
                sce.getServletContext().createListener(MyContextListener.class);
                sce.getServletContext().setAttribute("CreatingSCL.listener", (Object)Boolean.FALSE);
            }
            catch (UnsupportedOperationException e) {
                sce.getServletContext().setAttribute("CreatingSCL.listener", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                Assertions.fail((Throwable)e);
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    public static class MySIListener
    implements HttpSessionIdListener {
        public static int changes = 0;

        public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
            ++changes;
        }
    }

    public static class MySAListener
    implements HttpSessionAttributeListener {
        public static int adds = 0;
        public static int removes = 0;
        public static int replaces = 0;

        public void attributeAdded(HttpSessionBindingEvent event) {
            ++adds;
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            ++removes;
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
            ++replaces;
        }
    }

    public static class MySListener
    implements HttpSessionListener {
        public static int creates = 0;
        public static int destroys = 0;

        public void sessionCreated(HttpSessionEvent se) {
            ++creates;
        }

        public void sessionDestroyed(HttpSessionEvent se) {
            ++destroys;
        }
    }

    public static class MyRAListener
    implements ServletRequestAttributeListener {
        public static int adds = 0;
        public static int removes = 0;
        public static int replaces = 0;

        public void attributeAdded(ServletRequestAttributeEvent srae) {
            ++adds;
        }

        public void attributeRemoved(ServletRequestAttributeEvent srae) {
            ++removes;
        }

        public void attributeReplaced(ServletRequestAttributeEvent srae) {
            ++replaces;
        }
    }

    public static class MyRequestListener
    implements ServletRequestListener {
        public static int destroys = 0;
        public static int inits = 0;

        public void requestDestroyed(ServletRequestEvent sre) {
            ++destroys;
        }

        public void requestInitialized(ServletRequestEvent sre) {
            ++inits;
        }
    }

    public static class MySCAListener
    implements ServletContextAttributeListener {
        public static int adds = 0;
        public static int removes = 0;
        public static int replaces = 0;

        public void attributeAdded(ServletContextAttributeEvent event) {
            ++adds;
        }

        public void attributeRemoved(ServletContextAttributeEvent event) {
            ++removes;
        }

        public void attributeReplaced(ServletContextAttributeEvent event) {
            ++replaces;
        }
    }

    public static class MyTestSessionListener
    implements HttpSessionAttributeListener,
    HttpSessionListener {
        public void sessionCreated(HttpSessionEvent se) {
        }

        public void sessionDestroyed(HttpSessionEvent se) {
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
        }
    }

    public static class MySessionHandler
    extends SessionHandler {
        public void checkSessionListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionListeners);
            Assertions.assertEquals((int)size, (int)this._sessionListeners.size());
        }

        public void checkSessionAttributeListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionAttributeListeners);
            Assertions.assertEquals((int)size, (int)this._sessionAttributeListeners.size());
        }

        public void checkSessionIdListeners(int size) {
            Assertions.assertNotNull((Object)this._sessionIdListeners);
            Assertions.assertEquals((int)size, (int)this._sessionIdListeners.size());
        }
    }

    public static class MyContextListener
    implements ServletContextListener {
        boolean callSessionTimeouts;
        int timeout;

        public MyContextListener(boolean callSessionTimeouts, int timeout) {
            this.callSessionTimeouts = callSessionTimeouts;
            this.timeout = timeout;
        }

        public MyContextListener() {
            this(false, -1);
        }

        public void contextInitialized(ServletContextEvent sce) {
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.contextInitialized"));
            sce.getServletContext().setAttribute("MyContextListener.contextInitialized", (Object)Boolean.TRUE);
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.defaultSessionTrackingModes"));
            try {
                sce.getServletContext().getDefaultSessionTrackingModes();
                sce.getServletContext().setAttribute("MyContextListener.defaultSessionTrackingModes", (Object)Boolean.FALSE);
            }
            catch (UnsupportedOperationException e) {
                sce.getServletContext().setAttribute("MyContextListener.defaultSessionTrackingModes", (Object)Boolean.TRUE);
            }
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.effectiveSessionTrackingModes"));
            try {
                sce.getServletContext().getEffectiveSessionTrackingModes();
                sce.getServletContext().setAttribute("MyContextListener.effectiveSessionTrackingModes", (Object)Boolean.FALSE);
            }
            catch (UnsupportedOperationException e) {
                sce.getServletContext().setAttribute("MyContextListener.effectiveSessionTrackingModes", (Object)Boolean.TRUE);
            }
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.setSessionTrackingModes"));
            try {
                sce.getServletContext().setSessionTrackingModes(EnumSet.of(SessionTrackingMode.URL));
                sce.getServletContext().setAttribute("MyContextListener.setSessionTrackingModes", (Object)Boolean.FALSE);
            }
            catch (UnsupportedOperationException e) {
                sce.getServletContext().setAttribute("MyContextListener.setSessionTrackingModes", (Object)Boolean.TRUE);
            }
            if (this.callSessionTimeouts) {
                try {
                    sce.getServletContext().setSessionTimeout(this.timeout);
                    sce.getServletContext().setAttribute("MyContextListener.setSessionTimeout", (Object)Boolean.FALSE);
                }
                catch (UnsupportedOperationException e) {
                    sce.getServletContext().setAttribute("MyContextListener.setSessionTimeout", (Object)Boolean.TRUE);
                }
                try {
                    sce.getServletContext().getSessionTimeout();
                    sce.getServletContext().setAttribute("MyContextListener.getSessionTimeout", (Object)Boolean.FALSE);
                }
                catch (UnsupportedOperationException e) {
                    sce.getServletContext().setAttribute("MyContextListener.getSessionTimeout", (Object)Boolean.TRUE);
                }
            }
        }

        public void contextDestroyed(ServletContextEvent sce) {
            Assertions.assertNull((Object)sce.getServletContext().getAttribute("MyContextListener.contextDestroyed"));
            sce.getServletContext().setAttribute("MyContextListener.contextDestroyed", (Object)Boolean.TRUE);
        }
    }

    public static class MySCIStarter
    extends AbstractLifeCycle
    implements ServletContextHandler.ServletContainerInitializerCaller {
        ServletContainerInitializer _sci;
        ContextHandler.Context _ctx;

        MySCIStarter(ContextHandler.Context ctx, ServletContainerInitializer sci) {
            this._ctx = ctx;
            this._sci = sci;
        }

        protected void doStart() throws Exception {
            super.doStart();
            this._ctx.setExtendedListenerTypes(true);
            this._sci.onStartup(Collections.emptySet(), (ServletContext)this._ctx);
        }
    }

    public static class MySCI
    implements ServletContainerInitializer {
        boolean callSessionTimeouts;
        int timeout;

        public MySCI(boolean callSessionTimeouts, int timeout) {
            this.callSessionTimeouts = callSessionTimeouts;
            this.timeout = timeout;
        }

        public MySCI() {
            this(false, -1);
        }

        public void onStartup(Set<Class<?>> c, ServletContext ctx) {
            if (ctx.getAttribute("MySCI.startup") != null) {
                throw new IllegalStateException("MySCI already called");
            }
            ctx.setAttribute("MySCI.startup", (Object)Boolean.TRUE);
            ctx.addListener((EventListener)((Object)new MyContextListener(this.callSessionTimeouts, this.timeout)));
            try {
                ctx.getDefaultSessionTrackingModes();
                ctx.setAttribute("MySCI.defaultSessionTrackingModes", (Object)Boolean.TRUE);
            }
            catch (UnsupportedOperationException e) {
                ctx.setAttribute("MySCI.defaultSessionTrackingModes", (Object)Boolean.FALSE);
            }
            try {
                ctx.getEffectiveSessionTrackingModes();
                ctx.setAttribute("MySCI.effectiveSessionTrackingModes", (Object)Boolean.TRUE);
            }
            catch (UnsupportedOperationException e) {
                ctx.setAttribute("MySCI.effectiveSessionTrackingModes", (Object)Boolean.FALSE);
            }
            try {
                ctx.setSessionTrackingModes(EnumSet.of(SessionTrackingMode.URL));
                ctx.setAttribute("MySCI.setSessionTrackingModes", (Object)Boolean.TRUE);
            }
            catch (UnsupportedOperationException e) {
                ctx.setAttribute("MySCI.setSessionTrackingModes", (Object)Boolean.FALSE);
            }
            if (this.callSessionTimeouts) {
                try {
                    ctx.setAttribute("MYSCI.startSessionTimeout", (Object)ctx.getSessionTimeout());
                    ctx.setSessionTimeout(this.timeout);
                    ctx.setAttribute("MYSCI.setSessionTimeout", (Object)Boolean.TRUE);
                    ctx.setAttribute("MYSCI.getSessionTimeout", (Object)ctx.getSessionTimeout());
                }
                catch (Exception e) {
                    ctx.setAttribute("MYSCI.sessionTimeoutFailure", (Object)e);
                }
            }
        }
    }

    public static class StopTestListener
    implements ServletContextListener {
        int _initIndex;
        int _destroyIndex;

        public void contextInitialized(ServletContextEvent sce) {
            this._initIndex = __initIndex++;
        }

        public void contextDestroyed(ServletContextEvent sce) {
            this._destroyIndex = __destroyIndex++;
        }
    }

    public static class StopTestServlet
    extends GenericServlet {
        int _initIndex;
        int _destroyIndex;

        public void destroy() {
            this._destroyIndex = __destroyIndex++;
            super.destroy();
        }

        public void init() throws ServletException {
            this._initIndex = __initIndex++;
            super.init();
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        }
    }

    public static class StopTestFilter
    implements Filter {
        int _initIndex;
        int _destroyIndex;

        public void init(FilterConfig filterConfig) throws ServletException {
            this._initIndex = __initIndex++;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        }

        public void destroy() {
            this._destroyIndex = __destroyIndex++;
        }
    }
}

