/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Disabled
public class ServletRequestLogTest {
    private static final Logger LOG = LoggerFactory.getLogger(ServletRequestLogTest.class);

    public static Stream<Arguments> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        data.add(new Object[]{new HelloServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutCompleteServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnTimeoutDispatchServlet(), "/test/", "GET /test/ HTTP/1.1 200"});
        data.add(new Object[]{new AsyncOnStartIOExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ResponseSendErrorServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new ServletExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new IOExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        data.add(new Object[]{new RuntimeExceptionServlet(), "/test/", "GET /test/ HTTP/1.1 500"});
        return data.stream().map(Arguments::of);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollection(Servlet testServlet, String requestPath, String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        HandlerList handlers = new HandlerList();
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        handlers.setHandlers(new Handler[]{contexts, defaultHandler});
        server.setHandler((Handler)handlers);
        CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test");
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                server.start();
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, requestPath, null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                    int statusCode = connection.getResponseCode();
                    LOG.debug("Response Status Code: {}", (Object)statusCode);
                    if (statusCode == 200) {
                        String content = this.getResponseContent(connection);
                        LOG.debug("Response Content: {}", (Object)content);
                    }
                }
                finally {
                    connection.disconnect();
                }
                this.assertRequestLog(expectedLogEntry, captureLog);
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollectionErrorHandlerServerBean(Servlet testServlet, String requestPath, String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        ErrorHandler errorHandler = new ErrorHandler();
        server.addBean((Object)errorHandler);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        server.setHandler((Handler)new HandlerList(new Handler[]{contexts, defaultHandler}));
        CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test");
        try {
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, requestPath, null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                    int statusCode = connection.getResponseCode();
                    LOG.debug("Response Status Code: {}", (Object)statusCode);
                    if (statusCode == 200) {
                        String content = this.getResponseContent(connection);
                        LOG.debug("Response Content: {}", (Object)content);
                    }
                }
                finally {
                    connection.disconnect();
                }
                this.assertRequestLog(expectedLogEntry, captureLog);
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerCollectionSimpleErrorPageMapping(Servlet testServlet, String requestPath, String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        server.setHandler((Handler)new HandlerList(new Handler[]{contexts, new DefaultHandler()}));
        CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test");
        app.addServlet(CustomErrorServlet.class, "/errorpage");
        ErrorPageErrorHandler errorMapper = new ErrorPageErrorHandler();
        errorMapper.addErrorPage(500, "/errorpage");
        app.setErrorHandler((ErrorHandler)errorMapper);
        try {
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, requestPath, null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                    int statusCode = connection.getResponseCode();
                    LOG.debug("Response Status Code: {}", (Object)statusCode);
                    if (statusCode == 200) {
                        String content = this.getResponseContent(connection);
                        LOG.debug("Response Content: {}", (Object)content);
                    }
                }
                finally {
                    connection.disconnect();
                }
                this.assertRequestLog(expectedLogEntry, captureLog);
            });
        }
        finally {
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLogHandlerWrapped(Servlet testServlet, String requestPath, String expectedLogEntry) throws Exception {
        Server server = new Server();
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.setConnectors(new Connector[]{connector});
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        DefaultHandler defaultHandler = new DefaultHandler();
        server.setHandler((Handler)new HandlerList(new Handler[]{contexts, defaultHandler}));
        CaptureLog captureLog = new CaptureLog();
        server.setRequestLog((RequestLog)captureLog);
        ServletContextHandler app = new ServletContextHandler(1);
        app.setContextPath("/");
        contexts.addHandler((Handler)app);
        ServletHolder testHolder = new ServletHolder(testServlet);
        app.addServlet(testHolder, "/test");
        app.addServlet(CustomErrorServlet.class, "/errorpage");
        ErrorPageErrorHandler errorMapper = new ErrorPageErrorHandler();
        errorMapper.addErrorPage(500, "/errorpage");
        app.setErrorHandler((ErrorHandler)errorMapper);
        try {
            server.start();
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(4L), () -> {
                String host = connector.getHost();
                if (host == null) {
                    host = "localhost";
                }
                int port = connector.getLocalPort();
                URI serverUri = new URI("http", null, host, port, "/test", null, null);
                HttpURLConnection connection = (HttpURLConnection)serverUri.toURL().openConnection();
                try {
                    connection.setAllowUserInteraction(false);
                    int statusCode = connection.getResponseCode();
                    LOG.info("Response Status Code: {}", (Object)statusCode);
                    if (statusCode == 200) {
                        String content = this.getResponseContent(connection);
                        LOG.info("Response Content: {}", (Object)content);
                    }
                }
                finally {
                    connection.disconnect();
                }
                this.assertRequestLog(expectedLogEntry, captureLog);
            });
        }
        finally {
            server.stop();
        }
    }

    private void assertRequestLog(String expectedLogEntry, CaptureLog captureLog) {
        int captureCount = captureLog.captured.size();
        if (captureCount != 1) {
            LOG.warn("Capture Log size is {}, expected to be 1", (Object)captureCount);
            if (captureCount > 1) {
                for (int i = 0; i < captureCount; ++i) {
                    LOG.warn("[{}] {}", (Object)i, (Object)captureLog.captured.get(i));
                }
            }
            MatcherAssert.assertThat((String)"Capture Log Entry Count", (Object)captureLog.captured.size(), (Matcher)Matchers.is((Object)1));
        }
        String actual = captureLog.captured.get(0);
        MatcherAssert.assertThat((String)"Capture Log", (Object)actual, (Matcher)Matchers.is((Object)expectedLogEntry));
    }

    private String getResponseContent(HttpURLConnection connection) throws IOException {
        try (InputStream in = connection.getInputStream();){
            String string;
            try (InputStreamReader reader = new InputStreamReader(in);){
                StringWriter writer = new StringWriter();
                IO.copy((Reader)reader, (Writer)writer);
                string = writer.toString();
            }
            return string;
        }
    }

    public static class CustomErrorServlet
    extends HttpServlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            String reason = response instanceof Response ? ((Response)response).getReason() : null;
            int status = response.getStatus();
            response.setStatus(200);
            response.setContentType("text/plain");
            PrintWriter out = response.getWriter();
            out.printf("Error %d: %s%n", status, reason);
        }
    }

    private static class AsyncOnStartIOExceptionServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnStartIOExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
            throw new IOException("Whoops");
        }

        public void onError(AsyncEvent event) throws IOException {
            LOG.warn("onError() -> {}", (Object)event);
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutDispatchServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnTimeoutDispatchServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            if (request.getAttribute("deep") == null) {
                AsyncContext ac = request.startAsync();
                ac.setTimeout(1000L);
                ac.addListener((AsyncListener)this);
                request.setAttribute("deep", (Object)true);
            }
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().dispatch();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class AsyncOnTimeoutCompleteServlet
    extends AbstractTestServlet
    implements AsyncListener {
        private AsyncOnTimeoutCompleteServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            AsyncContext ac = request.startAsync();
            ac.setTimeout(1000L);
            ac.addListener((AsyncListener)this);
        }

        public void onTimeout(AsyncEvent event) throws IOException {
            event.getAsyncContext().complete();
        }

        public void onStartAsync(AsyncEvent event) throws IOException {
        }

        public void onError(AsyncEvent event) throws IOException {
        }

        public void onComplete(AsyncEvent event) throws IOException {
        }
    }

    private static class RuntimeExceptionServlet
    extends AbstractTestServlet {
        private RuntimeExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new RuntimeException("Whoops");
        }
    }

    private static class IOExceptionServlet
    extends AbstractTestServlet {
        private IOExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new IOException("Whoops");
        }
    }

    private static class ServletExceptionServlet
    extends AbstractTestServlet {
        private ServletExceptionServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            throw new ServletException("Whoops");
        }
    }

    private static class ResponseSendErrorServlet
    extends AbstractTestServlet {
        private ResponseSendErrorServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.sendError(500, "Whoops");
        }
    }

    private static class HelloServlet
    extends AbstractTestServlet {
        private HelloServlet() {
        }

        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.getWriter().print("Hello World");
        }
    }

    private static abstract class AbstractTestServlet
    extends HttpServlet {
        private AbstractTestServlet() {
        }

        public String toString() {
            return ((Object)((Object)this)).getClass().getSimpleName();
        }
    }

    public static class CaptureLog
    extends AbstractLifeCycle
    implements RequestLog {
        public List<String> captured = new ArrayList<String>();

        public void log(Request request, Response response) {
            int status = response.getCommittedMetaData().getStatus();
            this.captured.add(String.format("%s %s %s %03d", request.getMethod(), request.getRequestURI(), request.getProtocol(), status));
        }
    }
}

