/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.continuation.ContinuationThrowable;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.security.IdentityService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.DispatcherType;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ScopedHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.FilterMapping;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiException;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletHandler
extends ScopedHandler {
    public static final String __DEFAULT_SERVLET = "default";
    private ContextHandler _contextHandler;
    private ContextHandler.Context _servletContext;
    private FilterHolder[] _filters;
    private FilterMapping[] _filterMappings;
    private boolean _filterChainsCached = true;
    private int _maxFilterChainsCacheSize = 1000;
    private boolean _startWithUnavailable = true;
    private IdentityService _identityService;
    private ServletHolder[] _servlets;
    private ServletMapping[] _servletMappings;
    private transient Map<String, FilterHolder> _filterNameMap = new HashMap<String, FilterHolder>();
    private transient List<FilterMapping> _filterPathMappings;
    private transient MultiMap<String> _filterNameMappings;
    private transient Map<String, ServletHolder> _servletNameMap = new HashMap<String, ServletHolder>();
    private transient PathMap _servletPathMap;
    protected transient ConcurrentHashMap[] _chainCache;

    public void setServer(Server server) {
        if (this.getServer() != null && this.getServer() != server) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filters, null, "filter", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._filterMappings, null, "filterMapping", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._servlets, null, "servlet", true);
            this.getServer().getContainer().update((Object)this, (Object[])this._servletMappings, null, "servletMapping", true);
        }
        if (server != null && this.getServer() != server) {
            server.getContainer().update((Object)this, null, (Object[])this._filters, "filter", true);
            server.getContainer().update((Object)this, null, (Object[])this._filterMappings, "filterMapping", true);
            server.getContainer().update((Object)this, null, (Object[])this._servlets, "servlet", true);
            server.getContainer().update((Object)this, null, (Object[])this._servletMappings, "servletMapping", true);
        }
        super.setServer(server);
    }

    protected synchronized void doStart() throws Exception {
        SecurityHandler security_handler;
        this._servletContext = ContextHandler.getCurrentContext();
        ContextHandler contextHandler = this._contextHandler = this._servletContext == null ? null : this._servletContext.getContextHandler();
        if (this._contextHandler != null && (security_handler = (SecurityHandler)this._contextHandler.getChildHandlerByClass(SecurityHandler.class)) != null) {
            this._identityService = security_handler.getIdentityService();
        }
        this.updateNameMappings();
        this.updateMappings();
        if (this._filterChainsCached) {
            this._chainCache = new ConcurrentHashMap[]{null, new ConcurrentHashMap(), new ConcurrentHashMap(), null, new ConcurrentHashMap(), null, null, null, new ConcurrentHashMap(), null, null, null, null, null, null, null, new ConcurrentHashMap()};
        }
        super.doStart();
        if (this._contextHandler == null || !(this._contextHandler instanceof ServletContextHandler)) {
            this.initialize();
        }
    }

    protected synchronized void doStop() throws Exception {
        int i;
        super.doStop();
        if (this._filters != null) {
            i = this._filters.length;
            while (i-- > 0) {
                try {
                    this._filters[i].stop();
                }
                catch (Exception e) {
                    Log.warn((String)"EXCEPTION ", (Throwable)e);
                }
            }
        }
        if (this._servlets != null) {
            i = this._servlets.length;
            while (i-- > 0) {
                try {
                    this._servlets[i].stop();
                }
                catch (Exception e) {
                    Log.warn((String)"EXCEPTION ", (Throwable)e);
                }
            }
        }
        this._filterPathMappings = null;
        this._filterNameMappings = null;
        this._servletPathMap = null;
        this._chainCache = null;
    }

    IdentityService getIdentityService() {
        return this._identityService;
    }

    public Object getContextLog() {
        return null;
    }

    public FilterMapping[] getFilterMappings() {
        return this._filterMappings;
    }

    public FilterHolder[] getFilters() {
        return this._filters;
    }

    public PathMap.Entry getHolderEntry(String pathInContext) {
        if (this._servletPathMap == null) {
            return null;
        }
        return this._servletPathMap.getMatch(pathInContext);
    }

    public RequestDispatcher getRequestDispatcher(String uriInContext) {
        if (uriInContext == null) {
            return null;
        }
        if (!uriInContext.startsWith("/")) {
            return null;
        }
        try {
            String query = null;
            int q = uriInContext.indexOf(63);
            if (q > 0) {
                query = uriInContext.substring(q + 1);
                uriInContext = uriInContext.substring(0, q);
            }
            if ((q = uriInContext.indexOf(59)) > 0) {
                uriInContext = uriInContext.substring(0, q);
            }
            String pathInContext = URIUtil.canonicalPath((String)URIUtil.decodePath((String)uriInContext));
            String uri = URIUtil.addPaths((String)this._contextHandler.getContextPath(), (String)uriInContext);
            return new Dispatcher(this._contextHandler, uri, pathInContext, query);
        }
        catch (Exception e) {
            Log.ignore((Throwable)e);
            return null;
        }
    }

    public ServletContext getServletContext() {
        return this._servletContext;
    }

    public ServletMapping[] getServletMappings() {
        return this._servletMappings;
    }

    public ServletHolder[] getServlets() {
        return this._servlets;
    }

    public ServletHolder getServlet(String name) {
        return this._servletNameMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doScope(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String old_servlet_path = baseRequest.getServletPath();
        String old_path_info = baseRequest.getPathInfo();
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = null;
        UserIdentity.Scope old_scope = null;
        if (target.startsWith("/")) {
            PathMap.Entry entry = this.getHolderEntry(target);
            if (entry != null) {
                servlet_holder = (ServletHolder)entry.getValue();
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("servlet=" + servlet_holder));
                }
                String servlet_path_spec = (String)entry.getKey();
                String servlet_path = entry.getMapped() != null ? entry.getMapped() : PathMap.pathMatch((String)servlet_path_spec, (String)target);
                String path_info = PathMap.pathInfo((String)servlet_path_spec, (String)target);
                if (DispatcherType.INCLUDE.equals((Object)type)) {
                    baseRequest.setAttribute("javax.servlet.include.servlet_path", (Object)servlet_path);
                    baseRequest.setAttribute("javax.servlet.include.path_info", (Object)path_info);
                } else {
                    baseRequest.setServletPath(servlet_path);
                    baseRequest.setPathInfo(path_info);
                }
            }
        } else {
            servlet_holder = this._servletNameMap.get(target);
        }
        Log.debug((String)"servlet holder=", (Object)servlet_holder);
        try {
            if (servlet_holder != null) {
                old_scope = baseRequest.getUserIdentityScope();
                baseRequest.setUserIdentityScope((UserIdentity.Scope)servlet_holder);
                if (this._nextScope != null) {
                    this._nextScope.doScope(target, baseRequest, request, response);
                } else if (this._outerScope != null) {
                    this._outerScope.doHandle(target, baseRequest, request, response);
                } else {
                    this.doHandle(target, baseRequest, request, response);
                }
            }
        }
        finally {
            if (old_scope != null) {
                baseRequest.setUserIdentityScope(old_scope);
            }
            if (!DispatcherType.INCLUDE.equals((Object)type)) {
                baseRequest.setServletPath(old_servlet_path);
                baseRequest.setPathInfo(old_path_info);
            }
        }
    }

    public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        DispatcherType type = baseRequest.getDispatcherType();
        ServletHolder servlet_holder = (ServletHolder)baseRequest.getUserIdentityScope();
        FilterChain chain = null;
        if (target.startsWith("/")) {
            if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
                chain = this.getFilterChain(baseRequest, target, servlet_holder);
            }
        } else if (servlet_holder != null && this._filterMappings != null && this._filterMappings.length > 0) {
            chain = this.getFilterChain(baseRequest, null, servlet_holder);
        }
        Log.debug((String)"chain=", chain);
        try {
            if (servlet_holder == null) {
                this.notFound(request, response);
            } else {
                baseRequest.setHandled(true);
                if (chain != null) {
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                } else {
                    servlet_holder.handle(baseRequest, (ServletRequest)request, (ServletResponse)response);
                }
            }
        }
        catch (EofException e) {
            throw e;
        }
        catch (RuntimeIOException e) {
            throw e;
        }
        catch (ContinuationThrowable e) {
            throw e;
        }
        catch (Exception e) {
            Throwable cause;
            Throwable th;
            if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof ServletException) {
                    throw (ServletException)((Object)e);
                }
            }
            if ((th = e) instanceof UnavailableException) {
                Log.debug((Throwable)th);
            } else if (th instanceof ServletException) {
                Log.debug((Throwable)th);
                cause = ((ServletException)th).getRootCause();
                if (cause != null) {
                    th = cause;
                }
            } else if (th instanceof RuntimeIOException) {
                Log.debug((Throwable)th);
                cause = (IOException)((RuntimeIOException)th).getCause();
                if (cause != null) {
                    th = cause;
                }
            }
            if (th instanceof HttpException) {
                throw (HttpException)th;
            }
            if (th instanceof RuntimeIOException) {
                throw (RuntimeIOException)th;
            }
            if (th instanceof EofException) {
                throw (EofException)th;
            }
            if (Log.isDebugEnabled()) {
                Log.warn((String)request.getRequestURI(), (Throwable)th);
                Log.debug((String)request.toString());
            } else if (th instanceof IOException || th instanceof UnavailableException) {
                Log.debug((String)request.getRequestURI(), (Object)th);
            } else {
                Log.warn((String)request.getRequestURI(), (Throwable)th);
            }
            if (!response.isCommitted()) {
                request.setAttribute("javax.servlet.error.exception_type", th.getClass());
                request.setAttribute("javax.servlet.error.exception", (Object)th);
                if (th instanceof UnavailableException) {
                    UnavailableException ue = (UnavailableException)th;
                    if (ue.isPermanent()) {
                        response.sendError(404, th.getMessage());
                    } else {
                        response.sendError(503, th.getMessage());
                    }
                } else {
                    response.sendError(500, th.getMessage());
                }
            } else {
                Log.debug((String)("Response already committed for handling " + th));
            }
        }
        catch (Error e) {
            if (!DispatcherType.REQUEST.equals((Object)type) && !DispatcherType.ASYNC.equals((Object)type)) {
                throw e;
            }
            Log.warn((String)("Error for " + request.getRequestURI()), (Throwable)e);
            if (Log.isDebugEnabled()) {
                Log.debug((String)request.toString());
            }
            if (!response.isCommitted()) {
                request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                request.setAttribute("javax.servlet.error.exception", (Object)e);
                response.sendError(500, e.getMessage());
            }
            Log.debug((String)"Response already committed for handling ", (Object)e);
        }
    }

    private FilterChain getFilterChain(Request baseRequest, String pathInContext, ServletHolder servletHolder) {
        FilterChain chain;
        String key = pathInContext == null ? servletHolder.getName() : pathInContext;
        int dispatch = FilterMapping.dispatch(baseRequest.getDispatcherType());
        if (this._filterChainsCached && this._chainCache != null && (chain = (FilterChain)this._chainCache[dispatch].get(key)) != null) {
            return chain;
        }
        Object filters = null;
        if (pathInContext != null && this._filterPathMappings != null) {
            for (int i = 0; i < this._filterPathMappings.size(); ++i) {
                FilterMapping mapping = this._filterPathMappings.get(i);
                if (!mapping.appliesTo(pathInContext, dispatch)) continue;
                filters = LazyList.add(filters, (Object)((Object)mapping.getFilterHolder()));
            }
        }
        if (servletHolder != null && this._filterNameMappings != null && this._filterNameMappings.size() > 0 && this._filterNameMappings.size() > 0) {
            FilterMapping mapping;
            int i;
            Object o = this._filterNameMappings.get((Object)servletHolder.getName());
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters = LazyList.add((Object)filters, (Object)((Object)mapping.getFilterHolder()));
            }
            o = this._filterNameMappings.get((Object)"*");
            for (i = 0; i < LazyList.size((Object)o); ++i) {
                mapping = (FilterMapping)LazyList.get((Object)o, (int)i);
                if (!mapping.appliesTo(dispatch)) continue;
                filters = LazyList.add((Object)filters, (Object)((Object)mapping.getFilterHolder()));
            }
        }
        if (filters == null) {
            return null;
        }
        Object chain2 = null;
        if (this._filterChainsCached) {
            if (LazyList.size(filters) > 0) {
                chain2 = new CachedChain(filters, servletHolder);
            }
            if (this._maxFilterChainsCacheSize > 0 && this._chainCache[dispatch].size() > this._maxFilterChainsCacheSize) {
                this._chainCache[dispatch].clear();
            }
            this._chainCache[dispatch].put(key, chain2);
        } else if (LazyList.size(filters) > 0) {
            chain2 = new Chain(baseRequest, filters, servletHolder);
        }
        return chain2;
    }

    public boolean isInitializeAtStart() {
        return false;
    }

    public void setInitializeAtStart(boolean initializeAtStart) {
    }

    public boolean isAvailable() {
        if (!this.isStarted()) {
            return false;
        }
        ServletHolder[] holders = this.getServlets();
        for (int i = 0; i < holders.length; ++i) {
            ServletHolder holder = holders[i];
            if (holder == null || holder.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public void setStartWithUnavailable(boolean start) {
        this._startWithUnavailable = start;
    }

    public boolean isStartWithUnavailable() {
        return this._startWithUnavailable;
    }

    public void initialize() throws Exception {
        MultiException mx = new MultiException();
        if (this._filters != null) {
            for (int i = 0; i < this._filters.length; ++i) {
                this._filters[i].start();
            }
        }
        if (this._servlets != null) {
            Object[] servlets = (ServletHolder[])this._servlets.clone();
            Arrays.sort(servlets);
            for (int i = 0; i < servlets.length; ++i) {
                try {
                    if (((Holder)((Object)servlets[i])).getClassName() == null && ((ServletHolder)servlets[i]).getForcedPath() != null) {
                        ServletHolder forced_holder = (ServletHolder)this._servletPathMap.match(((ServletHolder)servlets[i]).getForcedPath());
                        if (forced_holder == null || forced_holder.getClassName() == null) {
                            mx.add((Throwable)new IllegalStateException("No forced path servlet for " + ((ServletHolder)servlets[i]).getForcedPath()));
                            continue;
                        }
                        ((Holder)((Object)servlets[i])).setClassName(forced_holder.getClassName());
                    }
                    servlets[i].start();
                    continue;
                }
                catch (Throwable e) {
                    Log.debug((String)"EXCEPTION ", (Object)e);
                    mx.add(e);
                }
            }
            mx.ifExceptionThrow();
        }
    }

    public boolean isFilterChainsCached() {
        return this._filterChainsCached;
    }

    public ServletHolder newServletHolder() {
        return new ServletHolder();
    }

    public ServletHolder newServletHolder(Class servlet) {
        return new ServletHolder(servlet);
    }

    public ServletHolder addServletWithMapping(String className, String pathSpec) {
        ServletHolder holder = this.newServletHolder(null);
        holder.setName(className + "-" + holder.hashCode());
        holder.setClassName(className);
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public ServletHolder addServletWithMapping(Class<? extends Servlet> servlet, String pathSpec) {
        ServletHolder holder = this.newServletHolder(servlet);
        this.setServlets((ServletHolder[])LazyList.addToArray((Object[])this.getServlets(), (Object)holder, ServletHolder.class));
        this.addServletWithMapping(holder, pathSpec);
        return holder;
    }

    public void addServletWithMapping(ServletHolder servlet, String pathSpec) {
        Object[] holders = this.getServlets();
        if (holders != null) {
            holders = (ServletHolder[])holders.clone();
        }
        try {
            this.setServlets((ServletHolder[])LazyList.addToArray((Object[])holders, (Object)servlet, ServletHolder.class));
            ServletMapping mapping = new ServletMapping();
            mapping.setServletName(servlet.getName());
            mapping.setPathSpec(pathSpec);
            this.setServletMappings((ServletMapping[])LazyList.addToArray((Object[])this.getServletMappings(), (Object)mapping, ServletMapping.class));
        }
        catch (Exception e) {
            this.setServlets((ServletHolder[])holders);
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public ServletHolder addServlet(String className, String pathSpec) {
        return this.addServletWithMapping(className, pathSpec);
    }

    public void addServlet(ServletHolder holder) {
        this.setServlets((ServletHolder[])LazyList.addToArray((Object[])this.getServlets(), (Object)holder, ServletHolder.class));
    }

    public void addServletMapping(ServletMapping mapping) {
        this.setServletMappings((ServletMapping[])LazyList.addToArray((Object[])this.getServletMappings(), (Object)mapping, ServletMapping.class));
    }

    public FilterHolder newFilterHolder(Class<? extends Filter> filter) {
        return new FilterHolder(filter);
    }

    public FilterHolder newFilterHolder() {
        return new FilterHolder();
    }

    public FilterHolder getFilter(String name) {
        return this._filterNameMap.get(name);
    }

    public FilterHolder addFilterWithMapping(Class<? extends Filter> filter, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(filter);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public FilterHolder addFilterWithMapping(String className, String pathSpec, int dispatches) {
        FilterHolder holder = this.newFilterHolder(null);
        holder.setName(className + "-" + ((Object)((Object)holder)).hashCode());
        holder.setClassName(className);
        this.addFilterWithMapping(holder, pathSpec, dispatches);
        return holder;
    }

    public void addFilterWithMapping(FilterHolder holder, String pathSpec, int dispatches) {
        FilterHolder[] holders = this.getFilters();
        if (holders != null) {
            holders = (FilterHolder[])holders.clone();
        }
        try {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])holders, (Object)((Object)holder), FilterHolder.class));
            FilterMapping mapping = new FilterMapping();
            mapping.setFilterName(holder.getName());
            mapping.setPathSpec(pathSpec);
            mapping.setDispatches(dispatches);
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, FilterMapping.class));
        }
        catch (RuntimeException e) {
            this.setFilters(holders);
            throw e;
        }
        catch (Error e) {
            this.setFilters(holders);
            throw e;
        }
    }

    public FilterHolder addFilter(String className, String pathSpec, int dispatches) {
        return this.addFilterWithMapping(className, pathSpec, dispatches);
    }

    public void addFilter(FilterHolder filter, FilterMapping filterMapping) {
        if (filter != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])this.getFilters(), (Object)((Object)filter), FilterHolder.class));
        }
        if (filterMapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)filterMapping, FilterMapping.class));
        }
    }

    public void addFilter(FilterHolder filter) {
        if (filter != null) {
            this.setFilters((FilterHolder[])LazyList.addToArray((Object[])this.getFilters(), (Object)((Object)filter), FilterHolder.class));
        }
    }

    public void addFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            this.setFilterMappings((FilterMapping[])LazyList.addToArray((Object[])this.getFilterMappings(), (Object)mapping, FilterMapping.class));
        }
    }

    public void prependFilterMapping(FilterMapping mapping) {
        if (mapping != null) {
            FilterMapping[] mappings = this.getFilterMappings();
            if (mappings == null || mappings.length == 0) {
                this.setFilterMappings(new FilterMapping[]{mapping});
            } else {
                FilterMapping[] new_mappings = new FilterMapping[mappings.length + 1];
                System.arraycopy(mappings, 0, new_mappings, 1, mappings.length);
                new_mappings[0] = mapping;
                this.setFilterMappings(new_mappings);
            }
        }
    }

    protected synchronized void updateNameMappings() {
        int i;
        this._filterNameMap.clear();
        if (this._filters != null) {
            for (i = 0; i < this._filters.length; ++i) {
                this._filterNameMap.put(this._filters[i].getName(), this._filters[i]);
                this._filters[i].setServletHandler(this);
            }
        }
        this._servletNameMap.clear();
        if (this._servlets != null) {
            for (i = 0; i < this._servlets.length; ++i) {
                this._servletNameMap.put(this._servlets[i].getName(), this._servlets[i]);
                this._servlets[i].setServletHandler(this);
            }
        }
    }

    protected synchronized void updateMappings() {
        int i;
        if (this._filterMappings == null) {
            this._filterPathMappings = null;
            this._filterNameMappings = null;
        } else {
            this._filterPathMappings = new ArrayList<FilterMapping>();
            this._filterNameMappings = new MultiMap();
            for (i = 0; i < this._filterMappings.length; ++i) {
                FilterHolder filter_holder = this._filterNameMap.get(this._filterMappings[i].getFilterName());
                if (filter_holder == null) {
                    throw new IllegalStateException("No filter named " + this._filterMappings[i].getFilterName());
                }
                this._filterMappings[i].setFilterHolder(filter_holder);
                if (this._filterMappings[i].getPathSpecs() != null) {
                    this._filterPathMappings.add(this._filterMappings[i]);
                }
                if (this._filterMappings[i].getServletNames() == null) continue;
                String[] names = this._filterMappings[i].getServletNames();
                for (int j = 0; j < names.length; ++j) {
                    if (names[j] == null) continue;
                    this._filterNameMappings.add((Object)names[j], (Object)this._filterMappings[i]);
                }
            }
        }
        if (this._servletMappings == null || this._servletNameMap == null) {
            this._servletPathMap = null;
        } else {
            PathMap pm = new PathMap();
            for (int i2 = 0; i2 < this._servletMappings.length; ++i2) {
                ServletHolder servlet_holder = this._servletNameMap.get(this._servletMappings[i2].getServletName());
                if (servlet_holder == null) {
                    throw new IllegalStateException("No such servlet: " + this._servletMappings[i2].getServletName());
                }
                if (this._servletMappings[i2].getPathSpecs() == null) continue;
                String[] pathSpecs = this._servletMappings[i2].getPathSpecs();
                for (int j = 0; j < pathSpecs.length; ++j) {
                    if (pathSpecs[j] == null) continue;
                    pm.put((Object)pathSpecs[j], (Object)servlet_holder);
                }
            }
            this._servletPathMap = pm;
        }
        if (this._chainCache != null) {
            i = this._chainCache.length;
            while (i-- > 0) {
                if (this._chainCache[i] == null) continue;
                this._chainCache[i].clear();
            }
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)("filterNameMap=" + this._filterNameMap));
            Log.debug((String)("pathFilters=" + this._filterPathMappings));
            Log.debug((String)("servletFilterMap=" + this._filterNameMappings));
            Log.debug((String)("servletPathMap=" + this._servletPathMap));
            Log.debug((String)("servletNameMap=" + this._servletNameMap));
        }
        try {
            if (this.isStarted()) {
                this.initialize();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void notFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (Log.isDebugEnabled()) {
            Log.debug((String)("Not Found " + request.getRequestURI()));
        }
        response.sendError(404);
    }

    public void setFilterChainsCached(boolean filterChainsCached) {
        this._filterChainsCached = filterChainsCached;
    }

    public void setFilterMappings(FilterMapping[] filterMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filterMappings, (Object[])filterMappings, "filterMapping", true);
        }
        this._filterMappings = filterMappings;
        this.updateMappings();
    }

    public synchronized void setFilters(FilterHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._filters, (Object[])holders, "filter", true);
        }
        this._filters = holders;
        this.updateNameMappings();
    }

    public void setServletMappings(ServletMapping[] servletMappings) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._servletMappings, (Object[])servletMappings, "servletMapping", true);
        }
        this._servletMappings = servletMappings;
        this.updateMappings();
    }

    public synchronized void setServlets(ServletHolder[] holders) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object[])this._servlets, (Object[])holders, "servlet", true);
        }
        this._servlets = holders;
        this.updateNameMappings();
    }

    public int getMaxFilterChainsCacheSize() {
        return this._maxFilterChainsCacheSize;
    }

    public void setMaxFilterChainsCacheSize(int maxFilterChainsCacheSize) {
        this._maxFilterChainsCacheSize = maxFilterChainsCacheSize;
    }

    public Servlet customizeServlet(Servlet servlet) throws Exception {
        return servlet;
    }

    public Servlet customizeServletDestroy(Servlet servlet) throws Exception {
        return servlet;
    }

    public Filter customizeFilter(Filter filter) throws Exception {
        return filter;
    }

    public Filter customizeFilterDestroy(Filter filter) throws Exception {
        return filter;
    }

    protected void dump(StringBuilder b, String indent) {
        super.dump(b, indent);
        if (this.getFilterMappings() != null) {
            for (FilterMapping f : this.getFilterMappings()) {
                b.append(indent);
                b.append(" +-");
                b.append(f);
                b.append('\n');
            }
        }
        HashSet<String> servlets = new HashSet<String>();
        if (this.getServletMappings() != null) {
            for (ServletMapping m : this.getServletMappings()) {
                servlets.add(m.getServletName());
                b.append(indent);
                b.append(" +-");
                b.append(m);
                b.append('\n');
            }
        }
        if (this.getServlets() != null) {
            for (ServletHolder h : this.getServlets()) {
                if (servlets.contains(h.getName())) continue;
                b.append(indent);
                b.append(" +-[]==>");
                b.append(h.getName());
                b.append('\n');
            }
        }
    }

    private class Chain
    implements FilterChain {
        final Request _baseRequest;
        final Object _chain;
        final ServletHolder _servletHolder;
        int _filter = 0;

        Chain(Request baseRequest, Object filters, ServletHolder servletHolder) {
            this._baseRequest = baseRequest;
            this._chain = filters;
            this._servletHolder = servletHolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("doFilter " + this._filter));
            }
            if (this._filter < LazyList.size((Object)this._chain)) {
                FilterHolder holder = (FilterHolder)((Object)LazyList.get((Object)this._chain, (int)this._filter++));
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call filter " + (Object)((Object)holder)));
                }
                Filter filter = holder.getFilter();
                if (holder.isAsyncSupported() || !this._baseRequest.isAsyncSupported()) {
                    filter.doFilter(request, response, (FilterChain)this);
                } else {
                    try {
                        this._baseRequest.setAsyncSupported(false);
                        filter.doFilter(request, response, (FilterChain)this);
                    }
                    finally {
                        this._baseRequest.setAsyncSupported(true);
                    }
                }
                return;
            }
            if (this._servletHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call servlet " + this._servletHolder));
                }
                this._servletHolder.handle(this._baseRequest, request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < LazyList.size((Object)this._chain); ++i) {
                Object o = LazyList.get((Object)this._chain, (int)i);
                b.append(o.toString());
                b.append("->");
            }
            b.append(this._servletHolder);
            return b.toString();
        }
    }

    private class CachedChain
    implements FilterChain {
        FilterHolder _filterHolder;
        CachedChain _next;
        ServletHolder _servletHolder;

        CachedChain(Object filters, ServletHolder servletHolder) {
            if (LazyList.size((Object)filters) > 0) {
                this._filterHolder = (FilterHolder)((Object)LazyList.get((Object)filters, (int)0));
                filters = LazyList.remove((Object)filters, (int)0);
                this._next = new CachedChain(filters, servletHolder);
            } else {
                this._servletHolder = servletHolder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            if (this._filterHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call filter " + (Object)((Object)this._filterHolder)));
                }
                Filter filter = this._filterHolder.getFilter();
                if (this._filterHolder.isAsyncSupported()) {
                    filter.doFilter(request, response, (FilterChain)this._next);
                } else {
                    Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                    boolean suspendable = baseRequest.isAsyncSupported();
                    if (suspendable) {
                        try {
                            baseRequest.setAsyncSupported(false);
                            filter.doFilter(request, response, (FilterChain)this._next);
                        }
                        finally {
                            baseRequest.setAsyncSupported(true);
                        }
                    } else {
                        filter.doFilter(request, response, (FilterChain)this._next);
                    }
                }
                return;
            }
            if (this._servletHolder != null) {
                if (Log.isDebugEnabled()) {
                    Log.debug((String)("call servlet " + this._servletHolder));
                }
                Request baseRequest = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
                this._servletHolder.handle(baseRequest, request, response);
            } else {
                ServletHandler.this.notFound((HttpServletRequest)request, (HttpServletResponse)response);
            }
        }

        public String toString() {
            if (this._filterHolder != null) {
                return (Object)((Object)this._filterHolder) + "->" + this._next.toString();
            }
            if (this._servletHolder != null) {
                return this._servletHolder.toString();
            }
            return "null";
        }
    }
}

