/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.GenericServlet;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.LocalConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.UrlEncoded;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DispatcherTest {
    private Server _server;
    private LocalConnector _connector;
    private ContextHandlerCollection _contextCollection;
    private ServletContextHandler _contextHandler;
    private ResourceHandler _resourceHandler;

    @Before
    public void init() throws Exception {
        this._server = new Server();
        this._server.setSendServerVersion(false);
        this._connector = new LocalConnector();
        this._contextCollection = new ContextHandlerCollection();
        this._contextHandler = new ServletContextHandler();
        this._contextHandler.setContextPath("/context");
        this._contextCollection.addHandler((Handler)this._contextHandler);
        this._resourceHandler = new ResourceHandler();
        this._resourceHandler.setResourceBase(MavenTestingUtils.getTestResourceDir((String)"dispatchResourceTest").getAbsolutePath());
        ContextHandler resourceContextHandler = new ContextHandler("/resource");
        resourceContextHandler.setHandler((Handler)this._resourceHandler);
        this._contextCollection.addHandler((Handler)resourceContextHandler);
        this._server.setHandler((Handler)this._contextCollection);
        this._server.addConnector((Connector)this._connector);
        this._server.start();
    }

    @After
    public void destroy() throws Exception {
        this._server.stop();
        this._server.join();
    }

    @Test
    public void testForward() throws Exception {
        this._contextHandler.addServlet(ForwardServlet.class, "/ForwardServlet/*");
        this._contextHandler.addServlet(AssertForwardServlet.class, "/AssertForwardServlet/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nContent-Length: 0\r\n\r\n";
        String responses = this._connector.getResponses("GET /context/ForwardServlet?do=assertforward&do=more&test=1 HTTP/1.1\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testForwardNonUTF8() throws Exception {
        this._contextHandler.addServlet(ForwardNonUTF8Servlet.class, "/ForwardServlet/*");
        this._contextHandler.addServlet(AssertNonUTF8ForwardServlet.class, "/AssertForwardServlet/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nContent-Length: 0\r\n\r\n";
        String responses = this._connector.getResponses("GET /context/ForwardServlet?do=assertforward&foreign=%d2%e5%ec%ef%e5%f0%e0%f2%f3%f0%e0&test=1 HTTP/1.1\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testForwardWithParam() throws Exception {
        this._contextHandler.addServlet(ForwardServlet.class, "/ForwardServlet/*");
        this._contextHandler.addServlet(EchoURIServlet.class, "/EchoURI/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\nContent-Length: 54\r\n\r\n/context\r\n/EchoURI\r\n/x x\r\n/context/EchoURI/x%20x;a=1\r\n";
        String responses = this._connector.getResponses("GET /context/ForwardServlet;ignore=true?do=req.echo&uri=EchoURI%2Fx%2520x%3Ba=1%3Fb=2 HTTP/1.1\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testInclude() throws Exception {
        this._contextHandler.addServlet(IncludeServlet.class, "/IncludeServlet/*");
        this._contextHandler.addServlet(AssertIncludeServlet.class, "/AssertIncludeServlet/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n";
        String responses = this._connector.getResponses("GET /context/IncludeServlet?do=assertinclude&do=more&test=1 HTTP/1.1\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testForwardThenInclude() throws Exception {
        this._contextHandler.addServlet(ForwardServlet.class, "/ForwardServlet/*");
        this._contextHandler.addServlet(IncludeServlet.class, "/IncludeServlet/*");
        this._contextHandler.addServlet(AssertForwardIncludeServlet.class, "/AssertForwardIncludeServlet/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Length: 0\r\n\r\n";
        String responses = this._connector.getResponses("GET /context/ForwardServlet/forwardpath?do=include HTTP/1.1\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testIncludeThenForward() throws Exception {
        this._contextHandler.addServlet(IncludeServlet.class, "/IncludeServlet/*");
        this._contextHandler.addServlet(ForwardServlet.class, "/ForwardServlet/*");
        this._contextHandler.addServlet(AssertIncludeForwardServlet.class, "/AssertIncludeForwardServlet/*");
        String expected = "HTTP/1.1 200 OK\r\nTransfer-Encoding: chunked\r\n\r\n0\r\n\r\n";
        String responses = this._connector.getResponses("GET /context/IncludeServlet/includepath?do=forward HTTP/1.1\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testServletForward() throws Exception {
        this._contextHandler.addServlet(DispatchServletServlet.class, "/dispatch/*");
        this._contextHandler.addServlet(RogerThatServlet.class, "/roger/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Length: 11\r\n\r\nRoger That!";
        String responses = this._connector.getResponses("GET /context/dispatch/test?forward=/roger/that HTTP/1.0\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testServletForwardDotDot() throws Exception {
        this._contextHandler.addServlet(DispatchServletServlet.class, "/dispatch/*");
        this._contextHandler.addServlet(RogerThatServlet.class, "/roger/that");
        String requests = "GET /context/dispatch/test?forward=/%2e%2e/roger/that HTTP/1.0\nHost: localhost\n\n";
        String responses = this._connector.getResponses(requests);
        Assert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 404 "));
    }

    @Test
    public void testServletForwardEncodedDotDot() throws Exception {
        this._contextHandler.addServlet(DispatchServletServlet.class, "/dispatch/*");
        this._contextHandler.addServlet(RogerThatServlet.class, "/roger/that");
        String requests = "GET /context/dispatch/test?forward=/%252e%252e/roger/that HTTP/1.0\nHost: localhost\n\n";
        String responses = this._connector.getResponses(requests);
        Assert.assertThat((Object)responses, (Matcher)Matchers.startsWith((String)"HTTP/1.1 404 "));
    }

    @Test
    public void testServletInclude() throws Exception {
        this._contextHandler.addServlet(DispatchServletServlet.class, "/dispatch/*");
        this._contextHandler.addServlet(RogerThatServlet.class, "/roger/*");
        String expected = "HTTP/1.1 200 OK\r\nContent-Length: 11\r\n\r\nRoger That!";
        String responses = this._connector.getResponses("GET /context/dispatch/test?include=/roger/that HTTP/1.0\nHost: localhost\n\n");
        Assert.assertEquals((Object)expected, (Object)responses);
    }

    @Test
    public void testWorkingResourceHandler() throws Exception {
        String responses = this._connector.getResponses("GET /resource/content.txt HTTP/1.0\nHost: localhost\n\n");
        Assert.assertTrue((boolean)responses.contains("content goes here"));
    }

    @Test
    public void testIncludeToResourceHandler() throws Exception {
        this._contextHandler.addServlet(DispatchToResourceServlet.class, "/resourceServlet/*");
        String responses = this._connector.getResponses("GET /context/resourceServlet/content.txt?do=include HTTP/1.0\nHost: localhost\n\n");
        junit.framework.Assert.assertNotNull((Object)responses);
        Assert.assertTrue((boolean)responses.contains("content goes here"));
    }

    @Test
    public void testForwardToResourceHandler() throws Exception {
        this._contextHandler.addServlet(DispatchToResourceServlet.class, "/resourceServlet/*");
        String responses = this._connector.getResponses("GET /context/resourceServlet/content.txt?do=forward HTTP/1.0\nHost: localhost\n\n");
        Assert.assertTrue((boolean)responses.contains("content goes here"));
    }

    @Test
    public void testWrappedIncludeToResourceHandler() throws Exception {
        this._contextHandler.addServlet(DispatchToResourceServlet.class, "/resourceServlet/*");
        String responses = this._connector.getResponses("GET /context/resourceServlet/content.txt?do=include&wrapped=true HTTP/1.0\nHost: localhost\n\n");
        Assert.assertTrue((boolean)responses.contains("content goes here"));
    }

    @Test
    public void testWrappedForwardToResourceHandler() throws Exception {
        this._contextHandler.addServlet(DispatchToResourceServlet.class, "/resourceServlet/*");
        String responses = this._connector.getResponses("GET /context/resourceServlet/content.txt?do=forward&wrapped=true HTTP/1.0\nHost: localhost\n\n");
        Assert.assertTrue((boolean)responses.contains("content goes here"));
    }

    @Test
    public void testForwardFilterToRogerServlet() throws Exception {
        this._contextHandler.addServlet(RogerThatServlet.class, "/*");
        this._contextHandler.addServlet(ReserveEchoServlet.class, "/recho/*");
        this._contextHandler.addServlet(EchoServlet.class, "/echo/*");
        this._contextHandler.addFilter(ForwardFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        String rogerResponse = this._connector.getResponses("GET /context/ HTTP/1.0\nHost: localhost\n\n");
        String echoResponse = this._connector.getResponses("GET /context/foo?echo=echoText HTTP/1.0\nHost: localhost\n\n");
        String rechoResponse = this._connector.getResponses("GET /context/?echo=echoText HTTP/1.0\nHost: localhost\n\n");
        Assert.assertTrue((boolean)rogerResponse.contains("Roger That!"));
        Assert.assertTrue((boolean)echoResponse.contains("echoText"));
        Assert.assertTrue((boolean)rechoResponse.contains("txeTohce"));
    }

    public static class AssertIncludeForwardServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.include.request_uri"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.include.context_path"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.include.servlet_path"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.include.path_info"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.include.query_string"));
            Assert.assertEquals((Object)"/context/IncludeServlet/includepath", (Object)request.getAttribute("javax.servlet.forward.request_uri"));
            Assert.assertEquals((Object)"/context", (Object)request.getAttribute("javax.servlet.forward.context_path"));
            Assert.assertEquals((Object)"/IncludeServlet", (Object)request.getAttribute("javax.servlet.forward.servlet_path"));
            Assert.assertEquals((Object)"/includepath", (Object)request.getAttribute("javax.servlet.forward.path_info"));
            Assert.assertEquals((Object)"do=forward", (Object)request.getAttribute("javax.servlet.forward.query_string"));
            List<String> expectedAttributeNames = Arrays.asList("javax.servlet.forward.request_uri", "javax.servlet.forward.context_path", "javax.servlet.forward.servlet_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string");
            ArrayList requestAttributeNames = Collections.list(request.getAttributeNames());
            Assert.assertTrue((boolean)requestAttributeNames.containsAll(expectedAttributeNames));
            Assert.assertEquals((Object)"/assertpath", (Object)request.getPathInfo());
            Assert.assertEquals(null, (Object)request.getPathTranslated());
            Assert.assertEquals((Object)"do=end", (Object)request.getQueryString());
            Assert.assertEquals((Object)"/context/AssertIncludeForwardServlet/assertpath", (Object)request.getRequestURI());
            Assert.assertEquals((Object)"/context", (Object)request.getContextPath());
            Assert.assertEquals((Object)"/AssertIncludeForwardServlet", (Object)request.getServletPath());
            response.setContentType("text/html");
            response.setStatus(200);
        }
    }

    public static class AssertForwardIncludeServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Assert.assertEquals((Object)"/context/ForwardServlet/forwardpath", (Object)request.getAttribute("javax.servlet.forward.request_uri"));
            Assert.assertEquals((Object)"/context", (Object)request.getAttribute("javax.servlet.forward.context_path"));
            Assert.assertEquals((Object)"/ForwardServlet", (Object)request.getAttribute("javax.servlet.forward.servlet_path"));
            Assert.assertEquals((Object)"/forwardpath", (Object)request.getAttribute("javax.servlet.forward.path_info"));
            Assert.assertEquals((Object)"do=include", (Object)request.getAttribute("javax.servlet.forward.query_string"));
            Assert.assertEquals((Object)"/context/AssertForwardIncludeServlet/assertpath", (Object)request.getAttribute("javax.servlet.include.request_uri"));
            Assert.assertEquals((Object)"/context", (Object)request.getAttribute("javax.servlet.include.context_path"));
            Assert.assertEquals((Object)"/AssertForwardIncludeServlet", (Object)request.getAttribute("javax.servlet.include.servlet_path"));
            Assert.assertEquals((Object)"/assertpath", (Object)request.getAttribute("javax.servlet.include.path_info"));
            Assert.assertEquals((Object)"do=end", (Object)request.getAttribute("javax.servlet.include.query_string"));
            List<String> expectedAttributeNames = Arrays.asList("javax.servlet.forward.request_uri", "javax.servlet.forward.context_path", "javax.servlet.forward.servlet_path", "javax.servlet.forward.path_info", "javax.servlet.forward.query_string", "javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string");
            ArrayList requestAttributeNames = Collections.list(request.getAttributeNames());
            Assert.assertTrue((boolean)requestAttributeNames.containsAll(expectedAttributeNames));
            Assert.assertEquals((Object)"/includepath", (Object)request.getPathInfo());
            Assert.assertEquals(null, (Object)request.getPathTranslated());
            Assert.assertEquals((Object)"do=assertforwardinclude", (Object)request.getQueryString());
            Assert.assertEquals((Object)"/context/IncludeServlet/includepath", (Object)request.getRequestURI());
            Assert.assertEquals((Object)"/context", (Object)request.getContextPath());
            Assert.assertEquals((Object)"/IncludeServlet", (Object)request.getServletPath());
            response.setContentType("text/html");
            response.setStatus(200);
        }
    }

    public static class AssertIncludeServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Assert.assertEquals((Object)"/context/AssertIncludeServlet", (Object)request.getAttribute("javax.servlet.include.request_uri"));
            Assert.assertEquals((Object)"/context", (Object)request.getAttribute("javax.servlet.include.context_path"));
            Assert.assertEquals((Object)"/AssertIncludeServlet", (Object)request.getAttribute("javax.servlet.include.servlet_path"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.include.path_info"));
            Assert.assertEquals((Object)"do=end&do=the", (Object)request.getAttribute("javax.servlet.include.query_string"));
            List<String> expectedAttributeNames = Arrays.asList("javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.query_string");
            ArrayList requestAttributeNames = Collections.list(request.getAttributeNames());
            Assert.assertTrue((boolean)requestAttributeNames.containsAll(expectedAttributeNames));
            Assert.assertEquals(null, (Object)request.getPathInfo());
            Assert.assertEquals(null, (Object)request.getPathTranslated());
            Assert.assertEquals((Object)"do=assertinclude&do=more&test=1", (Object)request.getQueryString());
            Assert.assertEquals((Object)"/context/IncludeServlet", (Object)request.getRequestURI());
            Assert.assertEquals((Object)"/context", (Object)request.getContextPath());
            Assert.assertEquals((Object)"/IncludeServlet", (Object)request.getServletPath());
            response.setContentType("text/html");
            response.setStatus(200);
        }
    }

    public static class AssertNonUTF8ForwardServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            byte[] cp1251_bytes = TypeUtil.fromHexString((String)"d2e5ecefe5f0e0f2f3f0e0");
            String expectedCP1251String = new String(cp1251_bytes, "cp1251");
            Assert.assertEquals((Object)"/context/ForwardServlet", (Object)request.getAttribute("javax.servlet.forward.request_uri"));
            Assert.assertEquals((Object)"/context", (Object)request.getAttribute("javax.servlet.forward.context_path"));
            Assert.assertEquals((Object)"/ForwardServlet", (Object)request.getAttribute("javax.servlet.forward.servlet_path"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.forward.path_info"));
            Assert.assertEquals((Object)"do=assertforward&foreign=%d2%e5%ec%ef%e5%f0%e0%f2%f3%f0%e0&test=1", (Object)request.getAttribute("javax.servlet.forward.query_string"));
            List<String> expectedAttributeNames = Arrays.asList("javax.servlet.forward.request_uri", "javax.servlet.forward.context_path", "javax.servlet.forward.servlet_path", "javax.servlet.forward.query_string");
            ArrayList requestAttributeNames = Collections.list(request.getAttributeNames());
            Assert.assertTrue((boolean)requestAttributeNames.containsAll(expectedAttributeNames));
            Assert.assertEquals(null, (Object)request.getPathInfo());
            Assert.assertEquals(null, (Object)request.getPathTranslated());
            UrlEncoded query = new UrlEncoded(request.getQueryString());
            Assert.assertThat((Object)query.getString((Object)"do"), (Matcher)Matchers.is((Object)"end"));
            String russian = new UrlEncoded(query.getString((Object)"else")).encode();
            Assert.assertThat((Object)russian, (Matcher)Matchers.is((Object)"%D0%B2%D1%8B%D0%B1%D1%80%D0%B0%D0%BD%D0%BE=%D0%A2%D0%B5%D0%BC%D0%BF%D0%B5%D1%80%D0%B0%D1%82%D1%83%D1%80%D0%B0"));
            Assert.assertThat((Object)query.getString((Object)"test"), (Matcher)Matchers.is((Object)"1"));
            Assert.assertThat((Object)query.containsKey((Object)"foreign"), (Matcher)Matchers.is((Object)true));
            String[] vals = request.getParameterValues("foreign");
            Assert.assertTrue((vals != null ? 1 : 0) != 0);
            Assert.assertEquals((long)1L, (long)vals.length);
            Assert.assertEquals((Object)expectedCP1251String, (Object)vals[0]);
            Assert.assertEquals((Object)"/context/AssertForwardServlet", (Object)request.getRequestURI());
            Assert.assertEquals((Object)"/context", (Object)request.getContextPath());
            Assert.assertEquals((Object)"/AssertForwardServlet", (Object)request.getServletPath());
            response.setContentType("text/html");
            response.setStatus(200);
        }
    }

    public static class AssertForwardServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Assert.assertEquals((Object)"/context/ForwardServlet", (Object)request.getAttribute("javax.servlet.forward.request_uri"));
            Assert.assertEquals((Object)"/context", (Object)request.getAttribute("javax.servlet.forward.context_path"));
            Assert.assertEquals((Object)"/ForwardServlet", (Object)request.getAttribute("javax.servlet.forward.servlet_path"));
            Assert.assertEquals(null, (Object)request.getAttribute("javax.servlet.forward.path_info"));
            Assert.assertEquals((Object)"do=assertforward&do=more&test=1", (Object)request.getAttribute("javax.servlet.forward.query_string"));
            List<String> expectedAttributeNames = Arrays.asList("javax.servlet.forward.request_uri", "javax.servlet.forward.context_path", "javax.servlet.forward.servlet_path", "javax.servlet.forward.query_string");
            ArrayList requestAttributeNames = Collections.list(request.getAttributeNames());
            Assert.assertTrue((boolean)requestAttributeNames.containsAll(expectedAttributeNames));
            Assert.assertEquals(null, (Object)request.getPathInfo());
            Assert.assertEquals(null, (Object)request.getPathTranslated());
            Assert.assertEquals((Object)"do=end&do=the&test=1", (Object)request.getQueryString());
            Assert.assertEquals((Object)"/context/AssertForwardServlet", (Object)request.getRequestURI());
            Assert.assertEquals((Object)"/context", (Object)request.getContextPath());
            Assert.assertEquals((Object)"/AssertForwardServlet", (Object)request.getServletPath());
            response.setContentType("text/html");
            response.setStatus(200);
        }
    }

    public static class EchoURIServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            response.setContentType("text/plain");
            response.setStatus(200);
            response.getOutputStream().println(request.getContextPath());
            response.getOutputStream().println(request.getServletPath());
            response.getOutputStream().println(request.getPathInfo());
            response.getOutputStream().println(request.getRequestURI());
        }
    }

    public static class DispatchToResourceServlet
    extends HttpServlet
    implements Servlet {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
            ServletContext targetContext = this.getServletConfig().getServletContext().getContext("/resource");
            RequestDispatcher dispatcher = targetContext.getRequestDispatcher(req.getPathInfo());
            if ("true".equals(req.getParameter("wrapped"))) {
                if (req.getParameter("do").equals("forward")) {
                    dispatcher.forward((ServletRequest)new HttpServletRequestWrapper(req), (ServletResponse)new HttpServletResponseWrapper(res));
                    return;
                } else {
                    if (!req.getParameter("do").equals("include")) throw new ServletException("type of forward or include is required");
                    dispatcher.include((ServletRequest)new HttpServletRequestWrapper(req), (ServletResponse)new HttpServletResponseWrapper(res));
                }
                return;
            } else if (req.getParameter("do").equals("forward")) {
                dispatcher.forward((ServletRequest)req, (ServletResponse)res);
                return;
            } else {
                if (!req.getParameter("do").equals("include")) throw new ServletException("type of forward or include is required");
                dispatcher.include((ServletRequest)req, (ServletResponse)res);
            }
        }
    }

    public static class ReserveEchoServlet
    extends GenericServlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            String echoText = req.getParameter("echo");
            if (echoText == null) {
                throw new ServletException("echo is a required parameter");
            }
            res.getWriter().print(new StringBuffer(echoText).reverse().toString());
        }
    }

    public static class EchoServlet
    extends GenericServlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            String echoText = req.getParameter("echo");
            if (echoText == null) {
                throw new ServletException("echo is a required parameter");
            }
            res.getWriter().print(echoText);
        }
    }

    public static class RogerThatServlet
    extends GenericServlet {
        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            res.getWriter().print("Roger That!");
        }
    }

    public static class IncludeServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            RequestDispatcher dispatcher = null;
            if (request.getParameter("do").equals("forward")) {
                dispatcher = this.getServletContext().getRequestDispatcher("/ForwardServlet/forwardpath?do=assertincludeforward");
            } else if (request.getParameter("do").equals("assertforwardinclude")) {
                dispatcher = this.getServletContext().getRequestDispatcher("/AssertForwardIncludeServlet/assertpath?do=end");
            } else if (request.getParameter("do").equals("assertinclude")) {
                dispatcher = this.getServletContext().getRequestDispatcher("/AssertIncludeServlet?do=end&do=the");
            }
            dispatcher.include((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static class DispatchServletServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            RequestDispatcher dispatcher = null;
            if (request.getParameter("include") != null) {
                dispatcher = this.getServletContext().getRequestDispatcher(request.getParameter("include"));
                dispatcher.include((ServletRequest)new ServletRequestWrapper((ServletRequest)request), (ServletResponse)new ServletResponseWrapper((ServletResponse)response));
            } else if (request.getParameter("forward") != null) {
                dispatcher = this.getServletContext().getRequestDispatcher(request.getParameter("forward"));
                if (dispatcher != null) {
                    dispatcher.forward((ServletRequest)new ServletRequestWrapper((ServletRequest)request), (ServletResponse)new ServletResponseWrapper((ServletResponse)response));
                } else {
                    response.sendError(404);
                }
            }
        }
    }

    public static class ForwardFilter
    implements Filter {
        ServletContext servletContext;

        public void init(FilterConfig filterConfig) throws ServletException {
            this.servletContext = filterConfig.getServletContext().getContext("/context");
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            if (this.servletContext == null || !(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
                chain.doFilter(request, response);
                return;
            }
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            if (req.getParameter("echo") != null && "/".equals(req.getPathInfo())) {
                RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher("/recho");
                dispatcher.forward(request, response);
            } else if (req.getParameter("echo") != null) {
                RequestDispatcher dispatcher = this.servletContext.getRequestDispatcher("/echo");
                dispatcher.forward(request, response);
            } else {
                chain.doFilter(request, response);
                return;
            }
        }

        public void destroy() {
        }
    }

    public static class ForwardNonUTF8Servlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            RequestDispatcher dispatcher = null;
            request.setAttribute("org.eclipse.jetty.server.Request.queryEncoding", (Object)"cp1251");
            dispatcher = this.getServletContext().getRequestDispatcher("/AssertForwardServlet?do=end&else=%D0%B2%D1%8B%D0%B1%D1%80%D0%B0%D0%BD%D0%BE%3D%D0%A2%D0%B5%D0%BC%D0%BF%D0%B5%D1%80%D0%B0%D1%82%D1%83%D1%80%D0%B0");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public static class ForwardServlet
    extends HttpServlet
    implements Servlet {
        protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            RequestDispatcher dispatcher = null;
            if (request.getParameter("do").equals("include")) {
                dispatcher = this.getServletContext().getRequestDispatcher("/IncludeServlet/includepath?do=assertforwardinclude");
            } else if (request.getParameter("do").equals("assertincludeforward")) {
                dispatcher = this.getServletContext().getRequestDispatcher("/AssertIncludeForwardServlet/assertpath?do=end");
            } else if (request.getParameter("do").equals("assertforward")) {
                dispatcher = this.getServletContext().getRequestDispatcher("/AssertForwardServlet?do=end&do=the");
            } else if (request.getParameter("do").equals("ctx.echo")) {
                dispatcher = this.getServletContext().getRequestDispatcher(request.getParameter("uri"));
            } else if (request.getParameter("do").equals("req.echo")) {
                dispatcher = request.getRequestDispatcher(request.getParameter("uri"));
            }
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

