/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.util.Collections;
import java.util.Set;
import javax.servlet.ServletRegistration;
import org.eclipse.jetty.servlet.Holder;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.Assert;
import org.junit.Test;

public class HolderTest {
    @Test
    public void testInitParams() throws Exception {
        ServletHolder holder = new ServletHolder(Holder.Source.JAVAX_API);
        ServletRegistration.Dynamic reg = holder.getRegistration();
        try {
            reg.setInitParameter(null, "foo");
            Assert.fail((String)"null name accepted");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            reg.setInitParameter("foo", null);
            Assert.fail((String)"null value accepted");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        reg.setInitParameter("foo", "bar");
        Assert.assertFalse((boolean)reg.setInitParameter("foo", "foo"));
        Set clash = reg.setInitParameters(Collections.singletonMap("foo", "bax"));
        Assert.assertTrue((String)"should be one clash", (clash != null && clash.size() == 1 ? 1 : 0) != 0);
        try {
            reg.setInitParameters(Collections.singletonMap(null, "bax"));
            Assert.fail((String)"null name in map accepted");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            reg.setInitParameters(Collections.singletonMap("foo", null));
            Assert.fail((String)"null value in map accepted");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        Set clash2 = reg.setInitParameters(Collections.singletonMap("FOO", "bax"));
        Assert.assertTrue((String)"should be no clash", (boolean)clash2.isEmpty());
        Assert.assertEquals((String)"setInitParameters should not replace existing non-clashing init parameters", (long)2L, (long)reg.getInitParameters().size());
    }
}

